/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import progress.message.broker.FlowControlListener;
import progress.message.broker.FlowControlManager;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IClientContext;
import progress.message.broker.IFlowController;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;

public class FlowControllerP27
extends DebugObject
implements FlowControlListener,
IFlowController {
    private IClientContext m_cc = null;
    private Hashtable<String, String> m_blockedList = null;
    private Hashtable<String, ResumedDestination> m_resumedList = null;
    private FlowControlManager m_flowManager = null;
    private boolean m_disconnected = false;

    public FlowControllerP27(FlowControlManager flowmgr, IClientContext cc) {
        super(DebugState.GLOBAL_DEBUG_ON ? "FlowController (" + cc.getId() + ")" : null);
        if (cc == null) {
            throw new EAssertFailure("Parameter is null: ClientContext cc");
        }
        this.m_cc = cc;
        this.m_blockedList = new Hashtable();
        this.m_flowManager = flowmgr;
        this.m_resumedList = new Hashtable();
        if (this.DEBUG) {
            this.debug("Constructed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        String destination;
        if (this.DEBUG) {
            this.debug("Disconnecting");
        }
        Hashtable htBlocked = null;
        Hashtable htResumed = null;
        FlowControllerP27 flowControllerP27 = this;
        synchronized (flowControllerP27) {
            if (this.m_disconnected) {
                return;
            }
            htBlocked = (Hashtable)this.m_blockedList.clone();
            htResumed = (Hashtable)this.m_resumedList.clone();
            this.m_disconnected = true;
            this.m_blockedList.clear();
            this.m_resumedList.clear();
        }
        Enumeration keys = htBlocked.keys();
        while (keys.hasMoreElements()) {
            destination = (String)keys.nextElement();
            String localDest = (String)htBlocked.get(destination);
            this.m_flowManager.removeFlowControlListener(this, localDest, destination);
            if (!this.DEBUG) continue;
            this.debug("Unregistered listener for " + destination);
        }
        keys = htResumed.keys();
        while (keys.hasMoreElements()) {
            destination = (String)keys.nextElement();
            ResumedDestination resumedDest = (ResumedDestination)htResumed.get(destination);
            this.m_flowManager.queueResumeCancelled(resumedDest.m_localDest, resumedDest.m_size);
            if (!this.DEBUG) continue;
            this.debug("QueueResumeCancelled for size " + resumedDest.m_size + " dest= " + destination + " localDest = " + resumedDest.m_localDest);
        }
    }

    @Override
    public synchronized boolean isDestinationLocalBlocked(IMgram m) {
        if (!m.isPubSub() && !m.isPTP() && m.getType() != 11) {
            throw new EAssertFailure("Mgram type not NORMAL or QUEUE_NORMAL or QUEUE_ACKFORWARD_TYPE");
        }
        String dest = this.getFullAddress(m);
        if (dest == null) {
            throw new EAssertFailure("NORMAL or QUEUE_NORMAL or QUEUE_ACKFORWARD_TYPE with null subject");
        }
        if (this.DEBUG) {
            this.debug("Checking blocked list for " + m.getGuarenteedTrackingNum() + ", dest = " + dest);
        }
        if (this.m_blockedList.get(dest) == null) {
            if (this.DEBUG) {
                this.debug("Destination not blocked locally: " + dest);
            }
            return false;
        }
        if (this.DEBUG) {
            this.debug("Destination blocked locally: " + dest);
        }
        return true;
    }

    @Override
    public synchronized void onResumeReply(IMgram m) throws EMgramFormatError {
        String destination = m.getQueueFlowControlHandle().getFlowDestination();
        if (this.DEBUG) {
            this.debug("Received Resume Reply: " + destination);
        }
        m.setRequestReplySend();
        this.m_cc.sendThrough(m);
        if (this.DEBUG) {
            this.debug("Sent Resume Complete: " + destination);
        }
        this.m_blockedList.remove(destination);
        if (this.DEBUG) {
            this.debug("Removed from blocked list: " + destination);
        }
    }

    @Override
    public synchronized boolean onQueueResume(Object destKey, String localDestination, int size) {
        String destination = (String)destKey;
        if (this.DEBUG) {
            this.debug("Resuming delivery on: " + destination);
        }
        boolean result = false;
        if (!this.m_disconnected && this.m_blockedList.get(destination) != null) {
            if (this.DEBUG) {
                this.debug("Sent Resume Begin for " + destination + " to " + this.m_cc);
            }
            try {
                this.m_resumedList.put(destination, new ResumedDestination(localDestination, size));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(baos);
                out.writeUTF(destination);
                out.flush();
                byte[] dest = baos.toByteArray();
                IMgram mg = MgramFactory.getMgramFactory().buildResumeMgram(this.m_cc.getChannel(), dest, dest.length, false);
                this.m_cc.sendThrough(mg);
                result = true;
                if (this.m_cc.isGroupSubscriptionMember()) {
                    this.m_cc.getGroupSubscriptionCC().notifyGroupRestoreThreads();
                }
            }
            catch (IOException e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        } else if (this.DEBUG) {
            this.debug("WARNING: Not locally blocked, resume ignored: " + destination);
        }
        return result;
    }

    @Override
    public void nack(IMgram m, IAgentQueue target) {
        this.nack(m, m.getEnqueuedSize(), target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nack(IMgram m, int size, IAgentQueue target, String[] blockedRoutes) {
        boolean register = false;
        String localDest = target.getQueueAddress();
        String mgramDest = null;
        if (m.isDiscardable()) {
            if (!this.m_disconnected && m.isGuarenteed() && m.getRouting() != null && !m.getRoutingHandle().isGSAPublication()) {
                this.m_cc.sendThrough(MgramFactory.getMgramFactory().buildAck(m.getGuarenteedTrackingNum(), (short)0, this.m_cc.getChannel()));
                if (this.DEBUG) {
                    this.debug("Sent ACK for discardable message, tracking " + m.getGuarenteedTrackingNum());
                }
            }
            return;
        }
        mgramDest = this.getFullAddress(m);
        if (this.DEBUG) {
            this.debug("Nack: TK = " + m.getGuarenteedTrackingNum() + ", destination = " + mgramDest + ", local = " + localDest);
        }
        FlowControllerP27 flowControllerP27 = this;
        synchronized (flowControllerP27) {
            if (this.m_disconnected) {
                return;
            }
            boolean sendBlock = false;
            if (this.m_blockedList.get(mgramDest) == null) {
                this.m_blockedList.put(mgramDest, localDest);
                if (this.DEBUG) {
                    this.debug("Added to local list: " + mgramDest);
                }
                sendBlock = true;
                register = true;
            } else if (this.DEBUG) {
                this.debug("Already on local list: " + mgramDest);
            }
            if (sendBlock) {
                this.sendBlock(mgramDest);
            }
            this.sendNack(m);
        }
        if (register) {
            this.m_flowManager.addFlowControlListener(this, localDest, mgramDest, size, blockedRoutes);
            if (this.DEBUG) {
                this.debug("Added listener for " + size + " on " + localDest + ", dest = " + mgramDest);
            }
        }
    }

    @Override
    public void block(IMgram m, IAgentQueue target) {
        this.block(m, m.getEnqueuedSize(), target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void block(IMgram m, int size, IAgentQueue target, String[] blockedRoutes) {
        boolean register = false;
        String localDest = target.getQueueAddress();
        String mgramDest = null;
        if (m.isDiscardable()) {
            return;
        }
        mgramDest = this.getFullAddress(m);
        if (this.DEBUG) {
            this.debug("TxnBlock: TK = " + m.getGuarenteedTrackingNum() + ", destination = " + mgramDest + ", local = " + localDest);
        }
        FlowControllerP27 flowControllerP27 = this;
        synchronized (flowControllerP27) {
            if (this.m_disconnected) {
                return;
            }
            boolean sendBlock = false;
            if (this.m_blockedList.get(mgramDest) == null) {
                this.m_blockedList.put(mgramDest, localDest);
                if (this.DEBUG) {
                    this.debug("Added to local list: " + mgramDest);
                }
                sendBlock = true;
                register = true;
            } else if (this.DEBUG) {
                this.debug("Already on local list: " + mgramDest);
            }
            if (sendBlock) {
                this.sendBlock(mgramDest);
            }
        }
        if (register) {
            long targSz = target.getMaxQueueSizeInBytes();
            long regSz = Math.min(targSz, (long)size);
            int registerSize = (int)regSz;
            this.m_flowManager.addFlowControlListener(this, localDest, mgramDest, registerSize, blockedRoutes);
            if (this.DEBUG) {
                this.debug("Added listener for " + size + " on " + localDest + ", dest = " + mgramDest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkGlobalBlocked(String localDestination, IMgram m) {
        FlowControllerP27 flowControllerP27 = this;
        synchronized (flowControllerP27) {
            String realDestination = this.getFullAddress(m);
            if (this.m_resumedList.get(realDestination) != null) {
                this.m_resumedList.remove(realDestination);
                return true;
            }
        }
        return !this.m_flowManager.isDestinationGloballyBlocked(localDestination);
    }

    private void sendBlock(String destination) {
        if (this.DEBUG) {
            this.debug("Sending BLOCK on " + destination + " to " + this.m_cc);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            out.writeUTF(destination);
            out.flush();
            byte[] dest = baos.toByteArray();
            IMgram mg = MgramFactory.getMgramFactory().buildBlockMgram(this.m_cc.getChannel(), dest, dest.length, false);
            this.m_cc.sendThrough(mg);
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }

    void sendNack(IMgram m) {
        if (this.m_disconnected) {
            return;
        }
        if (m.isGuarenteed()) {
            if (m.isPTP() || m.isPubSub() || m.getType() == 11) {
                this.m_cc.sendThrough(MgramFactory.getMgramFactory().buildNack(m.getGuarenteedTrackingNum(), this.m_cc.getChannel()));
                if (this.DEBUG) {
                    this.debug("Sent NACK for " + m.getGuarenteedTrackingNum());
                }
            } else {
                throw new EAssertFailure("Only QUEUE_NORMAL or QUEUE_ACKFORWARD_TYPE or NORMAL_TYPE may be nacked");
            }
        }
    }

    private final String getFullAddress(IMgram m) {
        String node = m.getRoutingHandle().getRouting();
        String subject = m.getSubject().getSubjectString();
        if (node == null || m.isPubSub()) {
            return subject;
        }
        return node + "::" + subject;
    }

    @Override
    public boolean isConnected() {
        return !this.m_disconnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBlockedDestinationsAsString() {
        Hashtable blockedListCopy = null;
        FlowControllerP27 flowControllerP27 = this;
        synchronized (flowControllerP27) {
            if (this.m_disconnected) {
                return null;
            }
            if (this.m_blockedList.isEmpty()) {
                return null;
            }
            blockedListCopy = (Hashtable)this.m_blockedList.clone();
        }
        StringBuffer resultBuffer = new StringBuffer();
        boolean first = true;
        for (Map.Entry entry : blockedListCopy.entrySet()) {
            String mgramDest = (String)entry.getKey();
            String localDest = (String)entry.getValue();
            if (first) {
                first = false;
            } else {
                resultBuffer.append(", ");
            }
            resultBuffer.append(mgramDest);
            if (localDest.equals(mgramDest)) continue;
            resultBuffer.append(" (").append(mgramDest).append(")");
        }
        return resultBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlockingDestinations(ArrayList al) {
        FlowControllerP27 flowControllerP27 = this;
        synchronized (flowControllerP27) {
            if (this.m_blockedList.isEmpty()) {
                return;
            }
            for (Map.Entry<String, String> entry : this.m_blockedList.entrySet()) {
                String mgramDest = entry.getKey();
                String localDest = entry.getValue();
                String destString = null;
                if (!localDest.equals(mgramDest)) {
                    StringBuilder sb = new StringBuilder(mgramDest);
                    sb.append(" (").append(localDest).append(")");
                    destString = sb.toString();
                } else {
                    destString = mgramDest;
                }
                al.add(destString);
            }
        }
    }

    @Override
    public String toString() {
        return "FlowCntrl(" + this.m_cc.getId() + ")";
    }

    private static class ResumedDestination {
        private String m_localDest = null;
        private int m_size = 0;

        ResumedDestination(String localDest, int size) {
            this.m_localDest = localDest;
            this.m_size = size;
        }

        public String toString() {
            return "(" + this.m_localDest + "," + this.m_size + ")";
        }
    }
}

