/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.xa.TxnAdminInfo;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class GetPreparedBranchesInfo
implements IMessageHandler {
    private static String INFO_VERSION_3_5 = "3.5";
    private AgentRegistrar m_reg;

    GetPreparedBranchesInfo(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        Message req = env.getMessage();
        Message rep = new Message();
        try {
            String version = req.readUTF();
            if (version.compareTo(INFO_VERSION_3_5) == 0) {
                int uid = AddrUtil.getUidFromAdmin(env.getSubject());
                Vector txnAdminInfos = this.m_reg.getTransactionMgr().getPreparedBranchesInfo();
                int len = txnAdminInfos.size();
                rep.writeUTF(INFO_VERSION_3_5);
                rep.writeInt(len);
                Enumeration enu = txnAdminInfos.elements();
                while (enu.hasMoreElements()) {
                    TxnAdminInfo info = (TxnAdminInfo)enu.nextElement();
                    Vector owners = info.getOwnerIds();
                    Vector appids = info.getOwnerAppids();
                    rep.writeInt(owners.size());
                    for (int ownerIndex = 0; ownerIndex < owners.size(); ++ownerIndex) {
                        rep.writeUTF((String)owners.elementAt(ownerIndex));
                    }
                    rep.writeInt(appids.size());
                    for (int appidIndex = 0; appidIndex < appids.size(); ++appidIndex) {
                        rep.writeUTF((String)appids.elementAt(appidIndex));
                    }
                }
                s.reply(rep, env);
            }
        }
        catch (IOException e) {
            if (!Broker.isInShutdown()) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }
}

