/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ClientContextMgramQueue;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.IClientContext;
import progress.message.broker.LogEvent;
import progress.message.broker.MsgSaver;
import progress.message.broker.RecoveryMgr;
import progress.message.msg.IMgram;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;

public class GroupMsgDeallocationEvt
extends LogEvent {
    private static final short m_eventType = 183;
    private static final byte REPLICATE_ONLY_FLAG = 1;
    private byte m_flags;
    private long m_msgTracking;
    private long m_groupId;
    private IMgram m_msg;
    private IClientContext m_recipient;
    private GroupSubscriptionClientContext m_groupcc;
    private boolean reallocateOnFlush = false;

    public GroupMsgDeallocationEvt(IClientContext recipient, GroupSubscriptionClientContext groupcc, long msgTracking, IMgram msg) {
        this.m_msgTracking = msgTracking;
        this.m_msg = MsgSaver.removeLBSWrapper(msg);
        this.m_groupId = groupcc.getId();
        if (msg.isNonPersistentReplicated()) {
            this.m_flags = (byte)(this.m_flags | 1);
            this.setReplicateOnly(true);
        }
        this.m_recipient = recipient;
        this.m_groupcc = groupcc;
        this.reallocateOnFlush = true;
        if (this.DEBUG) {
            this.debug("Constructor; tracking= " + msgTracking);
        }
    }

    public GroupMsgDeallocationEvt(ClientContextMgramQueue.InDoubtXOGroupSend idgs, IClientContext recipient, IMgram m) {
        this.m_msgTracking = idgs.gma.msgTracking;
        this.m_groupcc = idgs.groupcc;
        this.m_groupId = this.m_groupcc.getId();
        this.m_msg = MsgSaver.removeLBSWrapper(m);
        this.m_recipient = recipient;
        if (idgs.gma.replOnly) {
            this.m_flags = (byte)(this.m_flags | 1);
            this.setReplicateOnly(true);
        }
        this.reallocateOnFlush = true;
        if (this.DEBUG) {
            this.debug("Constructor; tracking= " + this.m_msgTracking);
        }
    }

    public GroupMsgDeallocationEvt() {
    }

    long getMsgTracking() {
        return this.m_msgTracking;
    }

    long getGroupId() {
        return this.m_groupId;
    }

    @Override
    public void onFlush() {
        if (this.reallocateOnFlush) {
            this.m_groupcc.processXOnceGroupDeallocation(this.m_msg, this.m_recipient, false, true);
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoGroupDeallocation(this);
    }

    @Override
    protected int serializedSizeBody() {
        return 17;
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeByte(this.m_flags, os);
        StreamUtil.writeLong(this.m_msgTracking, os);
        StreamUtil.writeLong(this.m_groupId, os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException, EMgramFormatError {
        this.m_flags = StreamUtil.readByte(in);
        this.setReplicateOnly((this.m_flags & 1) != 0);
        this.m_msgTracking = StreamUtil.readLong(in);
        this.m_groupId = StreamUtil.readLong(in);
    }

    @Override
    protected int memSizeBody() {
        return this.streamSizeBody();
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public short type() {
        return 183;
    }

    @Override
    protected void writeBodyToLog(OutputStream os, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }
}

