/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.IClientContext;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.LBSTrackingInfo;
import progress.message.broker.parser.ParseException;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.msg.IMgram;
import progress.message.zclient.DebugObject;
import progress.message.zclient.FastVector;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.SearchResults;

public class GroupSubscription
extends DebugObject
implements ISubjectMatchObject {
    static final byte FIRST_SESSION_VERSION_WITH_CLIENT_SUPPORT = 25;
    private static final long DEFAULT_BACKLOGGED_SESSION_SKIP_WARNING_INTERVAL = TimeUnit.MINUTES.toMillis(2L);
    private static final int DEFAULT_BACKLOGGED_SESSION_SKIP_WARN_BUNCH_LIMIT = 5;
    private static Long s_backloggedSessionSkipWarnInterval;
    private static Integer s_backloggedSessionSkipWarnBunchLimit;
    private Map<String, Long[]> m_backloggedSessionSkipTracker = new HashMap<String, Long[]>();
    protected ISubject m_subject;
    private String m_groupName;
    private int m_durableMemberCount = 0;
    private int m_ftMemberCount = 0;
    private Boolean m_hasSelector = null;
    private String m_selector = null;
    private boolean DEBUG1;
    private Boolean m_isDupsOK = null;
    private volatile Boolean m_batchable = null;
    protected ArrayList<BrokerSubscription> m_subs;
    private int m_curSub;
    private int m_curDisDur;
    private GroupSubscriptionClientContext m_groupcc = null;
    private AgentRegistrar m_reg = null;
    private Object m_groupSubSyncObj = new Object();
    static final byte OFFLOADING_NO_CHECK = 0;
    static final byte OFFLOADING_FALSE = 1;
    static final byte OFFLOADING_TRUE = 2;

    protected Object getGroupSubscriptionSyncObj() {
        return this.m_groupSubSyncObj;
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    final void setGroupName(String groupName) {
        this.m_groupName = groupName;
    }

    public ISubject getSubject() {
        return this.m_subject;
    }

    protected void setSubject(ISubject subject) {
        this.m_subject = subject;
    }

    GroupSubscription(ISubject groupSubject, AgentRegistrar reg) {
        super("GroupSubscription " + groupSubject.getSubjectString());
        this.DEBUG1 = this.checkDebugFlags(64);
        if (this.DEBUG1) {
            this.debug("Constructor with " + groupSubject);
        }
        this.m_subject = groupSubject;
        this.setGroupName(groupSubject.getSubjectString());
        this.m_subs = new ArrayList();
        this.m_reg = reg;
    }

    @Override
    public String toString() {
        return "GroupSubscription for group " + this.m_groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(BrokerSubscription bs) throws EInvalidSubjectSyntax, ParseException {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            boolean isDupsOk;
            this.verifySelector(bs);
            this.m_subs.add(bs);
            if (this.DEBUG1) {
                this.debug("addSubscription added: bs= " + bs + " hasSelectors= " + bs.hasSelectors() + " groupSelector= " + this.m_selector + " m_subs.size= " + this.m_subs.size());
            }
            bs.setGroup(this);
            if (bs.getClient().isDurable()) {
                ++this.m_durableMemberCount;
            }
            if (bs.getClient().isXOnce()) {
                ++this.m_ftMemberCount;
            }
            boolean bl = isDupsOk = bs.getClient().getAckMode() == 3;
            if (this.m_isDupsOK == null || this.m_isDupsOK.booleanValue()) {
                this.m_isDupsOK = isDupsOk ? Boolean.TRUE : Boolean.FALSE;
            }
            this.calculateBatchable();
            if (this.DEBUG) {
                this.debug(" --> m_subs.size() = " + this.m_subs.size() + " isPurelyDurable() = " + this.isPurelyDurable());
            }
        }
    }

    public void subjectModified(ISubject added, ISubject removed) throws EInvalidSubjectSyntax {
        throw new UnsupportedOperationException("Subject modification is not supported for single subject groups.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(BrokerSubscription bs) {
        if (this.DEBUG) {
            this.debug("removeSubscription: " + bs);
        }
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            this.m_subs.remove(bs);
            if (this.DEBUG1) {
                this.debug("removeSubscription removed: bs= " + bs + " m_subs.size= " + this.m_subs.size());
            }
            bs.setGroup(null);
            if (bs.getClient().isDurable()) {
                --this.m_durableMemberCount;
            }
            if (bs.getClient().isXOnce()) {
                --this.m_ftMemberCount;
            }
            if (bs.getClient().getAckMode() != 3) {
                this.m_isDupsOK = null;
            }
            if (this.m_subs.isEmpty()) {
                this.m_hasSelector = null;
            }
            this.calculateBatchable();
            if (this.DEBUG) {
                String result = "GroupSubscription for group " + this.m_groupName + "\n[Local member count: " + this.m_subs.size() + " isPurelyDurable: " + this.isPurelyDurable() + "]";
                result = result + " on AgentRegistar.getId()=" + AgentRegistrar.getAgentRegistrar().getId() + " BROKER_APPID/NAME=" + "Broker" + "/" + Config.BROKER_NAME;
                int subCount = this.m_subs.size();
                for (int i = 0; i < subCount; ++i) {
                    BrokerSubscription bsi = this.m_subs.get(i);
                    IClientContext cc = bsi.getClient();
                    int state = cc.getState();
                    String stateString = "";
                    if (cc.isUnregistered()) {
                        stateString = " unregistered";
                    } else if (cc.isConnected()) {
                        stateString = " connected";
                    } else if (cc.isDisconnecting()) {
                        stateString = " disconnecting";
                    } else if (cc.isDisconnected()) {
                        stateString = " disconnected";
                    }
                    result = result + "\n  (" + i + ") " + bsi + " [State: " + state + stateString + "]";
                    result = result + "\n    --> [cc.getId()=" + cc.getId() + " cc.getAppId()=" + cc.getAppid() + "]";
                    if (cc.isDurable()) {
                        result = result + "-durable";
                    }
                    if (!cc.isInterbroker()) continue;
                    result = result + "-ib";
                }
                this.debug(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getGroupMemberIds() {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            ArrayList<Long> memberIds = new ArrayList<Long>();
            Iterator<BrokerSubscription> iter = this.m_subs.iterator();
            while (iter.hasNext()) {
                IClientContext cc = iter.next().getClient();
                if (cc == null) continue;
                memberIds.add(new Long(cc.getId()));
            }
            return memberIds.iterator();
        }
    }

    public boolean isEmpty() {
        return this.m_subs.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerSubscription selectBrokerSubscription(IMgram msg, LBSTrackingInfo visitedBrokerList, FastVector reallocationOptions) {
        GroupSubscriptionClientContext groupcc = this.m_groupcc;
        if (groupcc != null && groupcc.hasRecoveredInDoubtMembers()) {
            return null;
        }
        String lastTest = null;
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            BrokerSubscription bs;
            if (this.DEBUG) {
                lastTest = "Test: local/conn/!fc/!ackpdg";
            }
            if ((bs = this.selectConnected(msg, true, true, null, reallocationOptions, (byte)1, true)) == null) {
                long[] visitedBrokers = null;
                if (visitedBrokerList != null) {
                    visitedBrokers = visitedBrokerList.getTransitHistoryArray();
                    if (this.DEBUG) {
                        this.debug("Visited Brokers:" + visitedBrokers);
                    }
                }
                if (this.DEBUG) {
                    lastTest = "Test: all/conn/!fc";
                }
                if ((bs = this.selectConnected(msg, true, false, visitedBrokers, reallocationOptions, (byte)1, false)) == null && (bs = this.selectConnected(msg, true, false, visitedBrokers, reallocationOptions, (byte)2, false)) == null) {
                    if (!msg.isDiscardable()) {
                        if (this.DEBUG) {
                            lastTest = "Test: disconnected";
                        }
                        bs = this.selectDisconnected(msg, reallocationOptions);
                    }
                    if (bs != null && bs.getClient().getCWADSActiveBroker() == null || reallocationOptions != null) {
                        return null;
                    }
                    if (bs == null) {
                        if (this.DEBUG) {
                            lastTest = "Test: local/conn/fc";
                        }
                        bs = this.selectConnected(msg, false, true, null, reallocationOptions, (byte)0, false);
                    }
                }
                if (bs == null && !msg.isDiscardable() && (this.isPurelyDurable() || visitedBrokers == null)) {
                    if (this.DEBUG) {
                        lastTest = "Test: all/conn/fc";
                    }
                    bs = this.selectConnected(msg, false, false, visitedBrokers, reallocationOptions, (byte)0, false);
                }
            }
            if (this.DEBUG) {
                if (bs == null) {
                    this.debug(" selectBrokerSubscription for " + this.m_groupName + " --> return 'null' m_subs.size()=" + this.m_subs.size());
                } else {
                    this.debug(" selectBrokerSubscription for " + this.m_groupName + " --> m_curSub=" + this.m_curSub + " m_curDisDur=" + this.m_curDisDur + " m_subs.size()=" + this.m_subs.size() + " [" + lastTest + "]");
                }
            }
            return bs;
        }
    }

    public boolean okToSend(LBSTrackingInfo groups) {
        boolean ok = false;
        if (groups != null) {
            return groups.containsTarget(this.m_groupName);
        }
        return ok;
    }

    public boolean alreadyVisited(long ccid, long[] visited) {
        if (visited == null) {
            return false;
        }
        for (int i = 0; i < visited.length; ++i) {
            if (ccid != visited[i]) continue;
            return true;
        }
        return false;
    }

    private boolean isMemberOk(long ccid, FastVector rallocationOptions) {
        if (rallocationOptions == null) {
            return true;
        }
        for (int i = 0; i < rallocationOptions.m_count; ++i) {
            if (ccid != (Long)rallocationOptions.m_data[i]) continue;
            return true;
        }
        return false;
    }

    private BrokerSubscription selectConnected(IMgram msg, boolean checkOkToSend, boolean localOnly, long[] visitedBrokers, FastVector reallocationOptions, byte checkOffloading, boolean checkClientPendingAcksEmpty) {
        StringBuilder visitDebugStr;
        int subCount = this.m_subs.size();
        if (subCount == 0) {
            return null;
        }
        boolean checkVisited = false;
        if (!localOnly && visitedBrokers != null) {
            checkVisited = visitedBrokers.length > 0;
        }
        int start = this.m_curSub >= subCount ? 0 : this.m_curSub;
        this.m_curSub = (start + 1) % subCount;
        BrokerSubscription leastAcksPendingCandidate = null;
        int leastAcksPending = -1;
        int leastAcksPendingCandidatePosition = -1;
        StringBuilder stringBuilder = visitDebugStr = localOnly ? new StringBuilder("selectConnected: Shared Subscriber Selection Audit") : null;
        while (true) {
            BrokerSubscription bs;
            IClientContext cc;
            if ((cc = (bs = this.m_subs.get(this.m_curSub)).getClient()).isStarted() && this.isMemberOk(cc.getId(), reallocationOptions)) {
                IClientContext ibcc = null;
                if (cc.isInterbroker()) {
                    ibcc = cc;
                } else if (cc.getCWADSActiveBroker() != null && cc.getCWADSActiveBroker().isInterbroker()) {
                    ibcc = cc.getCWADSActiveBroker();
                }
                if (!(ibcc != null && localOnly || reallocationOptions == null && checkVisited && ibcc != null && this.alreadyVisited(ibcc.getId(), visitedBrokers) || bs.hasSelectors() && bs.getSelectorAtBroker() && msg.getType() != 27 && !bs.isMessageForSubscription(msg))) {
                    IClientContext sendCc;
                    if (!checkOkToSend) {
                        return bs;
                    }
                    IClientContext iClientContext = sendCc = ibcc != null ? ibcc : cc;
                    if (checkOffloading == 1 && sendCc.getOutQueue().getOffloadedPubSubQueue().isEmpty()) {
                        if (sendCc.getMinSendPriority(null) <= msg.getPriority() && sendCc.hasRoomForMgram(msg)) {
                            if (!localOnly || !checkClientPendingAcksEmpty) {
                                return bs;
                            }
                            int acksPending = sendCc.getPendingGuarCount() + sendCc.getPendingQCount();
                            visitDebugStr.append("-").append(this.m_curSub).append("A").append(acksPending);
                            if (acksPending <= 0) {
                                visitDebugStr.append("-").append(this.m_curSub).append("!");
                                if (leastAcksPendingCandidate != null && this.DEBUG) {
                                    this.debug(visitDebugStr.toString());
                                }
                                return bs;
                            }
                            if (acksPending > 0) {
                                this.sendBackloggedSessionSkipNotification(cc);
                            }
                            if (leastAcksPendingCandidate == null || acksPending < leastAcksPending) {
                                leastAcksPending = acksPending;
                                leastAcksPendingCandidatePosition = this.m_curSub;
                                leastAcksPendingCandidate = bs;
                            }
                        } else if (localOnly) {
                            visitDebugStr.append("-").append(this.m_curSub).append("F");
                        }
                    } else {
                        if (!(checkOffloading != 2 || !sendCc.useFlowToDisk() || sendCc.getOutQueue().getOffloadedPubSubQueue().isEmpty() && sendCc.hasRoomForMgram(msg))) {
                            return bs;
                        }
                        if (this.DEBUG) {
                            this.debug("Skipping flow controlled bs[" + this.m_curSub + "] sendCc.getMinSendPriority()=" + sendCc.getMinSendPriority(null));
                        }
                        this.sendBackloggedSessionSkipNotification(cc);
                    }
                }
            }
            if (this.m_curSub == start) {
                if (leastAcksPendingCandidate != null) {
                    this.m_curSub = leastAcksPendingCandidatePosition;
                    visitDebugStr.append("-").append(this.m_curSub).append("!");
                    if (this.DEBUG) {
                        this.debug(visitDebugStr.toString());
                    }
                    return leastAcksPendingCandidate;
                }
                if (visitDebugStr != null && this.DEBUG) {
                    this.debug(visitDebugStr.toString());
                }
                return null;
            }
            this.m_curSub = (this.m_curSub + 1) % subCount;
        }
    }

    private void sendBackloggedSessionSkipNotification(IClientContext clientContext) {
        long now = System.currentTimeMillis();
        BrokerSubscription userSubscription = clientContext.getSubscriptions().getUserSubscription();
        Long[] trackRecord = this.m_backloggedSessionSkipTracker.get(userSubscription.getTopic());
        boolean sendNotification = false;
        if (trackRecord == null || trackRecord[1] + this.getBackloggedSessionSkipWarningInterval() <= now) {
            trackRecord = trackRecord == null ? new Long[2] : trackRecord;
            trackRecord[0] = 1L;
            trackRecord[1] = now;
            sendNotification = true;
        } else if (trackRecord[0] < (long)this.getBackloggedSessionSkipWarnBunchLimit() && trackRecord[1] + this.getBackloggedSessionSkipWarningInterval() > now) {
            trackRecord[0] = trackRecord[0] + 1L;
            sendNotification = true;
        }
        if (sendNotification) {
            BrokerManagementNotificationsHelper.sendBackloggedSessionSkipNotification(clientContext);
            this.m_backloggedSessionSkipTracker.put(userSubscription.getTopic(), trackRecord);
        }
        this.cleanOldBackloggedSessionSkipTracks();
    }

    private void cleanOldBackloggedSessionSkipTracks() {
        long now = System.currentTimeMillis();
        for (String key : this.m_backloggedSessionSkipTracker.keySet()) {
            if (this.m_backloggedSessionSkipTracker.get(key)[1] + this.getBackloggedSessionSkipWarningInterval() >= now) continue;
            this.m_backloggedSessionSkipTracker.remove(key);
        }
    }

    private long getBackloggedSessionSkipWarningInterval() {
        if (s_backloggedSessionSkipWarnInterval != null) {
            return s_backloggedSessionSkipWarnInterval;
        }
        s_backloggedSessionSkipWarnInterval = Config.BACKLOGGED_SESSION_SKIP_WARN_INTERVAL >= 0L ? Long.valueOf(Config.BACKLOGGED_SESSION_SKIP_WARN_INTERVAL) : Long.valueOf(DEFAULT_BACKLOGGED_SESSION_SKIP_WARNING_INTERVAL);
        return s_backloggedSessionSkipWarnInterval;
    }

    private int getBackloggedSessionSkipWarnBunchLimit() {
        if (s_backloggedSessionSkipWarnBunchLimit != null) {
            return s_backloggedSessionSkipWarnBunchLimit;
        }
        s_backloggedSessionSkipWarnBunchLimit = Config.BACKLOGGED_SESSION_SKIP_WARN_BUNCH_LIMIT > 0 ? Integer.valueOf(Config.BACKLOGGED_SESSION_SKIP_WARN_BUNCH_LIMIT) : Integer.valueOf(5);
        return s_backloggedSessionSkipWarnBunchLimit;
    }

    private BrokerSubscription selectDisconnected(IMgram msg, FastVector reallocationOptions) {
        int subCount = this.m_subs.size();
        if (subCount == 0) {
            return null;
        }
        int start = this.m_curDisDur >= subCount ? 0 : this.m_curDisDur;
        this.m_curDisDur = (start + 1) % subCount;
        BrokerSubscription bs;
        IClientContext cc;
        while (!(cc = (bs = this.m_subs.get(this.m_curDisDur)).getClient()).isDurable() || cc.isPendingReconnect() || cc.isStarted() && cc.getCWADSActiveBroker() != null || !this.isMemberOk(cc.getId(), reallocationOptions) || bs.hasSelectors() && bs.getSelectorAtBroker() && msg.getType() != 27 && !bs.isMessageForSubscription(msg)) {
            if (this.m_curDisDur == start) {
                return null;
            }
            this.m_curDisDur = (this.m_curDisDur + 1) % subCount;
        }
        return bs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPurelyDurable() {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            int curcount = this.m_subs.size();
            return curcount == this.m_durableMemberCount;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsPersistence(IMgram m) {
        if (this.isEmpty()) {
            return false;
        }
        GroupSubscriptionClientContext groupcc = this.m_groupcc;
        if (groupcc != null && groupcc.hasRecoveredInDoubtMembers()) {
            return true;
        }
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            if (this.m_durableMemberCount > 0 || m.isJMSPersistent() && this.m_ftMemberCount > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFTMembers() {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            return this.m_ftMemberCount > 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDurables() {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            return this.m_durableMemberCount > 0;
            {
            }
        }
    }

    private boolean hasSelector() {
        return this.m_hasSelector != null && this.m_hasSelector != false;
    }

    private void verifySelector(BrokerSubscription bs) throws ParseException {
        boolean hasSelector = bs.hasSelector();
        if (bs.getClient().isInterbroker()) {
            return;
        }
        if (this.m_hasSelector == null) {
            this.m_hasSelector = hasSelector ? Boolean.TRUE : Boolean.FALSE;
            this.m_selector = bs.getSelectorString();
        } else if (this.m_hasSelector.booleanValue()) {
            if (!hasSelector) {
                ParseException e = new ParseException("Group " + this.getGroupName() + " is using message selector " + this.m_selector + " new member cannot join group without the same one.");
                throw e;
            }
            if (!this.m_selector.equals(bs.getSelectorString())) {
                ParseException e = new ParseException("Group " + this.getGroupName() + " is using message selector " + this.m_selector + " new member cannot join group with " + bs.getSelectorString());
                throw e;
            }
        } else if (!this.m_hasSelector.booleanValue() && hasSelector) {
            ParseException e = new ParseException("Group " + this.getGroupName() + " is not using  a message selector " + " new member cannot join group with selector " + bs.getSelectorString());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkGroupInterestInMgram(IMgram m) {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            if (this.isEmpty()) {
                return false;
            }
            if (!this.hasSelector()) {
                return true;
            }
            BrokerSubscription selbs = this.getOneSubscription();
            if (selbs == null) {
                return false;
            }
            return !selbs.hasSelectors() || !selbs.getSelectorAtBroker() || m.getType() == 27 || selbs.isMessageForSubscription(m);
            {
            }
        }
    }

    @Override
    public final void prefixMatch(ISubject subject, SearchResults result) {
    }

    @Override
    public final boolean localEffect() {
        return true;
    }

    @Override
    public boolean isBatchable() {
        if (this.m_batchable == null) {
            this.calculateBatchable();
        }
        return this.m_batchable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateBatchable() {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            if (InterbrokerHook.isSet()) {
                this.m_batchable = Boolean.FALSE;
                return;
            }
            if (this.m_hasSelector == null || this.hasSelector()) {
                this.m_batchable = Boolean.FALSE;
                return;
            }
            if (this.m_subs.isEmpty()) {
                this.m_batchable = Boolean.FALSE;
                return;
            }
            for (int i = 0; i < this.m_subs.size(); ++i) {
                if (this.m_subs.get(i).isBatchable()) continue;
                this.m_batchable = Boolean.FALSE;
                return;
            }
            this.m_batchable = Boolean.TRUE;
        }
    }

    @Override
    public boolean isBatchAtomic(boolean batchAtomicIfNonDurable) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDupsOK() {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            this.m_isDupsOK = null;
        }
    }

    public void setGroupCC(GroupSubscriptionClientContext cc) {
        this.m_groupcc = cc;
    }

    public GroupSubscriptionClientContext getGroupCC() {
        return this.m_groupcc;
    }

    public String getGroupAppid() {
        return "$GROUPSUBSCRIPTION$";
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        String objName = ((GroupSubscription)obj).getGroupName();
        if (objName == null && this.m_groupName != null) {
            return false;
        }
        if (this.m_groupName == null && objName != null) {
            return false;
        }
        if (this.m_groupName == null && objName == null) {
            return true;
        }
        return this.m_groupName.equalsIgnoreCase(objName);
    }

    public int hashCode() {
        return Objects.hash(this.m_groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerSubscription getOneSubscription(HashSet memberList) {
        BrokerSubscription bs = null;
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            for (BrokerSubscription nbs : this.m_subs) {
                if (!memberList.contains(new Long(nbs.getClientId()))) continue;
                bs = nbs;
                break;
            }
        }
        return bs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerSubscription getOneSubscription() {
        BrokerSubscription returnedbs = null;
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            if (this.m_subs.isEmpty()) {
                return null;
            }
            Iterator<BrokerSubscription> it = this.m_subs.iterator();
            BrokerSubscription neighborbs = null;
            while (it.hasNext()) {
                BrokerSubscription bs = it.next();
                if (bs.getClient().isInterbroker()) {
                    if (neighborbs != null) continue;
                    neighborbs = bs;
                    continue;
                }
                returnedbs = bs;
                break;
            }
            if (returnedbs == null && neighborbs != null) {
                returnedbs = neighborbs;
            }
        }
        return returnedbs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<BrokerSubscription> appendAllSubscriptions(Collection<BrokerSubscription> c) {
        int size = 0;
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            size = this.m_subs.size();
            if (size > 0) {
                for (BrokerSubscription bs : this.m_subs) {
                    c.add(bs);
                }
            }
        }
        return c;
    }
}

