/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentListener;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.AgentSender;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.GroupMultiTopicSubscription;
import progress.message.broker.GroupSubscription;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.LBSTrackingInfo;
import progress.message.broker.PipeSocket;
import progress.message.broker.parser.ParseException;
import progress.message.client.EConnectFailure;
import progress.message.client.EConnectionLimitExceeded;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.EUserAlreadyConnected;
import progress.message.client.Username;
import progress.message.msg.IMgram;
import progress.message.net.ISocket;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.FastVector;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.Listener;
import progress.message.zclient.ProgressSecureRandom;
import progress.message.zclient.Sender;
import progress.message.zclient.SubjectUtil;

class GroupSubscriptions
extends DebugObject {
    private HashMap m_groups = new HashMap();
    private AgentRegistrar m_reg;

    GroupSubscriptions(AgentRegistrar reg) {
        super("GroupSubscriptions");
        this.m_reg = reg;
    }

    GroupSubscription getGroup(ISubject groupSub) {
        if (this.DEBUG) {
            this.debug("[" + new Date(System.currentTimeMillis()) + "]" + " get " + groupSub);
        }
        Object group = null;
        String groupName = this.getGroupNameFromSubject(groupSub);
        return this.getGroupByName(groupName);
    }

    GroupSubscription getGroupByName(String groupName) {
        if (this.DEBUG) {
            this.debug("[" + new Date(System.currentTimeMillis()) + "]" + " get " + groupName + " by name ");
        }
        Object group = null;
        group = this.m_groups.get(groupName);
        return group == null ? null : (GroupSubscription)group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupSubscription lookupGroup(BrokerSubscription bs) throws EInvalidSubjectSyntax {
        ISubject groupSubject = bs.getSubject();
        if (this.DEBUG) {
            this.debug("[" + new Date(System.currentTimeMillis()) + "]" + " addGroup: " + groupSubject);
        }
        GroupSubscription group = null;
        String groupName = this.getGroupNameFromSubject(groupSubject);
        group = this.getGroupByName(groupName);
        GroupSubscriptionClientContext groupcc = null;
        if (group == null) {
            groupcc = this.createSubscriptionGroupCC(groupName);
            if (groupcc == null) {
                throw new EAssertFailure("Internal failure initializing GroupSubscription.");
            }
            try {
                groupcc.lock();
                group = groupSubject.isMultiSubject() ? new GroupMultiTopicSubscription(groupSubject, this.m_reg) : new GroupSubscription(groupSubject, this.m_reg);
                group.setGroupCC(groupcc);
                groupcc.setGroup(group);
                this.m_reg.getSubjectSpace().put(groupSubject, (ISubjectMatchObject)group);
                this.m_groups.put(group.getGroupName(), group);
            }
            finally {
                groupcc.unlock();
            }
        } else {
            groupcc = group.getGroupCC();
        }
        if (!bs.getClient().isInterbroker()) {
            bs.getClient().setGroupSubscriptionCC(groupcc);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeGroup(ISubject groupSub) {
        if (this.DEBUG) {
            this.debug("[" + new Date(System.currentTimeMillis()) + "]" + " removeGroup: " + groupSub);
        }
        HashMap hashMap = this.m_groups;
        synchronized (hashMap) {
            String groupName = this.getGroupNameFromSubject(groupSub);
            GroupSubscription group = (GroupSubscription)this.m_groups.remove(groupName);
            if (this.DEBUG) {
                this.debug("[" + new Date(System.currentTimeMillis()) + "]" + " removeSubscription --> empty group --> remove the Group Sub.");
            }
            this.m_reg.getSubjectSpace().removeSubjectObject(groupSub, (ISubjectMatchObject)group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addGroupSubscription(BrokerSubscription bs) throws EInvalidSubjectSyntax, ParseException {
        if (!bs.getSubject().hasGroup()) {
            throw new EInvalidSubjectSyntax("The subject " + bs.getSubject() + " is not a valid group topic");
        }
        HashMap hashMap = this.m_groups;
        synchronized (hashMap) {
            GroupSubscription gs = null;
            gs = this.lookupGroup(bs);
            gs.addSubscription(bs);
            GroupSubscriptionClientContext groupcc = gs.getGroupCC();
            if (groupcc != null) {
                try {
                    groupcc.checkState();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    void groupSubjectModified(ISubject oldSubject, BrokerSubscription bs, ISubject added, ISubject removed) throws EInvalidSubjectSyntax {
        GroupSubscription gs = this.getGroup(oldSubject);
        if (gs != null) {
            gs.subjectModified(added, removed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSubscription(BrokerSubscription bs) {
        if (this.DEBUG) {
            this.debug("[" + new Date(System.currentTimeMillis()) + "]" + " removeSubscription: " + bs);
        }
        HashMap hashMap = this.m_groups;
        synchronized (hashMap) {
            ISubject groupSub = bs.getSubject();
            GroupSubscription gs = this.getGroup(groupSub);
            if (gs != null) {
                gs.removeSubscription(bs);
                if (gs.isEmpty()) {
                    this.removeGroup(groupSub);
                    GroupSubscriptionClientContext groupcc = gs.getGroupCC();
                    if (groupcc != null) {
                        boolean cclocked = false;
                        try {
                            groupcc.waitForGroupCCUnfreeze(false);
                            cclocked = true;
                            this.removeSubscriptionGroupCC(groupcc);
                            gs.setGroupCC(null);
                        }
                        catch (InterruptedException iex) {
                            Thread.currentThread().interrupt();
                        }
                        finally {
                            if (cclocked) {
                                groupcc.unlockGroupCC();
                            }
                        }
                    }
                } else {
                    GroupSubscriptionClientContext groupcc = gs.getGroupCC();
                    if (groupcc != null) {
                        groupcc.notifyGroup();
                    }
                }
                gs = null;
            }
        }
    }

    GSLookupResult lookUpSubscribers(LBSTrackingInfo groups, boolean batchAtomicIfNonDurable) {
        FastVector matches = new FastVector();
        int hops = groups.getHopCount();
        boolean isBatchable = true;
        boolean isBatchAtomic = true;
        for (int i = 0; i < groups.getTargetCount(); ++i) {
            String groupname = (String)groups.getTargetGroups().m_data[i];
            GroupSubscription gs = this.getGroupByName(groupname);
            if (gs == null) continue;
            matches.addElement(gs);
            if (this.DEBUG) {
                this.debug("[" + new Date(System.currentTimeMillis()) + "]" + " lookUpSubscribers: selecting " + gs + " from " + groupname);
            }
            if (!gs.isBatchable()) {
                isBatchable = false;
            }
            if (gs.isBatchAtomic(batchAtomicIfNonDurable)) continue;
            isBatchAtomic = false;
        }
        GSLookupResult result = new GSLookupResult();
        result.m_matches = matches;
        result.m_isBatchable = isBatchable;
        result.m_isBatchAtomic = isBatchAtomic;
        return result;
    }

    static int lookUpHops(FastVector groups) {
        if (groups == null) {
            return 0;
        }
        return (Integer)groups.m_data[0];
    }

    Collection getGroupSubscriptions() {
        return this.m_groups.values();
    }

    private String getGroupNameFromSubject(ISubject subject) {
        String key = null;
        key = subject.isMultiSubject() ? SubjectUtil.wrapSubjectGroupPrefix(subject.getGroupName()) : subject.getSubjectString();
        return key;
    }

    private GroupSubscriptionClientContext createSubscriptionGroupCC(String groupName) throws EInvalidSubjectSyntax {
        long groupClientID = AddrUtil.stringToClientId(groupName, "$GROUPSUBSCRIPTION$");
        GroupSubscriptionClientContext groupCC = null;
        try {
            Username principal = new Username(groupName);
            ClientSecurityContext csc = new ClientSecurityContext(principal, groupName, "$GROUPSUBSCRIPTION$", groupClientID, false, false, null, null, -1L);
            AgentConnection dummyConnection = this.createDummyConnection();
            dummyConnection.connectSuccess(0, csc, groupClientID);
            long ccid = this.m_reg.connect(groupClientID, dummyConnection, csc, false, (short)-1);
            groupCC = (GroupSubscriptionClientContext)this.m_reg.getClient(ccid);
            return groupCC;
        }
        catch (EUserAlreadyConnected ex) {
            throw new EInvalidSubjectSyntax("EUserAlreadyConnected error creating group for " + groupName + ":" + ex.getMessage());
        }
        catch (EConnectionLimitExceeded ex) {
            throw new EInvalidSubjectSyntax("EConnectionLimitExceeded error creating group for " + groupName + ":" + ex.getMessage());
        }
        catch (EConnectFailure ex) {
            throw new EInvalidSubjectSyntax("EConnectFailure error creating group for " + groupName + ":" + ex.getMessage());
        }
        catch (InterruptedException ex) {
            throw new EInvalidSubjectSyntax("InterruptedException error creating group for " + groupName + ":" + ex.getMessage());
        }
        catch (EClientNotRegistered ex) {
            throw new EInvalidSubjectSyntax("EClientNotRegistered error creating group for " + groupName + ":" + ex.getMessage());
        }
    }

    private void removeSubscriptionGroupCC(GroupSubscriptionClientContext groupcc) throws InterruptedException {
        if (groupcc == null) {
            return;
        }
        long groupccid = groupcc.getId();
        groupcc.stopDelivery();
        groupcc.waitForPubDispatches();
        this.m_reg.terminateClient(groupccid);
    }

    private final AgentConnection createDummyConnection() throws EConnectFailure {
        try {
            PipeSocket socket = new PipeSocket();
            GroupSubscriptionDummyConnection agentConn = new GroupSubscriptionDummyConnection(socket, ProgressSecureRandom.theSecureRandom().nextLong());
            return agentConn;
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EConnectFailure(-1, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoveryComplete() {
        FastVector groupSubCCs;
        HashMap hashMap = this.m_groups;
        synchronized (hashMap) {
            groupSubCCs = new FastVector(this.m_groups.size());
            Iterator subs = this.m_groups.values().iterator();
            while (subs.hasNext()) {
                groupSubCCs.addElement(((GroupSubscription)subs.next()).getGroupCC());
            }
        }
        for (int i = 0; i < groupSubCCs.m_count; ++i) {
            GroupSubscriptionClientContext gscc = (GroupSubscriptionClientContext)groupSubCCs.m_data[i];
            if (gscc == null) continue;
            gscc.recoveryComplete();
        }
    }

    public static final boolean isLBSWrappedMessage(IMgram m) {
        if (m == null || m.getType() != 25) {
            return false;
        }
        return m.getOperationHandle().getOperationType() == 14 || m.getOperationHandle().getOperationType() == 13;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSyncRecords() throws ECannotFlushEvents {
        FastVector groupSubCCs;
        HashMap hashMap = this.m_groups;
        synchronized (hashMap) {
            groupSubCCs = new FastVector(this.m_groups.size());
            Iterator subs = this.m_groups.values().iterator();
            while (subs.hasNext()) {
                groupSubCCs.addElement(((GroupSubscription)subs.next()).getGroupCC());
            }
        }
        for (int i = 0; i < groupSubCCs.m_count; ++i) {
            GroupSubscriptionClientContext gscc = (GroupSubscriptionClientContext)groupSubCCs.m_data[i];
            if (gscc == null) continue;
            gscc.writeSyncRecords();
        }
    }

    class GroupSubscriptionDummyConnection
    extends AgentConnection {
        public GroupSubscriptionDummyConnection(ISocket socket, long socketId) throws IOException {
            super(socket, socketId, false);
        }

        @Override
        boolean isAdminConnection() {
            return false;
        }

        @Override
        public AgentSender getAgentSender() {
            return null;
        }

        @Override
        public AgentListener getAgentListener() {
            return null;
        }

        @Override
        public Sender getSender() {
            return null;
        }

        @Override
        public Listener getListener() {
            return null;
        }

        @Override
        public boolean getFaultTolerant() {
            return false;
        }
    }

    public static class GSLookupResult {
        public FastVector m_matches = null;
        public boolean m_isBatchable = false;
        public boolean m_isBatchAtomic = false;
    }
}

