/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EBrokerTxnFailure;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EInvalidLogEvent;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.IAMPHandle;
import progress.message.broker.IClientContext;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.LBSTrackingInfo;
import progress.message.broker.LogEvent;
import progress.message.broker.MgramSerializer;
import progress.message.broker.PublishLimiter;
import progress.message.broker.RecipientVector;
import progress.message.broker.RecipientWrap;
import progress.message.broker.RecoveryMgr;
import progress.message.broker.TrackedSubjectFilter;
import progress.message.broker.prAccessor;
import progress.message.client.ESecurityGeneralException;
import progress.message.gr.RouterManager;
import progress.message.msg.IBatchHandle;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.EDuplicateKey;
import progress.message.util.LongHashTable;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.FastVector;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectFilter;
import progress.message.zclient.Label;
import progress.message.zclient.xonce.MgramTrace;

public class GuarMsgEvt
extends LogEvent {
    private IMgram m_guarMgram;
    private long m_orig_sender;
    private long m_orig_tracking;
    private boolean m_acked;
    private long m_redirectAckClient = -1L;
    private int m_tid;
    private boolean m_needGuarAck;
    private boolean m_needIBGuarAck;
    private boolean m_needRBGuarAck;
    private IClientContext m_publisher = null;
    FastVector m_guarRecips;
    private boolean m_deliveredToPubSub = false;
    FastVector m_ptpRecips;
    long[] m_ptpTrackingNums = null;
    private boolean m_xonce;
    private boolean m_deliverOnFlush = false;
    private boolean m_delivered = false;
    private PublishLimiter m_pubLimiter;
    private IMessageProtection m_mp;
    private IAMPHandle m_AMPHandle;
    private AgentGuarMsgTracker m_tracker;
    private LBSTrackingInfo m_groupSubscriptionList = null;
    private boolean m_groupSubscriptionOnly = false;
    private LongHashTable m_proxyRecipsTable;
    private volatile boolean m_splitBatch = false;
    private boolean m_batchedPublish = false;
    private boolean m_splitBatchOrBatchedPublish = false;
    private short m_eventType = (short)180;
    private boolean m_proxiedCidsOnly = false;
    private LongHashTable m_subjectFilters = null;
    private LongHashTable m_proxyLBSRecipsTable = null;

    public void setLBSInfo(LBSTrackingInfo groupSubscriptionList, boolean groupSubscriptionOnly) {
        this.m_groupSubscriptionList = groupSubscriptionList;
        this.m_groupSubscriptionOnly = groupSubscriptionOnly;
    }

    public LBSTrackingInfo getGroupSubscriptionList() {
        return this.m_groupSubscriptionList;
    }

    public boolean getGroupSubscriptionOnly() {
        return this.m_groupSubscriptionOnly;
    }

    GuarMsgEvt(IMgram guarMgram) {
        this(guarMgram, null, null, null, null, null, false, false, false, false, false, null, null, null, null, null, null);
        this.m_proxiedCidsOnly = true;
    }

    GuarMsgEvt(IMgram guarMgram, IMgram relMgram, RecipientVector guarRecips, RecipientVector ptpRecips, long[] ptpTrackingNums, IClientContext publisher, boolean xonce, boolean deliverOnFlush, boolean needGuarAck, boolean needIBGuarAck, boolean needRBGuarAck, IMessageProtection mp, PublishLimiter pubLimiter, IAMPHandle AMPHandle2, LongHashTable proxyRecipsTable, LongHashTable subjectFilters, LongHashTable proxyLBSRecipsTable) {
        this.m_guarMgram = guarMgram;
        if (guarRecips != null) {
            this.m_guarRecips = (FastVector)guarRecips.clone();
        }
        if (ptpRecips != null) {
            this.m_ptpRecips = (FastVector)ptpRecips.clone();
            if (this.m_ptpRecips.m_count > 0) {
                this.m_ptpTrackingNums = new long[ptpTrackingNums.length];
                for (int ii = 0; ii < ptpTrackingNums.length; ++ii) {
                    this.m_ptpTrackingNums[ii] = ptpTrackingNums[ii];
                }
            }
        }
        this.m_publisher = publisher;
        this.m_orig_sender = guarMgram.getBrokerHandle().getSenderID();
        this.m_orig_tracking = guarMgram.getGuarenteedTrackingNum();
        this.setReplicateOnly(guarMgram.isNonPersistentReplicated());
        this.m_needGuarAck = needGuarAck;
        this.m_needIBGuarAck = needIBGuarAck;
        this.m_needRBGuarAck = needRBGuarAck;
        this.m_redirectAckClient = this.m_guarMgram.getBrokerHandle().getRedirectAckTarget();
        this.m_xonce = xonce;
        this.m_deliverOnFlush = deliverOnFlush;
        this.m_mp = mp;
        this.m_pubLimiter = pubLimiter;
        this.m_AMPHandle = AMPHandle2;
        if (proxyRecipsTable != null && !proxyRecipsTable.isEmpty()) {
            this.m_proxyRecipsTable = proxyRecipsTable;
        }
        int subjectTrackingCount = 1;
        if (guarMgram.getSubject().isMultiSubject()) {
            subjectTrackingCount += guarMgram.getSubject().getMultiSubjectCount();
        }
        this.m_subjectFilters = subjectFilters;
        if (guarMgram.getType() == 27) {
            IBatchHandle batchHandle = guarMgram.getBatchHandle();
            int batchSize = batchHandle.getBatchSize();
            this.setNumSeqNos((batchSize + 1) * subjectTrackingCount);
        } else {
            this.m_batchedPublish = guarMgram.getBrokerHandle().isBatchedPublish();
            if (subjectTrackingCount > 1) {
                this.setNumSeqNos(subjectTrackingCount);
            }
        }
        this.m_proxiedCidsOnly = false;
        this.m_proxyLBSRecipsTable = proxyLBSRecipsTable;
    }

    GuarMsgEvt(short type) {
        this.m_eventType = type;
        this.m_proxiedCidsOnly = true;
    }

    GuarMsgEvt(GuarMsgEvt evt) {
        super(evt);
        this.m_guarMgram = evt.m_guarMgram;
        this.m_orig_sender = evt.m_orig_sender;
        this.m_orig_tracking = evt.m_orig_tracking;
        this.m_acked = evt.m_acked;
        this.m_redirectAckClient = evt.m_redirectAckClient;
        this.m_tid = evt.m_tid;
        this.m_needGuarAck = evt.m_needGuarAck;
        this.m_needIBGuarAck = evt.m_needIBGuarAck;
        this.m_needRBGuarAck = evt.m_needRBGuarAck;
        this.m_publisher = evt.m_publisher;
        this.m_guarRecips = evt.m_guarRecips;
        this.m_ptpRecips = evt.m_ptpRecips;
        this.m_ptpTrackingNums = evt.m_ptpTrackingNums;
        this.m_xonce = evt.m_xonce;
        this.m_deliverOnFlush = evt.m_deliverOnFlush;
        this.m_delivered = evt.m_delivered;
        this.m_pubLimiter = evt.m_pubLimiter;
        this.m_mp = evt.m_mp;
        this.m_AMPHandle = evt.m_AMPHandle;
        this.m_tracker = evt.m_tracker;
        this.m_proxyRecipsTable = evt.m_proxyRecipsTable;
        this.m_proxyLBSRecipsTable = evt.m_proxyLBSRecipsTable;
        this.m_proxiedCidsOnly = evt.m_proxiedCidsOnly;
        this.m_splitBatch = evt.m_splitBatch;
        this.m_batchedPublish = evt.m_batchedPublish;
        this.m_splitBatchOrBatchedPublish = evt.m_splitBatchOrBatchedPublish;
        this.m_eventType = evt.m_eventType;
    }

    public GuarMsgEvt rgmClone() {
        GuarMsgEvt result = new GuarMsgEvt(this);
        result.setPrev(null);
        result.setNext(null);
        if (this.m_guarRecips != null) {
            result.m_guarRecips = (FastVector)this.m_guarRecips.clone();
        }
        if (this.m_ptpRecips != null) {
            result.m_ptpRecips = (FastVector)this.m_ptpRecips.clone();
        }
        if (this.m_ptpTrackingNums != null) {
            result.m_ptpTrackingNums = (long[])this.m_ptpTrackingNums.clone();
        }
        if (this.m_proxyRecipsTable != null) {
            result.m_proxyRecipsTable = (LongHashTable)this.m_proxyRecipsTable.clone();
        }
        if (this.m_proxyLBSRecipsTable != null) {
            result.m_proxyLBSRecipsTable = (LongHashTable)this.m_proxyLBSRecipsTable.clone();
        }
        return result;
    }

    @Override
    public void setSeqNo(long tracking) {
        super.setSeqNo(tracking);
        if (this.m_guarMgram != null) {
            this.m_guarMgram.setGuarenteed(tracking);
            if (this.m_guarMgram.getSubject().isMultiSubject()) {
                if (this.getNumSeqNos() < this.m_guarMgram.getSubject().getMultiSubjectCount()) {
                    new EAssertFailure("MultiSubject GME with too few subject tracking numbers.");
                }
                this.m_guarMgram.getBrokerHandle().assignSubjectTrackingNumbers(tracking);
            }
        }
    }

    public IMgram getMessage() {
        return this.m_guarMgram;
    }

    FastVector getGuarRecipients() {
        return this.m_guarRecips;
    }

    FastVector getPtpRecipients() {
        return this.m_ptpRecips;
    }

    long[] getPtpTrackingNums() {
        return this.m_ptpTrackingNums;
    }

    void setGuarAck(boolean needGuarAck) {
        this.m_needGuarAck = needGuarAck;
    }

    void setIBGuarAck(boolean val) {
        this.m_needIBGuarAck = val;
    }

    void setRBGuarAck(boolean val) {
        this.m_needRBGuarAck = val;
    }

    boolean needGuarAck() {
        return this.m_needGuarAck;
    }

    @Override
    public short type() {
        return 180;
    }

    public long getOrigSender() {
        return this.m_orig_sender;
    }

    long getOrigTracking() {
        return this.m_orig_tracking;
    }

    long getRedirectAckClient() {
        return this.m_redirectAckClient;
    }

    AgentGuarMsgTracker getTracker() {
        return this.m_tracker;
    }

    public void setMessageProtection(IMessageProtection mp) {
        this.m_mp = mp;
    }

    public void setPubLimiter(PublishLimiter pubLimiter) {
        this.m_pubLimiter = pubLimiter;
    }

    public void setAMPHandle(IAMPHandle handle) {
        this.m_AMPHandle = handle;
    }

    public boolean splitBatch() {
        return this.m_splitBatch;
    }

    public void setSplitBatch(boolean splitBatch) {
        this.m_splitBatch = splitBatch;
    }

    public boolean isBatchedPublish() {
        return this.m_batchedPublish;
    }

    public void setBatchedPublish(boolean batchedPublish) {
        this.m_batchedPublish = batchedPublish;
    }

    public synchronized void setDeliveredToPubSub() {
        this.m_deliveredToPubSub = true;
    }

    public synchronized boolean getDeliveredToPubSub() {
        return this.m_deliveredToPubSub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDeliveryInfo(RecipientVector guarRecips, RecipientVector ptpRecips, long[] ptpTrackingNums, boolean xonce, LongHashTable proxyRecipsTable, boolean cloneProxyRecipsTable, LongHashTable sft, LongHashTable proxyLBSRecipsTable) {
        if (guarRecips != null) {
            this.m_guarRecips = (FastVector)guarRecips.clone();
        }
        if (ptpRecips != null) {
            this.m_ptpRecips = (FastVector)ptpRecips.clone();
            if (this.m_ptpRecips.m_count > 0) {
                this.m_ptpTrackingNums = new long[ptpTrackingNums.length];
                for (int ii = 0; ii < ptpTrackingNums.length; ++ii) {
                    this.m_ptpTrackingNums[ii] = ptpTrackingNums[ii];
                }
            }
        }
        this.m_xonce = xonce;
        if (proxyRecipsTable != null && !proxyRecipsTable.isEmpty()) {
            LongHashTable longHashTable = this.m_proxyRecipsTable = cloneProxyRecipsTable ? (LongHashTable)proxyRecipsTable.clone() : proxyRecipsTable;
        }
        if (cloneProxyRecipsTable) {
            if (sft != null && !sft.isEmpty()) {
                LongHashTable<ISubjectFilter> copy = new LongHashTable<ISubjectFilter>(sft.size());
                LongHashTable longHashTable = sft;
                synchronized (longHashTable) {
                    Enumeration<Long> keys = sft.keys();
                    Enumeration vals = sft.elements();
                    while (keys.hasMoreElements()) {
                        long key = keys.nextElement();
                        ISubjectFilter filter = (ISubjectFilter)vals.nextElement();
                        copy.put(key, filter.protectedClone());
                    }
                }
                this.m_subjectFilters = copy;
            }
            if (proxyLBSRecipsTable != null && !proxyLBSRecipsTable.isEmpty()) {
                this.m_proxyLBSRecipsTable = (LongHashTable)proxyLBSRecipsTable.clone();
            }
        } else {
            this.m_subjectFilters = sft;
            this.m_proxyLBSRecipsTable = proxyLBSRecipsTable;
        }
        if (this.m_tracker != null) {
            int pubSubAcks = this.m_xonce && this.m_guarRecips != null ? this.m_guarRecips.m_count : 0;
            this.m_tracker.setExpectedPubSubAckCount(pubSubAcks);
            int ptpAcks = this.m_xonce && this.m_ptpRecips != null ? this.m_ptpRecips.m_count : 0;
            this.m_tracker.setExpectedPtpAckCount(ptpAcks);
        }
        this.m_guarMgram.getBrokerHandle().setSubjectFilters(this.m_subjectFilters);
    }

    public void setTransacted(int tid) {
        this.m_tid = tid;
    }

    public void setNonTransacted() {
        this.m_tid = 0;
    }

    public boolean isTransacted() {
        return this.m_tid != 0;
    }

    public int getTransactionId() {
        return this.m_tid;
    }

    synchronized boolean removeRecipient(long id, boolean inDoubt) {
        if (this.DEBUG) {
            System.out.println("Removing recipient: " + id + " indoubt " + inDoubt + " GUAR=" + this.m_seqno);
        }
        boolean result = false;
        if (this.m_guarRecips != null) {
            boolean removed = false;
            for (int i = 0; i < this.m_guarRecips.m_data.length; ++i) {
                RecipientWrap rw = (RecipientWrap)this.m_guarRecips.m_data[i];
                if (rw == null || !rw.hasClientContext() || rw.getId() != id && rw.getGroupCCId() != id) continue;
                result = true;
                if (!inDoubt && this.m_proxyRecipsTable != null && this.removeProxyRecips(id) && this.DEBUG) {
                    System.out.println("Removed untargeted proxy recips for: " + rw.getId() + ", GUAR=" + this.m_seqno);
                }
                this.m_guarRecips.m_data[i] = null;
                removed = true;
                break;
            }
            if (!removed) {
                IClientContext cc = null;
                AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
                try {
                    cc = reg.getClient(id);
                    if (cc.isGroupSubscriptionMember()) {
                        result = this.removeRecipient(cc.getGroupSubscriptionCC().getId(), inDoubt);
                    }
                }
                catch (EClientNotRegistered e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    synchronized boolean hasProxyMappings() {
        return this.m_proxyRecipsTable != null && !this.m_proxyRecipsTable.isEmpty();
    }

    synchronized boolean removeProxyRecips(long proxyId) {
        if (this.m_proxyRecipsTable != null && this.m_proxyRecipsTable.remove(proxyId) != null) {
            if (this.m_proxyRecipsTable.isEmpty()) {
                this.m_proxyRecipsTable = null;
            }
            return true;
        }
        return false;
    }

    synchronized LongHashTable getProxyRecipsTable() {
        return this.m_proxyRecipsTable;
    }

    synchronized boolean hasProxyLBSRecips() {
        return this.m_proxyLBSRecipsTable != null && !this.m_proxyLBSRecipsTable.isEmpty();
    }

    synchronized boolean removeProxyLBSRecips(long proxyId) {
        if (this.m_proxyLBSRecipsTable != null && this.m_proxyLBSRecipsTable.remove(proxyId) != null) {
            if (this.m_proxyLBSRecipsTable.isEmpty()) {
                this.m_proxyLBSRecipsTable = null;
            }
            return true;
        }
        return false;
    }

    synchronized void removeAllProxyLBSRecips() {
        this.m_proxyLBSRecipsTable = null;
    }

    synchronized LongHashTable getProxyLBSRecipsTable() {
        return this.m_proxyLBSRecipsTable;
    }

    synchronized LongHashTable getSubjectFilters() {
        return this.m_subjectFilters;
    }

    synchronized void removeQRecipient(long tracking) {
        if (this.m_ptpRecips != null) {
            for (int ii = 0; ii < this.m_ptpRecips.m_data.length; ++ii) {
                if (this.m_ptpTrackingNums[ii] != tracking) continue;
                this.m_ptpRecips.m_data[ii] = null;
                break;
            }
        }
    }

    synchronized void removeAllQRecipients() {
        this.m_ptpRecips = null;
    }

    @Override
    protected void onFlush() {
        block7: {
            try {
                if (this.m_deliverOnFlush) {
                    this.deliverMsg();
                }
            }
            catch (ESecurityGeneralException ege) {
                BrokerComponent.getComponentContext().logMessage("Error encrypting message", (Throwable)ege, 1);
            }
            if (this.isTransacted()) {
                long[] tracking = new long[]{this.m_orig_tracking};
                try {
                    if (AgentRegistrar.getAgentRegistrar().getTransactionMgr().getTxn(this.m_tid).sendStorageAcks(tracking, false)) {
                        return;
                    }
                }
                catch (EBrokerTxnFailure ex) {
                    if (!this.DEBUG) break block7;
                    BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
                }
            }
        }
        this.sendAck();
    }

    @Override
    public boolean utilizeActionProcessor() {
        return this.m_deliverOnFlush;
    }

    void allAcksReceived() {
        this.sendAck();
    }

    @Override
    public int memSizeBody() {
        return 35 + (this.m_guarRecips == null || !this.m_xonce ? 0 : this.m_guarRecips.m_data.length * 8) + (this.m_ptpRecips == null || !this.m_xonce ? 0 : this.m_ptpRecips.m_data.length * 16) + this.m_guarMgram.serializedLength();
    }

    @Override
    public int streamSizeBody() {
        return this.m_guarMgram.serializedLength() + this.preMgramSize() + this.postMgramSize();
    }

    @Override
    public int serializedSizeBody() {
        return this.m_guarMgram.serializedLength() + this.preMgramSize() + this.postMgramSize();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writePreMgramToStream(out);
        this.writeMgramToStream(out, false);
        this.writePostMgramToStream(out, false);
    }

    private void writeMgramToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        IMgram mgram = this.m_guarMgram;
        if (this.m_groupSubscriptionList != null) {
            mgram = LBSTrackingInfo.buildLBSTargetWrapper(this.m_guarMgram, this.m_groupSubscriptionList);
        }
        MgramSerializer.getMgramSerializer().serialize(os, mgram, tteTTLConvert);
    }

    private void writeRecipientList(OutputStream os, boolean includeCCInformation) throws IOException {
        if (this.m_deliveredToPubSub) {
            StreamUtil.writeInt(0, os);
        } else {
            GuarMsgEvt.writeGuarRecips(os, !this.m_xonce || this.m_splitBatch ? null : this.m_guarRecips, this.getSeqNo());
        }
        GuarMsgEvt.writeProxyRecips(os, this.m_splitBatch ? null : this.m_proxyRecipsTable, this.getSeqNo(), this.m_proxiedCidsOnly);
        GuarMsgEvt.writeProxyLBSRecips(os, this.m_splitBatch ? null : this.m_proxyLBSRecipsTable);
        GuarMsgEvt.writePtpRecips(os, this.m_splitBatch ? null : this.m_ptpRecips, this.m_ptpTrackingNums, this.getSeqNo(), includeCCInformation);
    }

    private synchronized void writePostMgramToStream(OutputStream os, boolean includeCCInformation) throws IOException {
        this.writeRecipientList(os, includeCCInformation);
        StreamUtil.writeInt(this.m_tid, os);
        GuarMsgEvt.writeSubjectFilters(os, this.m_subjectFilters, this.m_guarMgram.getSubject());
    }

    private void writePreMgramToStream(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_orig_sender, os);
        StreamUtil.writeLong(this.m_orig_tracking, os);
        StreamUtil.writeBoolean(this.m_needGuarAck, os);
        StreamUtil.writeLong(this.m_redirectAckClient, os);
        this.m_splitBatchOrBatchedPublish = false;
        if (this.m_guarMgram.getType() == 27) {
            if (this.m_splitBatch) {
                this.m_splitBatchOrBatchedPublish = true;
            }
        } else if (this.m_batchedPublish) {
            this.m_splitBatchOrBatchedPublish = true;
        }
        StreamUtil.writeBoolean(this.m_splitBatchOrBatchedPublish, os);
    }

    private int preMgramSize() {
        return 26;
    }

    private int postMgramSize() {
        return this.recipientSize() + 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int recipientSize() {
        int result = 0;
        GuarMsgEvt guarMsgEvt = this;
        synchronized (guarMsgEvt) {
            result += GuarMsgEvt.guarRecipSize(this.m_guarRecips);
            result += GuarMsgEvt.proxyLBSRecipSize(this.m_proxyLBSRecipsTable);
            result += GuarMsgEvt.proxyRecipSize(this.m_proxyRecipsTable);
        }
        guarMsgEvt = this;
        synchronized (guarMsgEvt) {
        }
        return result += GuarMsgEvt.ptpRecipSize(this.m_ptpRecips, this.m_ptpTrackingNums);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writePreMgramToStream(os);
        this.writeMgramToStream(os, tteTTLConvert);
        this.writePostMgramToStream(os, true);
    }

    @Override
    protected void readBodyFromLog(InputStream in) throws IOException, EInvalidLogEvent, EMgramFormatError {
        this.m_splitBatchOrBatchedPublish = false;
        this.readPreMgram(in);
        this.readMgramFromStream(in, false);
        this.readPostMgram(in, false, false);
        this.m_acked = true;
    }

    private void readMgramFromStream(InputStream in, boolean tteTTLConvert) throws IOException, EMgramFormatError {
        int opType;
        this.m_guarMgram = MgramSerializer.getMgramSerializer().unserialize(in, tteTTLConvert);
        if (this.m_guarMgram.getType() == 25 && ((opType = this.m_guarMgram.getOperationHandle().getOperationType()) == 14 || opType == 13)) {
            this.m_groupSubscriptionList = LBSTrackingInfo.unmarshalLBTargetWrapper(this.m_guarMgram);
            this.m_groupSubscriptionOnly = opType == 14;
            this.m_guarMgram = (IMgram)this.m_guarMgram.getOperationHandle().getMgramList().getFirst();
        }
        if (this.m_splitBatchOrBatchedPublish) {
            if (this.m_guarMgram.getType() == 27) {
                this.m_splitBatch = true;
            } else {
                this.m_batchedPublish = true;
            }
        }
        int subjectTrackingCount = 1;
        if (this.m_guarMgram.getSubject().isMultiSubject()) {
            subjectTrackingCount += this.m_guarMgram.getSubject().getMultiSubjectCount();
        }
        if (this.m_guarMgram.getType() == 27) {
            IBatchHandle batchHandle = this.m_guarMgram.getBatchHandle();
            int batchSize = batchHandle.getBatchSize();
            this.setNumSeqNos((batchSize + 1) * subjectTrackingCount);
        } else if (subjectTrackingCount > 1) {
            this.setNumSeqNos(subjectTrackingCount);
        }
        this.m_guarMgram.getBrokerHandle().setLogEvent(this);
    }

    private void readPreMgram(InputStream in) throws IOException {
        this.m_orig_sender = StreamUtil.readLong(in);
        this.m_orig_tracking = StreamUtil.readLong(in);
        this.m_needGuarAck = StreamUtil.readBoolean(in);
        if (this.m_eventType >= 48) {
            this.m_redirectAckClient = StreamUtil.readLong(in);
        }
        if (this.m_eventType >= 69) {
            this.m_splitBatchOrBatchedPublish = StreamUtil.readBoolean(in);
        }
    }

    private void readPostMgram(InputStream in, boolean tteTTLConvert, boolean readCCInfo) throws IOException {
        this.m_guarRecips = GuarMsgEvt.readGuarRecips(in, tteTTLConvert, this.getSeqNo());
        if (this.m_guarRecips != null) {
            this.m_xonce = true;
            if (this.m_guarRecips.m_count == 0) {
                this.m_deliveredToPubSub = true;
            }
        }
        this.m_ptpRecips = null;
        this.m_ptpTrackingNums = null;
        this.m_proxyRecipsTable = null;
        if (this.m_eventType >= 48) {
            Object[] result;
            this.m_proxyRecipsTable = GuarMsgEvt.readProxyRecips(in, tteTTLConvert, this.getSeqNo());
            if (this.m_eventType >= 180) {
                this.m_proxyLBSRecipsTable = GuarMsgEvt.readProxyLBSRecips(in, this.getSeqNo());
                if (this.DEBUG) {
                    this.debug("Read lbs proxies " + this.m_proxyLBSRecipsTable + " for " + MgramTrace.diagnosticString(this.m_guarMgram));
                }
            }
            if ((result = GuarMsgEvt.readPtpRecips(in, tteTTLConvert, this.getSeqNo(), readCCInfo, this.m_eventType >= 155)) != null) {
                this.m_ptpRecips = (RecipientVector)result[0];
                this.m_ptpTrackingNums = (long[])result[1];
            }
            this.m_tid = StreamUtil.readInt(in);
        }
        if (this.m_eventType >= 110) {
            this.m_subjectFilters = GuarMsgEvt.readSubjectFilters(in);
            this.m_guarMgram.getBrokerHandle().setSubjectFilters(this.m_subjectFilters);
        }
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException, EMgramFormatError {
        this.m_splitBatchOrBatchedPublish = false;
        this.readPreMgram(in);
        this.readMgramFromStream(in, tteTTLConvert);
        this.readPostMgram(in, tteTTLConvert, true);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoGuarMsg(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAck() {
        if (this.m_guarMgram.isGuarenteed()) {
            boolean sendit;
            GuarMsgEvt guarMsgEvt = this;
            synchronized (guarMsgEvt) {
                sendit = !this.m_acked && !this.m_batchedPublish && !this.m_guarMgram.getBrokerHandle().isTransactionalPublish();
                this.m_acked = true;
            }
            if (sendit) {
                boolean guar = false;
                long ackTracking = 0L;
                AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
                try {
                    IClientContext cc = reg.getClient(this.m_orig_sender);
                    if (cc.isXOnce() && this.isTransacted()) {
                        return;
                    }
                    if (this.m_needGuarAck) {
                        this.createTracker();
                    }
                    if (!cc.isRemoteBroker()) {
                        cc.sendAck(this.m_orig_tracking, this.m_guarMgram);
                        if (this.DEBUG) {
                            System.out.println("Guaranteed message " + this.m_orig_tracking + ": publisher acked.");
                        }
                        return;
                    }
                    guar = true;
                    ackTracking = reg.getLogManager().allocSeqNo() & 0xFFFFFFFFFFFFL;
                    reg.getRouterManager().sendingGuarQAck(ackTracking, this.m_orig_sender, this.m_orig_tracking);
                    IMgram ack = null;
                    if (!cc.isRemoteBroker()) {
                        throw new EAssertFailure("Error attempt to send ack to invalid client type!");
                    }
                    ack = MgramFactory.getMgramFactory().buildQAck(this.m_orig_tracking, -1L, (short)0, guar, ackTracking, false, 0, cc.getChannel());
                    cc.sendThrough(ack);
                }
                catch (EClientNotRegistered e) {
                    // empty catch block
                }
            }
        }
    }

    void deliverMsg() throws ESecurityGeneralException {
        this.deliverMsg(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliverMsg(FastVector guarRecips) throws ESecurityGeneralException {
        GuarMsgEvt guarMsgEvt = this;
        synchronized (guarMsgEvt) {
            if (!this.m_delivered) {
                this.m_delivered = true;
                if (this.m_xonce && this.m_guarRecips == null && guarRecips != null) {
                    this.m_guarRecips = (FastVector)guarRecips.clone();
                }
            } else {
                return;
            }
            this.createTracker();
        }
        if (guarRecips != null || this.m_guarRecips != null) {
            IMgram guarCopy = this.m_guarMgram;
            try {
                guarCopy = (IMgram)this.m_guarMgram.protectedClone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new EAssertFailure(cnse);
            }
            long seqNo = this.getSeqNo();
            guarCopy.setGuarenteed(seqNo & 0xFFFFFFFFFFFFL);
            int multiSubjectCount = 1;
            if (guarCopy.getSubject().isMultiSubject()) {
                multiSubjectCount += guarCopy.getSubject().getMultiSubjectCount();
                if (!guarCopy.getSubject().hasSubjectTracking()) {
                    guarCopy.getBrokerHandle().assignSubjectTrackingNumbers(seqNo & 0xFFFFFFFFFFFFL);
                }
            }
            if (guarCopy.getType() == 27) {
                if (guarCopy.getBatchHandle().isAtomic()) {
                    long logSeqNo = seqNo;
                    IMgram iMgram = guarCopy;
                    synchronized (iMgram) {
                        guarCopy.getBatchHandle().syncBatch();
                    }
                    Iterator iter = guarCopy.getBatchHandle().getBatchIterator();
                    while (iter.hasNext()) {
                        IMgram subMgram = (IMgram)iter.next();
                        subMgram.setGuarenteed((logSeqNo += (long)multiSubjectCount) & 0xFFFFFFFFFFFFL);
                        if (!guarCopy.getSubject().isMultiSubject() || subMgram.getSubject().hasSubjectTracking()) continue;
                        subMgram.getBrokerHandle().assignSubjectTrackingNumbers(logSeqNo);
                    }
                }
                if (this.m_proxyRecipsTable != null && !guarCopy.getBatchHandle().isAtomic()) {
                    Iterator iter = guarCopy.getBatchHandle().getBatchIterator();
                    while (iter.hasNext()) {
                        IMgram subMgram = (IMgram)iter.next();
                        subMgram.getBrokerHandle().setProxyRecipsTable(this.m_proxyRecipsTable);
                    }
                }
            }
            if (guarCopy.getBrokerHandle().isFromLog()) {
                guarCopy.setSuccessor(true);
            }
            if (guarCopy != null && this.m_proxyRecipsTable != null) {
                if (this.DEBUG) {
                    System.out.println("Setting proxy recips table: GUAR " + this.getSeqNo());
                }
                guarCopy.getBrokerHandle().setProxyRecipsTable(this.m_proxyRecipsTable);
            }
            this.m_AMPHandle.handleMessageProtection(guarCopy, this.m_mp);
            guarCopy.sync();
            if (guarRecips != null) {
                this.m_AMPHandle.deliverSecuredToClients(guarRecips, guarCopy, this.m_pubLimiter, this.m_proxyLBSRecipsTable, this.m_tracker);
            } else if (this.m_guarRecips != null) {
                this.m_AMPHandle.deliverSecuredToClients(this.m_guarRecips, guarCopy, this.m_pubLimiter, this.m_proxyLBSRecipsTable, this.m_tracker);
            }
        }
    }

    void createTracker() {
        this.createTracker(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTracker(boolean msgDelivered) {
        GuarMsgEvt guarMsgEvt = this;
        synchronized (guarMsgEvt) {
            if (this.m_tracker != null) {
                return;
            }
            try {
                int pubSubAcks = 0;
                if (!msgDelivered && this.m_guarRecips != null) {
                    for (int i = 0; i < this.m_guarRecips.m_data.length; ++i) {
                        if (this.m_guarRecips.m_data[i] == null || !((RecipientWrap)this.m_guarRecips.m_data[i]).hasClientContext()) continue;
                        ++pubSubAcks;
                    }
                    if (this.DEBUG && pubSubAcks != this.m_guarRecips.m_count) {
                        this.debug("Created tracker m_guarRecips.count= " + this.m_guarRecips.m_count + " pubsubAcks= " + pubSubAcks + " " + this.m_guarRecips.m_data.length);
                    }
                }
                int ptpAcks = this.m_xonce && this.m_ptpRecips != null ? this.m_ptpRecips.m_count : 0;
                boolean startSplitting = this.splitBatch();
                this.m_tracker = new AgentGuarMsgTracker(this.getSeqNo() & 0xFFFFFFFFFFFFL, this, msgDelivered ? 0 : pubSubAcks, msgDelivered ? 0 : ptpAcks, this.m_needGuarAck, startSplitting);
            }
            catch (EDuplicateKey e) {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR010") + this.getSeqNo(), (Throwable)e, 2);
            }
        }
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        if (this.m_needIBGuarAck) {
            InterbrokerHook.xOnceMsgReceived(this.m_orig_sender, this.m_orig_tracking, this.m_tracker);
        } else if (this.m_needRBGuarAck) {
            RouterManager routerManager = reg.getRouterManager();
            routerManager.xOnceQMsgReceived(this.m_orig_sender, this.m_orig_tracking, this.m_tracker);
        } else if (this.m_publisher != null && this.m_needGuarAck && !this.m_guarMgram.getBrokerHandle().isTransactionalPublish()) {
            this.m_publisher.rcvdGuarMsg(this.m_orig_tracking, this.m_tracker);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "Guaranteed message:" + (this.m_needGuarAck ? "(needsGuarAck)" : "") + (this.getMessage().isNonPersistentReplicated() ? "(replicated only)" : "") + " Orig Sender= " + this.m_orig_sender + " Orig Tracking= " + this.m_orig_tracking + (this.m_tid > 0 ? " Tid= " + this.m_tid : "" + (this.m_xonce ? "(xonce delivery)" : ""));
    }

    static RecipientVector readGuarRecips(InputStream in, boolean tteTTLConvert, long tracking) throws IOException {
        RecipientVector recips = null;
        int rcount = StreamUtil.readInt(in);
        if (rcount >= 0) {
            recips = new RecipientVector();
            for (int i = 0; i < rcount; ++i) {
                long id = StreamUtil.readLong(in);
                Label lab = Label.unserialize(in, tteTTLConvert);
                recips.addElement(id, null, null, -1L, lab);
            }
        }
        return recips;
    }

    static Object[] readPtpRecips(InputStream in, boolean tteTTLConvert, long tracking, boolean readCCInfo, boolean readCCSubjectFilterId) throws IOException {
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        Object[] result = null;
        int rcount = StreamUtil.readInt(in);
        if (rcount > 0) {
            RecipientVector recips = new RecipientVector();
            long[] ptpTrackingNums = new long[rcount];
            for (int i = 0; i < rcount; ++i) {
                long id = StreamUtil.readLong(in);
                String targetedNodeName = null;
                String localQueueName = null;
                long subjectFilterId = -1L;
                if (readCCInfo) {
                    targetedNodeName = StreamUtil.readUTF(in);
                    localQueueName = StreamUtil.readUTF(in);
                    if (readCCSubjectFilterId) {
                        subjectFilterId = StreamUtil.readLong(in);
                    }
                }
                Label lab = Label.unserialize(in, tteTTLConvert);
                if (!readCCInfo) {
                    IClientContext client = null;
                    try {
                        if (reg != null) {
                            client = reg.getClient(id);
                        }
                    }
                    catch (EClientNotRegistered e) {
                        // empty catch block
                    }
                    if (client != null) {
                        recips.addElement(client, lab);
                    }
                } else {
                    recips.addElement(id, targetedNodeName, localQueueName, subjectFilterId, lab);
                }
                ptpTrackingNums[i] = StreamUtil.readLong(in);
            }
            result = new Object[]{recips, ptpTrackingNums};
        }
        return result;
    }

    static LongHashTable readProxyRecips(InputStream in, boolean tteTTLConvert, long tracking) throws IOException {
        LongHashTable<FastVector> proxyRecipsTable = null;
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        int numProxies = StreamUtil.readInt(in);
        if (numProxies > 0) {
            proxyRecipsTable = new LongHashTable<FastVector>();
        }
        for (int i = 0; i < numProxies; ++i) {
            long proxyId = StreamUtil.readLong(in);
            int numProxying = StreamUtil.readInt(in);
            boolean isProxyRegistered = false;
            FastVector proxying = null;
            isProxyRegistered = true;
            proxying = new FastVector();
            for (int p = 0; p < numProxying; ++p) {
                long clientId = StreamUtil.readLong(in);
                if (!isProxyRegistered) continue;
                if (DebugState.GLOBAL_DEBUG_ON) {
                    GuarMsgEvt.class_debug("GuarMsgEvt", "Adding proxy mapping: " + proxyId + "-->" + clientId + " SEQNO=" + tracking);
                }
                proxying.addElement(new Long(clientId));
            }
            if (proxying == null || proxying.m_count <= 0) continue;
            proxyRecipsTable.put(proxyId, proxying);
        }
        return proxyRecipsTable;
    }

    static LongHashTable readProxyLBSRecips(InputStream in, long tracking) throws IOException {
        int numProxies = StreamUtil.readInt(in);
        if (numProxies == 0) {
            return null;
        }
        LongHashTable<LBSTrackingInfo> proxyLBSRecipsTable = new LongHashTable<LBSTrackingInfo>(numProxies);
        for (int i = 0; i < numProxies; ++i) {
            long proxyId = StreamUtil.readLong(in);
            FastVector proxying = LBSTrackingInfo.readTargetGroupsFromStream(new DataInputStream(in));
            if (proxying == null || proxying.m_count <= 0) continue;
            LBSTrackingInfo info = new LBSTrackingInfo();
            info.setTargetGroups(proxying);
            proxyLBSRecipsTable.put(proxyId, info);
        }
        return proxyLBSRecipsTable;
    }

    static LongHashTable readSubjectFilters(InputStream in) throws IOException {
        int count = StreamUtil.readInt(in);
        if (count == 0) {
            return null;
        }
        LongHashTable<TrackedSubjectFilter> ret = new LongHashTable<TrackedSubjectFilter>(count);
        for (int i = 0; i < count; ++i) {
            long cid = StreamUtil.readLong(in);
            short subjectCount = StreamUtil.readShort(in);
            HashSet<Short> set = new HashSet<Short>(subjectCount);
            for (short s = 0; s < subjectCount; s = (short)(s + 1)) {
                set.add(new Short(StreamUtil.readShort(in)));
            }
            ret.put(cid, new TrackedSubjectFilter(set));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeSubjectFilters(OutputStream out, LongHashTable table, ISubject trackedSubject) throws IOException {
        if (table == null || table.isEmpty()) {
            StreamUtil.writeInt(0, out);
            return;
        }
        LongHashTable longHashTable = table;
        synchronized (longHashTable) {
            StreamUtil.writeInt(table.size(), out);
            Enumeration<Long> e = table.keys();
            while (e.hasMoreElements()) {
                long key = e.nextElement();
                StreamUtil.writeLong(key, out);
                Collection c = ((ISubjectFilter)table.get(key)).filterTrackingNums(trackedSubject);
                StreamUtil.writeShort((short)c.size(), out);
                Iterator i = c.iterator();
                while (i.hasNext()) {
                    StreamUtil.writeShort((Short)i.next(), out);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int subjectFiltersSize(LongHashTable table, ISubject s) {
        if (table == null || table.isEmpty()) {
            return 4;
        }
        int size = 4;
        LongHashTable longHashTable = table;
        synchronized (longHashTable) {
            Enumeration<Long> e = table.keys();
            while (e.hasMoreElements()) {
                long key = e.nextElement();
                Collection c = ((ISubjectFilter)table.get(key)).filterTrackingNums(s);
                size += 10 + c.size() * 2;
            }
        }
        return size;
    }

    static void writeGuarRecips(OutputStream os, FastVector guarRecips, long tracking) throws IOException {
        if (guarRecips != null) {
            RecipientWrap rw;
            int i;
            int rcount = 0;
            for (i = 0; i < guarRecips.m_data.length; ++i) {
                rw = (RecipientWrap)guarRecips.m_data[i];
                if (rw == null || !rw.hasClientContext()) continue;
                ++rcount;
            }
            StreamUtil.writeInt(rcount, os);
            for (i = 0; i < guarRecips.m_data.length; ++i) {
                rw = (RecipientWrap)guarRecips.m_data[i];
                if (rw == null || !rw.hasClientContext()) continue;
                if (rw.getGroupCCId() != -1L) {
                    StreamUtil.writeLong(rw.getGroupCCId(), os);
                } else {
                    StreamUtil.writeLong(rw.getId(), os);
                }
                rw.m_label.serialize(os, false);
            }
        } else {
            StreamUtil.writeInt(-1, os);
        }
    }

    static void writeProxyRecips(OutputStream os, LongHashTable proxyRecipsTable, long tracking, boolean cidsOnly) throws IOException {
        if (proxyRecipsTable != null && !proxyRecipsTable.isEmpty()) {
            Enumeration<Long> proxyList = proxyRecipsTable.keys();
            StreamUtil.writeInt(proxyRecipsTable.size(), os);
            while (proxyList.hasMoreElements()) {
                Long proxy = proxyList.nextElement();
                FastVector proxying = (FastVector)proxyRecipsTable.get(proxy);
                StreamUtil.writeLong((long)proxy, os);
                StreamUtil.writeInt(proxying.m_count, os);
                for (int i = 0; i < proxying.m_count; ++i) {
                    if (cidsOnly) {
                        StreamUtil.writeLong((long)((Long)proxying.m_data[i]), os);
                        continue;
                    }
                    StreamUtil.writeLong(((IClientContext)proxying.m_data[i]).getId(), os);
                }
            }
        } else {
            StreamUtil.writeInt(0, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeProxyLBSRecips(OutputStream os, LongHashTable lbsProxyMappings) throws IOException {
        if (lbsProxyMappings == null || lbsProxyMappings.isEmpty()) {
            StreamUtil.writeInt(0, os);
        } else {
            LongHashTable longHashTable = lbsProxyMappings;
            synchronized (longHashTable) {
                Enumeration<Long> proxyList = lbsProxyMappings.keys();
                StreamUtil.writeInt(lbsProxyMappings.size(), os);
                while (proxyList.hasMoreElements()) {
                    Long proxy = proxyList.nextElement();
                    LBSTrackingInfo lbsInfo = (LBSTrackingInfo)lbsProxyMappings.get(proxy);
                    StreamUtil.writeLong((long)proxy, os);
                    lbsInfo.writeTargetGroupsToStream(new DataOutputStream(os));
                }
            }
        }
    }

    static void writePtpRecips(OutputStream os, FastVector ptpRecips, long[] ptpTrackingNums, long tracking, boolean includeCCInformation) throws IOException {
        int i;
        int rcount = 0;
        if (ptpRecips != null) {
            for (i = 0; i < ptpRecips.m_data.length; ++i) {
                if (ptpRecips.m_data[i] == null || !((RecipientWrap)ptpRecips.m_data[i]).hasClientContext()) continue;
                ++rcount;
            }
        }
        StreamUtil.writeInt(rcount, os);
        if (rcount > 0) {
            for (i = 0; i < ptpRecips.m_data.length; ++i) {
                if (ptpRecips.m_data[i] == null || !((RecipientWrap)ptpRecips.m_data[i]).hasClientContext()) continue;
                StreamUtil.writeLong(((RecipientWrap)ptpRecips.m_data[i]).getId(), os);
                if (includeCCInformation) {
                    StreamUtil.writeUTF(((RecipientWrap)ptpRecips.m_data[i]).getTargetedNodeName(), os);
                    StreamUtil.writeUTF(((RecipientWrap)ptpRecips.m_data[i]).getLocalQueueName(), os);
                    StreamUtil.writeLong(((RecipientWrap)ptpRecips.m_data[i]).getSubjectFilterId(), os);
                }
                ((RecipientWrap)ptpRecips.m_data[i]).m_label.serialize(os, false);
                StreamUtil.writeLong(ptpTrackingNums[i], os);
            }
        }
    }

    static int guarRecipSize(FastVector guarRecips) {
        int result = 0;
        result += 4;
        if (guarRecips != null) {
            int rcount = 0;
            for (int i = 0; i < guarRecips.m_data.length; ++i) {
                if (guarRecips.m_data[i] == null || !((RecipientWrap)guarRecips.m_data[i]).hasClientContext()) continue;
                ++rcount;
            }
            result += rcount * (8 + Label.length());
        }
        return result;
    }

    static int proxyRecipSize(LongHashTable proxyRecipsTable) {
        int result = 0;
        result += 4;
        if (proxyRecipsTable != null && !proxyRecipsTable.isEmpty()) {
            Enumeration proxyLists = proxyRecipsTable.elements();
            while (proxyLists.hasMoreElements()) {
                FastVector proxying = (FastVector)proxyLists.nextElement();
                result += 8;
                result += 4;
                result += 8 * proxying.m_count;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int proxyLBSRecipSize(LongHashTable proxyLBSRecipsTable) {
        int result = 0;
        result += 4;
        if (proxyLBSRecipsTable != null && !proxyLBSRecipsTable.isEmpty()) {
            LongHashTable longHashTable = proxyLBSRecipsTable;
            synchronized (longHashTable) {
                Enumeration proxyLists = proxyLBSRecipsTable.elements();
                while (proxyLists.hasMoreElements()) {
                    LBSTrackingInfo proxying = (LBSTrackingInfo)proxyLists.nextElement();
                    result += 8;
                    result += 4;
                    result += proxying.getTargetSerializedLength();
                }
            }
        }
        return result;
    }

    static int ptpRecipSize(FastVector ptpRecips, long[] ptpTrackingNums) {
        int result = 0;
        result += 4;
        if (ptpRecips != null) {
            int rcount = 0;
            for (int i = 0; i < ptpRecips.m_data.length; ++i) {
                if (ptpRecips.m_data[i] == null || !((RecipientWrap)ptpRecips.m_data[i]).hasClientContext()) continue;
                ++rcount;
            }
            result += rcount * (16 + Label.length());
        }
        return result;
    }

    public void convertProxiedCidsToCCs() {
        if (this.hasProxyMappings() && this.m_proxiedCidsOnly) {
            LongHashTable<FastVector> result = new LongHashTable<FastVector>();
            Enumeration<Long> proxies = this.m_proxyRecipsTable.keys();
            while (proxies.hasMoreElements()) {
                long proxyId = proxies.nextElement();
                try {
                    IClientContext proxy = AgentRegistrar.getAgentRegistrar().getClient(proxyId);
                    FastVector proxyIds = (FastVector)this.m_proxyRecipsTable.get(proxyId);
                    FastVector proxying = new FastVector();
                    for (int proxyCount = 0; proxyCount < proxyIds.m_count; ++proxyCount) {
                        IClientContext cc = null;
                        try {
                            cc = AgentRegistrar.getAgentRegistrar().getClient((Long)proxyIds.m_data[proxyCount]);
                        }
                        catch (EClientNotRegistered e) {
                            continue;
                        }
                        proxying.addElement(cc);
                    }
                    if (proxying.m_count <= 0) continue;
                    result.put(proxyId, proxying);
                }
                catch (EClientNotRegistered e) {}
            }
            this.m_proxyRecipsTable = result;
            this.m_proxiedCidsOnly = false;
        }
    }
}

