/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.EOFEvent;
import progress.message.broker.EOLEvent;
import progress.message.broker.EProtectedBlockReached;
import progress.message.broker.LogFile;
import progress.message.broker.LogManager;
import progress.message.broker.LogOrderedList;
import progress.message.broker.LogOutputStream;
import progress.message.broker.SyncpointThread;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugThread;

class LogFlushThread
extends DebugThread {
    private AgentRegistrar m_reg;
    private LogFile m_lf;
    private LogManager m_lm;
    private SyncpointThread m_spt;
    private int m_delayMax;
    private int m_IdListLength;
    private LogOrderedList m_lol;
    private long m_lastSyncsize;
    private boolean DEBUG1 = (this.debugFlags & 0x40) > 0;
    private LogOutputStream m_logos = null;

    LogFlushThread(AgentRegistrar reg, LogManager lm, LogFile lf, SyncpointThread spt) {
        super("LogFlushThread");
        this.m_reg = reg;
        this.m_lm = lm;
        this.m_lf = lf;
        this.m_spt = spt;
        this.m_IdListLength = 10;
        this.m_delayMax = Config.LOG_FLUSH_DELAY;
        this.m_lol = new LogOrderedList(this.m_IdListLength);
    }

    public synchronized long getLastSyncsize() {
        return this.m_lastSyncsize;
    }

    private synchronized void setLastSyncsize(long size) {
        this.m_lastSyncsize = size;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void threadMain() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [36[CATCHBLOCK]], but top level block is 18[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void syncLogUp(boolean doDiskSync) throws IOException {
        long logpos = this.m_logos.getFilePointer();
        try {
            new EOLEvent().write2log(this.m_logos, 14L);
        }
        catch (ELogEventTooLong e) {
            throw new EAssertFailure(e.toString(), e);
        }
        if (this.DEBUG) {
            this.debug(System.currentTimeMillis() + ": flushing at file position " + logpos + " doDiskSync = " + doDiskSync);
        }
        this.m_logos.flush();
        if (doDiskSync) {
            this.m_logos.sync();
        }
        try {
            this.m_logos.seek(logpos);
        }
        catch (EProtectedBlockReached e) {
            // empty catch block
        }
    }

    long startNewFile(long pos) throws IOException {
        if (this.DEBUG1) {
            this.debug("In startNewFile: old file: pos= " + pos + " " + this.m_logos);
        }
        try {
            new EOFEvent().write2log(this.m_logos, 14L);
        }
        catch (ELogEventTooLong ee) {
            throw new EAssertFailure(ee.toString());
        }
        this.m_logos.flush();
        this.m_logos.sync();
        this.m_logos = this.m_lf.startNewFile();
        if (this.DEBUG) {
            this.debug("Started new file " + this.m_logos);
        }
        return this.m_logos.getFilePointer();
    }
}

