/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import progress.message.broker.LogStreamFile;

public class LogInputStream
extends InputStream {
    private LogStreamFile m_file;

    public String toString() {
        return "LogInputStream " + this.m_file;
    }

    LogInputStream(LogStreamFile file) throws IOException {
        this.m_file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read() throws IOException {
        LogStreamFile logStreamFile = this.m_file;
        synchronized (logStreamFile) {
            try {
                return this.m_file.read();
            }
            catch (EOFException e) {
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        LogStreamFile logStreamFile = this.m_file;
        synchronized (logStreamFile) {
            try {
                this.m_file.read(b, off, len);
            }
            catch (EOFException e) {
                len = -1;
            }
            return len;
        }
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized long getFilePointer() throws IOException {
        return this.m_file.getFilePointerRead();
    }

    public synchronized void seek(long pos) throws IOException {
        this.m_file.seekRead(pos);
    }
}

