/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Vector;
import progress.message.broker.LogEvent;
import progress.message.broker.LogFilterSupport;
import progress.message.broker.LogTrace;
import progress.message.zclient.IDebugCallback;
import progress.message.zclient.xonce.MgramTraceCallback;

public class LogTraceCallback
implements IDebugCallback {
    private static final boolean ONWRITEBEHAVIOUR = true;
    private static Class[] m_action_signature = new Class[]{String.class, LogEvent.class};
    private static Vector m_capture = new Vector(1000);
    private static int MAX_CAPTURES = 1000;

    @Override
    public void callback(String text, int method, Object params) {
        try {
            switch (method) {
                case 1: {
                    return;
                }
                case 0: {
                    this.methody(text, params);
                    return;
                }
                case 2: {
                    this.methodz(text, params);
                    return;
                }
            }
            return;
        }
        catch (Throwable t) {
            return;
        }
    }

    private void methodx(String text, Object params) {
        Object[] o = (Object[])params;
        LogEvent evt = (LogEvent)o[0];
        String[] actions = LogFilterSupport.match("w", evt);
        String action = null;
        Object[] methparms = new Object[]{LogTraceCallback.hhmmss() + ">", evt};
        for (int i = 0; i < actions.length; ++i) {
            action = actions[i];
            try {
                Method meth = this.getClass().getMethod(action, m_action_signature);
                meth.invoke((Object)this, methparms);
                continue;
            }
            catch (NoSuchMethodException nsme) {
                System.err.println("LogTraceCallback - unrecognised action:" + action);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void methody(String text, Object params) {
        Object[] o = (Object[])params;
        LogEvent evt = (LogEvent)o[2];
        String[] actions = LogFilterSupport.match("w", evt);
        String action = null;
        Object[] methparms = new Object[]{LogTraceCallback.hhmmss() + ">", evt};
        for (int i = 0; i < actions.length; ++i) {
            action = actions[i];
            try {
                Method meth = this.getClass().getMethod(action, m_action_signature);
                meth.invoke((Object)this, methparms);
                continue;
            }
            catch (NoSuchMethodException nsme) {
                System.err.println("LogTraceCallback - unrecognised action:" + action);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void methodz(String text, Object params) {
        Object[] o = (Object[])params;
        LogEvent evt = (LogEvent)o[0];
        String[] actions = LogFilterSupport.match("r", evt);
        String action = null;
        Object[] methparms = new Object[]{LogTraceCallback.hhmmss() + "<", evt};
        for (int i = 0; i < actions.length; ++i) {
            action = actions[i];
            try {
                Method meth = this.getClass().getMethod(action, m_action_signature);
                meth.invoke((Object)this, methparms);
                continue;
            }
            catch (NoSuchMethodException nsme) {
                System.err.println("LogTraceCallback - unrecognised action:" + action);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void printFully(String pre, LogEvent evt) {
        LogTrace.diagnose(pre, evt);
    }

    public void print(String pre, LogEvent evt) {
        LogTrace.diagnose(pre, evt);
    }

    public void clearMgramCapture(String pre, LogEvent evt) {
        MgramTraceCallback.clearCaptureBuffer();
    }

    public void printMgramCapture(String pre, LogEvent evt) {
        BrokerComponent.getBrokerComponent();
        String cn = BrokerComponent.getComponentContext().getComponentName().getContainerName();
        this.printCapture(new File("M_" + cn + "_" + LogTraceCallback.hhmmss() + ".capture"), MgramTraceCallback.getCaptureBuffer());
    }

    public void printCapture(String pre, LogEvent evt) {
        BrokerComponent.getBrokerComponent();
        String cn = BrokerComponent.getComponentContext().getComponentName().getContainerName();
        this.printCapture(new File(cn + "_" + LogTraceCallback.hhmmss() + ".capture"), LogTraceCallback.getCaptureBuffer());
    }

    public void clearCapture(String pre, LogEvent evt) {
        m_capture.clear();
    }

    public void captureFully(String pre, LogEvent evt) {
        this.capture(pre, evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void capture(String pre, LogEvent evt) {
        String s = pre + ":" + LogTrace.diagnosticString(evt);
        Vector vector = m_capture;
        synchronized (vector) {
            if (m_capture.size() >= MAX_CAPTURES) {
                m_capture.removeElementAt(0);
            }
            m_capture.add(LogTraceCallback.hhmmss() + ":" + s);
        }
    }

    public static void clearCaptureBuffer(String pre, LogEvent evt) {
        m_capture.clear();
    }

    public void printCaptureBuffer(String pre, LogEvent evt) {
        LogTraceCallback.printCaptureBuffer();
    }

    public static Object[] getCaptureBuffer() {
        return m_capture.toArray();
    }

    public static void printCaptureBuffer() {
        Object[] c = LogTraceCallback.getCaptureBuffer();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == null) continue;
            System.out.println(c[i].toString());
        }
    }

    private void printCapture(File f, Object[] c) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            PrintWriter pw = new PrintWriter(bw);
            for (int i = 0; i < c.length; ++i) {
                if (c[i] == null) continue;
                pw.println(c[i].toString());
            }
            pw.flush();
            pw.close();
            bw.close();
        }
        catch (Exception e) {
            System.out.println("Failed in printCapture:" + e);
        }
    }

    private static String hhmmss() {
        Date dt = new Date();
        return dt.getHours() + "_" + dt.getMinutes() + "_" + dt.getSeconds();
    }
}

