/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import progress.message.broker.AdministrativelyCreatedQueue;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.IQMsgStateListener;
import progress.message.broker.MessageGroupExpirer;
import progress.message.broker.OpenReceiverTable;
import progress.message.broker.PendingReceiverTable;
import progress.message.broker.QueueMsgGroupAssignEvt;
import progress.message.broker.QueueMsgGroupUnassignEvt;
import progress.message.zclient.DebugObject;

public class MessageGroupTable
extends DebugObject
implements IQMsgStateListener {
    private AdministrativelyCreatedQueue m_queue = null;
    private final int m_maxEntries;
    private MessageGroupEntry m_head;
    private MessageGroupEntry m_tail;
    private OpenReceiverTable m_receivers;
    private PendingReceiverTable m_pendingReceivers = null;
    private Map<String, MessageGroupEntry> m_groupToConsumerTable;
    private Map<Long, String> m_trackingToGroupTable;
    private int m_groupIdleTimeout = -1;
    private boolean m_isDispatchingDelayed = false;
    private MessageGroupExpirer m_expirer = new MessageGroupExpirer(this);

    public MessageGroupTable(int initialCapacity, int maxEntries, AdministrativelyCreatedQueue queue) {
        this.debugName("MessageGroupTable");
        this.m_queue = queue;
        this.m_receivers = new OpenReceiverTable();
        this.m_groupToConsumerTable = Collections.synchronizedMap(new HashMap(initialCapacity));
        this.m_maxEntries = maxEntries;
        this.m_trackingToGroupTable = Collections.synchronizedMap(new HashMap());
    }

    public synchronized void redoQueueMessageGroupAssign(long receiverId, String group) {
        MessageGroupEntry entry;
        if (this.DEBUG) {
            this.debug("adding message group " + group + " for (pending) ft receiver " + receiverId);
        }
        if (this.m_pendingReceivers == null) {
            this.m_pendingReceivers = new PendingReceiverTable();
        }
        if ((entry = this.get(group)) != null) {
            long oldReceiver = entry.m_uid;
            this.m_pendingReceivers.removeGroupMapping(oldReceiver, group);
        }
        this.m_pendingReceivers.addGroupMapping(receiverId, group);
        this.put(group, receiverId, false);
    }

    public synchronized void redoQueueMessageGroupUnassign(List<String> groupNames) {
        if (this.DEBUG) {
            this.debug("removing " + groupNames.size() + " message groups for (pending) ft receivers");
        }
        for (String group : groupNames) {
            long receiverId = this.removeGroup(group);
            if (this.m_pendingReceivers == null) continue;
            this.m_pendingReceivers.removeGroupMapping(receiverId, group);
        }
    }

    public synchronized void redoSyncQueueMessageGroups(long receiverId, List<String> groups) {
        if (this.DEBUG) {
            this.debug("syncing message groups for (pending) ft receiver " + receiverId);
        }
        for (String group : groups) {
            this.redoQueueMessageGroupAssign(receiverId, group);
        }
    }

    public void setGroupIdleTimeout(int timeoutInMiliseconds) {
        if (this.DEBUG) {
            this.debug("Setting group idle timeout = " + timeoutInMiliseconds + " mili seconds.");
        }
        this.m_groupIdleTimeout = timeoutInMiliseconds;
        this.m_expirer.initIfNeeded();
    }

    public int getGroupIdleTimeout() {
        return this.m_groupIdleTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDispatchingDelayed(boolean delay, int waitTimeInMiliseconds) {
        if (this.DEBUG) {
            if (delay) {
                this.debug("delay message dispatch for " + waitTimeInMiliseconds + " miliseconds...");
            } else {
                this.debug("start message dispatch by " + Thread.currentThread().getName());
            }
        }
        boolean startDispatch = false;
        MessageGroupTable messageGroupTable = this;
        synchronized (messageGroupTable) {
            if (delay && !this.m_isDispatchingDelayed) {
                this.m_isDispatchingDelayed = true;
                Thread timerCallback = new Thread(){

                    @Override
                    public void run() {
                        MessageGroupTable.this.setDispatchingDelayed(false, 0);
                    }
                };
                AgentRegistrar.getAgentRegistrar().getWatchDogThread().addRelativeTimer(timerCallback, waitTimeInMiliseconds);
            } else if (!delay && this.m_isDispatchingDelayed) {
                this.m_isDispatchingDelayed = false;
                startDispatch = true;
            }
        }
        if (startDispatch) {
            this.m_queue.startMessageGroupDispatch(true);
        }
    }

    public synchronized boolean isDispatchingDelayed() {
        return this.m_isDispatchingDelayed;
    }

    public synchronized void onOpenReceiver(long receiver) {
        this.m_expirer.initIfNeeded();
        this.m_receivers.addReceiver(receiver);
        if (this.m_pendingReceivers == null) {
            return;
        }
        PendingReceiverTable.PendingReceiverEntry entry = this.m_pendingReceivers.remove(receiver);
        if (entry != null) {
            if (this.DEBUG) {
                this.debug("onOpenReceiver: pending reconnect receiver " + receiver + " reconnects.");
            }
            if (!entry.m_groupTable.isEmpty()) {
                if (this.DEBUG) {
                    this.debug("onOpenReceiver: " + entry.m_groupTable.size() + " group(s) previously assigned to pending reconnect receiver " + receiver);
                }
                this.m_receivers.addGroupsToReceiver(receiver, entry.m_groupTable);
            }
        }
    }

    public synchronized boolean onCloseReceiver(long receiver) {
        PendingReceiverTable.PendingReceiverEntry pendingClient;
        OpenReceiverTable.OpenReceiverEntry closedReceiver = this.m_receivers.removeReceiver(receiver);
        if (closedReceiver != null) {
            if (!closedReceiver.m_table.isEmpty()) {
                for (String group : closedReceiver.m_table) {
                    long id = this.clearGroupConsumer(group, true);
                    if (id != receiver) {
                        throw new AssertionError((Object)("Group " + group + " belonging to " + id + " was incorrectly removed for receiver " + receiver));
                    }
                }
                return true;
            }
        } else if (this.m_pendingReceivers != null && (pendingClient = this.m_pendingReceivers.remove(receiver)) != null) {
            for (String group : pendingClient.m_groupTable) {
                long id;
                if (this.DEBUG) {
                    this.debug("updating message group " + group + " previously owned by (pending) ft receiver " + receiver);
                }
                if ((id = this.clearGroupConsumer(group, true)) != receiver) {
                    throw new AssertionError((Object)("Group " + group + " belonging to " + id + " was incorrectly reset for receiver " + receiver));
                }
            }
        }
        return false;
    }

    public synchronized boolean onNewMessage(String group) {
        MessageGroupEntry entry = this.m_groupToConsumerTable.get(group);
        if (entry != null && this.m_groupIdleTimeout > 0) {
            entry.setLastActiveTime(System.currentTimeMillis());
        }
        return true;
    }

    private synchronized boolean closeGroup(String group, boolean logUnassign) {
        boolean ret = false;
        long uid = this.removeGroup(group);
        if (uid != -1L) {
            if (this.m_pendingReceivers == null || this.m_pendingReceivers.get(uid) == null) {
                if (this.DEBUG) {
                    this.debug("closeGroup updating receiver's group table: group " + group + " removed.");
                }
                ret = this.m_receivers.removeGroup(uid, group);
            } else {
                if (this.DEBUG) {
                    this.debug("closeGroup updating pending receiver's group table: group " + group + " removed.");
                }
                this.m_pendingReceivers.removeGroupMapping(uid, group);
            }
            if (logUnassign) {
                this.logGroupUnassign(uid, group);
            }
        }
        if (this.DEBUG) {
            this.debug("Group " + group + " closed: the group->consumer mapping has been removed.");
        }
        return ret;
    }

    private void prepareToCloseGroup(String group, long tracking) {
        if (this.DEBUG) {
            this.debug("Preparing to close group " + group + " - found last msg in the group");
        }
        this.m_trackingToGroupTable.put(tracking, group);
        AgentRegistrar.getAgentRegistrar().getQMsgStateMgr().addPendingAckedMsg(tracking, this);
        this.get(group).setPendingClose();
    }

    private void logGroupAssign(long receiverId, String groupName) {
        QueueMsgGroupAssignEvt evt = new QueueMsgGroupAssignEvt(this.m_queue.m_qName, groupName, receiverId);
        AgentRegistrar.getAgentRegistrar().getLogManager().addEvent(evt, true);
    }

    private void logGroupUnassign(long receiverId, String groupName) {
        QueueMsgGroupUnassignEvt evt = new QueueMsgGroupUnassignEvt(this.m_queue.m_qName, groupName);
        AgentRegistrar.getAgentRegistrar().getLogManager().addEvent(evt, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean match(String group, long receiverID, boolean lastMessageInGroup, long tracking) {
        long owner;
        if (this.m_isDispatchingDelayed) {
            return false;
        }
        boolean matched = false;
        MessageGroupEntry entry = this.get(group);
        if (entry == null) {
            owner = this.m_receivers.nextReceiver(group);
            if (owner == -1L) throw new AssertionError((Object)("Failed to assign group " + group + " to any consumer while there is at least one receiver was connected."));
            entry = this.put(group, owner, true);
            this.logGroupAssign(owner, group);
            matched = owner == receiverID;
        } else {
            owner = entry.m_uid;
            if (owner != -1L) {
                if (entry.isPendingClose()) {
                    entry.setNewMessageAfterPendingClose();
                } else {
                    matched = owner == receiverID;
                }
            } else {
                owner = this.m_receivers.nextReceiver(group);
                if (owner == -1L) throw new AssertionError((Object)("Failed to assign group " + group + " to any consumer while there is at least one receiver was connected."));
                this.put(group, owner, true);
                this.logGroupAssign(owner, group);
                matched = owner == receiverID;
            }
        }
        if (this.DEBUG) {
            this.debug("MessageGroupTable.match(): group = " + group + ", receiver id = " + receiverID + ", group owner = " + owner);
        }
        if (!matched || !lastMessageInGroup) return matched;
        if (tracking > 0L) {
            this.prepareToCloseGroup(group, tracking);
            return matched;
        } else {
            if (this.DEBUG) {
                this.debug("Found last msg in group " + group + " - close/re-balance the group immediately");
            }
            this.closeGroup(group, true);
        }
        return matched;
    }

    public final int size() {
        return this.m_groupToConsumerTable.size();
    }

    public final boolean isEmpty() {
        return this.m_groupToConsumerTable.isEmpty();
    }

    private final MessageGroupEntry get(String group) {
        MessageGroupEntry entry = this.m_groupToConsumerTable.get(group);
        if (entry != null) {
            this.moveKeyToTail(entry);
        }
        return entry;
    }

    private final MessageGroupEntry put(String group, long uid, boolean setLastActive) {
        if (this.DEBUG) {
            this.debug("MessageGroupTable.put(): group = " + group + ", owner = " + uid);
        }
        if (group == null) {
            throw new NullPointerException();
        }
        MessageGroupEntry entry = this.m_groupToConsumerTable.get(group);
        if (entry != null) {
            this.moveKeyToTail(entry);
            entry.setConsumer(uid);
            if (setLastActive) {
                entry.setLastActiveTime(System.currentTimeMillis());
            }
            return entry;
        }
        entry = new MessageGroupEntry(group, uid);
        if (setLastActive) {
            entry.setLastActiveTime(System.currentTimeMillis());
        }
        this.m_groupToConsumerTable.put(group, entry);
        this.addToTail(entry);
        return entry;
    }

    private final void removeHead() {
        if (this.m_head == null) {
            return;
        }
        MessageGroupEntry entry = this.m_head;
        if (entry.m_prev != null) {
            entry.m_prev.m_next = entry.m_next;
        }
        if (entry.m_next != null) {
            entry.m_next.m_prev = entry.m_prev;
        }
        if (this.m_head == entry) {
            this.m_head = entry.m_next;
        }
        if (this.m_tail == entry) {
            this.m_tail = entry.m_prev;
        }
        this.m_groupToConsumerTable.remove(entry.m_group);
    }

    private final void addToTail(MessageGroupEntry entry) {
        if (this.m_tail == null) {
            this.m_head = this.m_tail = entry;
        } else {
            this.m_tail.m_next = entry;
            entry.m_prev = this.m_tail;
            entry.m_next = null;
            this.m_tail = entry;
        }
    }

    private final void removeFromLRU(MessageGroupEntry entry) {
        if (entry == null) {
            return;
        }
        if (entry.m_prev != null) {
            entry.m_prev.m_next = entry.m_next;
        }
        if (entry.m_next != null) {
            entry.m_next.m_prev = entry.m_prev;
        }
        if (this.m_head == entry) {
            this.m_head = entry.m_next;
        }
        if (this.m_tail == entry) {
            this.m_tail = entry.m_prev;
        }
    }

    private void moveKeyToTail(MessageGroupEntry entry) {
        if (this.m_tail == entry) {
            return;
        }
        this.removeFromLRU(entry);
        this.addToTail(entry);
    }

    private final void clearLRUStack() {
        MessageGroupEntry node = this.m_head;
        while (node != null) {
            MessageGroupEntry next = node.m_next;
            node.m_prev = null;
            node.m_next = null;
            node = next;
        }
        this.m_head = null;
        this.m_tail = null;
        node = null;
    }

    private long removeGroup(String group) throws NullPointerException {
        if (group == null) {
            throw new NullPointerException();
        }
        MessageGroupEntry entry = this.m_groupToConsumerTable.remove(group);
        if (entry != null) {
            if (this.DEBUG) {
                this.debug(entry.m_group + "<->" + entry.m_uid + " mapping was removed");
            }
            this.removeFromLRU(entry);
            return entry.m_uid;
        }
        return -1L;
    }

    public synchronized long clearGroupConsumer(String group, boolean consumerClosed) throws NullPointerException {
        if (group == null) {
            throw new AssertionError((Object)"Unable to clear group consumer - group not specified.");
        }
        long old = -1L;
        MessageGroupEntry entry = this.get(group);
        if (entry != null) {
            old = entry.m_uid;
            if (this.DEBUG) {
                this.debug("Updating " + entry.m_group + "<->" + old + " mapping: consumer reset.");
            }
            entry.clearConsumer();
            if (!consumerClosed) {
                if (this.m_pendingReceivers == null || this.m_pendingReceivers.get(old) == null) {
                    if (this.DEBUG) {
                        this.debug("clearGroupConsumer updating receiver's group table: group " + group + " removed.");
                    }
                    this.m_receivers.removeGroup(old, group);
                } else {
                    if (this.DEBUG) {
                        this.debug("clearGroupConsumer updating pending receiver's group table: group " + group + " removed.");
                    }
                    this.m_pendingReceivers.removeGroupMapping(old, group);
                }
            }
            this.logGroupUnassign(old, group);
        }
        return old;
    }

    public void clear() {
        this.m_groupToConsumerTable.clear();
        this.clearLRUStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMsgAcknowledged(long tracking) {
        long newConsumer = -1L;
        MessageGroupTable messageGroupTable = this;
        synchronized (messageGroupTable) {
            String group = this.m_trackingToGroupTable.remove(tracking);
            MessageGroupEntry entry = this.get(group);
            long currentConsumer = entry.m_uid;
            if (this.DEBUG) {
                this.debug("Received last msg ack for group " + entry.m_group + " from current consumer " + currentConsumer);
            }
            if (entry.hasNewMessageAfterPendingClose()) {
                newConsumer = this.m_receivers.nextReceiver(group);
            }
            if (newConsumer != -1L) {
                this.clearGroupConsumer(group, false);
                entry.setConsumer(newConsumer);
                this.logGroupAssign(newConsumer, group);
            } else {
                this.closeGroup(group, true);
            }
        }
        if (newConsumer != -1L) {
            this.m_queue.updateMessageGroupConsumerSelector(newConsumer);
            this.m_queue.startMessageGroupDispatch(false);
        }
    }

    public String getQueueName() {
        return this.m_queue.m_qName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireGroups() {
        if (this.m_groupIdleTimeout <= 0) {
            return;
        }
        boolean initiateDispatch = false;
        int countMarkLastActive = 0;
        int countExpired = 0;
        MessageGroupTable messageGroupTable = this;
        synchronized (messageGroupTable) {
            long now = System.currentTimeMillis();
            ArrayList<String> groupsToExpire = new ArrayList<String>();
            QueueMsgGroupUnassignEvt evt = new QueueMsgGroupUnassignEvt(this.m_queue.m_qName);
            for (Map.Entry<String, MessageGroupEntry> entry : this.m_groupToConsumerTable.entrySet()) {
                long lastActive = entry.getValue().getLastActiveTime();
                if (lastActive == 0L) {
                    entry.getValue().setLastActiveTime(System.currentTimeMillis());
                    ++countMarkLastActive;
                    continue;
                }
                if (now < lastActive + (long)this.m_groupIdleTimeout) continue;
                groupsToExpire.add(entry.getKey());
            }
            for (String group : groupsToExpire) {
                initiateDispatch |= this.closeGroup(group, false);
                evt.addGroupName(group);
                ++countExpired;
            }
            if (countExpired > 0) {
                AgentRegistrar.getAgentRegistrar().getLogManager().addEvent(evt, true);
            }
        }
        if (initiateDispatch) {
            this.m_queue.startMessageGroupDispatch(true);
        }
        if (this.DEBUG) {
            this.debug(this.getQueueName() + " - expired " + countExpired + " groups; set " + countMarkLastActive + " last-active timestamps");
        }
    }

    public synchronized void writeSyncGroupAssignments() throws ECannotFlushEvents {
        this.m_receivers.writeSyncGroupAssignments(this.m_queue.m_qName);
    }

    final class MessageGroupEntry {
        static final int GROUP_WITH_NO_ACTIVE_CONSUMER = 0;
        static final int GROUP_WITH_ACTIVE_CONSUMER = 1;
        static final int GROUP_IN_PENDING_CLOSE = 2;
        static final int GROUP_IN_PENDING_CLOSE_WITH_NEW_MESSAGES = 3;
        String m_group;
        long m_uid;
        int m_state;
        MessageGroupEntry m_prev;
        MessageGroupEntry m_next;
        private long m_lastActiveTime = 0L;

        MessageGroupEntry(String group, long uid) {
            this.m_group = group;
            this.m_uid = uid;
            this.m_state = 1;
        }

        synchronized long getLastActiveTime() {
            return this.m_lastActiveTime;
        }

        synchronized void setLastActiveTime(long lastActiveTime) {
            this.m_lastActiveTime = lastActiveTime;
        }

        synchronized long clearConsumer() {
            long old = this.m_uid;
            this.m_uid = -1L;
            this.m_state = 0;
            return old;
        }

        synchronized long setConsumer(long newConsumer) {
            long old = this.m_uid;
            this.m_uid = newConsumer;
            this.m_state = 1;
            return old;
        }

        synchronized void setPendingClose() {
            if (this.m_state != 1) {
                throw new IllegalStateException("Group " + this.m_group + " has no active consumer, state = " + this.m_state);
            }
            this.m_state = 2;
            if (MessageGroupTable.this.DEBUG) {
                MessageGroupTable.this.debug("Group " + this.m_group + " changed state to GROUP_IN_PENDING_CLOSE");
            }
        }

        synchronized boolean isPendingClose() {
            return this.m_state >= 2;
        }

        synchronized void setNewMessageAfterPendingClose() {
            if (this.m_state == 3) {
                return;
            }
            if (this.m_state != 2) {
                throw new IllegalStateException("Group " + this.m_group + " not in pending close, state = " + this.m_state);
            }
            this.m_state = 3;
            if (MessageGroupTable.this.DEBUG) {
                MessageGroupTable.this.debug("Group " + this.m_group + " changed state to GROUP_IN_PENDING_CLOSE_WITH_NEW_MESSAGES");
            }
        }

        synchronized boolean hasNewMessageAfterPendingClose() {
            return this.m_state == 3;
        }
    }
}

