/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.InterruptedIOException;
import java.util.Date;
import java.util.List;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.ClientAckEvt;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.ICCGuarDoubtManager;
import progress.message.broker.IClientContext;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.MgRsContainer;
import progress.message.broker.MsgRestorePos;
import progress.message.broker.MsgRestorer;
import progress.message.broker.prAccessor;
import progress.message.client.EGeneralException;
import progress.message.client.EUnsupportedMgramException;
import progress.message.db.EDatabaseException;
import progress.message.dbq.IQueryCancelCheck;
import progress.message.msg.IMgram;
import progress.message.util.EDuplicateKey;
import progress.message.zclient.SessionConfig;

final class MsgRestorerBase
extends MsgRestorer {
    private IClientContext m_cc;
    private long m_lastsn = -1L;
    private boolean m_restoreCancelled;
    private boolean m_disconnecting;
    private BrokerSubscription m_selectorSub = null;
    private MsgRestorePos m_msgRestorePos = new MsgRestorePos();
    private boolean m_durableSMORestore;
    private boolean m_doRemoteRestorePhases;
    private boolean m_isRestoringBroker;
    private boolean m_restoringRemoteMsgOnly;
    private MsgRestorePos m_remoteMsgRestorePos;
    private long m_lastsnRemote = -1L;
    private long m_maxDBSequenceNumber = -1L;
    private boolean m_needEndEvt;
    private boolean m_interruptable = false;

    @Override
    void setMaxDBSequenceNumber(long maxDBSequenceNumber) {
        if (this.checkDebugFlags(64)) {
            this.debug("Setting m_maxDBSequenceNumber to " + maxDBSequenceNumber);
        }
        this.m_maxDBSequenceNumber = maxDBSequenceNumber;
    }

    @Override
    long getMaxDBSequenceNumber() {
        return this.m_maxDBSequenceNumber;
    }

    @Override
    IClientContext getCC() {
        return this.m_cc;
    }

    @Override
    void messageSkipped(long msgid, long seqno) {
        if (!this.m_restoringRemoteMsgOnly) {
            if (this.DEBUG) {
                this.debug("messageSkipped: this seqno " + seqno + ", this msgId= " + msgid + " ,lastsn = " + this.m_lastsn + ", pos= " + this.m_msgRestorePos);
            }
            this.m_lastsn = seqno;
            this.m_msgRestorePos.update(msgid, seqno);
        } else {
            if (this.DEBUG) {
                this.debug("messageSkipped: this seqno " + seqno + ", this msgId= " + msgid + " ,lastsnRemote = " + this.m_lastsnRemote + ", Remotepos= " + this.m_remoteMsgRestorePos);
            }
            this.m_lastsnRemote = seqno;
            this.m_remoteMsgRestorePos.update(msgid, seqno);
        }
    }

    @Override
    synchronized void cancelRestore() {
        if (this.DEBUG) {
            this.debug("cancelRestore called");
        }
        this.m_restoreCancelled = true;
        if (this.m_interruptable) {
            this.shutdown();
        }
    }

    @Override
    final synchronized boolean isDisconnecting() {
        return this.m_disconnecting;
    }

    private synchronized void makeInterruptible() {
        this.m_interruptable = true;
    }

    private synchronized boolean makeUninterruptible() {
        this.m_interruptable = false;
        return MsgRestorerBase.interrupted();
    }

    synchronized boolean isRestoreCancelled() {
        if (this.checkDebugFlags(64) && Broker.exiting) {
            this.debug("Broker exiting=true; restoreCancelled= " + this.m_restoreCancelled);
        }
        return this.m_restoreCancelled || Broker.exiting;
    }

    MsgRestorerBase(IClientContext cc, MsgRestorePos startPos, boolean durableSMO, boolean doRemoteRestorePhases, boolean isRestoringBroker, MsgRestorePos remoteStartPos) {
        super(cc);
        this.m_msgRestorePos.update(startPos);
        this.m_durableSMORestore = durableSMO;
        this.m_doRemoteRestorePhases = doRemoteRestorePhases;
        this.m_isRestoringBroker = isRestoringBroker;
        this.m_remoteMsgRestorePos = remoteStartPos;
        this.m_cc = cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadMain() {
        try {
            this.m_cc.joinInDoubtTxns();
            this.m_cc.getGuarDoubtManager().takeAcknowledgeSnapshot();
            try {
                block89: {
                    block90: {
                        if (this.DEBUG) {
                            this.debug(" starting restore: " + new Date() + " m_cc.getId(): " + this.m_cc.getId() + " m_doRemoteRestorePhases: " + this.m_doRemoteRestorePhases + " m_isRestoringBroker: " + this.m_isRestoringBroker);
                        }
                        if (this.DEBUG) {
                            this.debug("Config.RESTORE_MSGS_COUNT= " + Config.RESTORE_MSGS_COUNT);
                        }
                        if (this.DEBUG) {
                            this.debug("Config.THROTTLE_PUBS_DURING_RESTORE= " + Config.THROTTLE_PUBS_DURING_RESTORE);
                        }
                        int restoreMsgsCount = Config.RESTORE_MSGS_COUNT;
                        if (this.DEBUG) {
                            this.debug("restoreMsgsCount " + restoreMsgsCount);
                        }
                        if (!this.isRestoreCancelled()) {
                            this.m_cc.waitToStartRestore();
                        }
                        if (this.m_doRemoteRestorePhases) {
                            block86: {
                                block87: {
                                    if (this.DEBUG) {
                                        this.debug("MsgRestorerBase doing remote restore phases");
                                    }
                                    this.m_restoringRemoteMsgOnly = true;
                                    if (this.m_isRestoringBroker) {
                                        // empty if block
                                    }
                                    if (this.DEBUG) {
                                        this.debug("Starting INIT_REMOTE_RESTORE...." + new Date());
                                    }
                                    this.m_needEndEvt = false;
                                    boolean continueRemoteRestore = this.doDurableOrderedRestore(0);
                                    if (!continueRemoteRestore) {
                                        if (this.DEBUG) {
                                            this.debug("initial remote restore aborted");
                                        }
                                        return;
                                    }
                                    this.m_maxDBSequenceNumber = -1L;
                                    this.m_cc.initialRemoteRestoreComplete(this.m_remoteMsgRestorePos);
                                    if (this.DEBUG) {
                                        this.debug("INIT_REMOTE_RESTORE Complete; m_remoteMsgRestorePos= " + this.m_remoteMsgRestorePos + " " + new Date());
                                    }
                                    if (this.DEBUG) {
                                        this.debug("waiting for saves to complete ");
                                    }
                                    if (!this.isRestoreCancelled()) {
                                        this.m_cc.waitToStartFinalRemoteRestore();
                                    }
                                    if (this.DEBUG) {
                                        this.debug("Starting FINAL_REMOTE_RESTORE...." + new Date());
                                    }
                                    if (this.doDurableOrderedRestore(0)) break block86;
                                    if (!this.DEBUG) break block87;
                                    this.debug("final remote restore aborted");
                                }
                                return;
                                finally {
                                    if (this.m_needEndEvt) {
                                        this.makeUninterruptible();
                                        try {
                                            if (this.m_cc.getGuarDoubtManager().getRestoredFromDbCount() > 0) {
                                                Thread.currentThread();
                                                Thread.sleep(500L);
                                            }
                                            this.m_cc.getGuarDoubtManager().syncRedeliveries();
                                            s_msgRestoreMgr.endRestore(this.m_cc.getId());
                                        }
                                        finally {
                                            this.makeInterruptible();
                                        }
                                    }
                                }
                            }
                            boolean disconnect = false;
                            if (!this.isRestoreCancelled()) {
                                this.m_maxDBSequenceNumber = -1L;
                                disconnect = this.m_cc.finalRemoteRestoreComplete(this.m_remoteMsgRestorePos);
                            }
                            if (this.m_isRestoringBroker) {
                                if (disconnect && !this.m_cc.isDisconnecting()) {
                                    this.m_disconnecting = true;
                                    if (!this.isRestoreCancelled()) {
                                        try {
                                            if (this.DEBUG) {
                                                this.debug("MsgRestorerBase disconnecting m_cc.getId(): " + this.m_cc.getId() + " on restoring broker after remote restore phases");
                                            }
                                            AgentRegistrar.getAgentRegistrar().prepareDisconnect(this.m_cc.getId());
                                            AgentRegistrar.getAgentRegistrar().disconnect(this.m_cc.getId(), true);
                                        }
                                        catch (EClientNotRegistered eClientNotRegistered) {
                                            // empty catch block
                                        }
                                    }
                                }
                                s_initRestoreFC.removeCC(this.m_cc);
                                if (this.DEBUG) {
                                    this.debug("Restoring broker exiting msgrestorer from remote restore phases");
                                }
                                return;
                            }
                            if (this.DEBUG) {
                                this.debug("Active broker continuing msgrestorer after remote restore phases. Now waiting for remote restore done ");
                            }
                            if (!this.isRestoreCancelled()) {
                                this.m_cc.waitForRemoteRestoreDone();
                            }
                        }
                        this.m_restoringRemoteMsgOnly = false;
                        if (this.DEBUG) {
                            this.debug("Starting INIT_RESTORE....m_durableSMORestore: " + this.m_durableSMORestore + " " + new Date());
                        }
                        boolean continueRestore = false;
                        this.m_needEndEvt = false;
                        continueRestore = this.m_durableSMORestore ? this.doDurableOrderedRestore(restoreMsgsCount) : this.doRestore(restoreMsgsCount);
                        if (Config.THROTTLE_PUBS_DURING_RESTORE) {
                            s_initRestoreFC.removeCC(this.m_cc);
                        }
                        if (!continueRestore) {
                            if (this.DEBUG) {
                                this.debug("initial restore aborted");
                            }
                            return;
                        }
                        if (this.m_selectorSub != null) {
                            s_msgSaver.flush();
                            while (!AgentRegistrar.getAgentRegistrar().trySetUnfilteredStatus(this.m_cc, false, true)) {
                                if (this.isRestoreCancelled()) {
                                    return;
                                }
                                Thread.sleep(25L);
                            }
                            this.m_selectorSub = null;
                            if (this.DEBUG) {
                                this.debug("Turned off the unfiltered status of the subscription");
                            }
                        }
                        if (this.DEBUG) {
                            this.debug("InitialRestoreComplete; pos= " + this.m_msgRestorePos + " " + new Date());
                        }
                        this.m_maxDBSequenceNumber = -1L;
                        this.m_cc.initialRestoreComplete(this.m_msgRestorePos);
                        if (this.DEBUG) {
                            this.debug("waiting for saves to complete ");
                        }
                        if (!this.isRestoreCancelled()) {
                            this.m_cc.waitToStartFinalRestore();
                        }
                        if (this.DEBUG) {
                            this.debug("Starting FINAL_RESTORE....m_durableSMORestore: " + this.m_durableSMORestore + " " + new Date());
                        }
                        continueRestore = false;
                        continueRestore = this.m_durableSMORestore ? this.doDurableOrderedRestore(0) : this.doRestore(0);
                        if (continueRestore) break block89;
                        if (!this.DEBUG) break block90;
                        this.debug("final restore aborted");
                    }
                    return;
                    finally {
                        if (this.m_needEndEvt) {
                            this.makeUninterruptible();
                            try {
                                if (this.m_cc.getGuarDoubtManager().getRestoredFromDbCount() > 0) {
                                    Thread.currentThread();
                                    Thread.sleep(500L);
                                }
                                this.m_cc.getGuarDoubtManager().syncRedeliveries();
                                s_msgRestoreMgr.endRestore(this.m_cc.getId());
                            }
                            finally {
                                this.makeInterruptible();
                            }
                        }
                    }
                }
                if (!this.isRestoreCancelled()) {
                    this.m_cc.restoreComplete(this.m_msgRestorePos);
                }
                if (this.isRestoreCancelled()) {
                    return;
                }
                if (this.DEBUG) {
                    this.debug("FINAL_RESTORE complete m_cc.getId(): " + this.m_cc.getId() + " pos= " + this.m_msgRestorePos + " " + new Date());
                }
            }
            finally {
                this.m_cc.getGuarDoubtManager().clearAcknowledgeSnapshot();
            }
        }
        catch (InterruptedException e) {
            if (Config.THROTTLE_PUBS_DURING_RESTORE) {
                s_initRestoreFC.removeCC(this.m_cc);
            }
            return;
        }
    }

    @Override
    final void acknowledge(IMgram m) {
        s_msgSaver.deleteMsg(this.m_cc, m.getGuarenteedTrackingNum(), m.getBrokerHandle().getTrackedSize(), false, m.isGuarenteed());
        if (m.getBrokerHandle().isFromLog()) {
            ClientAckEvt evt = new ClientAckEvt(this.m_cc.getId(), m.getGuarenteedTrackingNum(), null, false, true);
            AgentRegistrar.getAgentRegistrar().getLogManager().addEvent(evt, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doDurableOrderedRestore(int restoreMsgsCount) {
        if (this.DEBUG) {
            this.debug("doDurableOrderedRestore called.");
        }
        try {
            if (this.isRestoreCancelled()) {
                throw new InterruptedException();
            }
            if (this.DEBUG) {
                this.debug("doDurableOrderedRestore; localMsgRestorePos: " + this.m_msgRestorePos + " remoteMsgRestorePos: " + this.m_remoteMsgRestorePos);
            }
            long strt = System.currentTimeMillis();
            long rststrt = System.currentTimeMillis();
            List undelBatch = null;
            int totcount = 0;
            QueryCancelCheck cancel = new QueryCancelCheck();
            while ((undelBatch = s_db.restoreMsgsForSMODurable(cancel, this.m_cc.getId(), this.m_restoringRemoteMsgOnly, this.m_msgRestorePos, this.m_remoteMsgRestorePos, restoreMsgsCount, false, 0)) != null) {
                IMgram m;
                MgRsContainer msgs = new MgRsContainer(this.m_cc, undelBatch);
                msgs.setMsgRestorer(this);
                if (this.DEBUG) {
                    int ct = msgs.s_length;
                    long time = (System.currentTimeMillis() - strt + 500L) / 1000L;
                    this.debug("doDurableOrderedRestore; performed db query; msgs.size= " + ct + " queryTime(secs)= " + time);
                    strt = System.currentTimeMillis();
                }
                int msgcount = 0;
                int redct = 0;
                if (this.isRestoreCancelled()) {
                    throw new InterruptedException();
                }
                if (!undelBatch.isEmpty()) {
                    this.logRestoreEvtIfNeeded(this.m_restoringRemoteMsgOnly, true);
                }
                ICCGuarDoubtManager dm = this.m_cc.getGuarDoubtManager();
                while ((m = msgs.getNextMgram(cancel)) != null) {
                    boolean accepted = false;
                    try {
                        long seqno;
                        if (this.isRestoreCancelled()) {
                            throw new InterruptedException();
                        }
                        boolean fromRemoteBroker = m.getBrokerHandle().isFromRemoteBroker();
                        if (fromRemoteBroker) {
                            seqno = m.getBrokerHandle().getSequenceNumber();
                            if (this.m_lastsnRemote == seqno) {
                                if (!this.DEBUG) continue;
                                this.debug("Skipping msgId= " + m.getGuarenteedTrackingNum() + " seq= " + seqno);
                                continue;
                            }
                            this.m_lastsnRemote = seqno;
                            this.m_remoteMsgRestorePos.update(m);
                        } else {
                            seqno = m.getBrokerHandle().getSequenceNumber();
                            if (this.m_lastsn == seqno) {
                                if (!this.DEBUG) continue;
                                this.debug("Skipping msgId= " + m.getGuarenteedTrackingNum() + " seq= " + seqno);
                                continue;
                            }
                            this.m_lastsn = seqno;
                            this.m_msgRestorePos.update(m);
                        }
                        m.getBrokerHandle().setFromDB(true);
                        if (!this.m_cc.recheckRestoredMgram(m)) continue;
                        if (this.DEBUG) {
                            this.debug("restoring message " + m.getGuarenteedTrackingNum());
                        }
                        try {
                            if (this.isRestoreCancelled() || !(accepted = this.m_cc.addRestoredMgram(m, this.m_durableSMORestore, fromRemoteBroker))) {
                                msgs.close();
                                boolean seqno2 = false;
                                return seqno2;
                            }
                        }
                        catch (EDuplicateKey e) {
                            continue;
                        }
                        catch (InterruptedException e) {
                            if (msgs != null) {
                                msgs.close();
                            }
                            boolean bl = false;
                            if (m == null) return bl;
                            if (accepted) return bl;
                            this.m_cc.getGuarDoubtManager().removeRestoredFromDb(m.getGuarenteedTrackingNum());
                            m = null;
                            return bl;
                        }
                        {
                            if (m.isSuccessor()) {
                                ++redct;
                            }
                            ++msgcount;
                            ++totcount;
                        }
                    }
                    finally {
                        if (m == null || accepted) continue;
                        this.m_cc.getGuarDoubtManager().removeRestoredFromDb(m.getGuarenteedTrackingNum());
                        m = null;
                    }
                }
                msgs.close();
                if (this.DEBUG) {
                    long time = (System.currentTimeMillis() - strt + 500L) / 1000L;
                    this.debug("doDurableOrderedRestore: restored " + msgcount + " msgs; " + " redelivred= " + redct + " pos= " + this.m_msgRestorePos + " time (secs)= " + time);
                    strt = System.currentTimeMillis();
                }
                if (restoreMsgsCount != 0 && (restoreMsgsCount <= 0 || msgs.length() >= restoreMsgsCount)) continue;
            }
            if (!this.DEBUG) return true;
            long time = (System.currentTimeMillis() - rststrt + 500L) / 1000L;
            this.debug("doDurableOrderedRestore: completed; restored " + totcount + " msgs; time(secs)= " + time);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InterruptedIOException e) {
            return false;
        }
        catch (EDatabaseException e) {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR220") + this.m_cc.getUid() + "/" + this.m_cc.getAppid() + ": " + e.getMessage(), (Throwable)e, 2);
            return true;
        }
        catch (EGeneralException e) {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR220") + this.m_cc.getUid() + "/" + this.m_cc.getAppid() + ": " + e.getMessage(), (Throwable)e, 2);
            return true;
        }
        catch (EUnsupportedMgramException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 1);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doRestore(int restoreMsgsCount) {
        try {
            List undelBatch;
            if (this.isRestoreCancelled()) {
                throw new InterruptedException();
            }
            if (this.checkDebugFlags(64)) {
                this.debug("doRestore: starting ccstate= " + this.m_cc.getState() + " startPos: " + this.m_msgRestorePos);
            }
            long strt = System.currentTimeMillis();
            long rststrt = System.currentTimeMillis();
            MgRsContainer msgs = null;
            int totcount = 0;
            int maxSize = Config.PS_DB_QUEUE_SIZE / 2;
            QueryCancelCheck cancel = new QueryCancelCheck();
            while (!this.isRestoreCancelled() && (undelBatch = s_db.restoreMsgs(cancel, this.m_cc.getId(), this.m_msgRestorePos, restoreMsgsCount, true, maxSize)) != null) {
                IMgram m;
                msgs = new MgRsContainer(this.m_cc, undelBatch);
                msgs.setMsgRestorer(this);
                if (this.DEBUG) {
                    int ct = msgs.s_length;
                    long time = (System.currentTimeMillis() - strt + 500L) / 1000L;
                    this.debug("doRestore; performed db query; msgs.size= " + ct + " queryTime(secs)= " + time);
                    strt = System.currentTimeMillis();
                }
                int msgcount = 0;
                int redct = 0;
                if (this.isRestoreCancelled()) {
                    throw new InterruptedException();
                }
                ICCGuarDoubtManager dm = this.m_cc.getGuarDoubtManager();
                if (!undelBatch.isEmpty()) {
                    this.logRestoreEvtIfNeeded(false, false);
                }
                while (!this.isRestoreCancelled() && (m = msgs.getNextMgram(cancel)) != null) {
                    boolean accepted = false;
                    try {
                        long maxStartUpSeqNo;
                        long msgSeqNo2;
                        if (this.isRestoreCancelled()) {
                            throw new InterruptedException();
                        }
                        long seqno = m.getBrokerHandle().getSequenceNumber();
                        if (this.m_lastsn == seqno) {
                            if (!this.DEBUG) continue;
                            this.debug("Skipping msgId= " + m.getGuarenteedTrackingNum() + " seq= " + seqno);
                            continue;
                        }
                        this.m_lastsn = seqno;
                        this.m_msgRestorePos.update(m);
                        if (!m.isGuarenteed()) {
                            this.acknowledge(m);
                            continue;
                        }
                        if (AgentRegistrar.getAgentRegistrar().recoveredFromLog() && InterbrokerHook.isSet() && InterbrokerHook.isNeighbor(this.m_cc.getId()) && m.isNonPersistentReplicated() && (msgSeqNo2 = m.getBrokerHandle().getSequenceNumber()) <= (maxStartUpSeqNo = AgentRegistrar.getAgentRegistrar().getBrokerDatabase().getStartupMaxSeqNoUsed())) {
                            this.acknowledge(m);
                            continue;
                        }
                        m.getBrokerHandle().setFromDB(true);
                        if (!this.m_cc.recheckRestoredMgram(m)) continue;
                        if (this.DEBUG) {
                            this.debug("restoring message " + m.getGuarenteedTrackingNum() + " type= " + m.getType());
                        }
                        try {
                            if (this.isRestoreCancelled() || !(accepted = this.m_cc.addRestoredMgram(m, false, false))) {
                                msgs.close();
                                boolean msgSeqNo2 = false;
                                return msgSeqNo2;
                            }
                        }
                        catch (EDuplicateKey e) {
                            continue;
                        }
                        catch (InterruptedException e) {
                            if (msgs != null) {
                                msgs.close();
                            }
                            boolean bl = false;
                            if (m == null) return bl;
                            if (accepted) return bl;
                            this.m_cc.getGuarDoubtManager().removeRestoredFromDb(m.getGuarenteedTrackingNum());
                            m = null;
                            return bl;
                        }
                        {
                            if (m.isSuccessor()) {
                                ++redct;
                            }
                            ++msgcount;
                            ++totcount;
                        }
                    }
                    finally {
                        if (m == null || accepted) continue;
                        this.m_cc.getGuarDoubtManager().removeRestoredFromDb(m.getGuarenteedTrackingNum());
                        m = null;
                    }
                }
                msgs.close();
                if (this.isRestoreCancelled()) {
                    throw new InterruptedException();
                }
                if (this.DEBUG) {
                    long time = (System.currentTimeMillis() - strt + 500L) / 1000L;
                    this.debug("doRestore: restored " + msgcount + " msgs; " + " redelivred= " + redct + " pos= " + this.m_msgRestorePos + " time (secs)= " + time);
                    strt = System.currentTimeMillis();
                }
                if (restoreMsgsCount != 0 && (restoreMsgsCount <= 0 || msgs.length() >= restoreMsgsCount)) continue;
            }
            if (this.isRestoreCancelled()) {
                throw new InterruptedException();
            }
            if (!this.checkDebugFlags(64)) return true;
            long time = (System.currentTimeMillis() - rststrt + 500L) / 1000L;
            this.debug("doRestore: completed; restored " + totcount + " msgs; " + " ccstate= " + this.m_cc.getState() + " time(secs)= " + time);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InterruptedIOException e) {
            return false;
        }
        catch (EDatabaseException e) {
            if (Broker.exiting) return false;
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR220") + this.m_cc.getUid() + "/" + this.m_cc.getAppid() + ": " + e.getMessage(), (Throwable)e, 2);
            return false;
        }
        catch (EGeneralException e) {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR220") + this.m_cc.getUid() + "/" + this.m_cc.getAppid() + ": " + e.getMessage(), (Throwable)e, 2);
            return true;
        }
        catch (EUnsupportedMgramException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 1);
        }
        return true;
    }

    private void logRestoreEvtIfNeeded(boolean remote, boolean smo) {
        if (!this.m_needEndEvt) {
            boolean replicateOnly = Config.REPLICATED && this.m_cc.isXOnce() && SessionConfig.isNonDurableSubscriber(this.m_cc.getAppid());
            this.m_needEndEvt = true;
            s_msgRestoreMgr.beginRestore(this.m_cc, remote, smo, replicateOnly);
        }
    }

    private class QueryCancelCheck
    implements IQueryCancelCheck {
        private QueryCancelCheck() {
        }

        @Override
        public boolean cancelQuery() {
            return MsgRestorerBase.this.isRestoreCancelled();
        }

        @Override
        public void endDbWork() {
            MsgRestorerBase.this.makeInterruptible();
        }

        @Override
        public void beginDbWork() {
            MsgRestorerBase.this.makeUninterruptible();
        }
    }
}

