/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.AdministrativelyCreatedQueue;
import progress.message.broker.AgentAdministrativelyCreatedQueue;
import progress.message.broker.AgentDeadMessageQueue;
import progress.message.broker.AgentHttpDirectTemporaryQueue;
import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.AgentRoutingQueue;
import progress.message.broker.AgentTemporaryQueue;
import progress.message.broker.BaseQueue;
import progress.message.broker.DeadMessageQueue;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IQueueContext;
import progress.message.broker.IQueueFactory;
import progress.message.broker.ISavableQueueContext;
import progress.message.broker.PendingQueue;
import progress.message.broker.QueueContext;
import progress.message.broker.QueueTypeConstants;
import progress.message.broker.RoutingQueue;
import progress.message.broker.SavableQueueContext;
import progress.message.broker.TemporaryQueue;
import progress.message.broker.TemporaryQueueContext;

public class QueueFactory
implements IQueueFactory,
QueueTypeConstants {
    private static volatile QueueFactory s_qFactory;
    private static volatile IQueueContext s_queueCtx;
    private static volatile ISavableQueueContext s_savableQueueCtx;
    private static volatile IQueueContext s_temporaryQueueCtx;
    private static volatile AgentDeadMessageQueue s_admq;
    private static volatile DeadMessageQueue s_dmq;
    private static volatile AgentRoutingQueue s_arq;
    private static volatile RoutingQueue s_rq;
    private static volatile AgentRegistrar s_reg;
    private static volatile AgentQueueProcessor s_qproc;
    private static final Object DOUBLE_CHECKED_LOCK_OBJ;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueFactory() {
        if (s_qFactory == null) {
            Object object = DOUBLE_CHECKED_LOCK_OBJ;
            synchronized (object) {
                if (s_qFactory == null) {
                    s_qFactory = this;
                }
            }
        } else {
            return;
        }
        s_reg = AgentRegistrar.getAgentRegistrar();
        s_qproc = s_reg.getQueueProc();
    }

    public static QueueFactory getQueueFactory() {
        return s_qFactory;
    }

    public IAgentQueue createAgentQueue(int qType, String qname, int maxSize) {
        IAgentQueue iaq = null;
        switch (qType) {
            case 0: {
                iaq = this.createAgentAdministrativelyCreatedQueue(qname, maxSize);
                break;
            }
            case 1: {
                iaq = this.createAgentTemporaryQueue(qname, maxSize);
                break;
            }
            case 3: {
                iaq = this.createAgentDeadMessageQueue(maxSize);
                break;
            }
            case 4: {
                iaq = this.createAgentRoutingQueue(maxSize);
                break;
            }
            case 5: {
                iaq = this.createAgentHttpDirectTemporaryQueue(qname, maxSize);
                break;
            }
        }
        return iaq;
    }

    @Override
    public BaseQueue createQueue(int qType, String qname, int maxSize) {
        BaseQueue q = null;
        switch (qType) {
            case 0: {
                q = this.createAdministrativelyCreatedQueue(qname, maxSize);
                break;
            }
            case 1: {
                q = this.createTemporaryQueue(qname, maxSize);
                break;
            }
            case 2: {
                q = this.createPendingQueue(qname, maxSize);
                break;
            }
            case 3: {
                q = this.createDeadMessageQueue(maxSize);
                break;
            }
            case 4: {
                q = this.createRoutingQueue(maxSize);
                break;
            }
        }
        return q;
    }

    private IAgentQueue createAgentAdministrativelyCreatedQueue(String qname, int maxSize) {
        AdministrativelyCreatedQueue acq = (AdministrativelyCreatedQueue)this.createAdministrativelyCreatedQueue(qname, maxSize);
        AgentAdministrativelyCreatedQueue aacq = new AgentAdministrativelyCreatedQueue(qname, acq, s_reg);
        return aacq;
    }

    private BaseQueue createAdministrativelyCreatedQueue(String qname, int maxSize) {
        if (s_savableQueueCtx == null) {
            this.createSavableQueueContext();
        }
        int numPriorities = 10;
        AdministrativelyCreatedQueue q = new AdministrativelyCreatedQueue(qname, numPriorities, maxSize, s_savableQueueCtx, null);
        return q;
    }

    private IAgentQueue createAgentTemporaryQueue(String qname, int maxSize) {
        TemporaryQueue tq = (TemporaryQueue)this.createTemporaryQueue(qname, maxSize);
        AgentTemporaryQueue atq = new AgentTemporaryQueue(qname, tq, s_reg);
        return atq;
    }

    private BaseQueue createTemporaryQueue(String qname, int maxSize) {
        if (s_temporaryQueueCtx == null) {
            this.createTemporaryQueueContext();
        }
        int numPriorities = 10;
        TemporaryQueue q = new TemporaryQueue(qname, numPriorities, maxSize, s_temporaryQueueCtx, null);
        return q;
    }

    private BaseQueue createPendingQueue(String qname, int maxSize) {
        if (s_savableQueueCtx == null) {
            this.createSavableQueueContext();
        }
        int numPriorities = 10;
        PendingQueue q = new PendingQueue(qname, numPriorities, maxSize, s_savableQueueCtx, null);
        return q;
    }

    private IAgentQueue createAgentDeadMessageQueue(int maxSize) {
        if (s_admq != null) {
            return s_admq;
        }
        this.createDeadMessageQueue(maxSize);
        s_admq = new AgentDeadMessageQueue("SonicMQ.deadMessage", s_dmq, s_reg);
        return s_admq;
    }

    private BaseQueue createDeadMessageQueue(int maxSize) {
        if (s_dmq != null) {
            return s_dmq;
        }
        if (s_savableQueueCtx == null) {
            this.createSavableQueueContext();
        }
        int numPriorities = 10;
        s_dmq = new DeadMessageQueue("SonicMQ.deadMessage", numPriorities, maxSize, s_savableQueueCtx, null);
        return s_dmq;
    }

    private IAgentQueue createAgentRoutingQueue(int maxSize) {
        if (s_arq != null) {
            return s_arq;
        }
        this.createRoutingQueue(maxSize);
        s_arq = new AgentRoutingQueue("SonicMQ.routingQueue", s_rq, s_reg);
        return s_arq;
    }

    private BaseQueue createRoutingQueue(int maxSize) {
        if (s_rq != null) {
            return s_rq;
        }
        if (s_savableQueueCtx == null) {
            this.createSavableQueueContext();
        }
        int numPriorities = 10;
        s_rq = new RoutingQueue("SonicMQ.routingQueue", numPriorities, maxSize, s_savableQueueCtx, null);
        return s_rq;
    }

    private IAgentQueue createAgentHttpDirectTemporaryQueue(String qname, int maxSize) {
        AgentHttpDirectTemporaryQueue ahdtq = new AgentHttpDirectTemporaryQueue(qname, s_reg);
        return ahdtq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQueueContext createQueueContext() {
        if (s_queueCtx == null) {
            Object object = DOUBLE_CHECKED_LOCK_OBJ;
            synchronized (object) {
                if (s_queueCtx == null) {
                    s_queueCtx = new QueueContext(s_qproc, s_reg, s_reg.getFlowControlManager());
                }
            }
        }
        return s_queueCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISavableQueueContext createSavableQueueContext() {
        if (s_savableQueueCtx == null) {
            Object object = DOUBLE_CHECKED_LOCK_OBJ;
            synchronized (object) {
                if (s_savableQueueCtx == null) {
                    s_savableQueueCtx = new SavableQueueContext(s_qproc, s_reg, s_reg.getFlowControlManager(), s_reg.getQueueMsgSaver());
                }
            }
        }
        return s_savableQueueCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQueueContext createTemporaryQueueContext() {
        if (s_temporaryQueueCtx == null) {
            Object object = DOUBLE_CHECKED_LOCK_OBJ;
            synchronized (object) {
                if (s_temporaryQueueCtx == null) {
                    s_temporaryQueueCtx = new TemporaryQueueContext(s_qproc, s_reg, s_reg.getFlowControlManager());
                }
            }
        }
        return s_temporaryQueueCtx;
    }

    static {
        DOUBLE_CHECKED_LOCK_OBJ = new Object();
    }
}

