/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.msg.IMgram;
import progress.message.util.StreamUtil;

public final class QueueMsgAckedEvt
extends LogEvent {
    private long m_msgTracking;
    private IMgram m_ack;
    private boolean m_hasDelete;
    private short m_eventType = (short)104;

    public QueueMsgAckedEvt(long msgTracking, IMgram ack, boolean hasDelete) {
        this.m_msgTracking = msgTracking;
        this.m_ack = ack;
        this.m_hasDelete = hasDelete;
    }

    public QueueMsgAckedEvt(short eventType) {
        this.m_eventType = eventType;
    }

    long getTracking() {
        return this.m_msgTracking;
    }

    @Override
    protected void onFlush() {
        block3: {
            if (this.m_ack != null && this.m_ack.isGuarenteed()) {
                try {
                    AgentRegistrar.getAgentRegistrar().getClient(this.m_ack.getBrokerHandle().getSenderID()).sendAckAck(this.m_ack);
                }
                catch (EClientNotRegistered e) {
                    if (!this.DEBUG) break block3;
                    this.debug("Client not around for ack confirm - tracking: " + this.m_ack != null ? "" + this.m_ack.getGuarenteedTrackingNum() : "null");
                }
            }
        }
    }

    @Override
    public short type() {
        return 104;
    }

    @Override
    protected int memSizeBody() {
        return 9;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        return 9;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        StreamUtil.writeLong(this.m_msgTracking, out);
        StreamUtil.writeBoolean(this.m_hasDelete, out);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        StreamUtil.writeLong(this.m_msgTracking, os);
        StreamUtil.writeBoolean(this.m_hasDelete, os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_msgTracking = StreamUtil.readLong(in);
        this.m_hasDelete = StreamUtil.readBoolean(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoQueueMsgAcked(this.m_msgTracking, this.m_hasDelete, false);
    }

    @Override
    public String toString() {
        return super.toString() + " acknowledge of queue message " + this.m_msgTracking;
    }
}

