/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.Iterator;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EBrokerTxnFailure;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.IClientContext;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.LogEvent;
import progress.message.broker.MgramSerializer;
import progress.message.broker.RecoveryMgr;
import progress.message.broker.prAccessor;
import progress.message.msg.IBatchHandle;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;
import progress.message.util.EDuplicateKey;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.EMgramFormatError;

public class QueueMsgEvt
extends LogEvent {
    private short m_eventType = (short)75;
    private IMgram m_msg;
    private long m_orig_sender;
    private long m_orig_tracking;
    private String m_queueName;
    private boolean m_needGuarAck;
    private IClientContext m_publisher;
    private boolean m_acked = false;
    private AgentQueueMsgTracker m_tracker;
    private boolean m_seqNoSet = false;
    private int m_tid;
    private boolean m_batchedPublish;
    private boolean m_splitBatch = false;
    private boolean m_isTempQueue;
    private byte m_priority;
    private long m_expiration;
    private long m_enqueuedSize;

    QueueMsgEvt(String queueName, IClientContext publisher, IMgram msg, boolean needGuarAck, boolean isTempQueue) {
        if (queueName == null) {
            throw new EAssertFailure("null queue name");
        }
        this.m_publisher = publisher;
        this.m_orig_sender = msg.getBrokerHandle().getSenderID();
        this.m_orig_tracking = msg.getGuarenteedTrackingNum();
        this.setReplicateOnly(msg.isNonPersistentReplicated());
        this.m_msg = msg;
        this.m_needGuarAck = needGuarAck;
        this.m_queueName = queueName.intern();
        this.m_isTempQueue = isTempQueue;
        this.m_priority = msg.getPriority();
        this.m_expiration = msg.getTTE();
        this.m_enqueuedSize = msg.getEnqueuedSize();
        if (msg.getType() == 27) {
            IBatchHandle batchHandle = msg.getBatchHandle();
            int batchSize = batchHandle.getBatchSize();
            this.setNumSeqNos(batchSize + 1);
        } else {
            this.m_batchedPublish = msg.getBrokerHandle().isBatchedPublish();
        }
    }

    QueueMsgEvt(short type) {
        this.m_eventType = type;
    }

    public IMgram getMessage() {
        return this.m_msg;
    }

    @Override
    public short type() {
        return 75;
    }

    public boolean isTempQueue() {
        return this.m_isTempQueue;
    }

    public long getOrigSender() {
        return this.m_orig_sender;
    }

    long getOrigTracking() {
        return this.m_orig_tracking;
    }

    boolean needGuarAck() {
        return this.m_needGuarAck;
    }

    String getLocalQueueName() {
        return this.m_queueName;
    }

    void setMessage(IMgram message) {
        this.m_msg = message;
    }

    void setLocalQueueName(String queueName) {
        this.m_queueName = queueName;
    }

    void setOrigSender(long origSender) {
        this.m_orig_sender = origSender;
    }

    void setOrigTracking(long origTracking) {
        this.m_orig_tracking = origTracking;
    }

    void setGuarAck(boolean needGuarAck) {
        this.m_needGuarAck = needGuarAck;
    }

    AgentQueueMsgTracker getTracker() {
        return this.m_tracker;
    }

    void setTransacted(int tid) {
        this.m_tid = tid;
    }

    void setNonTransacted() {
        this.m_tid = 0;
    }

    public boolean isTransacted() {
        return this.m_tid != 0;
    }

    int getTransactionId() {
        return this.m_tid;
    }

    byte getPriority() {
        return this.m_priority;
    }

    long getExpiration() {
        return this.m_expiration;
    }

    long getEnqueuedSize() {
        return this.m_enqueuedSize;
    }

    public boolean splitBatch() {
        return this.m_splitBatch;
    }

    public void setSplitBatch(boolean splitBatch) {
        this.m_splitBatch = splitBatch;
    }

    public boolean isBatchedPublish() {
        return this.m_batchedPublish;
    }

    @Override
    public void setSeqNo(long seqno) {
        super.setSeqNo(seqno);
        this.m_seqNoSet = true;
        this.m_msg.setGuarenteed(seqno);
    }

    @Override
    protected void onFlush() {
        block5: {
            if (this.m_needGuarAck) {
                this.createTracker();
            }
            if (this.isTransacted()) {
                long[] tracking = new long[]{this.m_orig_tracking};
                try {
                    if (AgentRegistrar.getAgentRegistrar().getTransactionMgr().getTxn(this.m_tid).sendStorageAcks(tracking, false)) {
                        return;
                    }
                }
                catch (EBrokerTxnFailure ex) {
                    if (!this.DEBUG) break block5;
                    BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
                }
            }
        }
        this.sendAck();
    }

    @Override
    public int memSizeBody() {
        return 48 + (this.m_queueName.length() << 1) + this.m_msg.serializedLength();
    }

    @Override
    public void saveMemory() {
        this.m_msg.saveMemory();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writePreMgram(out);
        MgramSerializer.getMgramSerializer().serialize(out, this.m_msg, false);
        this.writePostMgram(out);
    }

    private void writePreMgram(OutputStream os) throws IOException {
        byte[] utfqname = StringUtil.stringToUTF(this.m_queueName);
        StreamUtil.writeLong(this.m_orig_sender, os);
        StreamUtil.writeLong(this.m_orig_tracking, os);
        StreamUtil.writeBoolean(this.m_needGuarAck, os);
        os.write(utfqname, 0, utfqname.length);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writePreMgram(os);
        MgramSerializer.getMgramSerializer().serialize(os, this.m_msg, tteTTLConvert);
        this.writePostMgram(os);
    }

    private void writePostMgram(OutputStream os) throws IOException {
        StreamUtil.writeInt(this.m_tid, os);
        StreamUtil.writeBoolean(this.m_splitBatch, os);
        StreamUtil.writeBoolean(this.m_isTempQueue, os);
        StreamUtil.writeByte(this.m_priority, os);
        StreamUtil.writeLong(this.m_expiration, os);
        StreamUtil.writeLong(this.m_enqueuedSize, os);
    }

    private void readPreMgramFromStream(InputStream in) throws IOException {
        this.m_orig_sender = StreamUtil.readLong(in);
        this.m_orig_tracking = StreamUtil.readLong(in);
        this.m_needGuarAck = StreamUtil.readBoolean(in);
        this.m_queueName = StreamUtil.readUTF(in);
        this.m_queueName = this.m_queueName.intern();
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException, EMgramFormatError {
        this.readPreMgramFromStream(in);
        this.m_msg = MgramSerializer.getMgramSerializer().unserialize(in, tteTTLConvert);
        this.m_msg.getBrokerHandle().setLogEvent(this);
        String queueName = this.m_queueName.intern();
        this.m_msg.getBrokerHandle().setLocalQueueName(queueName);
        if (this.m_msg.getType() == 27) {
            IBatchHandle batchHandle = this.m_msg.getBatchHandle();
            int batchSize = batchHandle.getBatchSize();
            this.setNumSeqNos(batchSize + 1);
            Iterator itr = batchHandle.getBatchIterator();
            while (itr.hasNext()) {
                IMgram subMgram = (IMgram)itr.next();
                subMgram.getBrokerHandle().setLocalQueueName(queueName);
            }
        }
        this.m_seqNoSet = true;
        this.readPostMgram(in);
    }

    @Override
    protected void readBodyFromLog(InputStream in) throws IOException, EMgramFormatError {
        this.readPreMgramFromStream(in);
        this.m_msg = MgramSerializer.getMgramSerializer().unserialize(in);
        this.m_msg.getBrokerHandle().setLogEvent(this);
        String queueName = this.m_queueName.intern();
        this.m_msg.getBrokerHandle().setLocalQueueName(queueName);
        if (this.m_msg.getType() == 27) {
            IBatchHandle batchHandle = this.m_msg.getBatchHandle();
            int batchSize = batchHandle.getBatchSize();
            this.setNumSeqNos(batchSize + 1);
            Iterator itr = batchHandle.getBatchIterator();
            while (itr.hasNext()) {
                IMgram subMgram = (IMgram)itr.next();
                subMgram.getBrokerHandle().setLocalQueueName(queueName);
            }
        }
        this.m_seqNoSet = true;
        this.readPostMgram(in);
    }

    private void readPostMgram(InputStream in) throws IOException {
        if (this.m_eventType == 58 || this.m_eventType == 70 || this.m_eventType == 75) {
            this.m_tid = StreamUtil.readInt(in);
            this.m_isTempQueue = false;
        }
        if (this.m_eventType == 70 || this.m_eventType == 75) {
            this.m_splitBatch = StreamUtil.readBoolean(in);
        }
        if (this.m_eventType == 75) {
            this.m_isTempQueue = StreamUtil.readBoolean(in);
            this.m_priority = StreamUtil.readByte(in);
            this.m_expiration = StreamUtil.readLong(in);
            this.m_enqueuedSize = StreamUtil.readLong(in);
        } else if (!this.m_splitBatch && this.m_msg != null) {
            this.m_priority = this.m_msg.getPriority();
            if (this.m_msg.isTTE()) {
                this.m_expiration = this.m_msg.getTTE();
            }
            this.m_enqueuedSize = this.m_msg.getEnqueuedSize();
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoQueueMsg(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAck() {
        boolean sendit;
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        QueueMsgEvt queueMsgEvt = this;
        synchronized (queueMsgEvt) {
            sendit = !this.m_acked && !this.m_batchedPublish && !this.m_msg.getBrokerHandle().isTransactionalPublish();
            this.m_acked = true;
        }
        if (sendit) {
            try {
                IClientContext cc = reg.getClient(this.m_orig_sender);
                if (cc.isXOnce() && this.isTransacted()) {
                    return;
                }
                if (this.m_needGuarAck) {
                    boolean guar = true;
                    long ackTracking = reg.getLogManager().allocSeqNo() & 0xFFFFFFFFFFFFL;
                    if (InterbrokerHook.isSet() && cc.isInterbroker()) {
                        InterbrokerHook.sendingGuarQAck(ackTracking, this.m_orig_sender, this.m_orig_tracking);
                        if (this.DEBUG) {
                            this.debug("Sending guaranteed ack for QMessage " + this.m_orig_tracking + " to IB sender " + this.m_orig_sender + " ackTracking= " + ackTracking);
                        }
                    } else if (cc.isRemoteBroker()) {
                        AgentRegistrar.getAgentRegistrar().getRouterManager().sendingGuarQAck(ackTracking, this.m_orig_sender, this.m_orig_tracking);
                        if (this.DEBUG) {
                            this.debug("Sending guaranteed ack for QMessage " + this.m_orig_tracking + " to GR Sender " + this.m_orig_sender + " ackTracking= " + ackTracking + "our tracking= " + this.getSeqNo());
                        }
                    } else {
                        cc.sendQAck(this.m_orig_tracking, this.m_msg);
                        return;
                    }
                    if (this.DEBUG) {
                        this.debug("QME - sending QAck; sender is " + this.m_orig_sender);
                    }
                    IMgram ack = MgramFactory.getMgramFactory().buildQAck(this.m_orig_tracking, -1L, (short)0, guar, ackTracking, false, 0, cc.getChannel());
                    cc.sendThrough(ack);
                    if (this.DEBUG) {
                        this.debug("QME - sent qack to " + this.m_orig_sender + "(CSC.NO_PARENT), orig tracking " + this.m_orig_tracking + " for TK:" + this.m_msg.getGuarenteedTrackingNum());
                    }
                } else {
                    if (this.DEBUG) {
                        this.debug("QME - sending QAck; sender is " + this.m_orig_sender);
                    }
                    cc.sendQAck(this.m_orig_tracking, this.m_msg);
                    if (this.DEBUG) {
                        this.debug("QME - sent qack to " + this.m_orig_sender + ", orig tracking " + this.m_orig_tracking + " for TK:" + this.m_msg.getGuarenteedTrackingNum());
                    }
                }
            }
            catch (EClientNotRegistered eClientNotRegistered) {
                // empty catch block
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "Persistent queue message; queue: " + this.m_queueName + (this.m_tid > 0 ? " Tid= " + this.m_tid : "");
    }

    @Override
    public int streamSizeBody() {
        return this.preMgramSize() + this.m_msg.networkLength() + this.postMgramSize();
    }

    @Override
    public int serializedSizeBody() {
        return this.preMgramSize() + this.m_msg.serializedLength() + this.postMgramSize();
    }

    private int preMgramSize() {
        byte[] utfqname;
        block2: {
            utfqname = null;
            try {
                utfqname = StringUtil.stringToUTF(this.m_queueName);
            }
            catch (UTFDataFormatException e) {
                if (!this.DEBUG) break block2;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        return utfqname.length + 8 + 8 + 1;
    }

    private int postMgramSize() {
        return 23;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTracker() {
        block20: {
            QueueMsgEvt queueMsgEvt = this;
            synchronized (queueMsgEvt) {
                if (this.m_tracker != null) {
                    return;
                }
                if (!this.m_seqNoSet) {
                    throw new EAssertFailure("Attempted to create queue message tracker without sequence nunber set!");
                }
                try {
                    boolean startSplitting = this.splitBatch();
                    this.m_tracker = new AgentQueueMsgTracker(this.getSeqNo(), this, this.m_needGuarAck, startSplitting);
                }
                catch (EDuplicateKey e) {
                    BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR010") + this.getSeqNo(), (Throwable)e, 2);
                }
            }
            try {
                if (!this.m_needGuarAck || !this.m_msg.isJMSPersistent() || this.m_msg.getBrokerHandle().isTransactionalPublish()) break block20;
                if (this.m_publisher == null) {
                    try {
                        this.m_publisher = AgentRegistrar.getAgentRegistrar().getClient(this.m_orig_sender);
                    }
                    catch (EClientNotRegistered cnr) {
                        this.m_publisher = null;
                        return;
                    }
                }
                if (this.m_publisher.isInterbroker()) {
                    InterbrokerHook.xOnceQMsgReceived(this.m_orig_sender, this.m_orig_tracking, this.m_tracker);
                    if (this.DEBUG) {
                        this.debug("Received xOnce qmsg from Interbroker: " + this.getSeqNo() + " Sender: " + this.m_orig_sender + " origTracking = " + this.m_orig_tracking);
                    }
                } else if (this.m_publisher.isRemoteBroker()) {
                    AgentRegistrar.getAgentRegistrar().getRouterManager().xOnceQMsgReceived(this.m_orig_sender, this.m_orig_tracking, this.m_tracker);
                    if (this.DEBUG) {
                        this.debug("Received xOnce qmsg from RemoteBroker: " + this.getSeqNo() + " Sender: " + this.m_orig_sender + " origTracking = " + this.m_orig_tracking);
                    }
                } else {
                    this.m_publisher.rcvdGuarQMsg(this.m_orig_tracking, this.m_tracker);
                }
            }
            finally {
                this.m_publisher = null;
            }
        }
    }
}

