/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.Config;
import progress.message.broker.EBrokerAborted;
import progress.message.broker.IReplicateableSaverOp;
import progress.message.broker.ISaverPostProcessor;
import progress.message.broker.LogManager;
import progress.message.broker.MgramSerializer;
import progress.message.broker.QMsgSaverOp;
import progress.message.broker.SavableQElement;
import progress.message.broker.StatsManager;
import progress.message.broker.StatsMetrics;
import progress.message.broker.prAccessor;
import progress.message.broker.stats.LMaxStatsObj;
import progress.message.broker.stats.LTotStatsObj;
import progress.message.broker.stats.LValueStatsObj;
import progress.message.client.EUnsupportedMgramException;
import progress.message.db.EDatabaseException;
import progress.message.dbq.IPtpDBQ;
import progress.message.ft.DynamicSyncDBQMsgsTracker;
import progress.message.ft.FTMgramFactory;
import progress.message.ft.ReplicationManager;
import progress.message.msg.IMgram;
import progress.message.util.EAssertFailure;
import progress.message.util.LongHashTable;
import progress.message.util.StreamUtil;
import progress.message.util.server.LongVector;
import progress.message.zclient.DebugThread;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.QueueLimiter;

public class QueueMsgSaver
extends DebugThread {
    private BrokerDatabase m_db;
    private IPtpDBQ m_ptpDBQ;
    private StatsManager m_statsMgr;
    private QueueLimiter m_limiter;
    private LongHashTable m_idsToSaveOpsQueued;
    private LongHashTable m_idsToSaveOpsInProgress;
    private LongHashTable m_idsToAsynchronouslyRetrieveOpsQueued;
    private AsyncRetrievalCache m_asyncCache;
    private LongHashTable m_idsToSaveOpsWaitingForQMSEnqueue;
    private Hashtable m_threadToSaveOpsWaitingForQMSEnqueue;
    private LogManager m_logmgr;
    private ReplicationManager m_replMgr;
    private int m_queueOps;
    private int m_deleteOps;
    private int m_retrievedMem;
    private int m_retrievedDb;
    private int m_cancelledTx;
    private int m_cancelledQueued;
    private volatile boolean m_shutdown = false;
    private Object m_addSyncObj = new Object();
    private Object m_deleteSyncObj = new Object();
    private long m_txSaves;
    private long m_txDeletes;
    private boolean DEBUG1;
    private QMsgSaverOp m_qHead;
    private QMsgSaverOp m_qTail;
    private boolean debugStatsEnabled = false;
    private LTotStatsObj numQueueWaits;
    private LTotStatsObj dbOperations;
    private LTotStatsObj dbBytes;
    private LMaxStatsObj maxCommitSize;
    private LTotStatsObj numCommits;
    private LTotStatsObj totTxMSecs;
    private LTotStatsObj totSelectMSecs;
    private LTotStatsObj numSavesCancelled;

    QueueMsgSaver(AgentRegistrar reg) {
        super("QueueMsgSaver");
        boolean bl = this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        if (this.DEBUG1) {
            this.debug("QueueSize= " + Config.PTP_DB_QUEUE_SIZE);
        }
        this.m_db = reg.getBrokerDatabase();
        this.m_ptpDBQ = this.m_db.getIPtpDBQ();
        this.m_statsMgr = reg.getStatsManager();
        this.m_logmgr = reg.getLogManager();
        this.m_idsToSaveOpsQueued = new LongHashTable();
        this.m_idsToSaveOpsInProgress = new LongHashTable();
        this.m_idsToAsynchronouslyRetrieveOpsQueued = new LongHashTable();
        this.m_asyncCache = new AsyncRetrievalCache();
        this.m_idsToSaveOpsWaitingForQMSEnqueue = new LongHashTable();
        this.m_threadToSaveOpsWaitingForQMSEnqueue = new Hashtable();
        this.m_limiter = new QueueLimiter(Config.PTP_DB_QUEUE_SIZE / 2);
        boolean bl2 = this.debugStatsEnabled = (this.debugFlags & 2) > 0 && StatsMetrics.areStatsEnabled(3);
        if (this.debugStatsEnabled) {
            this.numQueueWaits = new LTotStatsObj(3, "QMsgSaver numWaitingForQ", 2);
            this.m_statsMgr.registerStat(this.numQueueWaits);
            this.numSavesCancelled = new LTotStatsObj(3, "QMsgSaver numSavesCancelled", 1);
            this.m_statsMgr.registerStat(this.numSavesCancelled);
            this.dbOperations = new LTotStatsObj(3, "QMsgSaver numDBSaves/Dels", 1);
            this.dbOperations.outputStatistic("QMsgSaver DB saves/dels per sec", 6);
            this.m_statsMgr.registerStat(this.dbOperations);
            this.dbBytes = new LTotStatsObj(3, "QMsgSaver numDBBytes", 1);
            this.m_statsMgr.registerStat(this.dbBytes);
            this.maxCommitSize = new LMaxStatsObj(3, "QMsgSaver maxCommitSize", 4);
            this.m_statsMgr.registerStat(this.maxCommitSize);
            this.numCommits = new LTotStatsObj(3, "QMsgSaver numCommits", 1);
            this.m_statsMgr.registerStat(this.numCommits);
            this.totTxMSecs = new LTotStatsObj(3, "QMsgSaver Utilization", 8);
            this.m_statsMgr.registerStat(this.totTxMSecs);
            this.totSelectMSecs = new LTotStatsObj(3, "QMsgSaver numSelects", 10);
            this.totSelectMSecs.outputStatistic("QMsgSaver msec per Select", 5);
            this.m_statsMgr.registerStat(this.totSelectMSecs);
        }
        if ((this.debugFlags & 2) > 0 && StatsMetrics.areStatsEnabled(1)) {
            this.m_statsMgr.registerStat(new LValueStatsObj(1, "QueueMsgSaver QSize (Bytes)", 2){

                @Override
                public synchronized long getCurrentValue() {
                    this.update(((QueueMsgSaver)QueueMsgSaver.this).m_limiter.m_size);
                    return super.getCurrentValue();
                }
            });
            this.m_statsMgr.registerStat(new LValueStatsObj(1, "QueueMsgSaver QSize (numOperations)", 2){

                @Override
                public synchronized long getCurrentValue() {
                    this.update(QueueMsgSaver.this.m_queueOps);
                    return super.getCurrentValue();
                }
            });
        }
    }

    public LogManager getLogMgr() {
        return this.m_logmgr;
    }

    synchronized void setMaxAsyncCacheSize(long max) {
        this.m_asyncCache.setMaxCacheSize(max);
    }

    synchronized long getMaxAsyncCacheSize() {
        return this.m_asyncCache.getMaxCacheSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveMsg(String qname, SavableQElement sqe) {
        Object object = this.m_addSyncObj;
        synchronized (object) {
            this.saveMsgInternal(qname, sqe);
        }
    }

    private synchronized void saveMsgInternal(String qname, SavableQElement sqe) {
        IMgram mgram = null;
        try {
            mgram = (IMgram)((IMgram)sqe.getPayload()).protectedClone();
        }
        catch (CloneNotSupportedException ex) {
            // empty catch block
        }
        long tracking = mgram.getGuarenteedTrackingNum();
        if (tracking == 0L) {
            Thread.currentThread();
            Thread.dumpStack();
            throw new EAssertFailure("Saving tracking number " + tracking);
        }
        if (this.DEBUG) {
            this.debug("saveMsg: starting; qname= " + qname + " trackingnumber= " + tracking);
        }
        QMsgSaveOp op = new QMsgSaveOp(qname, mgram, tracking, sqe, true);
        this.enqueueQMS(op);
        this.m_idsToSaveOpsQueued.put(tracking, op);
        if (this.DEBUG) {
            this.debug("saveMsg: trackingnumber= " + tracking + " enqueued save request qSize= " + this.m_queueOps);
        }
    }

    synchronized void saveMsgDeferEnqueue(String qname, SavableQElement sqe) {
        Thread t;
        Vector<QMsgSaveOp> v;
        IMgram mgram = (IMgram)sqe.getPayload();
        long tracking = mgram.getGuarenteedTrackingNum();
        if (tracking == 0L) {
            Thread.currentThread();
            Thread.dumpStack();
            throw new EAssertFailure("saveMsgDeferEnqueue: tracking number " + tracking);
        }
        if (this.DEBUG) {
            this.debug("saveMsgDeferEnqueue: starting; qname= " + qname + " trackingnumber= " + tracking);
        }
        QMsgSaveOp op = new QMsgSaveOp(qname, mgram, tracking, sqe, true, true);
        QMsgSaveOp enq = (QMsgSaveOp)this.m_idsToSaveOpsWaitingForQMSEnqueue.get(tracking);
        if (enq != null) {
            new EAssertFailure("op already enqueued; trk= " + tracking + " thread= " + Thread.currentThread().getName());
        }
        if ((v = (Vector<QMsgSaveOp>)this.m_threadToSaveOpsWaitingForQMSEnqueue.get(t = Thread.currentThread())) == null) {
            v = new Vector<QMsgSaveOp>();
            this.m_threadToSaveOpsWaitingForQMSEnqueue.put(t, v);
        }
        v.addElement(op);
        this.m_idsToSaveOpsWaitingForQMSEnqueue.put(tracking, op);
        if (this.DEBUG) {
            this.debug("saveMsgDeferred: trackingnumber= " + tracking + " registered save request");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveMsg(String qname, IMgram mgram) {
        Object object = this.m_addSyncObj;
        synchronized (object) {
            this.saveMsgInternal(qname, mgram);
        }
    }

    synchronized void saveMsgInternal(String qname, IMgram mgram) {
        long tracking = mgram.getGuarenteedTrackingNum();
        if (tracking == 0L) {
            Thread.currentThread();
            Thread.dumpStack();
            throw new EAssertFailure("Saving tracking number " + tracking);
        }
        if (this.DEBUG) {
            this.debug("saveMsg: starting; qname= " + qname + " trackingnumber= " + tracking);
        }
        QMsgSaveOp op = new QMsgSaveOp(qname, mgram, tracking, null, false);
        this.enqueueQMS(op);
        this.m_idsToSaveOpsQueued.put(tracking, op);
        if (this.DEBUG) {
            this.debug("saveMsg: trackingnumber= " + tracking + " enqueued save request qSize= " + this.m_queueOps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishEnqueues() {
        Vector ops = (Vector)this.m_threadToSaveOpsWaitingForQMSEnqueue.remove(Thread.currentThread());
        if (ops == null) {
            return;
        }
        boolean interrupted = false;
        int enqueued = 0;
        boolean nowait = false;
        while (!ops.isEmpty()) {
            QMsgSaveOp op = (QMsgSaveOp)ops.remove(0);
            if (op.isCancelled()) continue;
            Object object = this.m_addSyncObj;
            synchronized (object) {
                QueueMsgSaver queueMsgSaver = this;
                synchronized (queueMsgSaver) {
                    op.setTracker();
                    this.enqueueQMS(op, nowait);
                    if (Thread.currentThread().isInterrupted()) {
                        nowait = true;
                        interrupted = true;
                    }
                    if (op.isCancelled()) {
                        this.removeQMS(op);
                    } else {
                        ++enqueued;
                        this.m_idsToSaveOpsQueued.put(op.getTracking(), op);
                        this.m_idsToSaveOpsWaitingForQMSEnqueue.remove(op.getTracking());
                    }
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void replicateSave(String qname, IMgram mgram, DynamicSyncDBQMsgsTracker tracker) {
        long tracking = mgram.getGuarenteedTrackingNum();
        tracker.setCurrent(tracking);
        if (tracker.okToReplicate(tracking)) {
            if (tracking == 0L) {
                Thread.currentThread();
                Thread.dumpStack();
                throw new EAssertFailure("Replicating tracking number " + tracking);
            }
            this.enqueueQMS(new QMsgReplicateSaveOp(qname, mgram, tracker));
            if (this.DEBUG) {
                this.debug("replicateSave: tracking = " + tracking + ", enqueued SAVE request qSize= " + this.m_queueOps);
            }
        }
    }

    public synchronized void replicateDelete(QMsgSaverOp op) {
        this.enqueueQMS(new QMsgReplicateDeleteOp((QMsgDeleteOp)op));
        if (this.DEBUG) {
            this.debug("replicateDelete: tracking = " + op.getTracking() + ", enqueued DELETE request qSize= " + this.m_queueOps);
        }
    }

    synchronized boolean cancelSave(long tracking) {
        if (this.DEBUG) {
            this.debug("cancelSave: starting; trackingnumber= " + tracking);
        }
        boolean canceled = false;
        QMsgSaveOp op = (QMsgSaveOp)this.m_idsToSaveOpsWaitingForQMSEnqueue.remove(tracking);
        if (op != null && (canceled = op.cancelSave())) {
            return true;
        }
        op = (QMsgSaveOp)this.m_idsToSaveOpsQueued.remove(tracking);
        if (op != null) {
            this.removeQMS(op);
            if (this.DEBUG) {
                this.debug("cancelSave: trackingnumber= " + tracking + " Canceled save request");
            }
            if (this.debugStatsEnabled) {
                this.numSavesCancelled.add(1L);
            }
            ++this.m_cancelledQueued;
            return true;
        }
        op = (QMsgSaveOp)this.m_idsToSaveOpsInProgress.get(tracking);
        canceled = false;
        if (op != null) {
            canceled = op.cancelSave();
            if (canceled) {
                if (this.DEBUG) {
                    this.debug("cancelSave: trackingnumber= " + tracking + " Canceled saveop in current transaction");
                }
                if (this.debugStatsEnabled) {
                    this.numSavesCancelled.add(1L);
                }
                ++this.m_cancelledTx;
            } else if (this.DEBUG) {
                this.debug("cancelSave: trackingnumber= " + tracking + " Could not cancel save request;");
            }
        }
        return canceled;
    }

    public boolean deleteMsg(long tracking, boolean syncPersist) {
        return this.deleteMsg(null, tracking, syncPersist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteMsg(String qname, long tracking, boolean syncPersist) {
        QMsgSaverOp op;
        Object object = this;
        synchronized (object) {
            boolean canceled;
            this.m_asyncCache.remove(tracking);
            QMsgSaveOp saveop = (QMsgSaveOp)this.m_idsToSaveOpsWaitingForQMSEnqueue.remove(tracking);
            if (saveop != null && (canceled = saveop.cancelSave())) {
                return false;
            }
            op = (QMsgSaverOp)this.m_idsToSaveOpsQueued.remove(tracking);
            if (op != null) {
                this.removeQMS(op);
                if (this.DEBUG) {
                    this.debug("deleteMsg: trackingnumber= " + tracking + " deleted save request from queue");
                }
                return false;
            }
        }
        object = this.m_deleteSyncObj;
        synchronized (object) {
            QueueMsgSaver queueMsgSaver = this;
            synchronized (queueMsgSaver) {
                op = new QMsgDeleteOp(qname, tracking, syncPersist);
                if (syncPersist) {
                    AgentRegistrar.getAgentRegistrar().getDeleteMsgManager().addQueueDelete(tracking);
                }
                this.enqueueQMS(op);
                ++this.m_deleteOps;
            }
        }
        if (this.DEBUG) {
            this.debug("deleteMsg: trackingnumber= " + tracking + " enqueued delete request qSize= " + this.m_queueOps);
        }
        return true;
    }

    public synchronized void deleteMsgs(long from, long to) {
        this.enqueueQMS(new QMsgBatchDeleteOp(from, to));
        if (this.DEBUG) {
            this.debug("deleteMsgs: from = " + from + ", to = " + to);
        }
    }

    public synchronized void dynamicSyncDone(long lastTracking) {
        this.enqueueQMS(new QMsgDynamicSyncCompleteOp(lastTracking));
    }

    public IMgram retrieveMgram(long tracking) {
        return this.retrieveMgram(null, tracking);
    }

    public IMgram retrieveMgram(String queue_name, long tracking) {
        return this.retrieveMgram(queue_name, tracking, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMgram retrieveMgram(String queue_name, long tracking, boolean cancelSave) {
        if (tracking == 0L) {
            Thread.currentThread();
            Thread.dumpStack();
            throw new EAssertFailure("Retrieval request for " + tracking + " on queue " + queue_name);
        }
        IMgram mgram = null;
        if (this.DEBUG) {
            this.debug("retrieveMgram: starting, tracking = " + tracking);
        }
        QueueMsgSaver queueMsgSaver = this;
        synchronized (queueMsgSaver) {
            QMsgAsyncRetrieveOp arop = (QMsgAsyncRetrieveOp)this.m_idsToAsynchronouslyRetrieveOpsQueued.remove(tracking);
            if (arop != null) {
                this.removeQMS(arop);
            }
            if ((mgram = this.m_asyncCache.remove(tracking)) != null) {
                ++this.m_retrievedMem;
                AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(tracking);
                if (tracker != null) {
                    tracker.setReplicateOnly(mgram.isNonPersistentReplicated());
                }
                return mgram;
            }
            String qname = null;
            QMsgSaveOp op = (QMsgSaveOp)this.m_idsToSaveOpsInProgress.get(tracking);
            if (op != null) {
                qname = op.getQueueName();
                mgram = op.getMgram();
                boolean canceled = false;
                if (cancelSave) {
                    canceled = op.cancelSave();
                }
                if (mgram != null && qname != null) {
                    if (this.DEBUG) {
                        this.debug("retrieveMgram: trackingnumber= " + tracking + " retrieved mgram from qmsTransactionQueue");
                    }
                    if (canceled) {
                        mgram.getBrokerHandle().setLocalQueueName(qname);
                    } else {
                        try {
                            IMgram mgClone = (IMgram)mgram.protectedClone();
                            mgClone.getBrokerHandle().setDBSaveRequested(true);
                            mgClone.getBrokerHandle().setLocalQueueName(qname);
                            mgram = mgClone;
                        }
                        catch (CloneNotSupportedException ex) {
                            // empty catch block
                        }
                    }
                    AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(tracking);
                    if (tracker != null) {
                        tracker.setReplicateOnly(mgram.isNonPersistentReplicated());
                    }
                    ++this.m_retrievedMem;
                    return mgram;
                }
            }
            if ((op = (QMsgSaveOp)this.m_idsToSaveOpsQueued.get(tracking)) != null) {
                qname = op.getQueueName();
                mgram = op.getMgram();
                if (mgram != null && qname != null) {
                    if (this.DEBUG) {
                        this.debug("retrieveMgram: trackingnumber= " + tracking + " retrieved mgram from qmsqueue");
                    }
                    if (cancelSave) {
                        this.removeQMS(op);
                        mgram.getBrokerHandle().setLocalQueueName(qname);
                    } else {
                        try {
                            IMgram mgClone = (IMgram)mgram.protectedClone();
                            mgClone.getBrokerHandle().setDBSaveRequested(true);
                            mgClone.getBrokerHandle().setLocalQueueName(qname);
                            mgram = mgClone;
                        }
                        catch (CloneNotSupportedException ex) {
                            // empty catch block
                        }
                    }
                    AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(tracking);
                    if (tracker != null) {
                        tracker.setReplicateOnly(mgram.isNonPersistentReplicated());
                    }
                    ++this.m_retrievedMem;
                    return mgram;
                }
            }
            ++this.m_retrievedDb;
        }
        long start = 0L;
        if (this.debugStatsEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            mgram = queue_name == null ? this.m_ptpDBQ.getQMgram(tracking) : this.m_ptpDBQ.getQMgram(queue_name, tracking);
            if (mgram != null) {
                mgram.getBrokerHandle().setFromDB(true);
                AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(tracking);
                if (tracker != null) {
                    tracker.setReplicateOnly(mgram.isNonPersistentReplicated());
                }
            }
        }
        catch (EDatabaseException e) {
            if (Broker.exiting) {
                Thread.currentThread().interrupt();
            }
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EAssertFailure(e.toString());
        }
        catch (EUnsupportedMgramException e) {
            BrokerComponent.getComponentContext().logMessage(e.toString(), 2);
            return null;
        }
        if (this.debugStatsEnabled) {
            this.totSelectMSecs.add(System.currentTimeMillis() - start);
        }
        if (this.DEBUG) {
            this.debug("retrieveMgram: trackingnumber= " + tracking + " retrieved mgram from db");
        }
        return mgram;
    }

    synchronized boolean retrieveMgramAsync(String queue_name, long tracking) {
        if (tracking == 0L) {
            Thread.currentThread();
            Thread.dumpStack();
            throw new EAssertFailure("Retrieving tracking number " + tracking + " asynchronously for queue " + queue_name);
        }
        IMgram m = this.m_asyncCache.get(tracking);
        if (m != null) {
            return true;
        }
        QMsgAsyncRetrieveOp op = (QMsgAsyncRetrieveOp)this.m_idsToAsynchronouslyRetrieveOpsQueued.get(tracking);
        if (op != null) {
            return true;
        }
        if (this.DEBUG) {
            this.debug("retrieveMgramAsync: request to asynchronously retrieve mgram = " + tracking);
        }
        if (this.hasRoom((op = new QMsgAsyncRetrieveOp(queue_name, tracking)).memsize())) {
            this.enqueueQMS(op);
            this.m_idsToAsynchronouslyRetrieveOpsQueued.put(tracking, op);
            if (this.DEBUG) {
                this.debug("retrieveMgramAsync: enqueued async retrieve request, mgram tracking number = " + tracking + ", qSize= " + this.m_queueOps);
            }
            return true;
        }
        return false;
    }

    synchronized void retrieveMgramsAsync(String queue_name, LongVector vec) {
        if (vec.isEmpty()) {
            return;
        }
        long tracking = 0L;
        int count = vec.size();
        for (int i = 0; i < count; ++i) {
            QMsgAsyncRetrieveOp op;
            tracking = vec.elementAt(i);
            if (tracking == 0L) {
                Thread.currentThread();
                Thread.dumpStack();
                throw new EAssertFailure("Retrieving tracking number " + tracking + " asynchronously");
            }
            IMgram m = this.m_asyncCache.get(tracking);
            if (m != null || (op = (QMsgAsyncRetrieveOp)this.m_idsToAsynchronouslyRetrieveOpsQueued.get(tracking)) != null) continue;
            if (this.DEBUG) {
                this.debug("retrieveMgramsAsync: request to asynchronously retrieve mgram = " + tracking);
            }
            op = new QMsgAsyncRetrieveOp(queue_name, tracking);
            this.enqueueQMS(op);
            this.m_idsToAsynchronouslyRetrieveOpsQueued.put(tracking, op);
            if (!this.DEBUG) continue;
            this.debug("retrieveMgramsAsync: enqueued async retrieve request, mgram tracking number = " + tracking + ", qSize= " + this.m_queueOps);
        }
        vec.removeAllElements();
    }

    private void enqueueQMS(QMsgSaverOp op) throws RuntimeException {
        this.enqueueQMS(op, false);
    }

    private synchronized void enqueueQMS(QMsgSaverOp op, boolean nowait) throws RuntimeException {
        int size = op.memsize();
        if (Thread.currentThread() != this && !nowait) {
            this.waitForQueueSpace(size);
        }
        if (!this.m_shutdown) {
            this.m_limiter.add(size);
            ++this.m_queueOps;
            if (this.m_qTail == null) {
                this.m_qHead = this.m_qTail = op;
            } else {
                this.m_qTail.setNext(op);
                op.setPrev(this.m_qTail);
                this.m_qTail = op;
            }
        } else {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        this.notifyAll();
    }

    public synchronized void enqueue(QMsgSaverOp op) {
        this.enqueueQMS(op);
    }

    private synchronized void removeQMS(QMsgSaverOp op) {
        QMsgSaverOp next = op.getNext();
        QMsgSaverOp prev = op.getPrev();
        if (this.m_qHead == op) {
            this.m_qHead = next;
        } else if (prev != null) {
            prev.setNext(next);
        }
        if (this.m_qTail == op) {
            this.m_qTail = prev;
        } else if (next != null) {
            next.setPrev(prev);
        }
        op.setNext(null);
        op.setPrev(null);
        this.m_limiter.add(-op.memsize());
        --this.m_queueOps;
        this.notifyAll();
    }

    private synchronized QMsgSaverOp getTodoList() throws InterruptedException {
        this.m_idsToSaveOpsInProgress.clear();
        this.notifyAll();
        while (this.m_qHead == null && !Broker.exiting) {
            this.wait();
        }
        if (this.DEBUG) {
            int saves = this.m_idsToSaveOpsQueued.size();
            int size = this.m_limiter.m_size;
            int async = this.m_idsToAsynchronouslyRetrieveOpsQueued.size();
            int waitingEnq = this.m_idsToSaveOpsWaitingForQMSEnqueue.size();
            this.debug("NumOps= " + this.m_queueOps + " saves= " + saves + " deletes= " + this.m_deleteOps + " asyncOps= " + async + " waitingEnq= " + waitingEnq + " cancelledTx= " + this.m_cancelledTx + " cancelledQueued= " + this.m_cancelledQueued + " retrievedMem= " + this.m_retrievedMem + " retrievedDb= " + this.m_retrievedDb + " size= " + size);
        }
        QMsgSaverOp list = this.m_qHead;
        LongHashTable temp = this.m_idsToSaveOpsInProgress;
        this.m_idsToSaveOpsInProgress = this.m_idsToSaveOpsQueued;
        this.m_idsToSaveOpsQueued = temp;
        this.m_qHead = null;
        this.m_qTail = null;
        this.m_limiter.reset();
        this.m_queueOps = 0;
        this.m_deleteOps = 0;
        this.m_retrievedMem = 0;
        this.m_retrievedDb = 0;
        this.m_cancelledTx = 0;
        this.m_cancelledQueued = 0;
        this.m_idsToAsynchronouslyRetrieveOpsQueued.clear();
        this.notifyAll();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws InterruptedException, RuntimeException {
        QMsgFlushOp op;
        QMsgFlushOp qMsgFlushOp = op = new QMsgFlushOp();
        synchronized (qMsgFlushOp) {
            QueueMsgSaver queueMsgSaver = this;
            synchronized (queueMsgSaver) {
                this.enqueueQMS(op);
            }
            if (this.DEBUG) {
                this.debug("flush: Enqueued flush request");
            }
            while (!op.isCompleted() && !this.m_shutdown) {
                op.wait();
            }
            if (this.m_shutdown) {
                throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
            }
            if (this.DEBUG) {
                this.debug("Flush completed");
            }
        }
    }

    private synchronized void waitForQueueSpace(int size) {
        try {
            while (!this.m_limiter.hasRoom(size) && !this.m_shutdown) {
                if (this.debugStatsEnabled) {
                    this.numQueueWaits.add(1L);
                }
                this.wait();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean hasRoom(int size) {
        return this.m_limiter.hasRoom(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void threadMain() throws InterruptedException {
        try {
            if (this.DEBUG) {
                this.debug("starting");
            }
            opList = null;
            bsm = BrokerStateManager.getBrokerStateManager();
            totCycleTime = 0L;
            maxCycleTime = 0L;
            totTxOps = 0L;
            totTxSize = 0L;
            totTxSaves = 0L;
            totTxDeletes = 0L;
            totTxCommits = 0L;
            lastStats = System.currentTimeMillis();
            while (!Broker.exiting && !this.isInterrupted()) {
                opList = null;
                opList = this.getTodoList();
                if (Broker.exiting) {
                    return;
                }
                start = System.currentTimeMillis();
                numTxOps = 0;
                numTxBytes = 0;
                op = opList;
                if (this.DEBUG) {
                    this.debug("Starting transaction " + new Date());
                }
                needRelease = false;
                isActive = bsm.isActive();
                try {
                    this.m_db.beginQueueDBTran();
                    needRelease = true;
                    while (op != null) {
                        opCanceled = false;
                        v0 = opCanceled = op.markProcessedBySaver() == false;
                        if (opCanceled) {
                            op = op.getNext();
                            continue;
                        }
                        if (Config.REPLICATED && op.isReplicateable()) {
                            this.initReplication();
                            this.m_replMgr.replicateSaverOp((IReplicateableSaverOp)op);
                        }
                        op.doit();
                        if (this.CALLBACK) {
                            this.callback("QMsgSaver operation performed", 0, op);
                        }
                        ++numTxOps;
                        numTxBytes += op.memsize();
                        op = op.getNext();
                    }
                    if (Config.REPLICATED && isActive) {
                        this.commitStandby();
                    }
                    this.m_db.commitQueueTran();
                    ++totTxCommits;
                    if (needRelease) {
                        this.m_db.releaseQueueDBTran();
                    }
                    ** GOTO lbl95
                }
                catch (IOException e) {
                    block40: {
                        block39: {
                            if (Broker.exiting) {
                                Thread.currentThread().interrupt();
                            }
                            if (needRelease) {
                                try {
                                    this.m_db.rollbackQueueTran();
                                }
                                catch (EDatabaseException ge) {
                                    if (Broker.exiting) break block39;
                                    if (this.DEBUG) {
                                        this.debug("An sql exception occurred during roll back.");
                                    }
                                    BrokerComponent.getComponentContext().logMessage((Throwable)ge, 2);
                                }
                            }
                        }
                        ge = this;
                        synchronized (ge) {
                            this.m_shutdown = true;
                            this.notifyAll();
                        }
                        if (Broker.exiting) break block40;
                        try {
                            BrokerComponent.getBrokerComponent().abort(prAccessor.getString("ERROR_QMSGSAVER_COMMIT"), e, 1);
                        }
                        catch (EBrokerAborted eba) {
                            if (needRelease) {
                                this.m_db.releaseQueueDBTran();
                            }
                            if (!this.DEBUG) return;
                            this.debug("threadMain: thread Exiting; Broker.exiting= " + Broker.exiting);
                            return;
                        }
                        {
                            catch (Throwable var29_28) {
                                if (!needRelease) throw var29_28;
                                this.m_db.releaseQueueDBTran();
                                throw var29_28;
                            }
                        }
                    }
                    try {
                        if (needRelease) {
                            this.m_db.releaseQueueDBTran();
                        }
lbl95:
                        // 4 sources

                        op = opList;
                        while (op != null && !Broker.exiting) {
                            op.postProcess();
                            nextOp = op.getNext();
                            op.setNext(null);
                            op.setPrev(null);
                            op = nextOp;
                        }
                        if (this.DEBUG) {
                            this.debug("Committed transaction; numOps= " + numTxOps + " " + new Date());
                        }
                        if (this.DEBUG1) {
                            now = System.currentTimeMillis();
                            cyc = now - start;
                            if (cyc > maxCycleTime) {
                                maxCycleTime = cyc;
                            }
                            totTxSize += (long)numTxBytes;
                            totTxOps += (long)numTxOps;
                            totCycleTime += cyc;
                            totTxSaves += this.m_txSaves;
                            this.m_txSaves = 0L;
                            totTxDeletes += this.m_txDeletes;
                            this.m_txDeletes = 0L;
                            if (totTxCommits % 10L == 0L) {
                                this.debug("totTx= " + totTxCommits + " elapsed= " + (System.currentTimeMillis() - lastStats) + " totCycTm= " + totCycleTime + " maxCycTx= " + maxCycleTime + " size=  " + totTxSize + " Ops= " + totTxOps + " Add= " + totTxSaves + " Del= " + totTxDeletes);
                                lastStats = System.currentTimeMillis();
                                totCycleTime = 0L;
                                maxCycleTime = 0L;
                                totTxSize = 0L;
                                totTxOps = 0L;
                                totTxSaves = 0L;
                                totTxDeletes = 0L;
                            }
                        }
                        if (!this.debugStatsEnabled || numTxBytes <= 0) continue;
                        now = System.currentTimeMillis();
                        this.totTxMSecs.add(now - start);
                        this.dbOperations.add(numTxOps);
                        this.dbBytes.add(numTxBytes);
                        this.numCommits.add(1L);
                        this.maxCommitSize.update(numTxOps);
                        this.maxCommitSize.update(0L);
                    }
                    catch (InterruptedException ie) {
                        if (Broker.exiting) return;
                        throw ie;
                    }
                    catch (Throwable var30_29) {
                        throw var30_29;
                        return;
                    }
                }
            }
        }
        finally {
            if (this.DEBUG) {
                this.debug("threadMain: thread Exiting; Broker.exiting= " + Broker.exiting);
            }
        }
    }

    private void commitStandby() throws InterruptedException {
        this.initReplication();
        this.m_replMgr.replicateSaverOp(new QMsgCommitOp(this.m_db.getMaxAddedQueueMessageId()), true);
    }

    private void initReplication() {
        if (this.m_replMgr == null) {
            this.m_replMgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
        }
    }

    public synchronized void exiting() {
        this.notifyAll();
    }

    public QMsgSaverOp buildQMsgSaverOp(byte type, InputStream is) throws IOException, EMgramFormatError {
        QMsgSaverOp result = null;
        switch (type) {
            case 1: 
            case 12: {
                result = new QMsgDeleteOp();
                break;
            }
            case 0: 
            case 11: {
                result = new QMsgSaveOp();
                break;
            }
            case 2: {
                result = new QMsgCommitOp();
            }
        }
        if (result != null) {
            result.readFromStream(is);
        }
        return result;
    }

    final class AsyncRetrievalCache {
        private Vector m_orderedMgrams = new Vector();
        private LongHashTable m_mgrams = new LongHashTable();
        private long m_currentCacheSize = 0L;
        private long m_maxCacheSize = (long)Config.MAX_QMSG_SAVER_ASYNC_CACHE_SIZE < 0x1FFFFFFFFFFFFFL ? (long)(Config.MAX_QMSG_SAVER_ASYNC_CACHE_SIZE * 1024) : Long.MAX_VALUE;

        AsyncRetrievalCache() {
        }

        synchronized void put(long tracking, IMgram m) {
            long sz = m.memoryLength();
            if (this.m_currentCacheSize + sz > this.m_maxCacheSize) {
                this.makeRoom(sz);
            }
            this.m_orderedMgrams.insertElementAt(m, 0);
            this.m_mgrams.put(tracking, m);
            this.m_currentCacheSize += sz;
            if (QueueMsgSaver.this.DEBUG) {
                QueueMsgSaver.this.debug("AsyncRetrievalCache.put: cache size after put = " + this.m_currentCacheSize);
            }
        }

        synchronized IMgram get(long tracking) {
            return (IMgram)this.m_mgrams.get(tracking);
        }

        synchronized IMgram remove(long tracking) {
            IMgram m;
            if (QueueMsgSaver.this.DEBUG) {
                QueueMsgSaver.this.debug("AsyncRetrievalCache.remove: cache size prior to remove = " + this.m_currentCacheSize);
            }
            if ((m = (IMgram)this.m_mgrams.remove(tracking)) != null) {
                this.m_orderedMgrams.removeElement(m);
                this.m_currentCacheSize -= (long)m.memoryLength();
            }
            if (QueueMsgSaver.this.DEBUG) {
                QueueMsgSaver.this.debug("AsyncRetrievalCache.remove: cache size after remove = " + this.m_currentCacheSize);
            }
            return m;
        }

        synchronized void setMaxCacheSize(long sz) {
            this.m_maxCacheSize = Math.abs(sz);
        }

        synchronized long getMaxCacheSize() {
            return this.m_maxCacheSize;
        }

        synchronized long getCurrentCacheSize() {
            return this.m_currentCacheSize;
        }

        synchronized void makeRoom(long sz) {
            if (sz > this.m_maxCacheSize) {
                this.m_orderedMgrams.clear();
                this.m_mgrams.clear();
                this.m_currentCacheSize = 0L;
            } else {
                long freedSpace;
                IMgram m = null;
                long tracking = 0L;
                for (freedSpace = 0L; freedSpace < sz; freedSpace += (long)m.memoryLength()) {
                    if (this.m_orderedMgrams.isEmpty()) {
                        this.m_mgrams.clear();
                        break;
                    }
                    m = (IMgram)this.m_orderedMgrams.lastElement();
                    this.m_orderedMgrams.remove(m);
                    tracking = m.getGuarenteedTrackingNum();
                    this.m_mgrams.remove(tracking);
                    m = null;
                }
                if (QueueMsgSaver.this.DEBUG) {
                    QueueMsgSaver.this.debug("AsyncRetrievalCache.makeRoom: freed space = " + freedSpace);
                }
                this.m_currentCacheSize -= freedSpace;
                if (this.m_currentCacheSize < 0L) {
                    this.m_currentCacheSize = 0L;
                }
            }
        }
    }

    final class QMsgBatchDeleteOp
    extends QMsgSaverOp
    implements ISaverPostProcessor {
        long from = -1L;
        long to = -1L;

        QMsgBatchDeleteOp(long from, long to) {
            this.from = from;
            this.to = to;
            this.setPostProcessor(this);
        }

        @Override
        void doit() throws EDatabaseException {
            int count = QueueMsgSaver.this.m_ptpDBQ.deleteQMsgs(this.from, this.to);
            if (QueueMsgSaver.this.DEBUG) {
                QueueMsgSaver.this.debug("QMsgBatchDeleteOp: deleting " + count + " qmessage(s).");
            }
        }

        @Override
        public boolean isReplicateable() {
            return false;
        }

        @Override
        public void doPostProcessing() {
        }

        public String toString() {
            return "QMsgBatchDeleteOp ";
        }
    }

    final class QMsgFlushOp
    extends QMsgSaverOp
    implements ISaverPostProcessor {
        boolean flushCompleted;

        QMsgFlushOp() {
            this.setPostProcessor(this);
        }

        @Override
        void doit() {
            if (QueueMsgSaver.this.DEBUG) {
                QueueMsgSaver.this.debug("QMsgFlushOp: flush completed");
            }
        }

        @Override
        public boolean isReplicateable() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doPostProcessing() {
            QMsgFlushOp qMsgFlushOp = this;
            synchronized (qMsgFlushOp) {
                this.flushCompleted = true;
                this.notifyAll();
            }
        }

        boolean isCompleted() {
            return this.flushCompleted;
        }

        public String toString() {
            return "QMsgFlushOp ";
        }
    }

    class QMsgAsyncRetrieveOp
    extends QMsgSaverOp
    implements ISaverPostProcessor {
        private String m_qname;
        private long m_tracking;

        QMsgAsyncRetrieveOp(String qname, long tracking) {
            this.m_qname = qname;
            this.m_tracking = tracking;
            this.m_size = Config.PTP_DB_ASYNC_RETRIEVEOP_SIZE;
            this.setPostProcessor(this);
        }

        @Override
        void doit() throws EDatabaseException {
            if (QueueMsgSaver.this.DEBUG) {
                QueueMsgSaver.this.debug("QMsgAsyncRetrieveOp: retrieving qmessage " + this.m_tracking);
            }
            QueueMsgSaver.this.m_idsToAsynchronouslyRetrieveOpsQueued.remove(this.m_tracking);
            IMgram m = null;
            try {
                m = QueueMsgSaver.this.m_ptpDBQ.getQMgramTx(this.m_qname, this.m_tracking);
            }
            catch (EDatabaseException e) {
                if (Broker.exiting) {
                    Thread.currentThread().interrupt();
                }
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                throw new EAssertFailure(e.toString());
            }
            if (m != null) {
                QueueMsgSaver.this.m_asyncCache.put(this.m_tracking, m);
                m.getBrokerHandle().setFromDB(true);
            }
        }

        @Override
        public boolean isReplicateable() {
            return false;
        }

        @Override
        public void doPostProcessing() {
        }

        public String toString() {
            return "QMsgAsyncRetrieveOp " + this.m_tracking;
        }
    }

    class QMsgDeleteOp
    extends QMsgSaverOp
    implements IReplicateableSaverOp,
    ISaverPostProcessor {
        private String m_qname;
        private long m_tracking;
        private boolean m_syncPersist;

        QMsgDeleteOp() {
        }

        QMsgDeleteOp(String qname, long tracking, boolean syncPersist) {
            this.m_qname = qname;
            this.m_tracking = tracking;
            this.m_size = Config.PTP_DB_DELETEOP_SIZE;
            this.m_syncPersist = syncPersist;
            this.setPostProcessor(this);
        }

        @Override
        void doit() throws EDatabaseException {
            if (QueueMsgSaver.this.DEBUG) {
                QueueMsgSaver.this.debug("QMsgDeleteOp: deleting qmessage " + this.m_tracking);
            }
            if (this.m_qname == null) {
                QueueMsgSaver.this.m_ptpDBQ.deleteQMsg(this.m_tracking);
            } else {
                QueueMsgSaver.this.m_ptpDBQ.deleteQMsg(this.m_qname, this.m_tracking);
            }
            ++QueueMsgSaver.this.m_txDeletes;
            IMgram m = QueueMsgSaver.this.m_asyncCache.remove(this.m_tracking);
            if (m != null) {
                m.getBrokerHandle().setFromDB(false);
            }
        }

        @Override
        public long getTracking() {
            return this.m_tracking;
        }

        @Override
        public boolean isReplicateable() {
            return this.m_syncPersist;
        }

        @Override
        public void doPostProcessing() {
            if (this.m_syncPersist) {
                AgentRegistrar.getAgentRegistrar().getDeleteMsgManager().removeQueueDelete(this.m_tracking);
            }
        }

        public String toString() {
            return "QMsgDeleteOp " + this.m_tracking;
        }

        @Override
        public byte getType() {
            return 1;
        }

        @Override
        public void writeToStream(OutputStream os) throws IOException {
            StreamUtil.writeByte((byte)0, os);
            StreamUtil.writeLong(this.m_tracking, os);
        }

        @Override
        public void readFromStream(InputStream is) throws IOException {
            StreamUtil.readByte(is);
            this.m_tracking = StreamUtil.readLong(is);
            this.m_size = Config.PTP_DB_DELETEOP_SIZE;
            this.m_syncPersist = false;
        }

        @Override
        public int length() {
            return 9;
        }
    }

    class QMsgSaveOp
    extends QMsgSaverOp
    implements IReplicateableSaverOp,
    ISaverPostProcessor {
        private String m_qname;
        private SavableQElement m_sqe;
        private long m_tracking;
        private IMgram m_mgram;
        private boolean m_doPostprocess;
        private AgentQueueMsgTracker m_tracker;
        private boolean m_processedBySaver = false;
        private boolean m_canceled = false;

        QMsgSaveOp() {
        }

        protected QMsgSaveOp(String qname, IMgram mgram) {
            this.m_qname = qname;
            this.m_mgram = mgram;
            this.m_tracking = mgram.getGuarenteedTrackingNum();
            this.m_size = this.m_mgram.memoryLength();
            this.m_doPostprocess = true;
            this.m_tracker = null;
            this.m_sqe = null;
        }

        QMsgSaveOp(String qname, IMgram mgram, long tracking, SavableQElement sqe, boolean doPostprocess) {
            this(qname, mgram, tracking, sqe, doPostprocess, false);
        }

        QMsgSaveOp(String qname, IMgram mgram, long tracking, SavableQElement sqe, boolean doPostprocess, boolean noSetTracker) {
            this.m_qname = qname;
            this.m_sqe = sqe;
            this.m_tracking = tracking;
            this.m_mgram = mgram;
            this.m_size = this.m_mgram.memoryLength();
            this.m_doPostprocess = doPostprocess;
            if (!noSetTracker) {
                this.setTracker();
            }
            this.setPostProcessor(this);
        }

        public final void setTracker() {
            if (this.m_tracker == null) {
                this.m_tracker = AgentQueueMsgTracker.getTracker(this.m_tracking);
                if (this.m_tracker != null) {
                    this.m_tracker.prepareSave();
                }
            }
        }

        @Override
        public boolean isReplicateable() {
            return this.m_mgram.isJMSPersistent();
        }

        @Override
        void doit() throws IOException {
            if (QueueMsgSaver.this.DEBUG) {
                QueueMsgSaver.this.debug("QMsgSaveOp: saving qmessage " + this.m_tracking);
            }
            QueueMsgSaver.this.m_db.updateMaxAddedQueueMessageId(this.m_tracking);
            QueueMsgSaver.this.m_ptpDBQ.saveQMsg(this.m_qname, this.m_mgram);
            ++QueueMsgSaver.this.m_txSaves;
        }

        @Override
        public long getTracking() {
            return this.m_tracking;
        }

        String getQueueName() {
            return this.m_qname;
        }

        IMgram getMgram() {
            return this.m_mgram;
        }

        @Override
        public void doPostProcessing() {
            if (this.m_doPostprocess) {
                this.m_mgram.getBrokerHandle().setFromDB(true);
                if (this.m_sqe != null) {
                    this.m_sqe.postProcess();
                }
                if (this.m_tracker != null) {
                    this.m_tracker.saved();
                    if (QueueMsgSaver.this.DEBUG) {
                        QueueMsgSaver.this.debug("Called tracker.saved() for " + this.m_tracking);
                    }
                } else if (this.m_mgram.isJMSPersistent() && QueueMsgSaver.this.DEBUG) {
                    QueueMsgSaver.this.debug("Tracker not found for " + this.m_tracking);
                }
            }
        }

        public String toString() {
            return "QMsgSaveOp " + this.m_tracking;
        }

        @Override
        public byte getType() {
            return 0;
        }

        @Override
        public void writeToStream(OutputStream os) throws IOException {
            StreamUtil.writeByte((byte)0, os);
            StreamUtil.writeLong(this.m_tracking, os);
            StreamUtil.writeUTF(this.m_qname, os);
            MgramSerializer.getMgramSerializer().serialize(os, this.m_mgram, true);
        }

        @Override
        public void readFromStream(InputStream is) throws IOException, EMgramFormatError {
            StreamUtil.readByte(is);
            this.m_tracking = StreamUtil.readLong(is);
            this.m_qname = StreamUtil.readUTF(is);
            this.m_mgram = MgramSerializer.getMgramSerializer().unserialize(is, true);
            this.m_sqe = null;
            this.m_doPostprocess = false;
            this.m_tracker = null;
        }

        @Override
        public int length() {
            return 9 + this.m_qname.length() + this.m_mgram.networkLength();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean markProcessedBySaver() {
            QMsgSaveOp qMsgSaveOp = this;
            synchronized (qMsgSaveOp) {
                if (this.m_canceled) {
                    return false;
                }
                this.m_processedBySaver = true;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cancelSave() {
            QMsgSaveOp qMsgSaveOp = this;
            synchronized (qMsgSaveOp) {
                if (this.m_processedBySaver) {
                    return false;
                }
                this.m_canceled = true;
                this.m_doPostprocess = false;
            }
            return true;
        }

        synchronized boolean isCancelled() {
            return this.m_canceled;
        }
    }

    final class QMsgDynamicSyncCompleteOp
    extends QMsgSaverOp
    implements ISaverPostProcessor {
        private long m_lastTracking;

        QMsgDynamicSyncCompleteOp(long lastTracking) {
            this.setPostProcessor(this);
            this.m_lastTracking = lastTracking;
        }

        @Override
        void doit() throws IOException {
            IMgram m = FTMgramFactory.createQueueDynamicSyncDoneOp(this.m_lastTracking);
            AgentRegistrar.getAgentRegistrar().getReplicationManager().replicateMgram(m);
        }

        @Override
        public void doPostProcessing() {
        }

        @Override
        public boolean isReplicateable() {
            return false;
        }
    }

    final class QMsgReplicateDeleteOp
    extends QMsgDeleteOp
    implements IReplicateableSaverOp,
    ISaverPostProcessor {
        QMsgReplicateDeleteOp(QMsgDeleteOp op) {
            super(null, op.getTracking(), true);
            this.setPostProcessor(this);
        }

        @Override
        void doit() {
            if (QueueMsgSaver.this.DEBUG) {
                QueueMsgSaver.this.debug("QMsgDeleteReplicationOp: replicating qmessage delete " + this.getTracking());
            }
        }

        @Override
        public byte getType() {
            return 12;
        }

        @Override
        public void doPostProcessing() {
        }
    }

    final class QMsgReplicateSaveOp
    extends QMsgSaveOp
    implements IReplicateableSaverOp,
    ISaverPostProcessor {
        DynamicSyncDBQMsgsTracker tracker;

        QMsgReplicateSaveOp(String qname, IMgram mgram, DynamicSyncDBQMsgsTracker tracker) {
            super(qname, mgram);
            this.tracker = tracker;
            this.setPostProcessor(this);
        }

        @Override
        void doit() throws IOException {
            if (QueueMsgSaver.this.DEBUG) {
                QueueMsgSaver.this.debug("QMsgSaveReplicationOp: replicating qmessage " + this.getTracking());
            }
            QueueMsgSaver.this.m_db.updateMaxAddedQueueMessageId(this.getTracking());
            this.tracker.setLastReplicated(this.getTracking());
        }

        @Override
        public byte getType() {
            return 11;
        }

        @Override
        public void doPostProcessing() {
        }
    }

    final class QMsgCommitOp
    extends QMsgSaverOp
    implements IReplicateableSaverOp,
    ISaverPostProcessor {
        private long m_maxMessageId;

        QMsgCommitOp() {
        }

        QMsgCommitOp(long maxMessageId) {
            this.setPostProcessor(this);
            this.m_maxMessageId = maxMessageId;
        }

        @Override
        public boolean isReplicateable() {
            return true;
        }

        @Override
        void doit() throws IOException {
            QueueMsgSaver.this.m_db.updateMaxAddedQueueMessageId(this.m_maxMessageId);
        }

        @Override
        public void doPostProcessing() {
        }

        @Override
        public byte getType() {
            return 2;
        }

        @Override
        public void writeToStream(OutputStream os) throws IOException {
            StreamUtil.writeByte((byte)0, os);
            StreamUtil.writeLong(this.m_maxMessageId, os);
        }

        @Override
        public void readFromStream(InputStream is) throws IOException {
            StreamUtil.readByte(is);
            this.m_maxMessageId = StreamUtil.readLong(is);
        }

        @Override
        public int length() {
            return 9;
        }
    }
}

