/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Message;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;

class ReportSenderBlocked
extends DebugObject
implements IMessageHandler {
    private AgentRegistrar m_reg;

    ReportSenderBlocked(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ReportPublisherBlocked" : null);
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session context, Envelope env) {
        String[] blockingQueues = null;
        try {
            Message msg = env.getMessage();
            ISubject subject = msg.getSubject();
            blockingQueues = new String[msg.readInt()];
            for (int i = 0; i < blockingQueues.length; ++i) {
                blockingQueues[i] = msg.readUTF();
            }
            String senderUid = SessionConfig.getUidFromAdminSubject(subject);
            String senderAppid = SessionConfig.getAppidFromAdminSubject(subject);
            try {
                IClientContext senderCC = this.m_reg.getClient(SessionConfig.stringToClientId(senderUid, senderAppid));
                BrokerManagementNotificationsHelper.sendFlowControlSendPauseNotification(Config.BROKER_NAME, senderCC, SessionConfig.getConnectIDFromSessionAppID(senderAppid), blockingQueues);
            }
            catch (EClientNotRegistered e) {}
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }
}

