/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.IClientContext;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.broker.Subscribe;
import progress.message.util.StreamUtil;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;
import progress.message.zclient.Subject;

public class SubscribeEvt
extends LogEvent {
    public static final byte DURABLE_MOD_NONE = 0;
    public static final byte DURABLE_MOD_ADDED_SUBJECTS = 1;
    public static final byte DURABLE_MOD_REMOVED_SUBJECTS = 2;
    private long m_id;
    private ISubject m_subject;
    private Label m_label;
    private Envelope m_req;
    private boolean m_localSubscribeDone;
    private boolean m_replyDone;
    private int m_errcode;
    private long m_creationTime = -1L;
    private long m_previousBrokerCID = -1L;
    private long m_restoreToBrokerCID = -1L;
    private long m_TTE = -1L;
    private boolean m_enforceDurableStrictMessageOrder = false;
    private boolean m_suppressCWADS = false;
    private int m_flowToDisk = 0;
    private boolean m_suppressNotification = false;
    protected short m_eventType = (short)112;
    private boolean m_usesSubscriptionTable = true;

    public long getTTE() {
        return this.m_TTE;
    }

    public void setTTE(long expiration) {
        this.m_TTE = expiration;
    }

    public void disableUsesSubscpriontTable() {
        this.m_usesSubscriptionTable = false;
    }

    public SubscribeEvt(Envelope req, long id, ISubject subject, Label label) {
        this.m_id = id;
        this.m_subject = subject;
        this.m_label = label;
        this.m_req = req;
        this.m_replyDone = req == null;
        this.setCreationTime(new Date(System.currentTimeMillis()).getTime());
    }

    protected SubscribeEvt(short type) {
        this.m_eventType = type;
        this.setCreationTime(new Date(System.currentTimeMillis()).getTime());
    }

    public long getClientId() {
        return this.m_id;
    }

    public long getCreationTime() {
        return this.m_creationTime;
    }

    public boolean getDurableStrictMessageOrder() {
        return this.m_enforceDurableStrictMessageOrder;
    }

    public int getFlowToDisk() {
        return this.m_flowToDisk;
    }

    public ISubject getSubject() {
        return this.m_subject;
    }

    public String getMessageSelector() {
        return "";
    }

    public byte getDurableModification() {
        return 0;
    }

    public ISubject getAddedSubject() {
        return null;
    }

    public ISubject getRemovedSubject() {
        return null;
    }

    public Label getLabel() {
        return this.m_label;
    }

    public Envelope getRequest() {
        return this.m_req;
    }

    public int getErrorCode() {
        return this.m_errcode;
    }

    public boolean getSuppressNotification() {
        return this.m_suppressNotification;
    }

    public void setSuppressNotification(boolean suppressNotification) {
        this.m_suppressNotification = suppressNotification;
    }

    public boolean getSuppressCWADSPropagation() {
        return this.m_suppressCWADS;
    }

    public void setSuppressCWADSPropagation(boolean suppressCWADS) {
        this.m_suppressCWADS = suppressCWADS;
    }

    void setErrorCode(int errcode) {
        this.m_errcode = errcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void localSubscribeDone() {
        boolean reply = false;
        SubscribeEvt subscribeEvt = this;
        synchronized (subscribeEvt) {
            this.m_localSubscribeDone = true;
            reply = !this.m_replyDone;
            if (reply) {
                this.m_replyDone = true;
            }
        }
        IClientContext cc = null;
        try {
            cc = AgentRegistrar.getAgentRegistrar().getClient(this.m_id);
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
        if (cc != null) {
            if (cc.getProxyingHandle() != null) {
                cc.getProxyingHandle().removeSubscribeEvt(this);
            }
            if (reply && cc.getRemoteNode() == null) {
                Subscribe.sendSuccessReply(this);
            }
        }
    }

    protected boolean getReplyDone() {
        return this.m_replyDone;
    }

    @Override
    protected void onFlush() {
        this.localSubscribeDone();
    }

    @Override
    public short type() {
        return 112;
    }

    @Override
    protected int memSizeBody() {
        SubscribeEvt subscribeEvt = this;
        return 26 + this.m_subject.memoryLength() + subscribeEvt.m_label.length() + 1 + (this.m_req == null ? 0 : this.m_req.length());
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out, false);
    }

    private void writeBody(OutputStream out, boolean tteTTLConvert) throws IOException {
        StreamUtil.writeLong(this.m_id, out);
        this.m_subject.writeToStream(out);
        this.m_label.serialize(out, tteTTLConvert);
        StreamUtil.writeLong(this.m_creationTime, out);
        StreamUtil.writeLong(this.m_previousBrokerCID, out);
        StreamUtil.writeLong(this.m_restoreToBrokerCID, out);
        StreamUtil.writeBoolean(this.m_enforceDurableStrictMessageOrder, out);
        StreamUtil.writeLong(this.m_TTE, out);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os, tteTTLConvert);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = StreamUtil.readLong(in);
        this.m_subject = this.m_eventType <= 107 ? new Subject(StreamUtil.readUTF(in)) : Subject.createFromStream(in);
        this.m_label = Label.unserialize(in, tteTTLConvert);
        if (this.m_eventType >= 59) {
            this.setCreationTime(StreamUtil.readLong(in));
            this.setPreviousBrokerCID(StreamUtil.readLong(in));
            this.setRestoreToBrokerCID(StreamUtil.readLong(in));
        }
        if (this.m_eventType >= 107) {
            this.m_enforceDurableStrictMessageOrder = StreamUtil.readBoolean(in);
            this.m_TTE = StreamUtil.readLong(in);
        } else {
            this.m_enforceDurableStrictMessageOrder = true;
            this.m_TTE = -1L;
        }
        this.m_localSubscribeDone = true;
        this.m_replyDone = true;
        this.setSuppressCWADSPropagation(true);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoSubscribe(this);
    }

    @Override
    public String toString() {
        return super.toString() + "Client " + this.m_id + " Subscribe to " + this.m_subject;
    }

    protected void setClientId(long id) {
        this.m_id = id;
    }

    protected final void setCreationTime(long creationTime) {
        this.m_creationTime = creationTime;
    }

    protected void setDurableStrictMessageOrder(boolean enforceDurableStrictMessageOrder) {
        if (enforceDurableStrictMessageOrder && this.m_subject != null && this.m_subject.hasGroup()) {
            BrokerComponent.getComponentContext().logMessage(this.m_id + " requested a durable subscription to be both part of a group and to have Strict Message Order. " + "  These are not compatible and the Strict Message Order will be ignored. ", 2);
        }
        this.m_enforceDurableStrictMessageOrder = enforceDurableStrictMessageOrder;
    }

    protected void setFlowToDisk(int flowToDisk) {
        this.m_flowToDisk = flowToDisk;
    }

    protected void setPreviousBrokerCID(long pCID) {
        this.m_previousBrokerCID = pCID;
    }

    protected void setRestoreToBrokerCID(long rCID) {
        this.m_restoreToBrokerCID = rCID;
    }

    protected long getPreviousBrokerCID() {
        return this.m_previousBrokerCID;
    }

    protected long getRestoreToBrokerCID() {
        return this.m_restoreToBrokerCID;
    }

    protected void setSubject(ISubject subject) {
        this.m_subject = subject;
    }

    protected void setLabel(Label label) {
        this.m_label = label;
    }

    protected void setLocalSubscriptionDone(boolean flag) {
        this.m_localSubscribeDone = flag;
    }

    protected void setReplyDone(boolean flag) {
        this.m_replyDone = flag;
    }

    @Override
    public boolean usesClientRegistry() {
        return true;
    }

    @Override
    public boolean usesSubscriptionTable() {
        return this.m_usesSubscriptionTable;
    }

    @Override
    public long getClientID() {
        return this.m_id;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        SubscribeEvt subscribeEvt = this;
        return 8 + this.m_subject.getSerializedLength() + subscribeEvt.m_label.length() + 8 + 8 + 8 + 1 + 8;
    }
}

