/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.EOldVirtualClockException;
import progress.message.broker.IClientContext;
import progress.message.broker.Subscribe;
import progress.message.broker.SubscribeEvt;
import progress.message.broker.SubscribeEvtForSelector;
import progress.message.broker.UnsubscribeEvt;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.TokenMgrError;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.EInvalidTTLException;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.util.DebugState;
import progress.message.util.WrappedDataInputStream;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;

final class SubscribeP28
extends DebugObject
implements IMessageHandler {
    private AgentRegistrar m_reg;

    SubscribeP28(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "Subscribe handler" : null);
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        try {
            Message req = env.getMessage();
            long requestor = AddrUtil.getIdFromAdmin(env.getSubject());
            SubscribeEvt evt = null;
            WrappedDataInputStream dis = new WrappedDataInputStream(req);
            try {
                ISubject sub = Subject.createFromStream(dis);
                Label lbl = Label.unserialize(req);
                String selector = req.readUTF();
                boolean isSelectorAtBroker = false;
                boolean enforceCWADSStrictMessageOrder = false;
                int flowToDisk = 0;
                try {
                    flowToDisk = req.readInt();
                }
                catch (IOException e) {
                    flowToDisk = 0;
                }
                byte flag = req.readByte();
                if ((flag & 1) > 0) {
                    isSelectorAtBroker = true;
                }
                if ((flag & 2) > 0) {
                    enforceCWADSStrictMessageOrder = true;
                    if (this.DEBUG) {
                        System.out.println("sub: " + sub + " enforceCWADSStrictMessageOrder: " + enforceCWADSStrictMessageOrder);
                    }
                }
                evt = new SubscribeEvtForSelector(env, requestor, sub, lbl, new String[]{selector}, isSelectorAtBroker);
                evt.setDurableStrictMessageOrder(enforceCWADSStrictMessageOrder);
                evt.setFlowToDisk(flowToDisk);
                if ((flag & 4) > 0) {
                    this.checkDurableUnsubscribe(requestor, (SubscribeEvtForSelector)evt);
                }
                if (this.DEBUG) {
                    System.out.println("sub: " + sub + " flowToDisk: " + flowToDisk);
                }
                if (this.DEBUG) {
                    System.out.println("SubP28: " + sub + " req: " + env.getSubject().getSubjectString());
                }
                this.m_reg.subscribe(evt, true);
            }
            catch (EInvalidSubjectSyntax e) {
                Subscribe.sendReply(env, -1);
            }
            catch (EClientNotRegistered e) {
                Subscribe.sendReply(env, -10);
            }
            catch (ESecurityPolicyViolation e) {
                Subscribe.sendReply(env, evt.getErrorCode());
            }
            catch (EInvalidTTLException ittle) {
                Subscribe.sendReply(env, -24);
            }
            catch (ParseException e) {
                Subscribe.sendReply(env, -22);
            }
            catch (TokenMgrError e) {
                Subscribe.sendReply(env, -22);
            }
            catch (InterruptedException ie) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)ie, 2);
                }
                Subscribe.sendReply(env, -40);
            }
        }
        catch (EInvalidAdminAddress e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            Subscribe.sendReply(env, -40);
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            Subscribe.sendReply(env, -40);
        }
    }

    private final void checkDurableUnsubscribe(long requestor, SubscribeEvtForSelector evt) throws InterruptedException {
        try {
            IClientContext cc = this.m_reg.getClient(requestor);
            if (cc.isDurable()) {
                BrokerSubscription bs = cc.getDurableBrokerSubscription();
                if (bs == null) {
                    return;
                }
                if (!bs.prepareForResubscribe(evt)) {
                    try {
                        this.m_reg.unsubscribe(new UnsubscribeEvt(null, requestor, bs.getSubject()));
                    }
                    catch (EClientNotRegistered e) {
                    }
                    catch (EOldVirtualClockException ovce) {
                        SessionConfig.logMessage("Virtual Clock Error", ovce, SessionConfig.WARNING);
                    }
                }
            }
        }
        catch (EClientNotRegistered ex) {
            return;
        }
    }
}

