/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Date;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EOldVirtualClockException;
import progress.message.broker.ExpirationQueue;
import progress.message.broker.IBrokerSubscription;
import progress.message.broker.UnsubscribeEvt;
import progress.message.client.EUserAlreadyConnected;
import progress.message.zclient.DebugThread;

class SubscriptionExpirator
extends DebugThread {
    private AgentRegistrar m_reg;
    private ExpirationQueue m_expSubs;
    private boolean m_forceExpire;
    private int m_pollingInterval;

    SubscriptionExpirator(AgentRegistrar reg, ExpirationQueue expSubs, int pollingInterval) {
        super("SubscriptionExpirator");
        this.m_pollingInterval = pollingInterval;
        this.m_reg = reg;
        this.m_expSubs = expSubs;
    }

    void startSubscriptionExpirator() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void threadMain() throws InterruptedException {
        if (this.DEBUG) {
            this.debug("SubscriptionExpirator thread started.  m_pollingInterval = " + this.m_pollingInterval + " (millisecs).");
        }
        try {
            while (!Broker.exiting && !this.isInterrupted()) {
                Object cc = null;
                boolean connected = false;
                SubscriptionExpirator subscriptionExpirator = this;
                synchronized (subscriptionExpirator) {
                    if (!this.m_forceExpire) {
                        this.wait(this.m_pollingInterval);
                    }
                }
                long curtime = System.currentTimeMillis();
                while (!Broker.exiting && !this.isInterrupted()) {
                    IBrokerSubscription ibs;
                    ExpirationQueue expirationQueue = this.m_expSubs;
                    synchronized (expirationQueue) {
                        long nextExpTime = this.m_expSubs.getSoonestTime();
                        if (nextExpTime == -1L || nextExpTime > curtime) {
                            break;
                        }
                        ibs = this.m_expSubs.extractSoonest();
                    }
                    try {
                        if (!(ibs instanceof BrokerSubscription)) continue;
                        BrokerSubscription bs = (BrokerSubscription)ibs;
                        if (this.DEBUG) {
                            this.debug(bs + " has expired. Unsubscribing it. bs.getExpiration()=" + new Date(bs.getTTE()) + " time=" + bs.getTTE());
                        }
                        if (bs.getClient().isRemoteNode()) {
                            this.m_reg.getGSManager().onExpire(bs);
                            continue;
                        }
                        UnsubscribeEvt evt = new UnsubscribeEvt(null, bs.getClient().getId(), bs.getSubject());
                        evt.setSuppressCWADSPropagation(true);
                        try {
                            this.m_reg.unsubscribe(evt, true);
                        }
                        catch (EUserAlreadyConnected ex) {}
                    }
                    catch (EClientNotRegistered e) {
                    }
                    catch (EOldVirtualClockException e) {}
                }
                SubscriptionExpirator subscriptionExpirator2 = this;
                synchronized (subscriptionExpirator2) {
                    if (this.m_forceExpire) {
                        this.m_forceExpire = false;
                        this.notifyAll();
                    }
                }
            }
            return;
        }
        catch (InterruptedException ie) {
            if (Broker.exiting) return;
            throw ie;
        }
        finally {
            if (this.DEBUG) {
                this.debug("threadMain: Thread exiting, broker exiting = " + Broker.exiting);
            }
        }
    }

    synchronized void expireNow() throws InterruptedException {
        this.m_forceExpire = true;
        this.notifyAll();
        while (this.m_forceExpire) {
            this.wait();
        }
    }
}

