/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.EUnknownLogEventType;
import progress.message.broker.GuarMsgEvt;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;

public class SyncQueueMsgMoveToTopicEvt
extends LogEvent {
    private long m_oldTracking;
    private GuarMsgEvt m_newGuarEvt;

    SyncQueueMsgMoveToTopicEvt(GuarMsgEvt newGuarEvt, long oldTracking) {
        this.m_newGuarEvt = newGuarEvt;
        if (this.m_newGuarEvt != null) {
            this.setReplicateOnly(this.m_newGuarEvt.isReplicateOnly());
        }
        this.m_oldTracking = oldTracking;
    }

    SyncQueueMsgMoveToTopicEvt() {
    }

    @Override
    public short type() {
        return 186;
    }

    public long getOldTracking() {
        return this.m_oldTracking;
    }

    public GuarMsgEvt getNewGuarEvt() {
        return this.m_newGuarEvt;
    }

    @Override
    public int memSizeBody() {
        return this.baseSize() + 4 + 2 + this.m_newGuarEvt.memsize();
    }

    @Override
    public int streamSizeBody() {
        return this.baseSize() + this.m_newGuarEvt.streamLength();
    }

    @Override
    public int serializedSizeBody() {
        return this.baseSize() + this.m_newGuarEvt.serializedLength();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.baseSize()) {
            throw new ELogEventTooLong(this);
        }
        this.writePreGuarEvt(out);
        this.m_newGuarEvt.write2log(out, maxbytes -= (long)this.baseSize());
    }

    private void writePreGuarEvt(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_oldTracking, os);
    }

    private int baseSize() {
        return 8;
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writePreGuarEvt(os);
        this.m_newGuarEvt.writeToStream(os, tteTTLConvert);
    }

    private void readPreGuarEvt(InputStream in) throws IOException {
        this.m_oldTracking = StreamUtil.readLong(in);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException, EMgramFormatError {
        this.readPreGuarEvt(in);
        LogEvent evt = (LogEvent)LogEvent.readFromStream(in, tteTTLConvert);
        try {
            this.m_newGuarEvt = (GuarMsgEvt)evt;
        }
        catch (ClassCastException e) {
            throw new EUnknownLogEventType(evt.type() + "");
        }
    }

    @Override
    protected void readBodyFromLog(InputStream in) throws IOException, EMgramFormatError {
        this.readPreGuarEvt(in);
        LogEvent evt = LogEvent.readFromLog(in);
        try {
            this.m_newGuarEvt = (GuarMsgEvt)evt;
        }
        catch (ClassCastException e) {
            throw new EUnknownLogEventType(evt.type() + "");
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoSyncQueueMsgMoveToTopic(this);
    }

    @Override
    public String toString() {
        return super.toString() + "SyncQueueMsgMoveToTopic " + " newTrk= " + this.m_newGuarEvt.getSeqNo() + " " + this.m_newGuarEvt.getMessage().getSubject() + " oldtrk= " + this.m_oldTracking;
    }
}

