/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.Transaction;
import progress.message.broker.TxMsg;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;

class TxMsgQueue
extends TxMsg {
    IClientContext m_publisher;
    AgentQueueMsgTracker m_tracker;

    TxMsgQueue(IClientContext publisher, int tid, IMgram m) {
        super(tid, publisher.getId(), publisher, m);
        this.m_publisher = publisher;
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("TxMsgQueue " + tid);
        }
    }

    TxMsgQueue(long id, int tid, IMgram m) {
        super(tid, id, null, m);
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("TxMsgQueue " + tid);
        }
    }

    void addDeliveryInfo(AgentQueueMsgTracker trk) {
        if (this.DEBUG) {
            this.debug("Added delivery info for message " + trk);
        }
        this.m_tracker = trk;
    }

    @Override
    void deliverMsg(int seq, boolean retry, Transaction txn) throws InterruptedException {
        if (this.DEBUG) {
            this.debug("Delivering committed queue message; " + this.getMsg().getGuarenteedTrackingNum() + " seq=" + seq + " retry= " + retry);
        }
        this.getMsg().getBrokerHandle().setTxnPublishFromLog(true);
        this.prepareForDelivery(this.getMsg(), seq, retry);
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        if (this.m_publisher == null) {
            try {
                this.m_publisher = reg.getClient(txn.getOwner());
            }
            catch (EClientNotRegistered e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        if (this.m_tracker != null) {
            this.m_tracker.setNonTransacted();
        }
        reg.getQueueProc().newMgram(this.getMsg(), this.m_publisher, true, true);
    }

    @Override
    void cancelMsg() throws InterruptedException {
        if (this.DEBUG) {
            this.debug("Canceling " + this.getMsg().getGuarenteedTrackingNum() + " tracker " + this.m_tracker);
        }
        if (this.m_tracker != null) {
            this.m_tracker.canceled(false);
        }
    }
}

