/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.durable.CWADSPingReplyOp;
import progress.message.broker.durable.ESubscriptionNotFound;
import progress.message.broker.durable.IDurableOperation;
import progress.message.broker.durable.IDurableReplyQueue;
import progress.message.client.EUserAlreadyConnected;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;
import progress.message.zclient.SessionConfig;

public class CWADSPingOp
implements IDurableOperation {
    private IDurableReplyQueue m_replyQueue;
    private long m_clientId;
    private long m_preemptingRootClientId = -1L;
    private static final byte CURRENT_VERSION = 0;
    private static int m_errorCode = -1;

    CWADSPingOp(IDurableReplyQueue replyQueue, long ccid, long preemptingRootClientId) {
        this.m_replyQueue = replyQueue;
        this.m_clientId = ccid;
        this.m_preemptingRootClientId = preemptingRootClientId;
    }

    public CWADSPingOp(IDurableReplyQueue replyQueue, IMgram mg) {
        this.m_replyQueue = replyQueue;
        IOperationHandle iopHandle = mg.getOperationHandle();
        if (iopHandle.getOperationType() != 15) {
            throw new EAssertFailure("Invalid Operation type!");
        }
        try {
            ObjectInput dinput = mg.getPayloadInputStreamHandle();
            dinput.readByte();
            this.m_clientId = dinput.readLong();
            this.m_preemptingRootClientId = dinput.readLong();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doit(BrokerDatabase db_not_used_here) throws IOException {
        CWADSPingReplyOp result = null;
        IClientContext cc = null;
        BrokerSubscription bs = null;
        try {
            cc = AgentRegistrar.getAgentRegistrar().getClient(this.m_clientId);
        }
        catch (EClientNotRegistered ecnr) {
            result = new CWADSPingReplyOp();
            result.setErrorCode(4);
            this.m_replyQueue.enqueue(result);
            return;
        }
        cc.lock();
        boolean locked = true;
        try {
            while (cc.isConnected()) {
                if (cc.isResumable()) {
                    try {
                        IClientContext rootCC;
                        long rootId = cc.getRootId();
                        if (rootId != this.m_preemptingRootClientId && !AgentRegistrar.getAgentRegistrar().isInternalAppid(rootId) || (rootCC = AgentRegistrar.getAgentRegistrar().getClient(rootId)).getAppid().startsWith(SessionConfig.TMP_APPID_PREFIX)) break;
                        cc.unlock();
                        locked = false;
                        rootCC.lock();
                        boolean errorPreemptingRoot = false;
                        if (rootCC.isConnected()) {
                            try {
                                AgentRegistrar.getAgentRegistrar();
                                AgentRegistrar.attemptToPreempt(rootCC, rootId);
                            }
                            catch (EUserAlreadyConnected ex1) {
                                errorPreemptingRoot = true;
                            }
                            catch (InterruptedException ex1) {
                                errorPreemptingRoot = true;
                                Thread.currentThread().interrupt();
                            }
                        } else {
                            rootCC.unlock();
                        }
                        cc.lock();
                        locked = true;
                        if (errorPreemptingRoot) {
                            break;
                        }
                    }
                    catch (EClientNotRegistered ecnr) {
                        // empty catch block
                    }
                }
                if (!cc.isConnected() || cc.getCWADSActiveBroker() == null || cc.getCWADSActiveBroker().getId() != cc.getId()) break;
                try {
                    locked = false;
                    AgentRegistrar.getAgentRegistrar();
                    AgentRegistrar.attemptToPreempt(cc, this.m_preemptingRootClientId);
                }
                catch (EUserAlreadyConnected ex) {
                    break;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    cc.lock();
                    locked = true;
                }
            }
            try {
                bs = cc.getDurableBrokerSubscription();
                result = new CWADSPingReplyOp(true, cc, bs);
                this.m_replyQueue.enqueue(result);
            }
            catch (ESubscriptionNotFound esnf) {
                result = new CWADSPingReplyOp();
                result.setErrorCode(4);
                this.m_replyQueue.enqueue(result);
                if (locked) {
                    cc.unlock();
                }
                return;
            }
        }
        finally {
            if (locked) {
                cc.unlock();
            }
        }
    }

    @Override
    public void postProcess() {
    }

    public static IMgram makeMgram(long ccid, long preemptingRootClientId) {
        IMgram result = MgramFactory.getMgramFactory().buildOperationMgram(15);
        try {
            ObjectOutput doutput = result.getPayloadOutputStreamHandle();
            doutput.writeByte(0);
            doutput.writeLong(ccid);
            doutput.writeLong(preemptingRootClientId);
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        result.setPriority((byte)12);
        return result;
    }

    public int getErrorCode() {
        return m_errorCode;
    }

    @Override
    public boolean isReplicateable() {
        return false;
    }
}

