/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import progress.message.broker.durable.DurableHeaderInfo;
import progress.message.broker.durable.IDurableHeaderInfo;
import progress.message.msg.IMgram;

public abstract class DurableInfoDelegator {
    private DurableHeaderInfo m_info;
    private String m_brokerName;
    private boolean m_hasInfo;

    public final void setReplyInformation(IMgram m, long clientId) {
        if (this.m_info == null) {
            this.m_info = new DurableHeaderInfo();
        }
        this.m_info.setReplyInformation(m, clientId);
        this.m_hasInfo = true;
    }

    public final IDurableHeaderInfo getReplyInformation() {
        if (this.m_hasInfo) {
            this.m_info.setBrokerName(this.getOriginationBroker());
            return this.m_info;
        }
        return null;
    }

    public final void setBrokerName(String brokerName) {
        this.m_brokerName = brokerName;
    }

    public final String getOriginationBroker() {
        return this.m_brokerName;
    }

    public final void serializeInfo(DataOutput doutput) throws IOException {
        doutput.writeUTF(this.m_brokerName);
        doutput.writeBoolean(this.m_hasInfo);
        if (this.m_hasInfo) {
            this.m_info.serialize(doutput);
        }
    }

    public final void unserializeInfo(DataInput dinput) throws IOException {
        this.m_brokerName = dinput.readUTF();
        this.m_hasInfo = dinput.readBoolean();
        if (this.m_hasInfo) {
            this.m_info = new DurableHeaderInfo();
            this.m_info.unserialize(dinput);
        }
    }

    protected boolean hasInfo() {
        return this.m_hasInfo;
    }
}

