/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.ClientAckEvt;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.IReplicateableSaverOp;
import progress.message.broker.durable.DurableRemoveReplyOp;
import progress.message.broker.durable.IDurableOperation;
import progress.message.broker.durable.IDurableReplyQueue;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;
import progress.message.util.StreamUtil;

public class DurableRemoveOp
implements IDurableOperation,
IReplicateableSaverOp {
    private IDurableReplyQueue m_replyQueue;
    private String m_jmsID;
    private long m_clientId;
    private int m_deleteCount;
    private int m_size;
    private DurableRemoveReplyOp m_result;
    private long m_messageId = -1L;
    private boolean m_isReplicated = false;
    private static final byte CURRENT_VERSION = 0;

    public DurableRemoveOp() {
    }

    public DurableRemoveOp(IDurableReplyQueue queue, long clientId, String JMSMessageID) {
        this.m_replyQueue = queue;
        this.m_jmsID = JMSMessageID;
        this.m_clientId = clientId;
    }

    public DurableRemoveOp(IDurableReplyQueue queue, IMgram mg) {
        this.m_replyQueue = queue;
        IOperationHandle iopHandle = mg.getOperationHandle();
        if (iopHandle.getOperationType() != 10) {
            throw new EAssertFailure("Invalid Operation type!");
        }
        try {
            ObjectInput dinput = mg.getPayloadInputStreamHandle();
            dinput.readByte();
            this.m_jmsID = dinput.readUTF();
            this.m_clientId = dinput.readLong();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public void doit(BrokerDatabase db) throws IOException {
        boolean delCount = false;
        BrokerDatabase.MgramInfo messageInfo = null;
        IClientContext cc = null;
        if (!this.m_isReplicated) {
            block6: {
                try {
                    cc = AgentRegistrar.getAgentRegistrar().getClient(this.m_clientId);
                    if (cc.isDisconnected() && !cc.isDisconnecting()) {
                        messageInfo = db.getMgramInfoFromJMSMessageIDtx(this.m_jmsID);
                        if (messageInfo != null) {
                            this.m_messageId = messageInfo.m_messageId;
                            this.m_size = messageInfo.m_size;
                            this.m_deleteCount = db.delMsg(this.m_clientId, this.m_messageId, this.m_size);
                        }
                        break block6;
                    }
                    this.m_result = new DurableRemoveReplyOp(false);
                    this.m_result.setErrorCode(2);
                    return;
                }
                catch (EClientNotRegistered e) {
                    this.m_result = new DurableRemoveReplyOp(false);
                    this.m_result.setErrorCode(4);
                    return;
                }
            }
            this.m_result = this.m_deleteCount > 0 ? new DurableRemoveReplyOp(true) : new DurableRemoveReplyOp(false);
        } else {
            this.m_deleteCount = db.delMsg(this.m_clientId, this.m_messageId, this.m_size);
        }
    }

    @Override
    public void postProcess() throws InterruptedException {
        if (this.m_deleteCount > 0) {
            ClientAckEvt replyEvt = new ClientAckEvt(this.m_clientId, this.m_messageId, null, false);
            AgentRegistrar.getAgentRegistrar().getLogManager().addEvent(replyEvt, true);
            AgentRegistrar.getAgentRegistrar().getLogManager().waitForFlush(replyEvt);
        }
        this.m_replyQueue.enqueue(this.m_result);
    }

    public static IMgram getMgram(String jmsID, long clientId) {
        IMgram result = MgramFactory.getMgramFactory().buildOperationMgram(10);
        try {
            ObjectOutput doutput = result.getPayloadOutputStreamHandle();
            doutput.writeByte(0);
            doutput.writeUTF(jmsID);
            doutput.writeLong(clientId);
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return result;
    }

    @Override
    public boolean isReplicateable() {
        return true;
    }

    @Override
    public boolean replicatePostDoit() {
        return true;
    }

    @Override
    public byte getType() {
        return 10;
    }

    @Override
    public int length() {
        return 1 + (this.m_jmsID != null ? this.m_jmsID.length() : 0) + 8 + 8 + 4;
    }

    @Override
    public int memsize() {
        return 8 + (this.m_jmsID != null ? this.m_jmsID.length() : 0) + 8 + 4 + 4 + 8 + 1 + 4;
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        StreamUtil.writeByte((byte)0, os);
        StreamUtil.writeUTF(this.m_jmsID, os);
        StreamUtil.writeLong(this.m_clientId, os);
        StreamUtil.writeLong(this.m_messageId, os);
        StreamUtil.writeInt(this.m_size, os);
    }

    @Override
    public void readFromStream(InputStream is) throws IOException {
        StreamUtil.readByte(is);
        this.m_jmsID = StreamUtil.readUTF(is);
        this.m_clientId = StreamUtil.readLong(is);
        this.m_messageId = StreamUtil.readLong(is);
        this.m_size = StreamUtil.readInt(is);
        this.m_isReplicated = true;
    }

    @Override
    public long getTracking() {
        return this.m_messageId;
    }
}

