/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.fc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentListener;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.IFlowController;
import progress.message.zclient.ISubject;
import progress.message.zclient.SessionConfig;

public abstract class FCEvent {
    private static final byte PUBSUB_MASK = 1;
    private static final byte PTP_MASK = 2;
    private static String BLOCKING_TYPE_PUBSUB = "PUBSUB";
    private static String BLOCKING_TYPE_PTP = "PTP";
    public String[] destinations;
    public int priority;
    public String blockedRoutingNode;
    public String blockedBroker;
    public String blockedUser;
    public String blockedConnectId;
    public String blockedPendingQueue;
    public String receivingBroker;
    public String blockingRoutingNode;
    public String[] blockingDurableSubscriptionNames;
    public String[] blockingDurableUsers;
    public String[] blockingDurableConnectIds;
    public String[] blockingDurableClientIds;
    public String[] blockingNondurableUsers;
    public String[] blockingNondurableConnectIds;
    public String[] blockingNondurableTopics;
    protected boolean isResumedEvt;
    protected short m_version;
    private byte contentTypeBits;
    protected IClientContext receiverSideCC;
    protected long m_receiverSideCid;

    public FCEvent(boolean resumed, short version) {
        this.isResumedEvt = resumed;
        this.m_version = version;
    }

    public FCEvent(boolean resumed) {
        this.isResumedEvt = resumed;
    }

    public void addQueueBlockedData(String[] dest) {
        this.contentTypeBits = (byte)(this.contentTypeBits | 2);
        this.destinations = dest;
    }

    public void addQueueResumedData(String dest) {
        this.contentTypeBits = (byte)(this.contentTypeBits | 2);
        this.destinations = new String[1];
        this.destinations[0] = dest;
    }

    public void addTopicBlockedData(int prio) {
        this.contentTypeBits = (byte)(this.contentTypeBits | 1);
        this.priority = prio;
    }

    public void addTopicResumedData(int prio) {
        this.contentTypeBits = (byte)(this.contentTypeBits | 1);
        this.priority = prio;
    }

    void initDurableData(int size) {
        this.blockingDurableSubscriptionNames = new String[size];
        this.blockingDurableUsers = new String[size];
        this.blockingDurableConnectIds = new String[size];
        this.blockingDurableClientIds = new String[size];
    }

    void initNondurableData(int size) {
        this.blockingNondurableUsers = new String[size];
        this.blockingNondurableConnectIds = new String[size];
        this.blockingNondurableTopics = new String[size];
    }

    void initDestData(int size) {
        this.destinations = new String[size];
    }

    void addBlockingCCData() throws EClientNotRegistered {
        IClientContext client = AgentRegistrar.getAgentRegistrar().getClient(this.m_receiverSideCid);
        this.addBlockingCCData(client);
    }

    void addBlockingCCData(IClientContext receivingSideCC) throws EClientNotRegistered {
        IFlowController ifc;
        IClientContext cc;
        int i;
        Iterator it;
        ArrayList nondurCCs = new ArrayList();
        ArrayList durCCs = new ArrayList();
        if (this.hasPubSubData()) {
            receivingSideCC.getPublishLimiter().addBlockingSubscribers(this.priority, durCCs, nondurCCs);
        }
        int size = durCCs.size();
        this.initDurableData(size);
        if (!durCCs.isEmpty()) {
            it = durCCs.iterator();
            i = 0;
            while (it.hasNext()) {
                AgentListener listener;
                AgentConnection con;
                cc = (IClientContext)it.next();
                this.blockingDurableUsers[i] = cc.getUid();
                String cid = SessionConfig.getDurableJMSClientIDFromAppid(cc.getAppid());
                if (cid == null) {
                    cid = "";
                }
                this.blockingDurableClientIds[i] = cid;
                this.blockingDurableSubscriptionNames[i] = SessionConfig.getDurableSubNameFromAppid(cc.getAppid());
                String connid = "";
                if (cc.isConnected() && (con = cc.getConnection()) != null && (listener = con.getAgentListener()) != null && (connid = listener.getChan0Appid()) != null && connid.endsWith("$CONNECTION$")) {
                    connid = connid.substring(0, connid.lastIndexOf("$CONNECTION$"));
                }
                this.blockingDurableConnectIds[i] = connid;
                ++i;
            }
        }
        size = nondurCCs.size();
        this.initNondurableData(size);
        if (!nondurCCs.isEmpty()) {
            it = nondurCCs.iterator();
            i = 0;
            while (it.hasNext()) {
                cc = (IClientContext)it.next();
                this.blockingNondurableUsers[i] = cc.getUid();
                String connid = cc.getAppid();
                try {
                    if (!cc.isInterbroker()) {
                        connid = SessionConfig.getConnectIDFromSubscriberAppid(connid);
                    }
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
                this.blockingNondurableConnectIds[i] = connid;
                Enumeration subscribedSubjects = cc.getSubscriptions().keys();
                StringBuilder buf = new StringBuilder();
                boolean firstSubject = true;
                while (subscribedSubjects.hasMoreElements()) {
                    ISubject subject = (ISubject)subscribedSubjects.nextElement();
                    if (subject.isAnySystem() && !subject.isTemporary()) continue;
                    if (firstSubject) {
                        firstSubject = false;
                    } else {
                        buf.append(',');
                    }
                    buf.append(subject.getSubjectString());
                }
                this.blockingNondurableTopics[i] = buf.toString();
                ++i;
            }
        }
        if (this.hasPtpData() && (ifc = receivingSideCC.getFlowController()) != null) {
            ArrayList ccdests = new ArrayList();
            ifc.addBlockingDestinations(ccdests);
            if (!ccdests.isEmpty()) {
                this.destinations = new String[ccdests.size()];
                Iterator it2 = ccdests.iterator();
                int i2 = 0;
                while (it2.hasNext()) {
                    this.destinations[i2++] = (String)it2.next();
                }
            }
        }
    }

    public String[] getContentTypes() {
        int size = 0;
        if (this.hasPtpData()) {
            ++size;
        }
        if (this.hasPubSubData()) {
            ++size;
        }
        String[] result = new String[size];
        int i = 0;
        if (this.hasPtpData()) {
            result[i++] = BLOCKING_TYPE_PTP;
        }
        if (this.hasPubSubData()) {
            result[i++] = BLOCKING_TYPE_PUBSUB;
        }
        return result;
    }

    public abstract void writeCommonData(DataOutput var1) throws IOException;

    public abstract void readCommonData(DataInput var1) throws IOException;

    public boolean hasPtpData() {
        return (this.contentTypeBits & 2) != 0;
    }

    public boolean hasPubSubData() {
        return (this.contentTypeBits & 1) != 0;
    }

    public void writeEventData(DataOutput out) throws IOException {
        out.writeShort(this.m_version);
        this.writeCommonData(out);
        if (!this.isResumedEvt) {
            this.writeBlockedData(out);
        } else {
            this.writeResumedData(out);
        }
    }

    protected void writeBlockedData(DataOutput out) throws IOException {
        if ((this.contentTypeBits & 2) != 0) {
            out.writeBoolean(true);
            this.writeQueueBlockedData(out);
        } else {
            out.writeBoolean(false);
        }
        if ((this.contentTypeBits & 1) != 0) {
            out.writeBoolean(true);
            this.writeTopicBlockedData(out);
        } else {
            out.writeBoolean(false);
        }
    }

    protected void writeResumedData(DataOutput out) throws IOException {
        if ((this.contentTypeBits & 2) != 0) {
            out.writeBoolean(true);
            this.writeQueueResumedData(out);
        } else {
            out.writeBoolean(false);
        }
        if ((this.contentTypeBits & 1) != 0) {
            out.writeBoolean(true);
            this.writeTopicResumedData(out);
        } else {
            out.writeBoolean(false);
        }
    }

    protected void writeTopicBlockedData(DataOutput out) throws IOException {
        out.writeByte((byte)this.priority);
    }

    protected void writeQueueBlockedData(DataOutput out) throws IOException {
        out.writeInt(this.destinations.length);
        for (int i = 0; i < this.destinations.length; ++i) {
            String dest = this.destinations[i];
            if (dest.startsWith("$Q.")) {
                out.writeUTF(dest.substring("$Q.".length()));
                continue;
            }
            out.writeUTF(dest);
        }
    }

    protected void writeTopicResumedData(DataOutput out) throws IOException {
        out.writeByte((byte)this.priority);
    }

    protected void writeQueueResumedData(DataOutput out) throws IOException {
        String dest = this.destinations[0];
        if (dest.startsWith("$Q.")) {
            out.writeUTF(dest.substring("$Q.".length()));
        } else {
            out.writeUTF(dest);
        }
    }

    public void readEventData(DataInput in) throws IOException {
        this.m_version = in.readShort();
        this.readCommonData(in);
        if (!this.isResumedEvt) {
            this.readBlockedData(in);
        } else {
            this.readResumedData(in);
        }
    }

    protected void readBlockedData(DataInput in) throws IOException {
        boolean hasPtp = in.readBoolean();
        if (hasPtp) {
            this.readQueueBlockedData(in);
        } else {
            this.initDestData(0);
        }
        boolean hasPubSub = in.readBoolean();
        if (hasPubSub) {
            this.readTopicBlockedData(in);
        } else {
            this.initDurableData(0);
            this.initNondurableData(0);
        }
    }

    protected void readQueueBlockedData(DataInput in) throws IOException {
        String[] blockingDests = new String[in.readInt()];
        for (int i = 0; i < blockingDests.length; ++i) {
            blockingDests[i] = in.readUTF();
        }
        this.destinations = blockingDests;
        this.contentTypeBits = (byte)(this.contentTypeBits | 2);
    }

    protected void readTopicBlockedData(DataInput in) throws IOException {
        this.priority = in.readByte();
        this.contentTypeBits = (byte)(this.contentTypeBits | 1);
    }

    protected void readResumedData(DataInput in) throws IOException {
        boolean hasPtp = in.readBoolean();
        if (hasPtp) {
            this.readQueueResumedData(in);
        } else {
            this.initDestData(1);
            this.destinations[0] = "";
        }
        boolean hasPubSub = in.readBoolean();
        if (hasPubSub) {
            this.readTopicResumedData(in);
        }
    }

    protected void readQueueResumedData(DataInput in) throws IOException {
        String[] blockingDests = new String[]{in.readUTF()};
        this.destinations = blockingDests;
        this.contentTypeBits = (byte)(this.contentTypeBits | 2);
    }

    protected void readTopicResumedData(DataInput in) throws IOException {
        this.priority = in.readByte();
        this.contentTypeBits = (byte)(this.contentTypeBits | 1);
    }
}

