/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.MergedBrokerSubscription;
import progress.message.broker.SubscriptionsTable;
import progress.message.broker.UnsubscribeEvt;
import progress.message.broker.gs.GSManager;
import progress.message.broker.gs.GSTransport;
import progress.message.msg.IMgram;
import progress.message.util.LongHashTable;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;

class GSAdminDeleteHandler
extends DebugObject
implements IMessageHandler {
    private AgentRegistrar m_reg;
    private GSTransport m_transport;
    private GSManager m_manager;

    GSAdminDeleteHandler(AgentRegistrar reg, GSManager manager, GSTransport transport) {
        super("GSAdminDeleteHandler");
        this.m_reg = reg;
        this.m_manager = manager;
        this.m_transport = transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Session s, Envelope env) {
        block36: {
            block34: {
                String rn;
                int reason;
                String originBroker;
                block35: {
                    if (!BrokerStateManager.getBrokerStateManager().isActive()) {
                        return;
                    }
                    IClientContext cc = null;
                    try {
                        IMgram mgram = env.getMgram();
                        ObjectInput in = mgram.getPayloadInputStreamHandle();
                        in.readByte();
                        originBroker = in.readUTF();
                        reason = in.readInt();
                        rn = in.readUTF();
                        if (this.DEBUG) {
                            this.debug("Received AdminDelete:node=" + rn + " reason=" + reason + " from broker=" + originBroker);
                        }
                        IClientContext remoteNodeCC = null;
                        long remoteNodeClientID = this.m_reg.getRouterManager().getRemoteNodeGSClientID(rn);
                        try {
                            remoteNodeCC = this.m_reg.getClient(remoteNodeClientID);
                        }
                        catch (EClientNotRegistered ex) {
                            if (this.DEBUG) {
                                this.debug("CC for remote node " + rn + " not found");
                            }
                            if (cc != null) {
                                cc.unlock();
                            }
                            return;
                        }
                        SubscriptionsTable nodeSubs = remoteNodeCC.getSubscriptions();
                        Hashtable nodeShallowClone = null;
                        SubscriptionsTable subscriptionsTable = nodeSubs;
                        synchronized (subscriptionsTable) {
                            nodeShallowClone = (Hashtable)nodeSubs.clone();
                        }
                        Enumeration nodeEnum = nodeShallowClone.elements();
                        while (nodeEnum.hasMoreElements()) {
                            BrokerSubscription nbs = (BrokerSubscription)nodeEnum.nextElement();
                            if (!(nbs instanceof MergedBrokerSubscription)) continue;
                            MergedBrokerSubscription mbs = (MergedBrokerSubscription)nbs;
                            LongHashTable subs = mbs.getContributors();
                            LongHashTable shallowClone = null;
                            LongHashTable longHashTable = subs;
                            synchronized (longHashTable) {
                                shallowClone = (LongHashTable)subs.clone();
                            }
                            Enumeration entries = shallowClone.elements();
                            while (entries.hasMoreElements()) {
                                BrokerSubscription bs = (BrokerSubscription)entries.nextElement();
                                try {
                                    if (this.checkDebugFlags(64)) {
                                        if (reason == 0) {
                                            this.debug("handleMessage: Deleting subscription for node=" + rn + " from broker=" + originBroker + " topic= " + bs.getSubject());
                                        } else {
                                            this.debug("handleMessage: Deleting expired subscription for node=" + rn + " from broker=" + originBroker + " topic= " + bs.getSubject());
                                        }
                                    }
                                    this.m_reg.unsubscribe(new UnsubscribeEvt(null, bs.getClientId(), bs.getSubject(), null));
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    if (cc != null) {
                                        cc.unlock();
                                    }
                                    return;
                                }
                                catch (IOException ioe) {
                                    SessionConfig.logMessage(ioe, SessionConfig.getLevelWarning());
                                }
                            }
                        }
                        if (this.m_manager.locateGSTracker(rn) != null) break block34;
                        if (!this.DEBUG) break block35;
                    }
                    catch (IOException ioe) {
                        SessionConfig.logMessage(ioe, SessionConfig.getLevelWarning());
                        break block36;
                    }
                    finally {
                        if (cc != null) {
                            cc.unlock();
                        }
                    }
                    this.debug("Notifying the cleanup thread");
                }
                this.m_reg.getQueueProc().getCleanupThread().notifyRemoteSubscriptionDeletion(rn);
                if (originBroker.equals(Config.BROKER_NAME)) {
                    if (this.DEBUG) {
                        this.debug("Sending management notification");
                    }
                    if (reason == 0) {
                        BrokerManagementNotificationsHelper.sendRemoteSubscriptionsDeletedNotification(rn, Config.ROUTING_NODE_NAME);
                    } else {
                        BrokerManagementNotificationsHelper.sendRemoteSubscriptionsExpiredNotification(rn, Config.ROUTING_NODE_NAME);
                    }
                }
            }
            if (this.DEBUG) {
                this.debug("Delete was successful");
            }
        }
    }
}

