/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.MergedBrokerSubscription;
import progress.message.gr.RouterManager;
import progress.message.msg.IMgram;
import progress.message.zclient.DebugObject;

class GSTracker
extends DebugObject {
    private BrokerSubscription m_subscription;
    private String m_remoteNodeName;
    private String m_clientId;
    private long m_messageCount;
    private long m_messageSize;
    private long m_messageMatchCount;
    private long m_messageMatchSize;
    private Hashtable m_children;

    GSTracker(String remoteNodeName) {
        super("GSTracker");
        this.m_remoteNodeName = remoteNodeName;
        this.m_clientId = RouterManager.getRemoteNodeGSAppID(remoteNodeName);
        this.m_subscription = null;
        this.m_messageCount = 0L;
        this.m_messageSize = 0L;
        this.m_messageMatchCount = 0L;
        this.m_messageMatchSize = 0L;
        this.m_children = new Hashtable();
    }

    GSTracker(String remoteNodeName, MergedBrokerSubscription subscription) {
        super("GSTracker");
        this.m_remoteNodeName = remoteNodeName;
        this.m_subscription = subscription;
        this.m_messageCount = 0L;
        this.m_messageSize = 0L;
        this.m_messageMatchCount = 0L;
        this.m_messageMatchSize = 0L;
        this.m_children = new Hashtable();
    }

    synchronized void messageAdded(IMgram mg) {
        ++this.m_messageCount;
        this.m_messageSize += (long)mg.serializedLength();
        if (this.DEBUG) {
            this.debug("Message added for tracker (" + this.m_remoteNodeName + ", " + (this.m_subscription == null ? null : this.m_subscription.getTopic()) + "), Count:" + this.m_messageCount + ", Size:" + this.m_messageSize);
        }
    }

    synchronized void messageRemoved(IMgram mg) {
        --this.m_messageCount;
        this.m_messageSize -= (long)mg.serializedLength();
        if (this.DEBUG) {
            this.debug("Message removed for tracker (" + this.m_remoteNodeName + ", " + (this.m_subscription == null ? null : this.m_subscription.getTopic()) + "), Count:" + this.m_messageCount + ", Size:" + this.m_messageSize);
        }
    }

    long getMessageCount() {
        return this.m_messageCount;
    }

    long getMessageSize() {
        return this.m_messageSize;
    }

    synchronized void reset() {
        this.m_messageCount = 0L;
        this.m_messageSize = 0L;
    }

    synchronized void messageMatched(IMgram mg) {
        ++this.m_messageMatchCount;
        this.m_messageMatchSize += (long)mg.serializedLength();
        if (this.DEBUG) {
            this.debug("Message matched for tracker (" + this.m_remoteNodeName + ", " + (this.m_subscription == null ? null : this.m_subscription.getTopic()) + "), Count:" + this.m_messageMatchCount + ", Size:" + this.m_messageMatchSize);
        }
    }

    long getMessageMatchCount() {
        return this.m_messageMatchCount;
    }

    long getMessageMatchSize() {
        return this.m_messageMatchSize;
    }

    synchronized void resetMatchStats() {
        this.m_messageMatchCount = 0L;
        this.m_messageMatchSize = 0L;
    }

    String getRemoteNodeName() {
        return this.m_remoteNodeName;
    }

    String getClientId() {
        if (this.m_subscription == null) {
            return this.m_clientId;
        }
        return this.m_subscription.getClient().getAppid();
    }

    String getTopic() {
        if (this.m_subscription == null) {
            return null;
        }
        return this.m_subscription.getTopic();
    }

    String[] getSelectors() {
        if (this.m_subscription == null) {
            return null;
        }
        return this.m_subscription.getSelectorStrings();
    }

    boolean getSelectorAtBroker() {
        if (this.m_subscription == null) {
            return false;
        }
        return this.m_subscription.getSelectorAtBroker();
    }

    synchronized void addChild(String topic, GSTracker t) {
        this.m_children.put(topic, t);
    }

    synchronized void removeChild(String topic) {
        this.m_children.remove(topic);
    }

    GSTracker getChild(String topic) {
        return (GSTracker)this.m_children.get(topic);
    }

    boolean hasChildren() {
        return this.m_children.size() > 0;
    }

    Enumeration getChildren() {
        return this.m_children.elements();
    }
}

