/*
 * Decompiled with CFR 0.152.
 */
package progress.message.db.pse;

import com.odi.Database;
import com.odi.DatabaseRootNotFoundException;
import com.odi.Placement;
import com.odi.Session;
import com.odi.util.OSTreeSet;
import java.io.File;
import java.util.Properties;
import java.util.Vector;
import progress.message.db.DBVersionInfo;
import progress.message.db.Db;
import progress.message.db.EDatabaseException;
import progress.message.db.prAccessor;
import progress.message.db.pse.PSEDbContext;
import progress.message.db.pse.util.OpContext;
import progress.message.db.pse.util.OpExec;
import progress.message.dbsc.pse.pc.reg.PSEBrokerDBVer;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class PSEUtil {
    public static String buildDirName(String baseDir, String subdir) {
        return baseDir + File.separator + subdir;
    }

    static Session createSession(String str) {
        Properties props = new Properties();
        props.setProperty("com.odi.disableCrossTransactionCaching", "false");
        props.setProperty("com.odi.queryDebugLevel", "0");
        props.setProperty("com.odi.stringPoolSize", "0");
        Session sess = Session.create(null, (Properties)props, (String)str);
        return sess;
    }

    public static void createNewDbSubDir(String dir, String subdir) throws EDatabaseException {
        String dirname = dir + File.separator + subdir;
        try {
            File f = new File(dir);
            if (!f.exists()) {
                throw new EDatabaseException("can't create subdir; parent directory does not exist " + dir);
            }
            f = new File(dirname);
            boolean created = false;
            if (!f.exists() && !(created = f.mkdir())) {
                throw new EDatabaseException("Can't create directory " + dirname);
            }
        }
        catch (SecurityException ex) {
            throw new EDatabaseException("Can't create directory " + dirname + " " + ex.toString(), ex);
        }
    }

    public static void deleteDbSubDir(String dir, String subdir) throws EDatabaseException {
        String dirname = dir + File.separator + subdir;
        try {
            File f = new File(dir);
            if (!f.exists()) {
                return;
            }
            f = new File(dirname);
            if (f.exists()) {
                f.delete();
            }
        }
        catch (SecurityException ex) {
            throw new EDatabaseException("Can't delete directory " + dirname + " " + ex.toString(), ex);
        }
    }

    public static boolean existsPSEDbFile(String dir, String subdir, String fname) {
        String fullname = dir + File.separator + subdir + File.separator + fname + ".odb";
        File f = new File(fullname);
        return f.exists();
    }

    public static void createRootTreeSet(PSEDbContext ctx, String name, Class classname, String primarykeyAccessor) throws EDatabaseException {
        OpExec op = new OpExec(){

            @Override
            public Object doit(Database db, Vector parms) throws EDatabaseException {
                String nm = (String)parms.elementAt(0);
                Class classnm = (Class)parms.elementAt(1);
                String pkAccessor = (String)parms.elementAt(2);
                OSTreeSet tset = null;
                tset = pkAccessor == null ? new OSTreeSet((Placement)db) : new OSTreeSet((Placement)db, classnm, pkAccessor);
                db.createRoot(nm, (Object)tset);
                return null;
            }
        };
        Vector<Object> parms = new Vector<Object>();
        parms.addElement(name);
        parms.addElement(classname);
        parms.addElement(primarykeyAccessor);
        op.exec(new OpContext(2, ctx), parms);
    }

    public static void createIndex(PSEDbContext ctx, String name, Class classname, String accessor, boolean ordered, boolean dups) throws EDatabaseException {
        OpExec op = new OpExec(){

            @Override
            public Object doit(Database db, Vector parms) throws EDatabaseException {
                String nm = (String)parms.elementAt(0);
                Class classnm = (Class)parms.elementAt(1);
                String accessor = (String)parms.elementAt(2);
                Boolean ordered = (Boolean)parms.elementAt(3);
                Boolean dups = (Boolean)parms.elementAt(4);
                OSTreeSet tset = (OSTreeSet)db.getRoot(nm);
                tset.addIndex(classnm, accessor, ordered.booleanValue(), dups.booleanValue());
                return null;
            }
        };
        Vector<Object> parms = new Vector<Object>();
        parms.addElement(name);
        parms.addElement(classname);
        parms.addElement(accessor);
        parms.addElement(new Boolean(ordered));
        parms.addElement(new Boolean(dups));
        op.exec(new OpContext(2, ctx), parms);
    }

    public static void createRoot(PSEDbContext ctx, String name, Object obj) throws EDatabaseException {
        OpExec op = new OpExec(){

            @Override
            public Object doit(Database db, Vector parms) throws EDatabaseException {
                String nm = (String)parms.elementAt(0);
                String rootobj = (String)parms.elementAt(1);
                db.createRoot(nm, (Object)rootobj);
                return null;
            }
        };
        Vector<Object> parms = new Vector<Object>();
        parms.addElement(name);
        parms.addElement(obj);
        op.exec(new OpContext(2, ctx), parms);
    }

    public static boolean existsRoot(PSEDbContext ctx, String name) throws EDatabaseException {
        OpExec op = new OpExec(){

            @Override
            public Object doit(Database db, Vector parms) throws EDatabaseException {
                Boolean result = new Boolean(false);
                try {
                    String nm = (String)parms.elementAt(0);
                    Object root = db.getRoot(nm);
                    result = new Boolean(true);
                }
                catch (DatabaseRootNotFoundException ex) {
                    // empty catch block
                }
                return result;
            }
        };
        Vector<String> parms = new Vector<String>();
        parms.addElement(name);
        Boolean res = (Boolean)op.exec(new OpContext(2, ctx), parms);
        return res;
    }

    public static String getStringRoot(PSEDbContext ctx, String name) throws EDatabaseException {
        if (DebugState.GLOBAL_DEBUG_ON) {
            DebugObject.class_debug("PSEUtil", "getStringRoot: rootname= " + name);
        }
        OpExec op = new OpExec(){

            @Override
            public Object doit(Database db, Vector parms) throws EDatabaseException {
                String result = null;
                try {
                    String nm = (String)parms.elementAt(0);
                    Object root = db.getRoot(nm);
                    if (root != null) {
                        result = new String((String)root);
                    }
                }
                catch (DatabaseRootNotFoundException ex) {
                    // empty catch block
                }
                return result;
            }
        };
        Vector<String> parms = new Vector<String>();
        parms.addElement(name);
        String res = (String)op.exec(new OpContext(1, 2, ctx), parms);
        return res;
    }

    public static DBVersionInfo getDBVersionInfo(PSEDbContext ctx, String rootname) throws EDatabaseException {
        if (DebugState.GLOBAL_DEBUG_ON) {
            DebugObject.class_debug("PSEUtil", "getDBVersionInfo: rootname= " + rootname);
        }
        OpExec op = new OpExec(){

            @Override
            public Object doit(Database db, Vector parms) throws EDatabaseException {
                PSEBrokerDBVer vers = null;
                DBVersionInfo versObj = new DBVersionInfo();
                versObj.m_version_in_database = prAccessor.getString("NONE");
                try {
                    vers = (PSEBrokerDBVer)db.getRoot((String)parms.elementAt(0));
                    if (vers != null) {
                        versObj.m_abs_tables_version_in_database = vers.getAbsDBVersion();
                        versObj.m_build_number_in_database = vers.getBuildNumber();
                        versObj.m_release_name_in_database = vers.getReleaseName();
                        versObj.m_major_version_in_database = vers.getMajorVersion();
                        versObj.m_minor_version_in_database = vers.getMinorVersion();
                        versObj.m_rel_tables_version_in_database = vers.getRelDBVersion();
                        versObj.m_version_in_database = Db.buildDbVersionString(versObj.m_release_name_in_database, versObj.m_build_number_in_database);
                        if (DebugState.GLOBAL_DEBUG_ON) {
                            DebugObject.class_debug("PSEUtil", "getDBVersionInfo: version_in_database= " + versObj.m_version_in_database);
                        }
                    }
                }
                catch (DatabaseRootNotFoundException ex) {
                    // empty catch block
                }
                return versObj;
            }
        };
        Vector<String> parms = new Vector<String>();
        parms.addElement(rootname);
        Object res = op.exec(new OpContext(1, 2, ctx), parms);
        return (DBVersionInfo)res;
    }

    public static void setDBVersionInfo(PSEDbContext ctx, String rootname, DBVersionInfo vers) throws EDatabaseException {
        if (DebugState.GLOBAL_DEBUG_ON) {
            DebugObject.class_debug("PSEUtil", "setDBVersionInfo: rootname= " + rootname);
        }
        OpExec op = new OpExec(){

            @Override
            public Object doit(Database db, Vector parms) throws EDatabaseException {
                String rootnm = (String)parms.elementAt(0);
                PSEBrokerDBVer brokerver = (PSEBrokerDBVer)db.getRoot(rootnm);
                DBVersionInfo vers = (DBVersionInfo)parms.elementAt(1);
                boolean created = false;
                if (brokerver == null) {
                    brokerver = new PSEBrokerDBVer();
                    created = true;
                    if (DebugState.GLOBAL_DEBUG_ON) {
                        DebugObject.class_debug("PSEUtil", "setDBVersionInfo: creating new PSEBrokerDBVer");
                    }
                }
                brokerver.setMajorVersion(vers.m_major_version_in_database);
                brokerver.setMinorVersion(vers.m_minor_version_in_database);
                brokerver.setRelDBVersion(vers.m_rel_tables_version_in_database);
                brokerver.setAbsDBVersion(vers.m_abs_tables_version_in_database);
                brokerver.setBuildNumber(vers.m_build_number_in_database);
                brokerver.setReleaseName(vers.m_release_name_in_database);
                if (created) {
                    db.setRoot(rootnm, (Object)brokerver);
                }
                return null;
            }
        };
        Vector<Object> parms = new Vector<Object>();
        parms.addElement(rootname);
        parms.addElement(vers);
        Object res = op.exec(new OpContext(2, ctx), parms);
    }
}

