/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbq.pse;

import com.odi.util.OSTreeSet;
import java.util.Iterator;
import progress.message.db.EDatabaseException;
import progress.message.dbsc.pse.pc.pubsub.IPSEClientUndelMsgs;
import progress.message.dbsc.pse.pc.pubsub.IPSEUndelMsg;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.server.EpochClock;
import progress.message.zclient.DebugObject;

public class MsgRestoreQueries
extends DebugObject {
    private boolean DEBUG1;

    public MsgRestoreQueries() {
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("MsgRestoreQueries ");
        }
        this.DEBUG1 = (this.debugFlags & 0x40) > 0;
    }

    void initQueries() throws EDatabaseException {
    }

    Iterator getRestoreIterator(IPSEClientUndelMsgs cmsgs, long tracking, long seq, boolean includeExpiration) {
        Iterator ri = null;
        OSTreeSet ts = cmsgs.getAllUndel();
        if (tracking < 0L) {
            if (includeExpiration) {
                if (this.DEBUG) {
                    this.debug("Using query m_QgetUndelClientMsgs");
                }
                ri = new GetUndelClientMsgs(ts, EpochClock.getTime());
            } else {
                if (this.DEBUG) {
                    this.debug("Using query m_QgetUndelClientMsgsNoExp");
                }
                ri = ts.iterator();
            }
        } else if (includeExpiration) {
            if (seq >= 0L) {
                if (this.DEBUG) {
                    this.debug("Using query m_QgetUndelClientMsgsGTTrkOrGTSeq");
                }
                ri = new GetUndelClientMsgsGTTrkOrGTSeq(ts, tracking, seq, EpochClock.getTime());
            } else {
                if (this.DEBUG) {
                    this.debug("Using query m_QgetUndelClientMsgsGTTrk");
                }
                ri = new GetUndelClientMsgsGTTrk(ts, tracking, EpochClock.getTime());
            }
        } else if (seq >= 0L) {
            if (this.DEBUG) {
                this.debug("Using query m_QgetUndelClientMsgsGTTrkOrGTSeqNoExp");
            }
            ri = new GetUndelClientMsgsGTTrkOrGTSeqNoExp(ts, tracking, seq);
        } else {
            if (this.DEBUG) {
                this.debug("Using query m_QgetUndelClientMsgsGTTrkNoExp");
            }
            ri = new GetUndelClientMsgsGTTrkNoExp(ts, tracking);
        }
        return ri;
    }

    Iterator getRestoreIteratorForSMODurable(IPSEClientUndelMsgs cmsgs, boolean remoteMsgsOnly, long localMsgTracking, long localMsgSeq, long remoteMsgTracking, long remoteMsgSeq) {
        RestoreIterator ri = null;
        OSTreeSet ts = cmsgs.getAllUndel();
        long client_id = cmsgs.getClientId();
        if (remoteMsgsOnly) {
            if (remoteMsgTracking < 0L) {
                if (this.DEBUG) {
                    this.debug("buildRestoreQueryForSMODurable SMO Query 1 client_id: " + client_id + " using remote only query with no previous position");
                }
                ri = new GetUndelClientRemoteMsgsforSMODurable(ts, EpochClock.getTime());
            } else if (remoteMsgSeq < 0L) {
                if (this.DEBUG) {
                    this.debug("buildRestoreQueryForSMODurable Query 2 client_id: " + client_id + " using remote only query with previous position remoteMsgTracking: " + remoteMsgTracking + " remoteMsgSeq: " + remoteMsgSeq);
                }
                ri = new GetUndelClientRemoteMsgsGTTrkforSMODurable(ts, remoteMsgTracking, EpochClock.getTime());
            } else {
                if (this.DEBUG) {
                    this.debug("buildRestoreQueryForSMODurable Query 3 client_id: " + client_id + " using remote only query with previous position remoteMsgTracking: " + remoteMsgTracking + " remoteMsgSeq: " + remoteMsgSeq);
                }
                ri = new GetUndelClientRemoteMsgsGTTrkOrGTSeqforSMODurable(ts, remoteMsgTracking, remoteMsgSeq, EpochClock.getTime());
            }
        } else if (localMsgTracking < 0L && remoteMsgTracking < 0L) {
            if (this.DEBUG) {
                this.debug("buildRestoreQueryForSMODurable Using NON-SMO Query 1  client_id: " + client_id + " using remote and local query with no previous remote or local position ");
            }
            if (this.DEBUG) {
                this.debug("Using query m_QgetUndelClientMsgs");
            }
            ri = new GetUndelClientMsgs(ts, EpochClock.getTime());
        } else {
            if (localMsgTracking < 0L) {
                if (remoteMsgSeq < 0L) {
                    throw new EAssertFailure("remoteMsgTracking != null and remoteMsgSeq == null cannot occur if localMsgTracking == null");
                }
                if (this.DEBUG) {
                    this.debug("buildRestoreQueryForSMODurable SMO Query 4 client_id: " + client_id + " using remote and local query with no previous local position. remoteMsgTracking: " + remoteMsgTracking + " remoteMsgSeq: " + remoteMsgSeq);
                }
                ri = new GetUndelClientRemoteGTTrkOrGTSeqLocalMsgsforSMODurable(ts, remoteMsgTracking, remoteMsgSeq, EpochClock.getTime());
                return ri;
            }
            if (remoteMsgTracking < 0L) {
                if (localMsgSeq < 0L) {
                    throw new EAssertFailure("localMsgTracking != null and localMsgSeq == null cannot occur if remoteMsgTracking == null");
                }
                if (this.DEBUG) {
                    this.debug("buildRestoreQueryForSMODurable SMO Query 5 client_id: " + client_id + " using remote and local query with no previous remote position. localMsgTracking: " + localMsgTracking + " localMsgSeq: " + localMsgSeq);
                }
                ri = new GetUndelClientRemoteLocalGTTrkOrGTSeqMsgsforSMODurable(ts, localMsgTracking, localMsgSeq, EpochClock.getTime());
            } else if (localMsgSeq < 0L && remoteMsgSeq < 0L) {
                if (this.DEBUG) {
                    this.debug("buildRestoreQueryForSMODurable using NON-SMO Query 3 client_id: " + client_id + " using remote and local query with localMsgTracking: " + localMsgTracking + " localMsgSeq: " + localMsgSeq + " remoteMsgTracking: " + remoteMsgTracking + " remoteMsgSeq: " + remoteMsgSeq);
                }
                ri = new GetUndelClientMsgsGTTrk(ts, localMsgTracking, EpochClock.getTime());
            } else if (localMsgSeq < 0L) {
                if (this.DEBUG) {
                    this.debug("buildRestoreQueryForSMODurable using SMO Query 4a client_id: " + client_id + " using remote and local query with localMsgTracking: " + localMsgTracking + " localMsgSeq: " + localMsgSeq + " remoteMsgTracking: " + remoteMsgTracking + " remoteMsgSeq: " + remoteMsgSeq);
                }
                ri = new GetUndelClientRemoteGTTrkOrGTSeqLocalGTTrkMsgsforSMODurable(ts, remoteMsgTracking, remoteMsgSeq, localMsgTracking, EpochClock.getTime());
            } else if (remoteMsgSeq < 0L) {
                if (this.DEBUG) {
                    this.debug("buildRestoreQueryForSMODurable SMO Query 5a client_id: " + client_id + " using remote and local query with localMsgTracking: " + localMsgTracking + " localMsgSeq: " + localMsgSeq + " remoteMsgTracking: " + remoteMsgTracking + " remoteMsgSeq: " + remoteMsgSeq);
                }
                ri = new GetUndelClientRemoteGTTrkLocalGTTrkOrGTSeqMsgsforSMODurable(ts, remoteMsgTracking, localMsgTracking, localMsgSeq, EpochClock.getTime());
            } else {
                if (this.DEBUG) {
                    this.debug("buildRestoreQueryForSMODurable SMO Query 6 client_id: " + client_id + " using remote and local query with localMsgTracking: " + localMsgTracking + " localMsgSeq: " + localMsgSeq + " remoteMsgTracking: " + remoteMsgTracking + " remoteMsgSeq: " + remoteMsgSeq);
                }
                ri = new GetUndelClientRemoteGTTrkOrGTSeqLocalGTTrkOrGTSeqMsgsforSMODurable(ts, remoteMsgTracking, remoteMsgSeq, localMsgTracking, localMsgSeq, EpochClock.getTime());
            }
        }
        return ri;
    }

    class GetUndelClientMsgsGTTrkAndLTEqTrkNoExp
    extends RestoreIterator {
        long _mid1;
        long _mid2;

        GetUndelClientMsgsGTTrkAndLTEqTrkNoExp(OSTreeSet ts, long mid1, long mid2) {
            super(ts, new Long(mid1 + 1L), true);
            this._mid1 = mid1;
            this._mid2 = mid2;
        }

        @Override
        boolean satisfiesQuery(Object obj) {
            IPSEUndelMsg undel = (IPSEUndelMsg)obj;
            return undel.getMessageId() <= this._mid2;
        }
    }

    class GetUndelClientMsgsGTTrkOrGTSeqNoExp
    extends RestoreIterator {
        long _mid;
        long _seq;

        GetUndelClientMsgsGTTrkOrGTSeqNoExp(OSTreeSet ts, long mid, long seq) {
            super(ts);
            this._mid = mid;
            this._seq = seq;
        }

        @Override
        boolean satisfiesQuery(Object obj) {
            IPSEUndelMsg undel = (IPSEUndelMsg)obj;
            return undel.getMessageId() > this._mid || undel.getSequenceNumber() > this._seq;
        }
    }

    class GetUndelClientMsgsGTTrkNoExp
    extends RestoreIterator {
        long _mid;

        GetUndelClientMsgsGTTrkNoExp(OSTreeSet ts, long mid) {
            super(ts, new Long(mid + 1L));
            this._mid = mid;
        }

        @Override
        boolean satisfiesQuery(Object obj) {
            return true;
        }
    }

    class GetUndelClientMsgsGTTrk
    extends RestoreIterator {
        long _mid;
        long _exp;

        GetUndelClientMsgsGTTrk(OSTreeSet ts, long mid, long exp) {
            super(ts, new Long(mid + 1L));
            this._mid = mid;
            this._exp = exp;
        }

        @Override
        boolean satisfiesQuery(Object obj) {
            IPSEUndelMsg undel = (IPSEUndelMsg)obj;
            return !undel.isExpired(this._exp);
        }
    }

    class GetUndelClientMsgsGTTrkOrGTSeq
    extends RestoreIterator {
        long _mid;
        long _seq;
        long _exp;

        GetUndelClientMsgsGTTrkOrGTSeq(OSTreeSet ts, long mid, long seq, long exp) {
            super(ts);
            this._mid = mid;
            this._seq = seq;
            this._exp = exp;
        }

        @Override
        boolean satisfiesQuery(Object obj) {
            IPSEUndelMsg undel = (IPSEUndelMsg)obj;
            return (undel.getMessageId() > this._mid || undel.getSequenceNumber() > this._seq) && !undel.isExpired(this._exp);
        }
    }

    class GetUndelClientMsgs
    extends RestoreIterator {
        long _exp;

        GetUndelClientMsgs(OSTreeSet ts, long exp) {
            super(ts);
            this._exp = exp;
        }

        @Override
        boolean satisfiesQuery(Object obj) {
            IPSEUndelMsg undel = (IPSEUndelMsg)obj;
            return !undel.isExpired(this._exp);
        }
    }

    class GetUndelClientRemoteGTTrkOrGTSeqLocalGTTrkOrGTSeqMsgsforSMODurable
    extends RestoreIterator {
        long _Rmid;
        long _Rseq;
        long _Lmid;
        long _Lseq;
        long _exp;

        GetUndelClientRemoteGTTrkOrGTSeqLocalGTTrkOrGTSeqMsgsforSMODurable(OSTreeSet ts, long rmid, long rseq, long lmid, long lseq, long exp) {
            super(ts);
            this._Rmid = rmid;
            this._Rseq = rseq;
            this._Lmid = lmid;
            this._Lseq = lseq;
            this._exp = exp;
        }

        @Override
        boolean satisfiesQuery(Object obj) {
            IPSEUndelMsg undel = (IPSEUndelMsg)obj;
            if (undel.isExpired(this._exp)) {
                return false;
            }
            if (undel.getFromRemoteBroker() && (undel.getMessageId() > this._Rmid || undel.getSequenceNumber() > this._Rseq)) {
                return true;
            }
            return !undel.getFromRemoteBroker() && (undel.getMessageId() > this._Lmid || undel.getSequenceNumber() > this._Lseq);
        }
    }

    class GetUndelClientRemoteGTTrkLocalGTTrkOrGTSeqMsgsforSMODurable
    extends RestoreIterator {
        long _Rmid;
        long _Lmid;
        long _Lseq;
        long _exp;

        GetUndelClientRemoteGTTrkLocalGTTrkOrGTSeqMsgsforSMODurable(OSTreeSet ts, long rmid, long lmid, long lseq, long exp) {
            super(ts);
            this._Rmid = rmid;
            this._Lmid = lmid;
            this._Lseq = lseq;
            this._exp = exp;
        }

        @Override
        boolean satisfiesQuery(Object obj) {
            IPSEUndelMsg undel = (IPSEUndelMsg)obj;
            if (undel.getFromRemoteBroker() && undel.getMessageId() > this._Rmid) {
                return !undel.isExpired(this._exp);
            }
            if (!(undel.getFromRemoteBroker() || undel.getMessageId() <= this._Lmid && undel.getSequenceNumber() <= this._Lseq)) {
                return !undel.isExpired(this._exp);
            }
            return false;
        }
    }

    class GetUndelClientRemoteLocalGTTrkOrGTSeqMsgsforSMODurable
    extends RestoreIterator {
        long _Lmid;
        long _Lseq;
        long _exp;

        GetUndelClientRemoteLocalGTTrkOrGTSeqMsgsforSMODurable(OSTreeSet ts, long lmid, long lseq, long exp) {
            super(ts);
            this._Lmid = lmid;
            this._Lseq = lseq;
            this._exp = exp;
        }

        @Override
        boolean satisfiesQuery(Object obj) {
            IPSEUndelMsg undel = (IPSEUndelMsg)obj;
            if (undel.isExpired(this._exp)) {
                return false;
            }
            if (undel.getFromRemoteBroker()) {
                return true;
            }
            return undel.getMessageId() > this._Lmid || undel.getSequenceNumber() > this._Lseq;
        }
    }

    class GetUndelClientRemoteGTTrkOrGTSeqLocalGTTrkMsgsforSMODurable
    extends RestoreIterator {
        long _Lmid;
        long _Rmid;
        long _Rseq;
        long _exp;

        GetUndelClientRemoteGTTrkOrGTSeqLocalGTTrkMsgsforSMODurable(OSTreeSet ts, long rmid, long rseq, long lmid, long exp) {
            super(ts);
            this._Lmid = lmid;
            this._Rmid = rmid;
            this._Rseq = rseq;
            this._exp = exp;
        }

        @Override
        boolean satisfiesQuery(Object obj) {
            IPSEUndelMsg undel = (IPSEUndelMsg)obj;
            if (!undel.getFromRemoteBroker()) {
                if (undel.getMessageId() > this._Lmid) {
                    return !undel.isExpired(this._exp);
                }
            } else if (undel.getMessageId() > this._Rmid || undel.getSequenceNumber() > this._Rseq) {
                return !undel.isExpired(this._exp);
            }
            return false;
        }
    }

    class GetUndelClientRemoteGTTrkOrGTSeqLocalMsgsforSMODurable
    extends RestoreIterator {
        long _Rmid;
        long _Rseq;
        long _exp;

        GetUndelClientRemoteGTTrkOrGTSeqLocalMsgsforSMODurable(OSTreeSet ts, long rmid, long rseq, long exp) {
            super(ts);
            this._Rmid = rmid;
            this._Rseq = rseq;
            this._exp = exp;
        }

        @Override
        boolean satisfiesQuery(Object obj) {
            IPSEUndelMsg undel = (IPSEUndelMsg)obj;
            if (!undel.getFromRemoteBroker()) {
                return !undel.isExpired(this._exp);
            }
            if (undel.getMessageId() > this._Rmid || undel.getSequenceNumber() > this._Rseq) {
                return !undel.isExpired(this._exp);
            }
            return false;
        }
    }

    class GetUndelClientRemoteMsgsGTTrkOrGTSeqforSMODurable
    extends RestoreIterator {
        long _Rmid;
        long _Rseq;
        long _exp;

        GetUndelClientRemoteMsgsGTTrkOrGTSeqforSMODurable(OSTreeSet ts, long rmid, long rseq, long exp) {
            super(ts);
            this._Rmid = rmid;
            this._Rseq = rseq;
            this._exp = exp;
        }

        @Override
        boolean satisfiesQuery(Object obj) {
            IPSEUndelMsg undel = (IPSEUndelMsg)obj;
            return undel.getFromRemoteBroker() && (undel.getMessageId() > this._Rmid || undel.getSequenceNumber() > this._Rseq) && !undel.isExpired(this._exp);
        }
    }

    class GetUndelClientRemoteMsgsGTTrkforSMODurable
    extends RestoreIterator {
        long _Rmid;
        long _exp;

        GetUndelClientRemoteMsgsGTTrkforSMODurable(OSTreeSet ts, long rmid, long exp) {
            super(ts, new Long(rmid + 1L));
            this._Rmid = rmid;
            this._exp = exp;
        }

        @Override
        boolean satisfiesQuery(Object obj) {
            IPSEUndelMsg undel = (IPSEUndelMsg)obj;
            return undel.getFromRemoteBroker() && !undel.isExpired(this._exp);
        }
    }

    class GetUndelClientRemoteMsgsforSMODurable
    extends RestoreIterator {
        long _exp;

        GetUndelClientRemoteMsgsforSMODurable(OSTreeSet ts, long exp) {
            super(ts);
            this._exp = exp;
        }

        @Override
        boolean satisfiesQuery(Object obj) {
            IPSEUndelMsg undel = (IPSEUndelMsg)obj;
            return undel.getFromRemoteBroker() && !undel.isExpired(this._exp);
        }
    }

    abstract class RestoreIterator
    implements Iterator {
        private OSTreeSet _ts;
        private Iterator _it;
        private Object _next;
        private Object _start;
        private boolean _quitOnFalse;
        int skipped;

        RestoreIterator(OSTreeSet ts) {
            this._ts = ts;
        }

        RestoreIterator(OSTreeSet ts, Object start) {
            this._ts = ts;
            this._start = start;
        }

        RestoreIterator(OSTreeSet ts, Object start, boolean quitOnFalse) {
            this._ts = ts;
            this._start = start;
            this._quitOnFalse = quitOnFalse;
        }

        @Override
        public boolean hasNext() {
            if (this._it == null) {
                this._it = this._start == null ? this._ts.primaryIndexIterator() : this._ts.primaryIndexIterator(this._start);
            }
            boolean hasNext = false;
            while (this._it.hasNext()) {
                Object next = this._it.next();
                if (this.satisfiesQuery(next)) {
                    this._next = next;
                    return true;
                }
                if (this._quitOnFalse) {
                    return false;
                }
                ++this.skipped;
            }
            return false;
        }

        public Object next() {
            Object next = this._next;
            this._next = null;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        abstract boolean satisfiesQuery(Object var1);
    }
}

