/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbq.pse;

import com.odi.ObjectStore;
import com.odi.ObjectStoreException;
import com.odi.util.OSTreeSet;
import com.sonicsw.security.pcs.CipherSuiteInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.BrokerStatus;
import progress.message.broker.DBSubscription;
import progress.message.broker.SyncpointLoc;
import progress.message.broker.gs.GSVirtualClock;
import progress.message.db.EDatabaseException;
import progress.message.db.pse.PSEBrokerDb;
import progress.message.db.pse.util.OpContext;
import progress.message.dbq.IRegDBQ;
import progress.message.dbq.pse.DBQPSEBase;
import progress.message.dbsc.pse.pc.reg.IPSESubscription;
import progress.message.dbsc.pse.pc.reg.PSEBrokerInfo;
import progress.message.dbsc.pse.pc.reg.PSEBrokerMode;
import progress.message.dbsc.pse.pc.reg.PSEBrokerQopCipher;
import progress.message.dbsc.pse.pc.reg.PSEBrokerState;
import progress.message.dbsc.pse.pc.reg.PSEClient;
import progress.message.dbsc.pse.pc.reg.PSELogTime;
import progress.message.dbsc.pse.pc.reg.PSESubscriptionV7;
import progress.message.dbsc.pse.pc.reg.PSESyncPoint;
import progress.message.util.EAssertFailure;
import progress.message.util.LongHashTable;
import progress.message.util.server.ByteBufferOutputStream;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;

public class RegDBQImplPSE
extends DBQPSEBase
implements IRegDBQ {
    private PSEBrokerDb m_pseDb;
    private OSTreeSet m_rootClients = null;

    public RegDBQImplPSE(PSEBrokerDb db) {
        super("RegDBQImplPSE ");
        this.m_pseDb = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws EDatabaseException {
        boolean DEBUG1 = this.isDebugLevel1();
        if (DEBUG1) {
            this.debug("init");
        }
        if (this.m_dbCtx == null) {
            this.m_dbCtx = this.m_pseDb.getCtx(1);
        }
        this.m_opCtxUpdate = new OpContext(2, this.m_dbCtx);
        this.m_opCtxRead = new OpContext(1, 2, this.m_dbCtx);
        this.acquireLock(this.m_opCtxRead);
        try {
            if (DEBUG1) {
                this.debug("Number of Clients= " + this.getRootClients().size());
            }
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
    }

    private OSTreeSet getRootClients() {
        if (this.m_rootClients != null) {
            return this.m_rootClients;
        }
        return (OSTreeSet)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("Clients"));
    }

    private PSEClient getClient(long cid) {
        Long key = new Long(cid);
        return (PSEClient)this.getRootClients().getFromPrimaryIndex((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getSecurityMode() throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering getSecurityMode");
        }
        byte secattr = 0;
        this.acquireLock(this.m_opCtxRead);
        try {
            PSEBrokerMode bmode = (PSEBrokerMode)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("BrokerMode"));
            secattr = (byte)bmode.getSecurityMode();
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        if (DEBUG) {
            this.debug("returning from getSecurityMode, secattr = " + secattr);
        }
        return secattr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLogTime() throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering getLogTime");
        }
        long lt = 0L;
        this.acquireLock(this.m_opCtxRead);
        try {
            PSELogTime lt_obj = (PSELogTime)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("LogTime"));
            lt = lt_obj.getLogTime();
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        if (DEBUG) {
            this.debug("returning from getLogTime");
        }
        return lt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncpointLoc getSyncPtLoc() throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering getSyncPtLoc");
        }
        SyncpointLoc l_syncpoint = null;
        this.acquireLock(this.m_opCtxRead);
        try {
            PSESyncPoint sp = (PSESyncPoint)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("SyncPoint"));
            short fileNumber = (short)sp.getFileNumber();
            long position = sp.getPos();
            if (DEBUG) {
                this.debug("about to construct SyncpointLoc with fileNumber = " + fileNumber + " and " + "position = " + position);
            }
            if (fileNumber != -1) {
                l_syncpoint = new SyncpointLoc(fileNumber, position);
            }
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        if (DEBUG) {
            this.debug("returning from getSyncPtLoc");
        }
        return l_syncpoint;
    }

    @Override
    public void setSyncPtLoc(SyncpointLoc spl) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering setSyncPtLoc");
        }
        short fileNum = spl.getFileNo();
        long filePos = spl.getFilePos();
        this.checkUpdateLock();
        try {
            PSESyncPoint sp = (PSESyncPoint)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("SyncPoint"));
            sp.setFileNumber(fileNum);
            sp.setPos(filePos);
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        if (DEBUG) {
            this.debug("returning from setSyncPtLoc");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastConnectionID() throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering getLastConnectionID");
        }
        long id = 0L;
        this.acquireLock(this.m_opCtxRead);
        try {
            PSEBrokerInfo binfo = (PSEBrokerInfo)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("BrokerInfo"));
            if (binfo != null) {
                id = binfo.getLastConnId();
            }
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        if (DEBUG) {
            this.debug("returning from getLastConnectionID, id = " + id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastConnectionID(long id) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering setLastConnectionID, id = " + id);
        }
        this.acquireLock(this.m_opCtxUpdate);
        try {
            PSEBrokerInfo binfo = (PSEBrokerInfo)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("BrokerInfo"));
            if (binfo == null) {
                binfo = new PSEBrokerInfo(id);
                this.m_dbCtx.getDatabase().setRoot(this.m_pseDb.rootName("BrokerInfo"), (Object)binfo);
            } else {
                binfo.setLastConnId(id);
            }
            this.commit();
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
        if (DEBUG) {
            this.debug("returning from setLastConnectionID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBrokerLastKnownState() throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering getBrokerLastKnownState");
        }
        int state = 0;
        this.acquireLock(this.m_opCtxRead);
        try {
            PSEBrokerState bstate = (PSEBrokerState)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("BrokerState"));
            state = bstate.getLastBrokerState();
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        if (DEBUG) {
            this.debug("returning from getBrokerLastKnownState, state = " + BrokerStatus.State.get(state));
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBrokerLastKnownState(int state) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering setBrokerLastKnownState, state = " + BrokerStatus.State.get(state));
        }
        this.acquireLock(this.m_opCtxUpdate);
        try {
            PSEBrokerState bstate = (PSEBrokerState)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("BrokerState"));
            bstate.setLastBrokerState(state);
            this.commit();
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
        if (DEBUG) {
            this.debug("returning from setBrokerLastKnownState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CipherSuiteInfo getCipherSuiteInfo() throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering getCipherSuiteInfo");
        }
        CipherSuiteInfo cipherSuiteInfo = null;
        this.acquireLock(this.m_opCtxRead);
        try {
            PSEBrokerQopCipher cipher = (PSEBrokerQopCipher)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("BrokerQoPCipher"));
            if (cipher != null) {
                cipherSuiteInfo = new CipherSuiteInfo();
                cipherSuiteInfo.setCipherInfo(cipher.getCipherProviderName(), cipher.getCipherProviderVersion(), cipher.getCipherTransformation());
                cipherSuiteInfo.setDigestInfo(cipher.getDigestProviderName(), cipher.getDigestProviderVersion(), cipher.getDigestAlgorithm());
            }
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        if (DEBUG) {
            this.debug("returning from getCipherSuiteInfo");
        }
        return cipherSuiteInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setCipherSuiteInfo(CipherSuiteInfo cipherSuiteInfo) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering setCipherSuiteInfo");
        }
        String[] cipherDetails = cipherSuiteInfo.getTransformation(0);
        String[] digestDetails = cipherSuiteInfo.getDigest(0);
        this.acquireLock(this.m_opCtxUpdate);
        try {
            PSEBrokerQopCipher cipher = (PSEBrokerQopCipher)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("BrokerQoPCipher"));
            if (cipher == null) {
                cipher = new PSEBrokerQopCipher();
                this.m_dbCtx.getDatabase().setRoot(this.m_pseDb.rootName("BrokerQoPCipher"), (Object)cipher);
            }
            cipher.setCipherProviderName(cipherDetails[0]);
            cipher.setCipherProviderVersion(cipherDetails[1]);
            cipher.setCipherTransformation(cipherDetails[2]);
            cipher.setDigestProviderName(digestDetails[0]);
            cipher.setDigestProviderVersion(digestDetails[1]);
            cipher.setDigestAlgorithm(digestDetails[2]);
            this.commit();
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
        if (DEBUG) {
            this.debug("returning from setCipherSuiteInfo");
        }
    }

    @Override
    public void saveClient(long cid, boolean isInterBroker, ClientSecurityContext secctx, long lastConnectedTime) throws EDatabaseException, IOException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering saveClient, cid = " + cid);
        }
        ByteBufferOutputStream tmp = new ByteBufferOutputStream(secctx.length());
        secctx.serialize(tmp);
        byte[] secctx_bytes = tmp.getBuffer();
        this.checkUpdateLock();
        try {
            PSEClient client = this.getClient(cid);
            if (client == null) {
                client = new PSEClient(cid);
                this.getRootClients().add((Object)client);
            }
            client.setUserId(secctx.getUid());
            client.setAppId(secctx.getAppid());
            client.setSecContext(secctx_bytes);
            client.setInterbroker(isInterBroker);
            client.setLastConnectedTime(lastConnectedTime);
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        if (DEBUG) {
            this.debug("returning from saveClient");
        }
    }

    @Override
    public void clearClientRegistryDbData() throws EDatabaseException {
        boolean DEBUG1 = this.isDebugLevel1();
        if (DEBUG1) {
            this.debug("entering clearClientRegistryDbData");
        }
        this.checkUpdateLock();
        int ct = 0;
        try {
            Iterator iter = this.getRootClients().iterator();
            while (iter.hasNext()) {
                PSEClient pse_client = (PSEClient)iter.next();
                iter.remove();
                ObjectStore.destroy((Object)pse_client);
                ++ct;
            }
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        if (DEBUG1) {
            this.debug("returning from clearClientRegistryDbData; numClientsdeleted= " + ct);
        }
    }

    @Override
    public void deleteClient(long cid) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering deleteClient, cid = " + cid);
        }
        this.checkUpdateLock();
        try {
            PSEClient client = this.getClient(cid);
            if (client == null) {
                if (DEBUG) {
                    this.debug("deleteClient: cid Not Found: " + cid);
                }
                return;
            }
            this.getRootClients().remove((Object)client);
            ObjectStore.destroy((Object)client);
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        if (DEBUG) {
            this.debug("returning from deleteClient");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongHashTable getAllClients() throws EDatabaseException {
        boolean DEBUG1 = this.isDebugLevel1();
        if (DEBUG1) {
            this.debug("entering getAllClients");
        }
        LongHashTable<BrokerDatabase.ClientAttributes> allClients = new LongHashTable<BrokerDatabase.ClientAttributes>();
        this.acquireLock(this.m_opCtxRead);
        int ct = 0;
        try {
            for (PSEClient pse_client : this.getRootClients()) {
                BrokerDatabase.ClientAttributes client_attrs = new BrokerDatabase.ClientAttributes();
                client_attrs.cid = pse_client.getClientId();
                client_attrs.userId = pse_client.getUserId();
                client_attrs.appId = pse_client.getAppId();
                client_attrs.csc = pse_client.getSecContext();
                client_attrs.isInterbroker = pse_client.getInterbroker();
                client_attrs.lastConnectedTime = pse_client.getLastConnectedTime();
                allClients.put(client_attrs.cid, client_attrs);
                ++ct;
            }
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        if (DEBUG1) {
            this.debug("returning from getAllClients; count= " + ct);
        }
        return allClients;
    }

    @Override
    public void saveClientSubscription(long cid, ISubject subject, Date expireTime, long tte, boolean isGuaranteed, String[] selectorStrs, boolean isSelectorAtBroker, boolean unfiltered, GSVirtualClock virtualClock, long creationTime, long previousBrokerCID, long restoreToBrokerCID, boolean isSMOEnabled, HashSet inDoubtProxies) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering saveClientSubscription, cid = " + cid + ", subject = " + subject);
        }
        long[] inDoubtProxiesArray = null;
        if (inDoubtProxies != null && !inDoubtProxies.isEmpty()) {
            inDoubtProxiesArray = new long[inDoubtProxies.size()];
            Iterator iter = inDoubtProxies.iterator();
            int i = 0;
            while (iter.hasNext()) {
                inDoubtProxiesArray[i] = (Long)iter.next();
                ++i;
            }
        }
        this.checkUpdateLock();
        try {
            PSEClient client = this.getClient(cid);
            if (client == null) {
                throw new EAssertFailure("saveClientSubscription: cid Not Found: " + cid);
            }
            PSESubscriptionV7 sub = new PSESubscriptionV7(subject, expireTime != null ? expireTime.getTime() : -1L, tte, isGuaranteed, isSelectorAtBroker, unfiltered, virtualClock != null ? virtualClock.getVirtualClock() : -1L, creationTime, previousBrokerCID, restoreToBrokerCID, isSMOEnabled, inDoubtProxiesArray, selectorStrs);
            client.addSubscription(sub);
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        if (DEBUG) {
            this.debug("returning from saveClientSubscription");
        }
    }

    @Override
    public void deleteClientSubscriptions(long cid) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering deleteClientSubscriptions, cid = " + cid);
        }
        this.checkUpdateLock();
        try {
            PSEClient client = this.getClient(cid);
            if (client == null) {
                if (DEBUG) {
                    this.debug("deleteClientSubscriptions: cid Not Found: " + cid);
                }
                return;
            }
            client.removeAllSubscriptions();
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        if (DEBUG) {
            this.debug("returning from deleteClientSubscriptions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getClientSubscriptions(long cid) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering getClientSubscriptions, cid = " + cid);
        }
        Vector subs = null;
        this.acquireLock(this.m_opCtxRead);
        try {
            PSEClient client = this.getClient(cid);
            if (client == null) {
                if (DEBUG) {
                    this.debug("getClientSubscriptions: cid Not Found: " + cid);
                }
                Vector vector = null;
                return vector;
            }
            subs = this.getClientSubscriptionsInternal(client);
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        if (DEBUG) {
            this.debug("returning from getClientSubscriptions");
        }
        return subs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllClientSubscriptions() throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering getAllClientSubscriptions");
        }
        Vector allSubs = new Vector(0);
        this.acquireLock(this.m_opCtxRead);
        try {
            for (PSEClient client : this.getRootClients()) {
                Vector clientSubs = this.getClientSubscriptionsInternal(client);
                if (clientSubs == null) continue;
                allSubs.addAll(clientSubs);
            }
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        if (DEBUG) {
            this.debug("returning from getAllClientSubscriptions");
        }
        return allSubs;
    }

    private Vector getClientSubscriptionsInternal(PSEClient client) throws ObjectStoreException {
        Collection pseSubs = client.getSubscriptions();
        if (pseSubs == null) {
            return null;
        }
        Vector<DBSubscription> dbSubs = new Vector<DBSubscription>(pseSubs.size());
        for (IPSESubscription pseSub : pseSubs) {
            Label lbl = new Label();
            lbl.setExpirationTime(pseSub.getExpiration());
            lbl.setGuaranteed(pseSub.getGuaranteed());
            lbl.setPersistent(true);
            GSVirtualClock virtualClock = null;
            if (pseSub.getVirtualClock() != -1L) {
                virtualClock = new GSVirtualClock(pseSub.getVirtualClock());
            }
            HashSet<Long> inDoubtProxies = new HashSet<Long>();
            long[] inDoubtProxiesArray = pseSub.getInDoubtProxies();
            if (inDoubtProxiesArray != null) {
                for (int i = 0; i < inDoubtProxiesArray.length; ++i) {
                    inDoubtProxies.add(new Long(inDoubtProxiesArray[i]));
                }
            }
            DBSubscription dbSub = new DBSubscription(client.getClientId(), pseSub.getSubject(), lbl, pseSub.getTTE(), pseSub.getSelectors(), pseSub.getSelectorAtBroker(), pseSub.getUnfiltered(), virtualClock, pseSub.getCreationTime(), pseSub.getPreviousBrokerClientId(), pseSub.getRestoreToBrokerClientId(), pseSub.getIsSMOEnabled(), inDoubtProxies);
            dbSubs.add(dbSub);
        }
        return dbSubs;
    }
}

