/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbq.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import progress.message.db.EDatabaseException;
import progress.message.db.jdbc.JDBCDatabase;
import progress.message.db.jdbc.SyncLock;
import progress.message.dbq.IDupDetectDBQ;
import progress.message.dbsc.data.IDbDupDetectData;
import progress.message.dbsc.data.impl.DbDupDetectData;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;

public class DupDetectDBQImplSQL
extends DebugObject
implements IDupDetectDBQ {
    private JDBCDatabase m_db;
    private Connection m_conn;
    private String m_tableName;
    private SyncLock m_dbqLock = new SyncLock();
    private PreparedStatement m_deletePrepStmt;
    private PreparedStatement m_writePrepStmt;
    private PreparedStatement m_deleteOldPrepStmt;
    private PreparedStatement m_deleteAllPrepStmt;
    private PreparedStatement m_readInfo;
    private PreparedStatement m_updateNewTimestampStatus;
    private PreparedStatement m_updateOldTimestampStatus;
    private PreparedStatement m_deleteChannelRecord;
    private PreparedStatement m_retrieveRecordsExclusive;
    private PreparedStatement m_retrieveRecordsInclusive;
    private PreparedStatement m_getLimits;
    boolean DEBUG1;

    public DupDetectDBQImplSQL(JDBCDatabase db, String tableName) {
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("DupDetectDBQImplSQL");
        }
        this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        this.m_db = db;
        this.m_tableName = tableName;
    }

    @Override
    public void init() throws EDatabaseException {
        try {
            if (this.DEBUG) {
                this.debug("init: starting");
            }
            this.m_conn = this.m_db.newConnection();
            this.m_conn.setTransactionIsolation(8);
            this.m_conn.setAutoCommit(false);
            this.m_deletePrepStmt = this.m_conn.prepareStatement("delete from " + this.m_db.table(this.m_tableName) + " where CommitId = ? and CreationTime = ? ");
            this.m_writePrepStmt = this.m_conn.prepareStatement("insert into " + this.m_db.table(this.m_tableName) + " ( CommitId, endOfLife, CreationTime, State, ChannelID ) " + " values (?, ?, ?, ?, ?)");
            this.m_deleteOldPrepStmt = this.m_conn.prepareStatement("delete from " + this.m_db.table(this.m_tableName) + " where endOfLife < ? ");
            this.m_deleteAllPrepStmt = this.m_conn.prepareStatement("delete from " + this.m_db.table(this.m_tableName));
            this.m_readInfo = this.m_conn.prepareStatement("select CommitId, endOfLife, CreationTime, State, ChannelID from " + this.m_db.table(this.m_tableName) + " where CommitId = ? ");
            this.m_retrieveRecordsInclusive = this.m_conn.prepareStatement("select CommitId, endOfLife, CreationTime, State, ChannelID from " + this.m_db.table(this.m_tableName) + " where CommitId >= ? and CommitId <= ? " + " order by CommitId");
            this.m_retrieveRecordsExclusive = this.m_conn.prepareStatement("select CommitId, endOfLife, CreationTime, State, ChannelID from " + this.m_db.table(this.m_tableName) + " where CommitId > ? and CommitId <= ? " + " order by CommitId");
            this.m_updateNewTimestampStatus = this.m_conn.prepareStatement("update " + this.m_db.table(this.m_tableName) + " set endOfLife = ?, State = ?, ChannelID = ?" + " where " + "CommitId = ? ");
            this.m_updateOldTimestampStatus = this.m_conn.prepareStatement("update " + this.m_db.table(this.m_tableName) + " set endOfLife = ?, State = ? where CommitId = ? and ChannelID = ?");
            this.m_deleteChannelRecord = this.m_conn.prepareStatement("delete from " + this.m_db.table(this.m_tableName) + " where CommitId = ? and ChannelID = ?");
            this.m_getLimits = this.m_conn.prepareStatement("select min(CommitId), max(CommitId) from " + this.m_db.table(this.m_tableName));
            if (this.DEBUG) {
                this.debug("init: completed");
            }
        }
        catch (SQLException e) {
            this.m_db.handleSQLException(e);
        }
    }

    @Override
    public void commit() throws EDatabaseException {
        this.checkLock();
        long start = System.currentTimeMillis();
        try {
            this.m_conn.commit();
        }
        catch (SQLException ex) {
            this.m_db.handleSQLException(ex);
        }
    }

    @Override
    public void rollback() throws EDatabaseException {
        this.checkLock();
        try {
            this.m_conn.rollback();
        }
        catch (SQLException ex) {
            this.m_db.handleSQLException(ex);
        }
    }

    @Override
    public void acquireLock() {
        this.m_dbqLock.acquire();
    }

    @Override
    public void releaseLock() {
        this.m_dbqLock.release();
    }

    private void checkLock() {
        if (!this.m_dbqLock.hasLock()) {
            throw new EAssertFailure("Can't execute db method; Current thread does not own transaction lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(String commitId, long timestamp) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("delete starting; commitId= " + commitId + " date= " + new Date(timestamp));
        }
        int ct = 0;
        this.acquireLock();
        try {
            this.m_deletePrepStmt.setString(1, commitId);
            this.m_deletePrepStmt.setTimestamp(2, new Timestamp(timestamp));
            ct = this.m_deletePrepStmt.executeUpdate();
            this.commit();
        }
        catch (SQLException sqle) {
            this.m_db.handleSQLException(sqle);
        }
        finally {
            this.releaseLock();
        }
        if (this.DEBUG) {
            this.debug("delete completed; deleted " + ct);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteOld(long time) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("deleteOld starting; date= " + new Date(time));
        }
        int ct = 0;
        this.acquireLock();
        try {
            this.m_deleteOldPrepStmt.setTimestamp(1, new Timestamp(time));
            ct = this.m_deleteOldPrepStmt.executeUpdate();
            this.commit();
        }
        catch (SQLException sqle) {
            this.m_db.handleSQLException(sqle);
        }
        finally {
            this.releaseLock();
        }
        if (this.DEBUG) {
            this.debug("deleteOld completed; deleted " + ct);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteAll() throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("deleteAll: starting ");
        }
        int ct = 0;
        this.acquireLock();
        try {
            ct = this.m_deleteAllPrepStmt.executeUpdate();
            this.commit();
        }
        catch (SQLException sqle) {
            this.m_db.handleSQLException(sqle);
        }
        finally {
            this.releaseLock();
        }
        if (this.DEBUG) {
            this.debug("deleteAll completed; deleted " + ct);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteChannelRecord(String commitId, String channelID) throws EDatabaseException, IllegalArgumentException {
        if (this.DEBUG) {
            this.debug("deleteChannelRecord starting; commitId= " + commitId + " channelID = " + channelID);
        }
        int ct = 0;
        this.acquireLock();
        try {
            try {
                this.m_deleteChannelRecord.setString(1, commitId);
                this.m_deleteChannelRecord.setString(2, channelID);
            }
            catch (SQLException sqle) {
                throw new IllegalArgumentException();
            }
            try {
                ct = this.m_deleteChannelRecord.executeUpdate();
                this.commit();
            }
            catch (SQLException sqle) {
                this.m_db.handleSQLException(sqle);
            }
        }
        finally {
            this.releaseLock();
        }
        if (this.DEBUG) {
            this.debug("deleteChannelRecord completed; deleted " + ct);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateChannelRecord(String commitId, long endOfLife, int channelStatus, String channelID) throws EDatabaseException, IllegalArgumentException {
        if (this.DEBUG) {
            this.debug("updateChannelrecord starting; commitId= " + commitId + " channelID = " + channelID);
        }
        int ct = 0;
        this.acquireLock();
        try {
            try {
                this.m_updateOldTimestampStatus.setTimestamp(1, new Timestamp(endOfLife));
                this.m_updateOldTimestampStatus.setInt(2, channelStatus);
                this.m_updateOldTimestampStatus.setString(3, commitId);
                this.m_updateOldTimestampStatus.setString(4, channelID);
            }
            catch (SQLException sqle) {
                throw new IllegalArgumentException();
            }
            try {
                ct = this.m_updateOldTimestampStatus.executeUpdate();
                this.commit();
            }
            catch (SQLException sqle) {
                this.m_db.handleSQLException(sqle);
            }
        }
        finally {
            this.releaseLock();
        }
        if (this.DEBUG) {
            this.debug("updateChannelrecord completed; commitId= " + commitId + " channelID = " + channelID + " numUpdated= " + ct);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(String commitId, long endOfLife, long timestamp, int status, String channelID) throws EDatabaseException, IllegalArgumentException {
        if (this.DEBUG) {
            this.debug("write  starting; commitId= " + commitId + " channelID= " + channelID + " timeStamp= " + new Date(timestamp) + " endOfLife= " + new Date(endOfLife));
        }
        int result = 0;
        this.acquireLock();
        try {
            result = this.writeInternal(commitId, endOfLife, timestamp, status, channelID, true);
        }
        finally {
            this.releaseLock();
        }
        if (this.DEBUG) {
            this.debug("write  completed; commitId= " + commitId + " channelID = " + channelID + " result= " + result);
        }
        return result;
    }

    @Override
    public int writeTx(String commitId, long endOfLife, long timestamp, int status, String channelID) throws EDatabaseException, IllegalArgumentException {
        if (this.DEBUG) {
            this.debug("writeTx  starting; commitId= " + commitId + " channelID = " + channelID);
        }
        int result = 0;
        this.checkLock();
        result = this.writeInternal(commitId, endOfLife, timestamp, status, channelID, false);
        if (this.DEBUG) {
            this.debug("writeTx  completed; commitId= " + commitId + " channelID = " + channelID + " result= " + result);
        }
        return result;
    }

    @Override
    public void updateAllRecordInfoTx(String commitId, long endOfLife, int channelStatus, String channelID) throws EDatabaseException, IllegalArgumentException {
        if (this.DEBUG) {
            this.debug("updateAllRecordInfoTx starting; commitId= " + commitId + " channelID = " + channelID);
        }
        this.checkLock();
        try {
            this.m_updateNewTimestampStatus.setTimestamp(1, new Timestamp(endOfLife));
            this.m_updateNewTimestampStatus.setInt(2, channelStatus);
            this.m_updateNewTimestampStatus.setString(3, channelID);
            this.m_updateNewTimestampStatus.setString(4, commitId);
        }
        catch (SQLException sqle) {
            throw new IllegalArgumentException();
        }
        try {
            this.m_updateNewTimestampStatus.executeUpdate();
        }
        catch (SQLException sqle) {
            this.m_db.handleSQLException(sqle);
        }
        if (this.DEBUG) {
            this.debug("updateAllRecordInfoTx completed; commitId= " + commitId + " channelID = " + channelID);
        }
    }

    @Override
    public IDbDupDetectData getRecordInfoTx(String commitId) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("getRecordInfoTx starting; commitId= " + commitId);
        }
        DbDupDetectData result = null;
        this.checkLock();
        try {
            this.m_readInfo.setString(1, commitId);
            ResultSet rs = this.m_readInfo.executeQuery();
            if (rs.next()) {
                result = new DbDupDetectData(rs.getString(1), rs.getTimestamp(2).getTime(), rs.getTimestamp(3).getTime(), rs.getInt(4), rs.getString(5));
            }
            rs.close();
        }
        catch (SQLException sqle) {
            this.m_db.handleSQLException(sqle);
        }
        return result;
    }

    private int writeInternal(String commitId, long endOfLife, long timestamp, int status, String channelID, boolean doCommit) throws EDatabaseException, IllegalArgumentException {
        int res = 0;
        try {
            this.m_writePrepStmt.setString(1, commitId);
            this.m_writePrepStmt.setTimestamp(2, new Timestamp(endOfLife));
            this.m_writePrepStmt.setTimestamp(3, new Timestamp(timestamp));
            this.m_writePrepStmt.setInt(4, status);
            this.m_writePrepStmt.setString(5, channelID);
        }
        catch (SQLException sqle) {
            throw new IllegalArgumentException();
        }
        try {
            res = this.m_writePrepStmt.executeUpdate();
            if (doCommit) {
                this.commit();
            }
        }
        catch (SQLException sqle) {
            if (this.m_db.isUniqueConstraintException(sqle)) {
                res = -1;
            }
            this.m_db.handleSQLException(sqle);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getRecords(String minCommitId, String maxCommitId, int count, boolean inclusive) throws EDatabaseException {
        ArrayList<DbDupDetectData> result = new ArrayList<DbDupDetectData>();
        PreparedStatement retrieve = null;
        this.acquireLock();
        try {
            retrieve = inclusive ? this.m_retrieveRecordsInclusive : this.m_retrieveRecordsExclusive;
            retrieve.setString(1, minCommitId);
            retrieve.setString(2, maxCommitId);
            ResultSet rs = retrieve.executeQuery();
            try {
                for (int resultCount = 0; rs.next() && resultCount < count; ++resultCount) {
                    DbDupDetectData data = new DbDupDetectData(rs.getString(1), rs.getTimestamp(2).getTime(), rs.getTimestamp(3).getTime(), rs.getInt(4), rs.getString(5));
                    result.add(data);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                this.commit();
            }
        }
        catch (SQLException sqle) {
            throw new IllegalArgumentException();
        }
        finally {
            this.releaseLock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLimits() throws EDatabaseException {
        block13: {
            this.acquireLock();
            try {
                ResultSet rs = this.m_getLimits.executeQuery();
                if (!rs.next()) break block13;
                String min = rs.getString(1);
                String max = rs.getString(2);
                if (min == null) {
                    String[] stringArray = null;
                    return stringArray;
                }
                String[] stringArray = new String[]{min, max};
                return stringArray;
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SQLException sqle) {
                throw new IllegalArgumentException();
            }
            finally {
                this.releaseLock();
            }
        }
        return null;
    }
}

