/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse;

import com.odi.Database;
import com.odi.Session;
import com.odi.util.IndexIterator;
import com.odi.util.OSTreeSet;
import java.util.Collection;
import java.util.Iterator;
import progress.message.broker.BrokerStatus;
import progress.message.dbsc.pse.ILog;
import progress.message.dbsc.pse.pc.reg.IPSESubscription;
import progress.message.dbsc.pse.pc.reg.PSEBrokerState;
import progress.message.dbsc.pse.pc.reg.PSEClient;
import progress.message.dbsc.pse.pc.reg.PSESyncPoint;
import progress.message.util.EAssertFailure;

public class DbSchemaCheckReg {
    Database m_db;
    ILog m_logger;

    public DbSchemaCheckReg(Database db, ILog log) {
        this.m_db = db;
        this.m_logger = log;
    }

    public void checkDb() {
        Session sess = Session.getCurrent();
        if (sess == null) {
            throw new EAssertFailure("No current Session");
        }
        if (!sess.inTransaction()) {
            throw new EAssertFailure("No current Transaction");
        }
        this.m_logger.logln("\nChecking Reg Schema...");
        this.dumpRegInfo();
        this.m_logger.logln("\nCompleted Checking Reg Schema.");
    }

    private void dumpRegInfo() {
        PSESyncPoint sp = (PSESyncPoint)this.m_db.getRoot("SyncPoint");
        if (sp != null) {
            short fileNumber = (short)sp.getFileNumber();
            long position = sp.getPos();
            this.m_logger.logln("SyncpointLoc: fileNumber= " + fileNumber + " position= " + position);
        } else {
            this.m_logger.logln("PSESyncpoint does not exist in Db");
        }
        this.m_logger.logln("\n");
        int state = 0;
        PSEBrokerState bstate = (PSEBrokerState)this.m_db.getRoot("BrokerState");
        if (bstate != null) {
            state = bstate.getLastBrokerState();
            this.m_logger.logln("BrokerLastKnownState= " + BrokerStatus.State.get(state));
        } else {
            this.m_logger.logln("PSEBrokerState does not exist in Db");
        }
    }

    private void dumpClientInfo() {
        OSTreeSet ts = (OSTreeSet)this.m_db.getRoot("Clients");
        int numSubs = 0;
        this.m_logger.logln("Num Clients= " + ts.size());
        IndexIterator it = ts.primaryIndexIterator();
        while (it.hasNext()) {
            PSEClient pse_client = (PSEClient)it.next();
            String appid = pse_client.getAppId();
            Collection subs = pse_client.getSubscriptions();
            if (subs == null) continue;
            this.m_logger.logln("Cid= " + pse_client.getClientId() + " Appid= " + pse_client.getAppId() + " Uid= " + pse_client.getUserId());
            if (subs == null || subs.isEmpty()) continue;
            Iterator iter = subs.iterator();
            while (iter.hasNext()) {
                ++numSubs;
                IPSESubscription pseSub = (IPSESubscription)iter.next();
                String[] sels = pseSub.getSelectors();
                StringBuffer buf = null;
                buf = new StringBuffer();
                if (sels != null) {
                    for (int i = 0; i < sels.length; ++i) {
                        buf.append(sels[i]);
                        buf.append(";   ");
                    }
                }
                this.m_logger.logln("\tTopic= " + pseSub.getSubject().getSubjectString() + " selAtBroker= " + pseSub.getSelectorAtBroker() + "\n\tSelectors= " + buf.toString());
            }
        }
        this.m_logger.logln("NumSubscriptions= " + numSubs);
    }
}

