/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dd;

import com.sonicsw.mf.common.IComponentContext;
import java.text.MessageFormat;
import progress.message.db.Db;
import progress.message.db.EBrokerNameTooLong;
import progress.message.db.EDatabaseException;
import progress.message.db.EDatabaseNotExists;
import progress.message.dbsc.ISchemaDef;
import progress.message.dbsc.IStatusListener;
import progress.message.dd.prAccessor;
import progress.message.util.DebugState;
import progress.message.util.server.OStream;
import progress.message.zclient.DebugObject;

public final class NoDupDetectDbAdmin
extends DebugObject {
    Db mDb;
    private IComponentContext m_context = null;

    NoDupDetectDbAdmin(Db db) {
        super(DebugState.GLOBAL_DEBUG_ON ? "NoDupDetectDbAdmin" : null);
        if (this.DEBUG) {
            this.debug("ctor");
        }
        this.mDb = db;
    }

    public synchronized void drop() throws EDatabaseException {
        try {
            this.mDb.start();
        }
        catch (EDatabaseNotExists e) {
            return;
        }
        if (this.mDb.seemsConfiguredDD()) {
            ISchemaDef sdef = this.mDb.getSchemaDef();
            sdef.dropDD();
        }
    }

    public synchronized void init() throws EDatabaseException, EBrokerNameTooLong {
        try {
            this.mDb.start();
        }
        catch (EDatabaseNotExists e) {
            this.mDb.createNewDb();
            this.mDb.start();
        }
        if (this.mDb.seemsConfiguredDD()) {
            this.log(prAccessor.getString("STR003"));
        } else {
            ISchemaDef sdef = this.mDb.getSchemaDef();
            sdef.setStatusListener(new IStatusListener(){

                @Override
                public void creatingSchemaObj(int type, String name, boolean created) {
                    switch (type) {
                        case 1: {
                            if (!created) break;
                            Object[] parms = new Object[]{name};
                            NoDupDetectDbAdmin.this.log(MessageFormat.format(prAccessor.getString("CREATING_DBOBJECT"), parms));
                            break;
                        }
                        case 3: {
                            if (!created) break;
                            Object[] parms = new Object[]{name};
                            NoDupDetectDbAdmin.this.log(MessageFormat.format(prAccessor.getString("CREATING_INDEX"), parms));
                            break;
                        }
                        case 2: {
                            if (!created) break;
                            Object[] parms = new Object[]{name};
                            NoDupDetectDbAdmin.this.log(MessageFormat.format(prAccessor.getString("CREATING_TABLE"), parms));
                            break;
                        }
                    }
                }

                @Override
                public void upgradingSchema(String message) {
                }
            });
            sdef.createDD();
        }
    }

    public synchronized void upgrade(int dbvers) throws EDatabaseException {
        ISchemaDef sdef = this.mDb.getSchemaDef();
        sdef.upgradeDD(dbvers);
    }

    public void setContext(IComponentContext context) throws Exception {
        this.m_context = context;
    }

    private void log(String out) {
        if (this.m_context != null) {
            this.m_context.logMessage(out, 3);
        } else {
            OStream.println(out);
        }
    }
}

