/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dd;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.CommitResult;
import progress.message.broker.Config;
import progress.message.db.Db;
import progress.message.db.EDatabaseException;
import progress.message.db.EInvalidConfiguration;
import progress.message.dbq.DBQSetup;
import progress.message.dbq.IDupDetectDBQ;
import progress.message.dbsc.data.IDbDupDetectData;
import progress.message.dd.NoDupDetectDb;
import progress.message.ft.DupDetectionSyncReplicationMgr;
import progress.message.ft.FTMgramFactory;
import progress.message.ft.FTReflectionOperation;
import progress.message.ft.ReplicationManager;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public final class NoDupDetectDbConnection
extends DebugObject {
    Db mDb;
    private IDupDetectDBQ mDupDetectDBQ;
    private DupDetectionSyncReplicationMgr mReplSyncMgr;

    public NoDupDetectDbConnection(Db db) throws EDatabaseException {
        super(DebugState.GLOBAL_DEBUG_ON ? "NoDupDetectDbConnection" : null);
        if (this.DEBUG) {
            this.debug("NoDupDetectDbConnection ctor mDb= " + db);
        }
        this.mDb = db;
        this.mDupDetectDBQ = DBQSetup.initDupDetectDBQ(this.mDb);
        this.mDupDetectDBQ.init();
        if (this.replicationEnabled()) {
            this.mReplSyncMgr = new DupDetectionSyncReplicationMgr(this);
        }
    }

    public int updateChannelRecord(String commitId, long lifespan, int channelStatus, String channelID) throws EDatabaseException, EInvalidConfiguration, IllegalArgumentException {
        if (commitId.length() > 64 || channelID != null && channelID.length() > 254 || lifespan < 0L) {
            throw new IllegalArgumentException();
        }
        lifespan = lifespan != 0L ? lifespan : NoDupDetectDb.getDefaultLifeSpan();
        long endOfLife = System.currentTimeMillis() + lifespan;
        int ct = this.performUpdateChannelRecord(commitId, endOfLife, channelStatus, channelID);
        return ct;
    }

    private boolean replicationEnabled() {
        return Config.REPLICATED && !NoDupDetectDb.isFTShared();
    }

    private synchronized int performUpdateChannelRecord(String commitId, long endOfLife, int channelStatus, String channelID) throws EDatabaseException {
        ReplicationManager mgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
        if (this.replicationEnabled() && mgr.okToReplicate() && !this.mReplSyncMgr.suppressSynchronization(commitId)) {
            FTReflectionOperation op = FTMgramFactory.createReflectionOperation();
            op.addMethod(7, "updateChannelRecord", IDupDetectDBQ.s_updateChannelRecordParams, new Object[]{commitId, new Long(endOfLife), new Integer(channelStatus), channelID});
            mgr.replicateFTRelectionOp(op);
        }
        return this.mDupDetectDBQ.updateChannelRecord(commitId, endOfLife, channelStatus, channelID);
    }

    public int deleteChannelRecord(String commitId, String channelID) throws EDatabaseException, IllegalArgumentException {
        if (commitId.length() > 64 || channelID.length() > 254) {
            throw new IllegalArgumentException();
        }
        int result = 0;
        try {
            this.performDeleteChannelRecord(commitId, channelID);
        }
        catch (EDatabaseException ex) {
            if (this.DEBUG) {
                ex.printStackTrace();
            }
            throw ex;
        }
        return result;
    }

    private synchronized void performDeleteChannelRecord(String commitId, String channelID) throws EDatabaseException {
        ReplicationManager mgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
        if (this.replicationEnabled() && mgr.okToReplicate() && !this.mReplSyncMgr.suppressSynchronization(commitId)) {
            FTReflectionOperation op = FTMgramFactory.createReflectionOperation();
            op.addMethod(7, "deleteChannelRecord", IDupDetectDBQ.s_deleteChannelRecordParams, new Object[]{commitId, channelID});
            mgr.replicateFTRelectionOp(op);
        }
        this.mDupDetectDBQ.deleteChannelRecord(commitId, channelID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitResult writeChannel(String commitId, long lifespan, long timestamp, int channelStatus, String channelID) throws EDatabaseException, EInvalidConfiguration, IllegalArgumentException {
        if (commitId.length() > 64 || channelID != null && channelID.length() > 254 || lifespan < 0L) {
            throw new IllegalArgumentException();
        }
        FTReflectionOperation ftOp = null;
        boolean updatePerformed = false;
        ftOp = this.performAquireLock(commitId);
        CommitResult result = null;
        try {
            IDbDupDetectData ri = this.mDupDetectDBQ.getRecordInfoTx(commitId);
            boolean haveResult = false;
            if (ri != null) {
                lifespan = lifespan != 0L ? lifespan : NoDupDetectDb.getDefaultLifeSpan();
                result = new CommitResult();
                if (ri.getStatus() == 14) {
                    result.setResult(14);
                    this.mDupDetectDBQ.commit();
                    CommitResult commitResult = result;
                    return commitResult;
                }
                if (ri.getChannelID().equals(channelID)) {
                    long endOfLife = System.currentTimeMillis() + lifespan;
                    this.performUpdateAllRecordInfoTx(commitId, endOfLife, channelStatus, channelID, ftOp);
                    updatePerformed = true;
                    result.setResult(0);
                    this.performCommit();
                    CommitResult commitResult = result;
                    return commitResult;
                }
                if (ri.getEndOfLife() > System.currentTimeMillis()) {
                    result.setResult(13);
                    result.setTimeStamp(ri.getEndOfLife());
                    this.mDupDetectDBQ.commit();
                    CommitResult endOfLife = result;
                    return endOfLife;
                }
                long endOfLife = System.currentTimeMillis() + lifespan;
                this.mDupDetectDBQ.updateAllRecordInfoTx(commitId, endOfLife, channelStatus, channelID);
                this.performUpdateAllRecordInfoTx(commitId, endOfLife, channelStatus, channelID, ftOp);
                updatePerformed = true;
                result.setResult(0);
                this.performCommit();
                CommitResult commitResult = result;
                return commitResult;
            }
            result = this.write(commitId, lifespan, timestamp, channelStatus, channelID, true, ftOp);
            if (result.getResult() != 14) {
                updatePerformed = true;
            }
            this.performCommit();
        }
        finally {
            this.performReleaseLock(ftOp);
            if (ftOp != null && updatePerformed) {
                AgentRegistrar.getAgentRegistrar().getReplicationManager().replicateFTRelectionOp(ftOp);
            }
        }
        return result;
    }

    private synchronized FTReflectionOperation performAquireLock(String commitId) throws EDatabaseException {
        FTReflectionOperation ftOp = null;
        if (this.replicationEnabled() && !this.mReplSyncMgr.suppressSynchronization(commitId)) {
            ftOp = FTMgramFactory.createReflectionOperation();
            ftOp.addMethod(7, "acquireLock", null, null);
        }
        this.mDupDetectDBQ.acquireLock();
        return ftOp;
    }

    private void performReleaseLock(FTReflectionOperation ftOp) throws EDatabaseException {
        if (ftOp != null) {
            ftOp.addMethod(7, "releaseLock", null, null);
        }
        this.mDupDetectDBQ.releaseLock();
    }

    private FTReflectionOperation performCommit() throws EDatabaseException {
        FTReflectionOperation ftOp = null;
        if (this.replicationEnabled()) {
            ftOp = FTMgramFactory.createReflectionOperation();
            ftOp.addMethod(7, "commit", null, null);
        }
        this.mDupDetectDBQ.commit();
        return ftOp;
    }

    private synchronized void performUpdateAllRecordInfoTx(String commitId, long endOfLife, int channelStatus, String channelID, FTReflectionOperation ftOp) throws EDatabaseException {
        if (ftOp != null) {
            ftOp.addMethod(7, "updateAllRecordInfoTx", IDupDetectDBQ.s_updateAllRecordInfoTx, new Object[]{new String(commitId), new Long(endOfLife), new Integer(channelStatus), new String(channelID)});
            ftOp.addMethod(7, "commit", null, null);
        }
        this.mDupDetectDBQ.updateAllRecordInfoTx(commitId, endOfLife, channelStatus, channelID);
    }

    public synchronized CommitResult write(String commitId, long lifespan, long timestamp, int status, String channelID) throws EDatabaseException, EInvalidConfiguration, IllegalArgumentException {
        return this.write(commitId, lifespan, timestamp, status, channelID, false, null);
    }

    private synchronized CommitResult write(String commitId, long lifespan, long timestamp, int status, String channelID, boolean intx, FTReflectionOperation ftOp) throws EDatabaseException, EInvalidConfiguration, IllegalArgumentException {
        CommitResult result = new CommitResult();
        result.setResult(0);
        if (commitId.length() > 64 || channelID != null && channelID.length() > 254 || lifespan < 0L) {
            throw new IllegalArgumentException();
        }
        lifespan = lifespan != 0L ? lifespan : NoDupDetectDb.getDefaultLifeSpan();
        long endOfLife = System.currentTimeMillis() + lifespan;
        String cid = channelID != null ? channelID : "-1";
        int res = 0;
        res = intx ? this.performWriteTx(commitId, endOfLife, timestamp, status, cid, ftOp) : this.performWrite(commitId, endOfLife, timestamp, status, cid);
        if (this.DEBUG) {
            this.debug("This commitId was written to db: " + commitId + ":" + new Date(endOfLife) + " with result: " + res);
        }
        if (res == -1) {
            if (this.DEBUG) {
                this.debug("The commitId: " + commitId + " is already in database");
            }
            result.setResult(14);
        }
        return result;
    }

    private synchronized int performWriteTx(String commitId, long endOfLife, long timestamp, int status, String cid, FTReflectionOperation ftOp) throws EDatabaseException {
        int res = this.mDupDetectDBQ.writeTx(commitId, endOfLife, timestamp, status, cid);
        if (res != -1 && ftOp != null) {
            ftOp.addMethod(7, "writeTx", IDupDetectDBQ.s_writeTxParams, new Object[]{new String(commitId), new Long(endOfLife), new Long(timestamp), new Integer(status), new String(cid)});
        }
        return res;
    }

    private synchronized int performWrite(String commitId, long endOfLife, long timestamp, int status, String cid) throws EDatabaseException {
        int res = this.mDupDetectDBQ.write(commitId, endOfLife, timestamp, status, cid);
        if (res != -1) {
            ReplicationManager mgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
            if (this.replicationEnabled() && mgr.okToReplicate() && !this.mReplSyncMgr.suppressSynchronization(commitId)) {
                FTReflectionOperation op = FTMgramFactory.createReflectionOperation();
                op.addMethod(7, "write", IDupDetectDBQ.s_writeParams, new Object[]{new String(commitId), new Long(endOfLife), new Long(timestamp), new Integer(status), new String(cid)});
                mgr.replicateFTRelectionOp(op);
            }
        }
        return res;
    }

    public void delete(String commitId, long timestamp) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("Going to delete: " + new Date(timestamp));
        }
        int ct = this.performDelete(commitId, timestamp);
        if (this.DEBUG) {
            this.debug("Delete completed; deleted " + ct + " rows");
        }
    }

    private synchronized int performDelete(String commitId, long timestamp) throws EDatabaseException {
        ReplicationManager mgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
        if (this.replicationEnabled() && mgr.okToReplicate() && !this.mReplSyncMgr.suppressSynchronization(commitId)) {
            FTReflectionOperation op = FTMgramFactory.createReflectionOperation();
            op.addMethod(7, "delete", IDupDetectDBQ.s_deleteParams, new Object[]{commitId, new Long(timestamp)});
            mgr.replicateFTRelectionOp(op);
        }
        int ct = this.mDupDetectDBQ.delete(commitId, timestamp);
        return ct;
    }

    public void deleteOld() throws EDatabaseException {
        long time = System.currentTimeMillis();
        if (this.DEBUG) {
            this.debug("Going to clean: " + new Date(time));
        }
        int ct = this.performDeleteOld(time);
        if (this.DEBUG) {
            this.debug("Cleaning done; deleted " + ct + " rows");
        }
    }

    private synchronized int performDeleteOld(long time) throws EDatabaseException {
        ReplicationManager mgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
        if (this.replicationEnabled() && mgr.okToReplicate()) {
            FTReflectionOperation op = FTMgramFactory.createReflectionOperation();
            op.addMethod(7, "deleteOld", IDupDetectDBQ.s_deleteOldParams, new Object[]{new Long(time)});
            mgr.replicateFTRelectionOp(op);
        }
        int ct = this.mDupDetectDBQ.deleteOld(time);
        return ct;
    }

    public synchronized void deleteAll() throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("Going to clean all data");
        }
        int ct = this.performDeleteAll();
        if (this.DEBUG) {
            this.debug("Cleaning done; deleted " + ct + " rows");
        }
    }

    private synchronized int performDeleteAll() throws EDatabaseException {
        ReplicationManager mgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
        if (this.replicationEnabled() && mgr.okToReplicate()) {
            FTReflectionOperation op = FTMgramFactory.createReflectionOperation();
            op.addMethod(7, "deleteAll", IDupDetectDBQ.s_deleteAllParams, null);
            mgr.replicateFTRelectionOp(op);
        }
        int ct = this.mDupDetectDBQ.deleteAll();
        return ct;
    }

    public IDupDetectDBQ getDupDetectDBQ() {
        return this.mDupDetectDBQ;
    }

    public synchronized String[] getLimits() throws EDatabaseException {
        return this.mDupDetectDBQ.getLimits();
    }

    public synchronized String[] startDynamicSync() throws EDatabaseException {
        return this.mReplSyncMgr.startDynamicSync();
    }

    public synchronized void completeDynamicSync() {
        this.mReplSyncMgr.completeDynamicSync();
    }

    public synchronized void setCurrentReplicationCommitId(String commitId) {
        this.mReplSyncMgr.setCurrentCommitId(commitId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeDupDetectData(List dataList) throws EDatabaseException {
        if (!dataList.isEmpty()) {
            Iterator iter = dataList.iterator();
            this.mDupDetectDBQ.acquireLock();
            try {
                while (iter.hasNext()) {
                    IDbDupDetectData data = (IDbDupDetectData)iter.next();
                    this.mDupDetectDBQ.writeTx(data.getCommitID(), data.getEndOfLife(), data.getCreationTime(), data.getStatus(), data.getChannelID());
                }
                this.mDupDetectDBQ.commit();
            }
            finally {
                this.mDupDetectDBQ.releaseLock();
            }
        }
    }

    public synchronized List getDupDetectData(String minimum, String maximum, int count, boolean inclusive) throws EDatabaseException {
        return this.mDupDetectDBQ.getRecords(minimum, maximum, count, inclusive);
    }
}

