/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.util.ArrayList;
import progress.message.broker.Broker;
import progress.message.ft.DynamicSyncManager;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugThread;

public class SubscriptionDynSyncer
extends DebugThread {
    private DynamicSyncManager m_dsm;
    private int m_role = -1;
    private ArrayList m_subscribes = null;
    private Object m_subMutex = new Object();

    public SubscriptionDynSyncer(DynamicSyncManager dsm, int role) {
        super("SubscriptionDynSyncer");
        this.m_dsm = dsm;
        this.m_role = role;
        if (this.m_role == 2) {
            throw new EAssertFailure("SubscriptionDynSyncer shouldn't be used by the STANDBY during dynamic sync.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSubscriptions(ArrayList subscriptions) {
        if (subscriptions == null) {
            throw new EAssertFailure("Subscriptions added should never be null.  Instead when no subscriptions to replicate an empty ArrayList should be passed in");
        }
        Object object = this.m_subMutex;
        synchronized (object) {
            this.m_subscribes = subscriptions;
            this.m_subMutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadMain() {
        try {
            if (this.DEBUG) {
                this.debug("SubcriptionDynSyncer running... m_role: " + this.m_role);
            }
            if (this.m_role == 1) {
                if (this.DEBUG) {
                    this.debug("get and send subscription info to be replicated on the standby");
                }
                this.doActiveSync();
            } else if (this.m_role == 2) {
                throw new EAssertFailure("SubscriptionDynSyncer shouldn't be used by the STANDBY during dynamic sync.");
            }
            if (this.DEBUG) {
                this.debug("SubcriptionDynSyncer exiting...");
            }
            this.m_dsm.setStatus(16);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.DEBUG) {
                this.debug("Thread Exiting; Broker.exiting= " + Broker.exiting);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doActiveSync() throws InterruptedException {
        Object object = this.m_subMutex;
        synchronized (object) {
            while (this.m_subscribes == null) {
                this.m_subMutex.wait();
            }
        }
        this.m_dsm.replicateSubscriptions(this.m_subscribes);
    }
}

