/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.io.IOException;
import java.io.ObjectOutput;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.ft.FTMgramFactory;
import progress.message.ft.ReplicationManager;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.zclient.DebugObject;

public class TxnFileReplicationOutputStream
extends DebugObject {
    private int m_tid;
    IOperationHandle m_replicateHandle = null;
    IMgram m_replicateMgram = null;
    boolean m_flushNext = false;
    boolean m_first = true;
    ReplicationManager m_replMgr;
    boolean m_dynSyncReplicationStream = false;
    private short m_initialflags = 0;

    public TxnFileReplicationOutputStream(int tid, boolean dynSyncReplicationStream) {
        super("TxnReplicationOutputStream");
        this.m_tid = tid;
        this.m_replMgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
        this.m_dynSyncReplicationStream = dynSyncReplicationStream;
        if (this.m_dynSyncReplicationStream) {
            this.m_initialflags = (short)(this.m_initialflags | 1);
        }
    }

    public void flush() {
        this.flush(true);
    }

    public void write(long origTracking, IMgram m) {
        IMgram txwrapper = null;
        IOperationHandle txwrapperop = null;
        short flags = this.m_initialflags;
        if (this.m_flushNext) {
            this.flush(false);
        }
        if (this.m_replicateHandle == null) {
            if (this.m_first) {
                flags = (short)(flags | 2);
                this.m_first = false;
            }
            this.m_replicateMgram = FTMgramFactory.createReplicateTxnMgramOp(this.m_tid, flags);
            this.m_replicateHandle = this.m_replicateMgram.getOperationHandle();
        }
        txwrapper = MgramFactory.getMgramFactory().buildOperationMgram(24);
        try {
            ObjectOutput oo = txwrapper.getPayloadOutputStreamHandle();
            oo.writeLong(origTracking);
            oo.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        txwrapperop = txwrapper.getOperationHandle();
        txwrapperop.addMgram(MgramFactory.getMgramFactory().buildReplicatedMgram(m, true));
        this.m_replicateHandle.addMgram(txwrapper);
        if (this.m_replicateHandle.getMgramListNetworkLength() > Config.REPLICATION_CHUNK_SIZE) {
            this.m_flushNext = true;
        }
    }

    private void flush(boolean sync) {
        boolean interrupted = false;
        if (this.m_replicateMgram != null) {
            if (sync) {
                try {
                    if (this.DEBUG) {
                        this.debug("sending replicated filebased mgram synchronously m_tid: " + this.m_tid);
                    }
                    this.m_replMgr.replicateMgramSynchronously(this.m_replicateMgram);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            } else {
                if (this.DEBUG) {
                    this.debug("sending replicated filebased mgram asynchronously m_tid: " + this.m_tid);
                }
                this.m_replMgr.replicateMgram(this.m_replicateMgram);
            }
            this.m_replicateMgram = null;
            this.m_replicateHandle = null;
            this.m_flushNext = false;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

