/*
 * Decompiled with CFR 0.152.
 */
package progress.message.gr;

import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.broker.Config;
import progress.message.gr.RouteInfo;
import progress.message.gr.RouteNodeHolder;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class RouteTable
extends DebugObject {
    Hashtable m_hash;
    String m_localNodeName = Config.ROUTING_NODE_NAME;
    Hashtable m_nodeTable;
    public static int ADD = 0;
    public static int REPLACE = 1;
    public static int REPLACEBROKER = 2;
    public static int REMOVE = 3;
    public static int IGNORE = 4;

    public RouteTable(Hashtable nodeTable) {
        super(DebugState.GLOBAL_DEBUG_ON ? "RouteTable" : null);
        this.m_hash = new Hashtable();
        this.m_nodeTable = nodeTable;
    }

    public synchronized int setRoute(RouteInfo riNew, RouteNodeHolder oldNode) {
        RouteNodeHolder rnh;
        String hashName = riNew.getHashName();
        boolean sameNode = false;
        RouteInfo riLast = null;
        RouteInfo riPrev = (RouteInfo)this.m_hash.get(hashName);
        if (oldNode != null && riPrev != null && (rnh = riPrev.getRemoteNode()) != null) {
            oldNode.setRemoteBroker(rnh.getRemoteBroker());
        }
        if (riPrev == null) {
            if (this.DEBUG) {
                if (this.m_localNodeName.equals(riNew.getNodeName())) {
                    this.debug("setRoute: Added a new local global: (" + riNew.getGlobalName() + ", " + riNew.getNodeName() + ", " + riNew.getBrokerName() + ")");
                } else {
                    this.debug("setRoute: Added a new remote global: (" + riNew.getGlobalName() + ", " + riNew.getNodeName() + ")");
                }
            }
            riNew.setNext(null);
            this.m_hash.put(hashName, riNew);
            return ADD;
        }
        riPrev.clearReconcilePending();
        if (this.m_localNodeName.equals(riNew.getNodeName())) {
            sameNode = true;
            while (riPrev != null && !riPrev.getBrokerName().equals(riNew.getBrokerName())) {
                riLast = riPrev;
                riPrev = riPrev.getNext();
            }
            if (riPrev == null) {
                if (this.DEBUG) {
                    this.debug("setRoute: Added a new local global: (" + riNew.getGlobalName() + ", " + riNew.getNodeName() + ", " + riNew.getBrokerName() + ")");
                }
                riNew.setNext(null);
                riLast.setNext(riNew);
                return ADD;
            }
        }
        if (riNew.getTimestamp().before(riPrev.getTimestamp())) {
            return IGNORE;
        }
        if (riNew.getTimestamp().equals(riPrev.getTimestamp()) && riNew.getHops() >= riPrev.getHops()) {
            return IGNORE;
        }
        if (!sameNode) {
            if (this.DEBUG) {
                this.debug("setRoute: Replaced a remote global: (" + riNew.getGlobalName() + ", " + riNew.getNodeName() + ")");
            }
            this.m_hash.put(hashName, riNew);
        } else {
            riNew.setNext(riPrev.getNext());
            if (riLast != null) {
                if (this.DEBUG) {
                    this.debug("setRoute: Replaced a local global: (" + riNew.getGlobalName() + ", " + riNew.getNodeName() + ", " + riNew.getBrokerName() + ")");
                }
                riLast.setNext(riNew);
            } else {
                if (this.DEBUG) {
                    this.debug("setRoute: Replaced a local global in the route table: (" + riNew.getGlobalName() + ", " + riNew.getNodeName() + ", " + riNew.getBrokerName() + ")");
                }
                this.m_hash.put(hashName, riNew);
            }
            riPrev = null;
        }
        return REPLACE;
    }

    public synchronized int removeRoute(RouteInfo ri, boolean removeAll) {
        RouteInfo riPrev;
        boolean sameNode = false;
        String hashName = ri.getHashName();
        RouteInfo riLast = null;
        if (riPrev != null) {
            if (this.m_localNodeName.equals(ri.getNodeName()) && !removeAll) {
                sameNode = true;
                riLast = null;
                for (riPrev = (RouteInfo)this.m_hash.get(hashName); riPrev != null && !riPrev.getBrokerName().equals(ri.getBrokerName()); riPrev = riPrev.getNext()) {
                    riLast = riPrev;
                }
                if (riPrev == null) {
                    if (this.DEBUG) {
                        this.debug("removeRoute: Didn't find a local global: (" + ri.getGlobalName() + ", " + ri.getNodeName() + ", " + ri.getBrokerName() + ")");
                    }
                    return IGNORE;
                }
            }
            if (!ri.getTimestamp().before(riPrev.getTimestamp())) {
                if (this.DEBUG && ri.getTimestamp().equals(riPrev.getTimestamp())) {
                    this.debug("***** removeRoute; same timestamp  " + ri.getNodeName() + " " + ri.getGlobalName() + " " + ri.getBrokerName() + "  ri.getTimestamp()= " + ri.getTimestamp().getTime() + " riPrev.getTimestamp()= " + riPrev.getTimestamp().getTime());
                }
                if (!sameNode) {
                    this.m_hash.remove(hashName);
                    if (this.DEBUG) {
                        this.debug("removeRoute: Removed a global: (" + ri.getGlobalName() + ", " + ri.getNodeName() + ")");
                    }
                    return REMOVE;
                }
                if (riLast != null) {
                    riLast.setNext(riPrev.getNext());
                    if (this.DEBUG) {
                        this.debug("removeRoute: Removed a local global (not first): (" + ri.getGlobalName() + ", " + ri.getNodeName() + ", " + ri.getBrokerName() + ")");
                    }
                } else {
                    RouteInfo newFirst = riPrev.getNext();
                    if (newFirst == null) {
                        this.m_hash.remove(hashName);
                        if (this.DEBUG) {
                            this.debug("removeRoute: Removed last instance of a local global: (" + ri.getGlobalName() + ", " + ri.getNodeName() + ", " + ri.getBrokerName() + ")");
                        }
                    } else {
                        this.m_hash.put(hashName, newFirst);
                        if (this.DEBUG) {
                            this.debug("removeRoute: Removed a local global (first instance): (" + ri.getGlobalName() + ", " + ri.getNodeName() + ", " + ri.getBrokerName() + "). New first instance: (" + newFirst.getGlobalName() + ", " + newFirst.getNodeName() + ", " + newFirst.getBrokerName() + ")");
                        }
                    }
                }
                return REMOVE;
            }
        }
        if (this.DEBUG) {
            if (riPrev != null) {
                this.debug("removeRoute: Ignored a global: (" + ri.getGlobalName() + ", " + ri.getNodeName() + ", " + ri.getBrokerName() + ")");
            } else {
                this.debug("removeRoute: Didn't find a global: (" + ri.getGlobalName() + ", " + ri.getNodeName() + ", " + ri.getBrokerName() + ")");
            }
        }
        return IGNORE;
    }

    private synchronized void updateFailedRoute(RouteInfo riNew, RouteInfo riFailed, RouteInfo riLast) {
        RouteInfo riNext = null;
        Object rnh = null;
        String hashName = riFailed.getHashName();
        riLast.setNext(riNew.getNext());
        if (this.DEBUG) {
            this.debug("updateFailedRoute: Switched from a failed instance of a local global: (" + riFailed.getGlobalName() + ", " + riFailed.getNodeName() + ", " + riFailed.getBrokerName() + ") to another instance: (" + riNew.getGlobalName() + ", " + riNew.getNodeName() + ", " + riNew.getBrokerName() + ")");
        }
        riNew.setNext(riFailed.getNext());
        this.m_hash.put(hashName, riNew);
        for (riNext = riNew; riNext != null; riNext = riNext.getNext()) {
            riLast = riNext;
        }
        riFailed.setNext(null);
        riLast.setNext(riFailed);
    }

    public synchronized RouteInfo getRoute(String hashName) {
        RouteInfo riCurrent = (RouteInfo)this.m_hash.get(hashName);
        if (riCurrent != null && riCurrent.getNodeName().equals(this.m_localNodeName)) {
            RouteInfo riNext;
            RouteNodeHolder rnh = null;
            RouteInfo riLast = null;
            for (riNext = riCurrent; riNext != null; riNext = riNext.getNext()) {
                rnh = riNext.getRemoteNode();
                if (rnh == null && (rnh = (RouteNodeHolder)this.m_nodeTable.get(riNext.getNodeName().concat(riNext.getBrokerName()))) != null) {
                    riNext.setRemoteNode(rnh);
                }
                if (rnh == null || !rnh.getFailed()) break;
                riLast = riNext;
            }
            if (riNext != null) {
                if (riNext != riCurrent) {
                    this.updateFailedRoute(riNext, riCurrent, riLast);
                }
                return riNext;
            }
            return riCurrent;
        }
        return riCurrent;
    }

    public Enumeration getAll() {
        return this.m_hash.elements();
    }
}

