/*
 * Decompiled with CFR 0.152.
 */
package progress.message.gr;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.security.pcs.AbstractCipherSuite;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentAdminConnection;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EUnknownLogEventType;
import progress.message.broker.GuarQAckDoneEvt;
import progress.message.broker.GuarQAckXchgEvt;
import progress.message.broker.IClientContext;
import progress.message.broker.INeighbor;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.InDoubtQMsgReenqueueEvt;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.LogEvent;
import progress.message.broker.LogManager;
import progress.message.broker.QueueMsgSendEvt;
import progress.message.broker.RoutingConfiguration;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.client.EConnectionLimitExceeded;
import progress.message.client.EGeneralException;
import progress.message.client.EInauthenticClient;
import progress.message.client.EInterrupted;
import progress.message.client.EUserAlreadyConnected;
import progress.message.db.EDatabaseException;
import progress.message.dbq.IRoutingDBQ;
import progress.message.ft.FTMgramFactory;
import progress.message.ft.FTReflectionOperation;
import progress.message.ft.ReplicationManager;
import progress.message.gr.ConvertToRouter;
import progress.message.gr.DRAInDoubtReconnectTask;
import progress.message.gr.EAlreadyConnecting;
import progress.message.gr.ERouterAuthenticationFailure;
import progress.message.gr.HttpOutboundHelper;
import progress.message.gr.RemoteBroker;
import progress.message.gr.RemoteBrokerHelper;
import progress.message.gr.RouteForwarder;
import progress.message.gr.RouterConnection;
import progress.message.gr.RouterListener;
import progress.message.gr.RouterSession;
import progress.message.gr.RoutingTargetFactory;
import progress.message.gr.SonicMQTargetFactory;
import progress.message.gr.prAccessor;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.Neighbor;
import progress.message.msg.IMgram;
import progress.message.resources.prMessageFormat;
import progress.message.security.SecurityBean;
import progress.message.util.ArrayUtil;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.LongHashTable;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.DebugThread;
import progress.message.zclient.EUnexpectedMgram;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.xonce.IMsgTracker;

public class RouterManager
extends DebugObject {
    private static final String GR_APPID_PREFIX = "GR$";
    private static final String GS_APPID_PREFIX = "GS$";
    private LongHashTable m_remoteBrokers = null;
    private LongHashTable m_connectingRemoteBrokers = null;
    private Object m_dummyObject;
    private RouterSession m_routerSession = null;
    private AgentRegistrar m_reg = null;
    private AgentAdminConnection m_aac = null;
    private RouteForwarder m_rtf = null;
    RoutingConfiguration m_rc = null;
    private LogManager m_logmgr = null;
    private BrokerDatabase m_brokerdb = null;
    private IRoutingDBQ m_routingDBQ = null;
    private InDoubtRetryQueue m_inDoubtBrokers = null;
    private boolean m_stopping = false;
    IMessageProtection m_mp = null;
    byte[] m_tempMessageKeyBuffer = null;
    private static final ThreadLocal<SimpleDateFormat> DATE_PARSER_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yy/MM/dd kk:mm:ss");
        }
    };
    InDoubtReconnect inDoubtReconnect = null;
    private HttpOutboundHelper m_httpHelper = null;
    private RoutingTargetFactory m_nonHTTPRoutingTargetFactory = null;
    private boolean DEBUG1 = (this.debugFlags & 0x40) > 0;

    public RouterManager(AgentRegistrar reg, LogManager logmgr, AgentAdminConnection aac) throws EDatabaseException {
        super(DebugState.GLOBAL_DEBUG_ON ? "RouterManager" : null);
        this.m_reg = reg;
        this.m_aac = aac;
        this.m_logmgr = logmgr;
        this.m_rc = this.m_reg.getRoutingConfig();
        this.m_remoteBrokers = new LongHashTable();
        this.m_connectingRemoteBrokers = new LongHashTable();
        this.m_dummyObject = new Object();
        this.m_inDoubtBrokers = new InDoubtRetryQueue();
        this.m_rtf = new RouteForwarder(this);
        this.m_httpHelper = new HttpOutboundHelper(this.m_reg, this);
        this.m_nonHTTPRoutingTargetFactory = new SonicMQTargetFactory(this, this.m_reg, null);
        if (Config.ENABLE_HTTP_DIRECT) {
            this.m_httpHelper.loadHttpRemoteBrokerFactoryFromDS(this.m_nonHTTPRoutingTargetFactory);
        }
        try {
            this.m_mp = AbstractCipherSuite.getNewMessageProtectionInstance();
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EAssertFailure(e);
        }
        this.m_tempMessageKeyBuffer = new byte[this.m_mp.getSecretKeyLength()];
    }

    public HttpOutboundHelper getHttpHelper() {
        return this.m_httpHelper;
    }

    public void loadRegisteredRemoterBrokersFromDataStore() throws EDatabaseException {
        this.m_brokerdb = this.m_reg.getBrokerDatabase();
        this.m_routingDBQ = this.m_brokerdb.getIRoutingDBQ();
        Vector list = this.m_routingDBQ.getRemoteBrokers();
        for (int i = 0; i < list.size(); ++i) {
            Object[] data = (Object[])list.elementAt(i);
            long cid = (Long)data[0];
            String url = (String)data[1];
            String ftPeerUrl = (String)data[2];
            String user = (String)data[3];
            String password = (String)data[4];
            String node = (String)data[5];
            String broker = (String)data[6];
            RemoteBroker rb = new RemoteBroker(this, cid, node, broker, url, ftPeerUrl, user, password);
            this.m_remoteBrokers.put(cid, rb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRemoteBroker(long cid) {
        LongHashTable longHashTable = this.m_remoteBrokers;
        synchronized (longHashTable) {
            this.m_remoteBrokers.remove(cid);
            if (!Broker.isInShutdown()) {
                try {
                    this.performDeleteRemoteBroker(cid);
                }
                catch (EDatabaseException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws EGeneralException {
        IRemoteBroker irb = null;
        this.m_routerSession = new RouterSession(this.m_aac);
        MessageHandler mh = new MessageHandler();
        mh.setName("RouterManager msg handler");
        mh.bind("$SYS.GR.CONVERT", (IMessageHandler)new ConvertToRouter(this.m_reg, this));
        this.m_aac.addMessageHandler(mh);
        mh.getSession().subscribe("$SYS.GR.CONVERT");
        mh.getSession().subscribe("$ISYS.GR.ACK_EXCHANGE");
        long inDoubtTime = System.currentTimeMillis();
        LongHashTable longHashTable = this.m_remoteBrokers;
        synchronized (longHashTable) {
            Enumeration<Long> enumeration = ((LongHashTable)this.m_remoteBrokers.clone()).keys();
            while (enumeration.hasMoreElements()) {
                long cid = enumeration.nextElement();
                irb = (IRemoteBroker)this.m_remoteBrokers.get(cid);
                if (!irb.hasInDoubtState()) {
                    this.m_remoteBrokers.remove(cid);
                    try {
                        this.performDeleteRemoteBroker(cid);
                    }
                    catch (EDatabaseException e) {}
                    continue;
                }
                irb.setInDoubtTime(inDoubtTime);
                this.m_inDoubtBrokers.addElement(irb, 0L);
            }
        }
        if (InterbrokerHook.isSet()) {
            INeighbor[] narray = Interbroker.getInterbroker().getAllNeighbors();
            for (int ii = 0; ii < narray.length; ++ii) {
                irb = (IRemoteBroker)((Object)narray[ii]);
                if (!irb.hasInDoubtState()) continue;
                irb.setInDoubtTime(inDoubtTime);
                this.m_inDoubtBrokers.addElement(irb, 0L);
            }
        }
    }

    private void performDeleteRemoteBroker(long cid) throws EDatabaseException {
        ReplicationManager mgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
        if (Config.REPLICATED && mgr.okToReplicate()) {
            FTReflectionOperation op = FTMgramFactory.createReflectionOperation();
            op.addMethod(3, "deleteRemoteBroker", IRoutingDBQ.s_addRemoteBrokerParams.toArray(new Class[0]), new Object[]{new Long(cid)});
            mgr.replicateFTRelectionOp(op);
        }
        this.m_routingDBQ.deleteRemoteBroker(cid);
    }

    public void startThreads() {
        this.m_stopping = false;
        this.inDoubtReconnect = new InDoubtReconnect();
        this.inDoubtReconnect.start();
    }

    public void stopThreads() {
        this.m_stopping = true;
        if (this.inDoubtReconnect != null) {
            this.inDoubtReconnect.shutdown();
        }
    }

    private void expireInDoubt(IRemoteBroker irb) throws InterruptedException {
        if (this.DEBUG) {
            this.debug("Expiring in-doubt messages for " + irb);
        }
        irb.expireInDoubt();
    }

    IRemoteBroker createRemoteBroker(RoutingConnectionInfo connectInfo, String pendingQueueName) {
        if (this.DEBUG) {
            this.debug("Constructing unregistered RemoteBroker for " + connectInfo);
        }
        if (Config.ENABLE_HTTP_DIRECT) {
            RoutingTargetFactory httpFactory = this.m_httpHelper.getTargetFactory();
            if (httpFactory == null) {
                return null;
            }
            return httpFactory.createRoutingTarget(connectInfo, pendingQueueName);
        }
        if (this.m_nonHTTPRoutingTargetFactory == null) {
            return null;
        }
        return this.m_nonHTTPRoutingTargetFactory.createRoutingTarget(connectInfo, pendingQueueName);
    }

    public synchronized void addConnectingBroker(long cid) throws EAlreadyConnecting {
        if (this.m_connectingRemoteBrokers.get(cid) != null) {
            throw new EAlreadyConnecting(String.valueOf(cid));
        }
        this.m_connectingRemoteBrokers.put(cid, this.m_dummyObject);
    }

    public synchronized void removeConnectingBroker(long cid) {
        this.m_connectingRemoteBrokers.remove(cid);
    }

    public String getUserIDForNode(String node, String myCertificateCommonName) {
        String userName = this.getUserIDForNode(node);
        return userName.equals("AUTHENTICATED") && !myCertificateCommonName.equals("") ? myCertificateCommonName : userName;
    }

    public String getUserIDForNode(String node) {
        RoutingConnectionInfo connectInfo = this.m_reg.getRoutingConfig().getRoutingConnection(node);
        if (connectInfo != null) {
            return connectInfo.getUserName();
        }
        return "AUTHENTICATED";
    }

    public String getPasswordForNode(String node) {
        RoutingConnectionInfo connectInfo = this.m_reg.getRoutingConfig().getRoutingConnection(node);
        if (connectInfo != null && !connectInfo.getUserName().equals("AUTHENTICATED")) {
            return connectInfo.getPassword();
        }
        return "";
    }

    public static String getLocalRouterAppID() {
        return RouterManager.getRouterAppID(Config.ROUTING_NODE_NAME, Config.BROKER_NAME);
    }

    public static String getRemoteNodeGSAppID(String node) {
        return RouterManager.getRouterAppID(node, "", GS_APPID_PREFIX);
    }

    public static String getRemoteBrokerGSAppID(String node, String broker) {
        return RouterManager.getRouterAppID(node, broker, GS_APPID_PREFIX);
    }

    public static String getRouterAppID(String node, String broker) {
        return RouterManager.getRouterAppID(node, broker, GR_APPID_PREFIX);
    }

    public static String getRouterAppID(String node, String broker, String prefix) {
        String validatedNodeName = RouterManager.validateNodeName(node);
        String appId = prefix + validatedNodeName + "$" + broker;
        return appId;
    }

    public static boolean isRouterAppID(String appID) {
        return appID.startsWith(GR_APPID_PREFIX);
    }

    public static boolean isRemoteNodeGSAppID(String appID) {
        int prefixLen;
        int endOfNodeName;
        return appID.startsWith(GS_APPID_PREFIX) && (endOfNodeName = appID.indexOf("$", prefixLen = GS_APPID_PREFIX.length())) != -1 && endOfNodeName + 1 == appID.length();
    }

    public static String getRemoteNodeFromGSAppID(String appID) {
        int prefixLen;
        int endOfNodeName;
        if (appID.startsWith(GS_APPID_PREFIX) && (endOfNodeName = appID.indexOf("$", prefixLen = GS_APPID_PREFIX.length())) != -1) {
            String nodeName = appID.substring(prefixLen, endOfNodeName);
            return nodeName.replace('\"', '.');
        }
        return null;
    }

    public static String getRemoteBrokerFromGSAppID(String appID) {
        return RouterManager.getRemoteBrokerFromAppID(appID);
    }

    public static String getRemoteBrokerFromAppID(String appID) {
        int startOfBrokerName;
        if ((appID.startsWith(GR_APPID_PREFIX) || appID.startsWith(GS_APPID_PREFIX)) && (startOfBrokerName = appID.lastIndexOf("$")) != -1) {
            if (++startOfBrokerName > appID.length() - 1) {
                return null;
            }
            return appID.substring(startOfBrokerName);
        }
        return null;
    }

    public static String getRemoteNodeFromGRAppID(String appID) {
        int prefixLen;
        int endOfNodeName;
        if (appID.startsWith(GR_APPID_PREFIX) && (endOfNodeName = appID.indexOf("$", prefixLen = GR_APPID_PREFIX.length())) != -1) {
            String nodeName = appID.substring(prefixLen, endOfNodeName);
            return nodeName.replace('\"', '.');
        }
        return null;
    }

    private static String validateNodeName(String nodeName) {
        String validatedNodeName = null;
        validatedNodeName = nodeName.indexOf(".") != -1 ? nodeName.replace('.', '\"') : nodeName;
        return validatedNodeName;
    }

    public long getRemoteNodeGSClientID(String remoteNode) {
        String appID = RouterManager.getRemoteNodeGSAppID(remoteNode);
        String userID = this.getGSUserID();
        return AddrUtil.stringToClientId(userID, appID);
    }

    public String getGSUserID() {
        return Config.BROKER_UID;
    }

    public String getGSPWD() {
        return Config.BROKER_PWD;
    }

    public long getRemoteBrokerGSClientID(String remoteNode, String remoteBroker) {
        String appID = RouterManager.getRemoteBrokerGSAppID(remoteNode, remoteBroker);
        String userID = this.getGSUserID();
        return AddrUtil.stringToClientId(userID, appID);
    }

    public RouteForwarder getRouteForwarder() {
        return this.m_rtf;
    }

    LogManager getLogManager() {
        return this.m_logmgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteBroker register(long cid, String url, String ftPeerUrl, String node, String broker, String userid, String password) {
        if (this.DEBUG) {
            this.debug("registering CID:" + cid + ", UID:" + userid + ", NODE:" + node + ", URL:" + url);
        }
        LongHashTable longHashTable = this.m_remoteBrokers;
        synchronized (longHashTable) {
            RemoteBroker old = (RemoteBroker)this.m_remoteBrokers.get(cid);
            if (old != null) {
                if (this.DEBUG) {
                    this.debug("CID:" + cid + " already registered as " + old);
                }
                old.update(url, userid, password);
                RemoteBrokerHelper.ConnectThreadMonitor monitorThread = AgentRegistrar.getAgentRegistrar().getQueueProc().getRemoteBrokerHelper().getConnectThreadMonitor();
                Boolean oldVal = null;
                if (monitorThread != null) {
                    oldVal = monitorThread.setOkToInterrupt(false);
                }
                try {
                    this.performUpdateRemoteBroker(cid, url, ftPeerUrl, node, broker, userid, password);
                }
                catch (EDatabaseException e) {
                }
                finally {
                    if (oldVal != null && oldVal.booleanValue()) {
                        monitorThread.setOkToInterrupt(true);
                    }
                }
                return old;
            }
            RemoteBroker remote = new RemoteBroker(this, cid, node, broker, url, ftPeerUrl, userid, password);
            this.m_remoteBrokers.put(cid, remote);
            RemoteBrokerHelper.ConnectThreadMonitor monitorThread = AgentRegistrar.getAgentRegistrar().getQueueProc().getRemoteBrokerHelper().getConnectThreadMonitor();
            Boolean oldVal = null;
            if (monitorThread != null) {
                oldVal = monitorThread.setOkToInterrupt(false);
            }
            try {
                this.performAddRemoteBroker(cid, url, ftPeerUrl, node, broker, userid, password);
            }
            catch (EDatabaseException e) {
            }
            finally {
                if (oldVal != null && oldVal.booleanValue()) {
                    monitorThread.setOkToInterrupt(true);
                }
            }
            return remote;
        }
    }

    private void performUpdateRemoteBroker(long cid, String url, String ftPeerURL, String node, String broker, String userid, String password) throws EDatabaseException {
        ReplicationManager mgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
        if (Config.REPLICATED && mgr.okToReplicate()) {
            FTReflectionOperation op = FTMgramFactory.createReflectionOperation();
            op.addMethod(3, "updateRemoteBroker", IRoutingDBQ.s_addRemoteBrokerParams.toArray(new Class[0]), new Object[]{new Long(cid), url, ftPeerURL, node, broker, userid, password});
            mgr.replicateFTRelectionOp(op);
        }
        this.m_routingDBQ.updateRemoteBroker(cid, url, ftPeerURL, node, broker, userid, password);
    }

    private void performAddRemoteBroker(long cid, String url, String ftPeerURL, String node, String broker, String userid, String password) throws EDatabaseException {
        ReplicationManager mgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
        if (Config.REPLICATED && mgr.okToReplicate()) {
            if (this.DEBUG) {
                this.debug("performAddRemoteBroker okToReplicate CID:" + cid + ", UID:" + userid + ", NODE:" + node + ", URL:" + url);
            }
            FTReflectionOperation op = FTMgramFactory.createReflectionOperation();
            op.addMethod(3, "addRemoteBroker", IRoutingDBQ.s_addRemoteBrokerParams.toArray(new Class[0]), new Object[]{new Long(cid), url, ftPeerURL, node, broker, userid, password});
            mgr.replicateFTRelectionOp(op);
        }
        this.m_routingDBQ.addRemoteBroker(cid, url, ftPeerURL, node, broker, userid, password);
    }

    public boolean checkNodePermission(String user, String node) {
        SecurityBean secBean = this.m_reg.getSecurityBean();
        ProgressPasswordUser ppu = secBean.getUser(user);
        if (ppu == null) {
            return false;
        }
        return secBean.isRoutingUserAuthorized(node, ppu);
    }

    RouterSession getRouterSession() {
        return this.m_routerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteBroker getRemoteBroker(long cid) {
        LongHashTable longHashTable = this.m_remoteBrokers;
        synchronized (longHashTable) {
            return (RemoteBroker)this.m_remoteBrokers.get(cid);
        }
    }

    public Object getRBRegistrySyncObj() {
        return this.m_remoteBrokers;
    }

    public Enumeration getAllRemoteBrokers() {
        return ((LongHashTable)this.m_remoteBrokers.clone()).elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRemoteBroker(long cid) {
        LongHashTable longHashTable = this.m_remoteBrokers;
        synchronized (longHashTable) {
            return this.m_remoteBrokers.get(cid) != null;
        }
    }

    public void onConvertMgram(AgentConnection conn, IMgram convertMgram) throws EUnexpectedMgram {
        long code;
        try {
            code = ArrayUtil.readLong(convertMgram.getRawBody(), 0);
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        switch ((int)code) {
            case 0: {
                if (this.DEBUG) {
                    this.debug("Received initial GR_CONVERT mgram");
                }
                this.initConvert(conn, convertMgram);
                break;
            }
            case 1: {
                if (this.DEBUG) {
                    this.debug("Received final GR_CONVERT mgram");
                }
                this.finalConvert(conn, convertMgram);
                if (!this.DEBUG) break;
                this.debug("Processed final GR_CONVERT mgram");
                break;
            }
            default: {
                throw new EUnexpectedMgram(convertMgram);
            }
        }
    }

    private void initConvert(AgentConnection old_con, IMgram convertMgram) throws EUnexpectedMgram {
        try {
            long token;
            RemoteBroker remote;
            long cid = old_con.getSecurityContext(convertMgram.getChannel()).getClientId();
            int channel = old_con.getChannel(cid);
            if (this.DEBUG) {
                this.debug("received GR_CONVERT_TYPE mgram from CID:" + cid);
            }
            if ((remote = (RemoteBroker)this.getRemoteBroker(cid)) == null) {
                return;
            }
            if (this.DEBUG) {
                this.debug("converting " + remote);
            }
            try {
                token = ArrayUtil.readLong(convertMgram.getRawBody(), 16);
            }
            catch (IndexOutOfBoundsException e) {
                return;
            }
            boolean ok = remote.okToConvert(token);
            if (this.DEBUG) {
                this.debug(remote.toString() + " OK = " + ok);
            }
            if (ok) {
                if (this.DEBUG) {
                    this.debug("Converting connection from " + remote + " to routing connection");
                }
                RouterConnection new_con = null;
                try {
                    new_con = new RouterConnection(old_con.getSocket(), remote);
                }
                catch (IOException e) {
                    if (this.DEBUG) {
                        this.debug("Could not accept connection from " + remote + ": " + e);
                        BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                    }
                    old_con.close();
                    if (this.DEBUG) {
                        this.debug("Closed incoming AgentConnection for " + cid);
                    }
                    return;
                }
                if (this.DEBUG) {
                    this.debug("Passive convert created " + new_con.getListener() + " for " + remote);
                }
                new_con.setPartnerProductVersion(old_con.getPartnerProductVersion());
                new_con.setAcceptorName(old_con.getAcceptorName());
                new_con.setAcceptorUrl(old_con.getAcceptorUrl());
                new_con.setRemoteBroker(remote.getClientID());
                RouterListener listener = (RouterListener)new_con.getAgentListener();
                listener.setClientSessionVer(old_con.getAgentListener().getClientSessionVer());
                new_con.setNegotiatedConnectParms(old_con.getNegotiatedConnectParms());
                byte version = old_con.getAgentSender().getClientMgramVersion();
                listener.setClientMgramVer(version);
                new_con.getAgentSender().setClientMgramVersion(version);
                new_con.getAgentListener().copyInputStreams(old_con.getAgentListener());
                RoutingConnectionInfo connectInfo = null;
                connectInfo = this.m_reg.getRoutingConfig().getRoutingConnection(remote.getNodeName());
                if (connectInfo != null) {
                    new_con.setIdleTimeout(connectInfo.getTimeout());
                } else {
                    new_con.setIdleTimeout(Config.CONNECT_IDLE_TIMEOUT);
                }
                ClientSecurityContext csc = (ClientSecurityContext)old_con.getSecurityContext(convertMgram.getChannel()).clone();
                new_con.connectSuccess(channel, csc, csc.getClientId());
                try {
                    new_con.checkLimits(0, csc.getAppid(), csc);
                }
                catch (EConnectionLimitExceeded ecle) {
                    // empty catch block
                }
                new_con.getAgentListener().setCommonSecurityContext(csc);
                if (Config.ENABLE_QOPSECURITY) {
                    new_con.getAgentSender().initMessageProtection(csc.getSessionKey());
                }
                try {
                    if (this.DEBUG) {
                        this.debug("Returning GR_CONVERT_TYPE mgram to " + remote);
                    }
                    this.m_reg.getClient(cid).sendThrough(convertMgram);
                    if (this.DEBUG) {
                        this.debug("GR_CONVERT_TYPE returned to " + remote);
                    }
                    this.m_reg.prepareDisconnect(cid, 4);
                    this.m_reg.disconnect(cid, true);
                    if (this.DEBUG) {
                        this.debug("Disconnected initial connection for " + remote + "(cid=" + cid + ")");
                    }
                    long id = remote.getClientID();
                    if (this.DEBUG) {
                        this.debug("Attempting to connect " + remote + " as " + id);
                    }
                    try {
                        this.m_reg.connect(id, new_con, false);
                    }
                    catch (InterruptedException e) {
                        throw new EInterrupted();
                    }
                    IClientContext cc = this.m_reg.getClient(id);
                    cc.setRemoteBroker();
                }
                catch (EClientNotRegistered e) {
                    if (this.DEBUG) {
                        this.debug("Could not accept connection from " + remote + ": " + e);
                        BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                    }
                    old_con.close();
                    new_con.close();
                    throw new ThreadDeath();
                }
                catch (EGeneralException e) {
                    if (this.DEBUG) {
                        this.debug("Could not accept connection from " + remote + ": " + e);
                        BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                    }
                    old_con.close();
                    new_con.close();
                    throw new ThreadDeath();
                }
                if (this.DEBUG) {
                    this.debug("Passive convert starting " + new_con.getListener() + " for " + remote);
                }
                new_con.startListener();
                if (this.DEBUG) {
                    this.debug("Processed initial GR_CONVERT mgram - throwing ThreadDeath");
                }
                throw new ThreadDeath();
            }
            throw new EUnexpectedMgram(convertMgram);
        }
        catch (RuntimeException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalConvert(AgentConnection new_conn, IMgram convertMgram) throws EUnexpectedMgram {
        block8: {
            RemoteBroker remote = null;
            try {
                long id;
                try {
                    id = ArrayUtil.readLong(convertMgram.getRawBody(), 8);
                }
                catch (IndexOutOfBoundsException e) {
                    return;
                }
                remote = (RemoteBroker)this.getRemoteBroker(id);
                IClientContext cc = this.m_reg.lockContext(id);
                if (cc == null) break block8;
                try {
                    if (this.DEBUG) {
                        this.debug("postConnect()ing ID:" + id + " with " + cc);
                    }
                    this.m_reg.postConnect(id, cc.getChannel());
                    remote.setClientContext(cc);
                    this.removeConnectingBroker(remote.getClientID());
                    new_conn.unsetRemoteBroker(remote.getClientID());
                    Object[] obj = new Object[]{Config.ROUTING_NODE_NAME, Config.BROKER_NAME, remote.getNodeName(), remote.getBrokerName(), DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                    BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RTCONN_ACCEPTED"), obj), 3);
                    this.m_rtf.onNewConnection(remote, true);
                    cc.startDelivery(null);
                    this.m_reg.getGSManager().onNewConnection(remote, true);
                }
                finally {
                    cc.unlock();
                }
            }
            catch (Exception e) {
                if (!this.DEBUG) break block8;
                this.debug("Unable to start new sender: " + e);
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }

    public void onRouteInfoMgram(AgentConnection conn, IMgram routeInfoMgram) throws EUnexpectedMgram {
        long cid = conn.getClientId(routeInfoMgram.getChannel());
        IRemoteBroker remote = this.getRemoteBroker(cid);
        if (remote == null) {
            if (InterbrokerHook.isSet()) {
                remote = Interbroker.getInterbroker().getNeighborByID(cid);
            }
            if (remote == null) {
                throw new EUnexpectedMgram(routeInfoMgram);
            }
        }
        if (this.DEBUG) {
            this.debug("GR_ROUTEINFO_TYPE received from " + remote + " on " + conn);
        }
        this.m_rtf.onMgram(remote, routeInfoMgram);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(long cid, int reason) {
        RemoteBroker rb = null;
        LongHashTable longHashTable = this.m_remoteBrokers;
        synchronized (longHashTable) {
            this.removeConnectingBroker(cid);
            rb = (RemoteBroker)this.m_remoteBrokers.get(cid);
            if (rb != null) {
                Object[] obj;
                if (this.DEBUG) {
                    this.debug(rb.toString() + " disconnecting.");
                }
                rb.disconnect(reason);
                if (reason == 3) {
                    obj = new Object[]{Config.ROUTING_NODE_NAME, Config.BROKER_NAME, rb.getNodeName(), rb.getBrokerName(), DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                    BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RTCONN_IDLE_TIMEOUT"), obj), 3);
                } else if (reason == 2) {
                    obj = new Object[]{rb.getNodeName(), rb.getBrokerName(), Config.ROUTING_NODE_NAME, Config.BROKER_NAME, DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                    BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RTCONN_IDLE_TIMEOUT"), obj), 3);
                } else if (reason == 1) {
                    obj = new Object[]{rb.getNodeName(), rb.getBrokerName(), Config.ROUTING_NODE_NAME, Config.BROKER_NAME, DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                    BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RTCONN_PEER_DISCONNECT"), obj), 3);
                } else {
                    obj = new Object[]{Config.ROUTING_NODE_NAME, Config.BROKER_NAME, rb.getNodeName(), rb.getBrokerName(), DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                    BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RTCONN_LOST"), obj), 2);
                    this.m_reg.getGSManager().onFailedConnection(rb);
                }
                boolean interrupted = false;
                if (rb.isRouteDeleted()) {
                    if (this.DEBUG) {
                        this.debug("default route not available - clear in-doubt state for remote broker " + rb);
                    }
                    rb.allXOnceQAcksDone();
                    rb.setInDoubtTime(System.currentTimeMillis() - Config.INDOUBT_TIMEOUT);
                    try {
                        this.expireInDoubt(rb);
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                    }
                }
                if (rb.hasInDoubtState()) {
                    if (this.DEBUG) {
                        this.debug("In-doubt state pending: " + rb);
                    }
                    rb.setInDoubtTime(System.currentTimeMillis());
                    this.m_inDoubtBrokers.addElement(rb, 0L);
                } else {
                    if (!Broker.isInShutdown()) {
                        try {
                            this.performDeleteRemoteBroker(cid);
                        }
                        catch (EDatabaseException e) {
                            // empty catch block
                        }
                    }
                    this.m_remoteBrokers.remove(cid);
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
        }
        if (InterbrokerHook.isSet()) {
            Neighbor n = Interbroker.getInterbroker().getNeighborByID(cid);
            if (n != null && n.hasInDoubtState()) {
                if (this.DEBUG) {
                    this.debug("In-doubt state pending: " + n);
                }
                n.setInDoubtTime(System.currentTimeMillis());
                this.m_inDoubtBrokers.addElement(n, 0L);
            } else if (n == null && this.DEBUG) {
                this.debug("CID:" + cid + " not registered as a routing broker");
            }
            return;
        }
        if (this.DEBUG) {
            this.debug("CID:" + cid + " not registered as a routing broker");
        }
    }

    public static LogEvent constructGRLogEvent(short type) throws EUnknownLogEventType {
        switch (type) {
            case 26: 
            case 76: {
                return new QueueMsgSendEvt(type);
            }
            case 28: {
                return new GuarQAckDoneEvt();
            }
            case 29: {
                return new GuarQAckXchgEvt();
            }
            case 30: {
                return new InDoubtQMsgReenqueueEvt();
            }
        }
        throw new EUnknownLogEventType(String.valueOf(type));
    }

    public void sendingGuarQAck(long ackTracking, long brokerId, long msgTracking) {
        RemoteBroker broker = (RemoteBroker)this.getRemoteBroker(brokerId);
        if (broker != null) {
            broker.addGuarQAck(ackTracking, msgTracking);
        }
    }

    public void xOnceQMsgReceived(long senderID, long tracking, IMsgTracker tracker) {
        RemoteBroker broker = (RemoteBroker)this.getRemoteBroker(senderID);
        if (broker != null) {
            broker.xOnceQMsgReceived(tracking, tracker);
        }
    }

    public void setMsgInDoubt(long receiverID, long tracking) {
        RemoteBroker broker = (RemoteBroker)this.getRemoteBroker(receiverID);
        this.m_reg.getQMsgStateMgr().addInDoubtMsg(tracking);
        if (broker != null) {
            broker.setQMsgInDoubt(tracking);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInDoubtReconnect(IRemoteBroker irb) throws InterruptedException {
        RemoteBroker rb;
        if (!irb.isNeighbor() && this.m_rc.getRoutingConnection((rb = (RemoteBroker)irb).getNodeName()) == null) {
            if (this.DEBUG) {
                this.debug("default route not available - clear in-doubt state for remote broker " + rb);
            }
            rb.allXOnceQAcksDone();
            rb.setInDoubtTime(System.currentTimeMillis() - Config.INDOUBT_TIMEOUT);
            this.expireInDoubt(rb);
            if (!rb.hasInDoubtState()) {
                this.deleteRemoteBroker(rb.getClientID());
            }
            return;
        }
        RemoteBrokerHelper.ConnectThreadMonitor monitorThread = AgentRegistrar.getAgentRegistrar().getQueueProc().getRemoteBrokerHelper().getConnectThreadMonitor();
        if (!irb.hasInDoubtState()) {
            return;
        }
        long inDoubtTime = irb.getInDoubtTime();
        long elapsed = System.currentTimeMillis() - inDoubtTime;
        if (this.DEBUG) {
            this.debug("handleInDoubtReconnect: inDoubtTime= " + new Date(inDoubtTime) + " elapsed= " + elapsed + " irb= " + irb);
        }
        if (inDoubtTime != 0L && elapsed >= Config.INDOUBT_TIMEOUT) {
            if (this.DEBUG) {
                this.debug("Expiring in doubt messages");
            }
            this.expireInDoubt(irb);
        }
        if (!irb.isNeighbor()) {
            if (!irb.isConnected() && !irb.isConnecting()) {
                if (Config.DISABLE_INDOUBT_RECONNECT) {
                    Thread.sleep(Config.INDOUBT_RECONNECT_INTERVAL);
                } else {
                    RemoteBroker rb2 = (RemoteBroker)irb;
                    if (this.DEBUG) {
                        this.debug("Attempting reconnect to " + irb);
                    }
                    try {
                        if (monitorThread != null) {
                            monitorThread.setMonitor(MessageFormat.format(prAccessor.getString("RTINDOUBT_SET_MON"), rb2.getNodeName()));
                        } else if (this.checkDebugFlags(64)) {
                            this.debug("DRA Monitor thread is null");
                        }
                        try {
                            rb2.reconnect(this.m_reg, true);
                        }
                        finally {
                            if (monitorThread != null) {
                                monitorThread.unsetMonitor();
                            }
                        }
                        if (this.DEBUG) {
                            this.debug("Reconnect successful: " + rb2);
                        }
                        if (rb2.hasInDoubtState()) {
                            this.m_inDoubtBrokers.addElement(rb2, Config.INDOUBT_RECONNECT_INTERVAL);
                        }
                    }
                    catch (EInauthenticClient e) {
                        if (this.DEBUG) {
                            this.debug("Connection failure: " + e.getMessage());
                            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                        }
                        String user = rb2.getUserID();
                        Object[] obj = new Object[]{user == null ? "<unspecified user>" : user, DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                        String msg = prAccessor.getString("RBUSER_NOT_FOUND");
                        BrokerComponent.getComponentContext().logMessage(prMessageFormat.format(msg, obj), 2);
                        this.m_inDoubtBrokers.addElement(rb2, Config.INDOUBT_RECONNECT_INTERVAL);
                        this.m_reg.getGSManager().onFailedConnectInitiation(rb2);
                    }
                    catch (ERouterAuthenticationFailure e) {
                        if (this.DEBUG) {
                            this.debug("Connection failure: " + e.getMessage());
                            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                        }
                        String node = rb2.getNodeName() != null ? rb2.getNodeName() : "<unspecified node>";
                        String uid = rb2.getUserID() != null ? rb2.getUserID() : "<unspecified uid>";
                        Object[] obj = new Object[]{uid, node, DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                        BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RTAUTH_NODE_PERMISSION_REMOTE"), obj), 2);
                        this.m_inDoubtBrokers.addElement(rb2, Config.INDOUBT_RECONNECT_INTERVAL);
                        this.m_reg.getGSManager().onFailedConnectInitiation(rb2);
                    }
                    catch (EAlreadyConnecting ace) {
                        if (this.DEBUG) {
                            this.debug("In-Doubt broker connected or pending connect, putting back on list: " + irb);
                        }
                        this.m_inDoubtBrokers.addElement(irb, Config.INDOUBT_RECONNECT_INTERVAL);
                    }
                    catch (EUserAlreadyConnected uace) {
                        if (this.DEBUG) {
                            this.debug("In-Doubt broker connected or pending connect, putting back on list: " + irb);
                        }
                        this.m_inDoubtBrokers.addElement(irb, 1000L);
                    }
                    catch (EGeneralException e) {
                        if (e instanceof EInterrupted && this.m_stopping) {
                            throw new InterruptedException();
                        }
                        this.m_inDoubtBrokers.addElement(rb2, Config.INDOUBT_RECONNECT_INTERVAL);
                        this.m_reg.getGSManager().onFailedConnectInitiation(rb2);
                        if (this.DEBUG) {
                            this.debug("Connection failure: " + e.getMessage());
                            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                        }
                        String node = rb2.getNodeName() != null ? rb2.getNodeName() : "<unspecified node>";
                        String broker = rb2.getBrokerName() != null ? rb2.getBrokerName() : "<unspecified broker>";
                        Object[] obj = new Object[]{DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis())), Config.ROUTING_NODE_NAME, Config.BROKER_NAME, node, broker, e.getMessage()};
                        BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("INDOUBT_RECONN_FAILURE"), obj), 2);
                    }
                }
            } else {
                if (this.DEBUG) {
                    this.debug("In-Doubt broker connected or pending connect, putting back on list: " + irb);
                }
                this.m_inDoubtBrokers.addElement(irb, 1000L);
            }
        } else {
            if (this.DEBUG) {
                this.debug("In-Doubt broker is a Neighbor, putting back on list: " + irb);
            }
            this.m_inDoubtBrokers.addElement(irb, Config.INDOUBT_RECONNECT_INTERVAL);
        }
    }

    void prepareForIdleTimeout(IRemoteBroker irb) {
        RemoteBroker rb;
        if (irb != null && !irb.isHttp() && !irb.isNeighbor() && (rb = (RemoteBroker)irb).isRegistered() && rb.isConnected()) {
            IClientContext cc = rb.getCC();
            AgentConnection ac = null;
            if (cc != null && cc.isConnected() && (ac = cc.getConnection()) != null) {
                int idletm = ac.getIdleTimeout();
                int newidletm = 30;
                if (Config.BROKER_PING_INTERVAL > 0 && Config.BROKER_PING_INTERVAL < newidletm) {
                    newidletm = Config.BROKER_PING_INTERVAL;
                }
                if (Config.CONNECT_ATTEMPT_INTERVAL > 0L && Config.CONNECT_ATTEMPT_INTERVAL < (long)newidletm) {
                    newidletm = (int)Config.CONNECT_ATTEMPT_INTERVAL;
                }
                if (Config.CONNECT_RETRY_INTERVAL > 0L && Config.CONNECT_RETRY_INTERVAL < (long)newidletm) {
                    newidletm = (int)Config.CONNECT_RETRY_INTERVAL;
                }
                newidletm = (newidletm + 1) / 2;
                if (idletm > 0) {
                    newidletm = Math.min(newidletm, idletm);
                }
                if (this.DEBUG1) {
                    this.debug("Setting idle timeout to : " + newidletm + " oldidletm= " + idletm + " rb= " + rb);
                }
                ac.setIdleTimeout(newidletm);
            }
        }
    }

    private class InDoubtRetryQueue {
        ArrayList m_remoteBrokers = new ArrayList();
        ArrayList m_nextRetryTimes = new ArrayList();

        InDoubtRetryQueue() {
        }

        synchronized void addElement(IRemoteBroker irb, long delay) {
            long newRetry = System.currentTimeMillis() + delay;
            if (this.m_nextRetryTimes.isEmpty()) {
                this.m_nextRetryTimes.add(new Long(newRetry));
                this.m_remoteBrokers.add(irb);
                this.notifyAll();
                return;
            }
            Long farthest = (Long)this.m_nextRetryTimes.get(this.m_nextRetryTimes.size() - 1);
            if (newRetry >= farthest) {
                this.m_nextRetryTimes.add(new Long(newRetry));
                this.m_remoteBrokers.add(irb);
                this.notifyAll();
                return;
            }
            for (int i = 0; i < this.m_nextRetryTimes.size(); ++i) {
                long retryTime = (Long)this.m_nextRetryTimes.get(i);
                if (newRetry >= retryTime) continue;
                this.m_nextRetryTimes.add(i, new Long(newRetry));
                this.m_remoteBrokers.add(i, irb);
                this.notifyAll();
                return;
            }
        }

        synchronized IRemoteBroker waitNextRetry() throws InterruptedException {
            IRemoteBroker irb = null;
            while (!Broker.exiting) {
                long waitTime = 0L;
                if (!this.m_nextRetryTimes.isEmpty()) {
                    long now = System.currentTimeMillis();
                    long nextRetryTime = (Long)this.m_nextRetryTimes.get(0);
                    if (nextRetryTime <= now) {
                        irb = (IRemoteBroker)this.m_remoteBrokers.remove(0);
                        this.m_nextRetryTimes.remove(0);
                        break;
                    }
                    waitTime = nextRetryTime - now;
                }
                this.wait(waitTime);
            }
            return irb;
        }
    }

    private class InDoubtReconnect
    extends DebugThread {
        private boolean DEBUG1;

        InDoubtReconnect() {
            super("InDoubtReconnect");
            boolean bl = this.DEBUG1 = (this.debugFlags & 0x40) > 0;
            if (this.DEBUG1) {
                this.debug("Constructed; sync= " + RemoteBrokerHelper.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadMain() {
            RemoteBrokerHelper rbh = AgentRegistrar.getAgentRegistrar().getQueueProc().getRemoteBrokerHelper();
            if (this.DEBUG) {
                this.debug("Starting... ");
            }
            try {
                long numTasks = 0L;
                long numLoops = 0L;
                long oldNumTasks = 0L;
                while (!Broker.exiting && !this.isInterrupted()) {
                    if (this.DEBUG1 && numTasks != oldNumTasks) {
                        this.debug("Starting loop.... numLoops= " + numLoops + " numTasks= " + numTasks);
                        oldNumTasks = numTasks;
                    }
                    IRemoteBroker irb = RouterManager.this.m_inDoubtBrokers.waitNextRetry();
                    if (Broker.exiting) {
                        break;
                    }
                    if (this.DEBUG) {
                        this.debug("Got in-doubt RemoteBroker: " + irb);
                    }
                    if (!irb.hasInDoubtState()) {
                        if (!this.DEBUG) continue;
                        this.debug("No in-doubt state remaining: " + irb);
                        continue;
                    }
                    DRAInDoubtReconnectTask reconnectTask = new DRAInDoubtReconnectTask(irb);
                    if (rbh.submitDRATask(reconnectTask)) {
                        if (this.DEBUG) {
                            this.debug("Added reconnectTask task for " + irb);
                        }
                        if (!RemoteBrokerHelper.sync) continue;
                        reconnectTask.waitForCompletion();
                        continue;
                    }
                    RouterManager.this.m_inDoubtBrokers.addElement(irb, 1000L);
                    if (!this.DEBUG1) continue;
                    this.debug("ReconnectTask task not added for " + irb + " added reconnect retry");
                }
            }
            catch (InterruptedException ie) {
                return;
            }
            finally {
                if (this.DEBUG) {
                    this.debug("threadMain: thread exiting, broker exiting = " + Broker.exiting);
                }
            }
        }
    }
}

