/*
 * Decompiled with CFR 0.152.
 */
package progress.message.gr;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.gr.RouterManager;
import progress.message.gr.prAccessor;
import progress.message.resources.prMessageFormat;

public abstract class RoutingTargetFactory {
    protected RouterManager m_routerManager;
    protected AgentRegistrar m_agentRegistrar;
    protected RoutingTargetFactory m_successor;
    protected Properties m_properties;
    private static final ThreadLocal<SimpleDateFormat> DATE_PARSER_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yy/MM/dd kk:mm:ss");
        }
    };

    public RoutingTargetFactory(RouterManager rmg, AgentRegistrar reg, Properties properties, RoutingTargetFactory next) {
        this.m_routerManager = rmg;
        this.m_agentRegistrar = reg;
        this.m_successor = next;
        this.m_properties = new Properties();
    }

    public RoutingTargetFactory(RouterManager rmg, AgentRegistrar reg, String propFile, RoutingTargetFactory next) {
        this.m_routerManager = rmg;
        this.m_agentRegistrar = reg;
        this.m_successor = next;
        if (propFile != null) {
            this.m_properties = new Properties();
            try {
                this.m_properties.load(new FileInputStream(propFile));
            }
            catch (FileNotFoundException fnfe) {
                Object[] obj = new Object[]{propFile, DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                String msg = prAccessor.getString("RTFACT_PROPFILE_NOT_FOUND");
                BrokerComponent.getComponentContext().logMessage(prMessageFormat.format(msg, obj), 2);
                this.m_properties = null;
            }
            catch (IOException ioe) {
                Object[] obj = new Object[]{propFile, DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                String msg = prAccessor.getString("RTFACT_PROPFILE_READ_ERROR");
                BrokerComponent.getComponentContext().logMessage(prMessageFormat.format(msg, obj), 2);
                this.m_properties = null;
            }
        }
    }

    public IRemoteBroker createRoutingTarget(RoutingConnectionInfo connectInfo, String pendingQueueName) {
        IRemoteBroker irb = null;
        irb = this.create(connectInfo, pendingQueueName);
        if (irb == null && this.m_successor != null) {
            irb = this.m_successor.createRoutingTarget(connectInfo, pendingQueueName);
        }
        return irb;
    }

    protected abstract IRemoteBroker create(RoutingConnectionInfo var1, String var2);
}

