/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.Config;
import progress.message.client.EGeneralException;
import progress.message.interbroker.CWADSEvent;
import progress.message.interbroker.IBSubscription;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.InterbrokerConfig;
import progress.message.interbroker.Neighbor;
import progress.message.interbroker.prAccessor;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;

class CollectiveGroup {
    private static Interbroker s_ib = Interbroker.getInterbroker();
    private String m_name;
    private Neighbor[] m_members;
    private Neighbor[] m_actives = new Neighbor[0];
    private Hashtable m_subscriptions = new Hashtable();
    private long m_creationVTime;

    CollectiveGroup(String name, Vector members) {
        this(name);
        int length = members.size();
        this.m_members = new Neighbor[length];
        for (int i = 0; i < length; ++i) {
            Neighbor n = (Neighbor)members.elementAt(i);
            n.setGroup(this);
            this.m_members[i] = n;
        }
    }

    CollectiveGroup(String name) {
        this.m_name = name;
        this.m_members = new Neighbor[0];
        this.m_creationVTime = Interbroker.getInterbroker().getVTime();
        Label lab = new Label();
        this.addSubscription(new Subject(SessionConfig.getDirectedSubject("*", "*", "*", Config.BROKER_UID, "*") + ".#"), lab);
        this.addSubscription(new Subject(SessionConfig.getDirectedSubject("*", "*", "*", Config.BROKER_UID, "*")), lab);
    }

    String getName() {
        return this.m_name;
    }

    long getCreationVTime() {
        return this.m_creationVTime;
    }

    void addNeighbor(Neighbor n) {
        n.setGroup(this);
        this.m_members = CollectiveGroup.appendToArray(this.m_members, n);
    }

    void removeNeighbor(Neighbor n) {
        this.m_members = CollectiveGroup.removeFromArray(this.m_members, n);
    }

    final void addSubscription(ISubject subject, Label label) {
        IBSubscription sub = (IBSubscription)this.m_subscriptions.get(subject);
        if (sub == null) {
            sub = new IBSubscription(subject);
            this.m_subscriptions.put(subject, sub);
        }
        this.doProxySubscribeOp(sub.addRef(label), sub);
    }

    void removeSubscription(ISubject subject, Label label) {
        IBSubscription sub = (IBSubscription)this.m_subscriptions.get(subject);
        if (sub == null) {
            String mf99 = prAccessor.getString("STR002");
            Object[] ob99 = new Object[]{this, subject};
            throw new EAssertFailure(MessageFormat.format(mf99, ob99));
        }
        this.doProxySubscribeOp(sub.removeRef(label), sub);
    }

    void updateSubscription(ISubject subject, Label fromLabel, Label toLabel) {
        IBSubscription sub = (IBSubscription)this.m_subscriptions.get(subject);
        if (sub == null) {
            String mf150 = prAccessor.getString("STR004");
            Object[] ob150 = new Object[]{this, subject};
            throw new EAssertFailure(MessageFormat.format(mf150, ob150));
        }
        this.doProxySubscribeOp(sub.updateRef(fromLabel, toLabel), sub);
    }

    void sendCWADSEvent(CWADSEvent ce) throws EGeneralException {
        this.doCWADSUpdateOp(ce);
    }

    Enumeration getSubscriptions() {
        return this.m_subscriptions.elements();
    }

    private void doProxySubscribeOp(int op, IBSubscription sub) {
        try {
            ISubject subject = sub.getSubject();
            switch (op) {
                case 1: 
                case 3: {
                    Label lab = sub.getLabel();
                    for (int i = 0; i < this.m_actives.length; ++i) {
                        if (InterbrokerConfig.DEBUG) {
                            System.out.println("Subscribing to " + subject + " at " + this.m_actives[i]);
                        }
                        s_ib.getIBSession().proxySubscribe(this.m_actives[i].getID(), subject, lab);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.m_actives.length; ++i) {
                        if (InterbrokerConfig.DEBUG) {
                            System.out.println("Unubscribing from " + subject + " at " + this.m_actives[i]);
                        }
                        s_ib.getIBSession().proxyUnsubscribe(this.m_actives[i].getID(), subject);
                    }
                    this.m_subscriptions.remove(subject);
                }
            }
        }
        catch (EGeneralException e) {
            String mf212 = prAccessor.getString("STR006");
            Object[] ob212 = new Object[]{Integer.toString(op), sub.getSubject().getSubjectString(), e};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(mf212, ob212), (Throwable)e, 2);
        }
    }

    private void doCWADSUpdateOp(CWADSEvent ce) throws EGeneralException {
        for (int i = 0; i < this.m_actives.length; ++i) {
            if (InterbrokerConfig.DEBUG) {
                System.out.println("sending CWADS subscription update to " + this.m_actives[i]);
            }
            s_ib.getIBSession().notifyCWADSUpdate(this.m_actives[i].getID(), ce);
        }
    }

    boolean isInGroup(long id) {
        int i = this.m_members.length;
        while (i-- != 0) {
            if (this.m_members[i].getID() != id) continue;
            return true;
        }
        return false;
    }

    void activate(Neighbor ibc) {
        this.m_actives = CollectiveGroup.appendToArray(this.m_actives, ibc);
    }

    void deactivate(Neighbor n) {
        this.m_actives = CollectiveGroup.removeFromArray(this.m_actives, n);
    }

    Neighbor[] getMembers() {
        return this.m_members;
    }

    Neighbor[] getActiveMembers() {
        return this.m_actives;
    }

    public String toString() {
        String str = new String("Cluster " + this.m_name);
        return str;
    }

    static Neighbor[] appendToArray(Neighbor[] array, Neighbor ibc) {
        Neighbor[] tmp = new Neighbor[array.length + 1];
        System.arraycopy(array, 0, tmp, 0, array.length);
        tmp[array.length] = ibc;
        return tmp;
    }

    static Neighbor[] removeFromArray(Neighbor[] array, Neighbor n) {
        int i;
        Neighbor[] tmp = array;
        for (i = 0; i < array.length && array[i] != n; ++i) {
        }
        if (i < array.length) {
            tmp = new Neighbor[array.length - 1];
            System.arraycopy(array, 0, tmp, 0, i);
            System.arraycopy(array, i + 1, tmp, i, array.length - i - 1);
        }
        return tmp;
    }
}

