/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentAdminConnection;
import progress.message.broker.AgentAdminSession;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EGeneralCWADSException;
import progress.message.broker.EStartupFailure;
import progress.message.broker.EUnknownLogEventType;
import progress.message.broker.GuarAckDoneEvt;
import progress.message.broker.GuarAckXchgEvt;
import progress.message.broker.IBrokerSubscription;
import progress.message.broker.IClientContext;
import progress.message.broker.IInterbrokerHook;
import progress.message.broker.INeighbor;
import progress.message.broker.IStateListener;
import progress.message.broker.LogEvent;
import progress.message.broker.durable.ESubscriptionNotFound;
import progress.message.client.EConnectFailure;
import progress.message.client.EConnectionLimitExceeded;
import progress.message.client.EGeneralException;
import progress.message.client.EInterrupted;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.ENetworkFailure;
import progress.message.interbroker.CWADSEvent;
import progress.message.interbroker.CollectiveGroup;
import progress.message.interbroker.ConfigConnectionMgr;
import progress.message.interbroker.ConnectEvent;
import progress.message.interbroker.Convert;
import progress.message.interbroker.IBEvent;
import progress.message.interbroker.IBSubscription;
import progress.message.interbroker.InterbrokerConfig;
import progress.message.interbroker.InterbrokerConnection;
import progress.message.interbroker.InterbrokerListener;
import progress.message.interbroker.InterbrokerSession;
import progress.message.interbroker.LabelUpdateEvent;
import progress.message.interbroker.MessageSubdispatcher;
import progress.message.interbroker.Neighbor;
import progress.message.interbroker.Neighbors;
import progress.message.interbroker.SubjectLabelUpdateEvent;
import progress.message.interbroker.SubscribeEvent;
import progress.message.interbroker.SubscriptionListEnd;
import progress.message.interbroker.SubscriptionListXfer;
import progress.message.interbroker.UnsubscribeEvent;
import progress.message.interbroker.prAccessor;
import progress.message.msg.IMgram;
import progress.message.security.SecurityBean;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.LongHashTable;
import progress.message.util.Queue;
import progress.message.util.WrappedDataOutputStream;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.Connection;
import progress.message.zclient.EUnexpectedMgram;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;

public final class Interbroker
implements Runnable,
IInterbrokerHook,
IStateListener {
    private static Object LOCK_OBJ = new Object();
    private static Object s_object;
    private static Thread s_thread;
    private static volatile Interbroker s_singleton;
    private boolean m_interbrokerActive = false;
    private boolean m_handlersActive = false;
    private boolean m_shutdown = false;
    static final short SUBJECT_SUBSCRIPTION = 1;
    private static final int SUB_LIST_FRAG_SIZE = 10000;
    private AgentRegistrar m_reg;
    private Neighbors m_neighbors;
    private Queue m_event_queue;
    private MessageSubdispatcher m_msg_processor;
    private Convert m_converter;
    private InterbrokerSession m_ibs;
    private long m_vclock;
    private LongHashTable m_clientBlacklist = new LongHashTable();
    private ConfigConnectionMgr m_configMgr;

    public static Interbroker getInterbroker() {
        return s_singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Interbroker initialize(AgentRegistrar reg) throws EStartupFailure {
        if (s_singleton == null) {
            Object object = LOCK_OBJ;
            synchronized (object) {
                if (s_singleton == null) {
                    s_singleton = new Interbroker(reg);
                    s_thread = new Thread(s_singleton);
                    s_singleton.interbrokerEventQueueActive();
                    try {
                        BrokerStateManager.getBrokerStateManager().registerListener(s_singleton);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return s_singleton;
    }

    @Override
    public Connection getConfigConnection() {
        return this.m_configMgr.getConnection();
    }

    public Connection getConfigZConnection() {
        return this.m_configMgr.getConnection();
    }

    private Interbroker(AgentRegistrar reg) throws EStartupFailure {
        s_singleton = this;
        this.m_reg = reg;
        this.m_neighbors = new Neighbors();
        this.m_event_queue = new Queue();
        if (InterbrokerConfig.DEBUG) {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR038"), 3);
        }
        if (!InterbrokerConfig.loadConfig()) {
            String s = prAccessor.getString("STR039");
            BrokerComponent.getComponentContext().logMessage(s, 2);
            throw new EStartupFailure(s);
        }
        this.m_configMgr = new ConfigConnectionMgr(this);
        this.m_configMgr.getConfigBean().addIBConfigListener(this.m_neighbors);
        if (!this.m_neighbors.processConfiguration(this.m_configMgr)) {
            String s = prAccessor.getString("STR043");
            BrokerComponent.getComponentContext().logMessage(s, 2);
            throw new EStartupFailure(s);
        }
        CollectiveGroup[] groups = this.m_neighbors.getAllGroups();
        if (groups.length > 0) {
            this.m_reg.setCollective(groups[0].getName());
        }
        if (InterbrokerConfig.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("...interbroker configuration complete.", 3);
        }
    }

    @Override
    public void stateChanging(int newState) {
    }

    @Override
    public void stateChanged(int newState) throws Exception {
        switch (newState) {
            case 1: 
            case 2: {
                this.handlersActive();
            }
        }
    }

    private void interbrokerActive() {
        if (!this.m_interbrokerActive) {
            this.m_neighbors.initiateContact();
            this.m_interbrokerActive = true;
        }
    }

    private void interbrokerEventQueueActive() {
        s_thread.start();
    }

    private void handlersActive() throws Exception {
        if (this.m_handlersActive) {
            return;
        }
        AgentAdminConnection aac = this.m_reg.getAdminConnection();
        this.m_ibs = new InterbrokerSession(aac);
        IMessageHandler default_handler = new IMessageHandler(){

            @Override
            public void handleMessage(Session s, Envelope envelope) {
                Message msg = envelope.getMessage();
                ISubject sub = null;
                byte[] bod = null;
                try {
                    sub = msg.getSubject();
                    bod = msg.getBody();
                }
                catch (EGeneralException e) {
                    // empty catch block
                }
                BrokerComponent.getComponentContext().logMessage("  Default IB Handler: <" + sub + "," + bod + ">", 3);
            }
        };
        IMessageHandler null_handler = new IMessageHandler(){

            @Override
            public void handleMessage(Session s, Envelope env) {
            }
        };
        this.m_msg_processor = new MessageSubdispatcher(InterbrokerConfig.addPrefix(""), default_handler);
        this.m_msg_processor.setName("Interbroker handler");
        this.m_converter = new Convert(this);
        this.m_msg_processor.addDispatcher("CONVERT", this.m_converter);
        this.m_msg_processor.addDispatcher("subscriptionListXfer", new SubscriptionListXfer(this.m_reg));
        this.m_msg_processor.addDispatcher("subscriptionListEnd", new SubscriptionListEnd(this));
        this.m_msg_processor.addDispatcher("ACK_EXCHANGE", null_handler);
        this.m_msg_processor.addDispatcher("config", null_handler);
        AgentAdminSession aas = this.m_reg.getAdminSession();
        aac.addMessageHandler(this.m_msg_processor);
        Label local = new Label();
        local.setRouteLimit(1);
        aas.submitSubscription(InterbrokerConfig.addPrefix("#"), local).start();
        this.m_handlersActive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws EStartupFailure {
        BrokerComponent.getComponentContext().logMessage("Starting Interbroker...", 3);
        if (this != s_singleton) {
            return;
        }
        BrokerComponent.getComponentContext().logMessage("Continuing Interbroker...", 3);
        try {
            this.handlersActive();
            while (true) {
                IBEvent evt;
                Interbroker interbroker = this;
                synchronized (interbroker) {
                    if (this.m_event_queue.isEmpty()) {
                        break;
                    }
                    evt = (IBEvent)this.m_event_queue.dequeue();
                }
                if (InterbrokerConfig.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage("processing Event: " + evt, 3);
                }
                evt.process(this);
            }
            if (Broker.getBroker().isMFComponent()) {
                this.interbrokerActive();
            }
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EStartupFailure("Error starting interbroker: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopInterbroker() {
        this.m_shutdown = true;
        if (this.m_configMgr != null) {
            this.m_configMgr.stopConfigServer();
        }
        Interbroker interbroker = this;
        synchronized (interbroker) {
            this.notifyAll();
        }
        if (s_thread != null && s_thread.isAlive()) {
            s_thread.interrupt();
        } else if (s_thread != null) {
            try {
                s_thread.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        if (this.m_neighbors != null) {
            this.m_neighbors.stopThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: {
            if (this.m_shutdown) {
                return;
            }
            try {
                while (!Broker.exiting && !Thread.currentThread().isInterrupted()) {
                    IBEvent evt;
                    Interbroker interbroker = this;
                    synchronized (interbroker) {
                        while (this.m_event_queue.isEmpty() && !Broker.exiting) {
                            this.wait();
                        }
                        if (Broker.exiting) {
                            break;
                        }
                        evt = (IBEvent)this.m_event_queue.dequeue();
                    }
                    if (InterbrokerConfig.DEBUG) {
                        BrokerComponent.getComponentContext().logMessage("Processing Event: " + evt, 3);
                    }
                    evt.process(this);
                }
            }
            catch (Exception e) {
                if (Broker.exiting) break block10;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }

    public ConfigConnectionMgr getConfigConnectionMgr() {
        return this.m_configMgr;
    }

    @Override
    public SecurityBean getSecurityBean() {
        return this.m_configMgr.getSecurityBean();
    }

    @Override
    public void startConfigEventDelivery() throws EStartupFailure {
        this.m_configMgr.startEventDelivery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDiscardMessage(long to_id, long from_id, int rte) {
        boolean result = false;
        Neighbors neighbors = this.m_neighbors;
        synchronized (neighbors) {
            result = this.m_neighbors.isDiscardMessage(to_id, from_id, rte);
        }
        if (InterbrokerConfig.DEBUG) {
            System.out.println("Discard Msg(" + this.m_reg.getClientName(to_id) + "," + this.m_reg.getClientName(from_id) + "," + rte + ")? " + (result ? "YES" : "NO"));
        }
        return result;
    }

    @Override
    public boolean isNeighbor(long id) {
        return this.m_neighbors.getByID(id) != null;
    }

    static Label markLabelGuaranteedForNonDurableFT(Label label, IClientContext client, ISubject subject, boolean clone) {
        if (!label.isGuaranteed() && client.isXOnce() && client.getClientSessionVer() >= 28 && SessionConfig.isNonDurableSubscriber(client.getAppid()) && !SessionConfig.isSystemSubject(subject)) {
            if (clone) {
                label = (Label)label.clone();
            }
            label.setGuaranteed(true);
            if (InterbrokerConfig.DEBUG) {
                System.out.println("********Interbroker.markLabelGuaranteedForNonDurableFT:  (label was non-guar)  subj= " + subject.getSubjectString() + " label= " + label + " " + client + " " + Thread.currentThread());
            }
        }
        return label;
    }

    @Override
    public void subscribeEvent(BrokerSubscription bs) {
        bs.setIBMark(false);
        if (InterbrokerConfig.FORWARD_SUBSCRIPTIONS && bs.getLabel().getRouteLimit() > 1) {
            Label label = (Label)bs.getLabel().clone();
            label = Interbroker.markLabelGuaranteedForNonDurableFT(label, bs.getClient(), bs.getSubject(), false);
            this.queueEvent(new SubscribeEvent(bs.getClientId(), bs.getSubject(), label));
        }
    }

    @Override
    public void unsubscribeEvent(BrokerSubscription bs) {
        if (InterbrokerConfig.FORWARD_SUBSCRIPTIONS && bs.getLabel().getRouteLimit() > 1) {
            Label label = (Label)bs.getLabel().clone();
            label = Interbroker.markLabelGuaranteedForNonDurableFT(label, bs.getClient(), bs.getSubject(), false);
            this.queueEvent(new UnsubscribeEvent(bs.getClientId(), bs.getSubject(), label));
        }
    }

    @Override
    public void notifyCWADSEvent(int eventType, IClientContext cc, BrokerSubscription bs) {
        if (bs != null) {
            bs.setIBMark(false);
        }
        if (InterbrokerConfig.DEBUG) {
            System.out.println("CWADS_DEBUG: queueing CWADSEvent type = " + eventType + "\n cc = " + cc);
        }
        try {
            this.queueEvent(new CWADSEvent(eventType, cc, bs));
        }
        catch (ESubscriptionNotFound esnf) {
            BrokerComponent.getComponentContext().logMessage("Error sending cwads event", (Throwable)esnf, 2);
        }
    }

    @Override
    public void sendCWADSEventExcluding(int eventType, IClientContext cc, long excludeBrokerId) throws EGeneralCWADSException {
        if (InterbrokerConfig.DEBUG) {
            System.out.println("sendCWADSEventExcluding: sending CWADSEvent type = " + eventType + " cc = " + cc + " excludeBrokerId: " + excludeBrokerId);
        }
        BrokerSubscription bs = cc.getDurableBrokerSubscription();
        Neighbor[] activeNeighbors = this.m_neighbors.getAll();
        for (int i = activeNeighbors.length - 1; i >= 0; --i) {
            if (activeNeighbors[i] == null || !activeNeighbors[i].isActive() || activeNeighbors[i].getID() == excludeBrokerId) {
                if (!InterbrokerConfig.DEBUG) continue;
                System.out.println("sendCWADSEventExcluding: skipping: " + activeNeighbors[i].getID());
                continue;
            }
            try {
                if (InterbrokerConfig.DEBUG) {
                    System.out.println("sendCWADSEventExcluding: sending to: " + activeNeighbors[i].getID());
                }
                this.getIBSession().notifyCWADSUpdate(activeNeighbors[i].getID(), new CWADSEvent(eventType, cc, bs));
                continue;
            }
            catch (ESubscriptionNotFound esnf) {
                BrokerComponent.getComponentContext().logMessage("Error sending cwads event", (Throwable)esnf, 2);
                continue;
            }
            catch (EGeneralException ege) {
                // empty catch block
            }
        }
    }

    @Override
    public void sendCWADSEvent(int eventType, IClientContext cc, long brokerCCId) throws EGeneralCWADSException {
        Neighbor n;
        if (InterbrokerConfig.DEBUG) {
            System.out.println("CWADS_DEBUG: sending CWADSEvent type = " + eventType + "\n cc = " + cc);
        }
        if ((n = this.m_neighbors.getByID(brokerCCId)) == null || !n.isActive()) {
            throw new EGeneralCWADSException("Broker is not active");
        }
        try {
            BrokerSubscription bs = cc.getDurableBrokerSubscription();
            this.getIBSession().notifyCWADSUpdate(n.getID(), new CWADSEvent(eventType, cc, bs));
        }
        catch (ESubscriptionNotFound esnf) {
            BrokerComponent.getComponentContext().logMessage("Error sending cwads event", (Throwable)esnf, 2);
        }
        catch (EGeneralException ege) {
            throw new EGeneralCWADSException(ege.getMessage(), ege);
        }
    }

    @Override
    public void labelUpdateEvent(IBrokerSubscription bs, Label newLabel) {
        BrokerSubscription brokerSub;
        bs.setIBMark(false);
        if (!InterbrokerConfig.FORWARD_SUBSCRIPTIONS) {
            return;
        }
        if (bs instanceof BrokerSubscription && ((brokerSub = (BrokerSubscription)bs).getLabel().getRouteLimit() > 1 || newLabel.getRouteLimit() > 1)) {
            Label oldLabel = (Label)brokerSub.getLabel().clone();
            oldLabel = Interbroker.markLabelGuaranteedForNonDurableFT(oldLabel, brokerSub.getClient(), brokerSub.getSubject(), false);
            newLabel = Interbroker.markLabelGuaranteedForNonDurableFT(newLabel, brokerSub.getClient(), brokerSub.getSubject(), true);
            this.queueEvent(new SubjectLabelUpdateEvent(((BrokerSubscription)bs).getClientId(), ((BrokerSubscription)bs).getSubject(), oldLabel, newLabel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clientConnect(long id, AgentConnection conn) throws EConnectFailure {
        LongHashTable longHashTable = this.m_clientBlacklist;
        synchronized (longHashTable) {
            if (this.m_clientBlacklist.get(id) != null) {
                throw new EConnectFailure(179, SessionConfig.IB_CONNECT_REFUSED);
            }
        }
        if (AddrUtil.clientIdToAppid(id) == InterbrokerConfig.BROKER_CONNECT_APPID_SCODE) {
            Neighbor n = this.m_neighbors.getByConnectID(id);
            if (n != null) {
                n.passiveConnect(conn);
            } else {
                throw new EConnectFailure(179, SessionConfig.IB_CONNECT_REFUSED);
            }
        }
    }

    @Override
    public void disconnect(long id) {
        Neighbor n = this.m_neighbors.getByID(id);
        if (n == null) {
            n = this.m_neighbors.getByConnectID(id);
        }
        if (n != null) {
            this.m_neighbors.disconnect(n);
        }
    }

    @Override
    public boolean configConnectionOk(int uid) {
        return InterbrokerConfig.CONFIG_SERVER.equals("") && this.m_configMgr.getConfigBean().existsBroker(uid);
    }

    @Override
    public void xOnceMsgReceived(long senderID, long tracking, AgentGuarMsgTracker tracker) {
        Neighbor n = this.m_neighbors.getByID(senderID);
        if (n != null) {
            n.xOnceMsgReceived(tracking, tracker);
        }
    }

    @Override
    public void sendingGuarAck(long ackTracking, long neighborID, long msgTracking) {
        Neighbor n = this.m_neighbors.getByID(neighborID);
        if (n != null) {
            n.addGuarAck(ackTracking, msgTracking);
        }
    }

    @Override
    public void sendingGuarQAck(long ackTracking, long brokerId, long msgTracking) {
        Neighbor neighbor = this.m_neighbors.getByID(brokerId);
        if (neighbor != null) {
            neighbor.addGuarQAck(ackTracking, msgTracking);
        }
    }

    @Override
    public void xOnceQMsgReceived(long senderID, long tracking, AgentQueueMsgTracker tracker) {
        Neighbor neighbor = this.m_neighbors.getByID(senderID);
        if (neighbor != null) {
            neighbor.xOnceQMsgReceived(tracking, tracker);
        }
    }

    @Override
    public void setMsgInDoubt(long receiverID, long tracking) {
        Neighbor neighbor = this.m_neighbors.getByID(receiverID);
        this.m_reg.getQMsgStateMgr().addInDoubtMsg(tracking);
        if (neighbor != null) {
            neighbor.setQMsgInDoubt(tracking);
        }
    }

    public static LogEvent constructIBLogEvent(short type) throws EUnknownLogEventType {
        switch (type) {
            case 25: {
                return new GuarAckXchgEvt();
            }
            case 24: {
                return new GuarAckDoneEvt();
            }
        }
        throw new EUnknownLogEventType("" + type);
    }

    @Override
    public void convertEvent(AgentConnection old_con, IMgram m) throws EUnexpectedMgram {
        long token;
        long cid = old_con.getSecurityContext(m.getChannel()).getClientId();
        int channel = old_con.getChannel(cid);
        Neighbor remote = this.m_neighbors.getByConnectID(cid);
        if (remote == null) {
            return;
        }
        try {
            token = ArrayUtil.readLong(m.getRawBody(), 0);
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        if (remote.okToConvert(token)) {
            long id;
            if (InterbrokerConfig.DEBUG) {
                BrokerComponent.getComponentContext().logMessage("Converting local agent into interbroker", 3);
            }
            InterbrokerConnection new_con = null;
            try {
                new_con = new InterbrokerConnection(old_con.getSocket(), remote);
            }
            catch (IOException e) {
                if (InterbrokerConfig.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage("Could not accept connection from " + remote + ": " + e.getMessage(), (Throwable)e, 2);
                }
                remote.abortConvert();
                old_con.close();
                return;
            }
            if (InterbrokerConfig.DEBUG) {
                BrokerComponent.getComponentContext().logMessage("Passive convert created " + new_con.getListener() + " for " + remote, 3);
            }
            ((InterbrokerListener)new_con.getAgentListener()).setClientSessionVer(old_con.getAgentListener().getClientSessionVer());
            new_con.setNegotiatedConnectParms(old_con.getNegotiatedConnectParms());
            new_con.setPartnerProductVersion(old_con.getPartnerProductVersion());
            new_con.setAcceptorName(old_con.getAcceptorName());
            new_con.setAcceptorUrl(old_con.getAcceptorUrl());
            new_con.getAgentListener().copyInputStreams(old_con.getAgentListener());
            ClientSecurityContext csc = (ClientSecurityContext)old_con.getSecurityContext(m.getChannel()).clone();
            csc.setAppid("Broker");
            new_con.connectSuccess(channel, csc, csc.getClientId());
            try {
                new_con.checkLimits(0, csc.getAppid(), csc);
            }
            catch (EConnectionLimitExceeded ecle) {
                // empty catch block
            }
            new_con.getAgentListener().setCommonSecurityContext(csc);
            if (Config.ENABLE_QOPSECURITY) {
                new_con.getAgentSender().initMessageProtection(csc.getSessionKey());
            }
            try {
                if (InterbrokerConfig.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage("Returning ib_convert mgram to " + remote, 3);
                }
                this.m_reg.getClient(cid).sendThrough(m);
                this.m_reg.prepareDisconnect(cid, 5);
                this.m_reg.disconnect(cid, true);
                if (InterbrokerConfig.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage("ib_convert returned", 3);
                }
                id = remote.getID();
                try {
                    this.m_reg.connect(id, new_con, true);
                }
                catch (InterruptedException e) {
                    if (!Broker.exiting) {
                        throw new EInterrupted();
                    }
                }
            }
            catch (EClientNotRegistered e) {
                if (InterbrokerConfig.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage("Could not accept connection from " + remote + ": " + e.getMessage(), (Throwable)e, 2);
                }
                remote.abortConvert();
                old_con.close();
                new_con.close();
                throw new ThreadDeath();
            }
            catch (EGeneralException e) {
                if (InterbrokerConfig.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage("Could not accept connection from " + remote + ": " + e.getMessage(), (Throwable)e, 2);
                }
                remote.abortConvert();
                old_con.close();
                new_con.close();
                throw new ThreadDeath();
            }
            id = remote.getID();
            this.activate(id);
            if (InterbrokerConfig.DEBUG) {
                BrokerComponent.getComponentContext().logMessage("Passive convert starting " + new_con.getListener() + " for " + remote, 3);
            }
            new_con.startListener();
            throw new ThreadDeath();
        }
        throw new EUnexpectedMgram(m);
    }

    public InterbrokerSession getIBSession() {
        return this.m_ibs;
    }

    AgentRegistrar getAgentRegistrar() {
        return this.m_reg;
    }

    Neighbors getNeighbors() {
        return this.m_neighbors;
    }

    @Override
    public INeighbor[] getActiveNeighbors() {
        return this.m_neighbors.getAllActive();
    }

    public INeighbor[] getAllNeighbors() {
        return this.m_neighbors.getAll();
    }

    void connectEvent(Neighbor n, long token) {
        this.queueEvent(new ConnectEvent(n, token));
    }

    public Neighbor getNeighborByID(long remote_broker_id) {
        return this.m_neighbors.getByID(remote_broker_id);
    }

    Neighbor getNeighborByConnectID(long id) {
        return this.m_neighbors.getByConnectID(id);
    }

    @Override
    public String[] getCollectiveNames() {
        CollectiveGroup[] groups = this.m_neighbors.getAllGroups();
        int gcount = groups.length;
        if (gcount > 0) {
            String[] ret = new String[gcount];
            for (int i = 0; i < gcount; ++i) {
                ret[i] = groups[i].getName();
            }
            return ret;
        }
        return null;
    }

    void activate(long id) {
        IClientContext cc;
        Neighbor n = this.m_neighbors.getByID(id);
        if (n != null) {
            this.m_neighbors.activate(n);
        }
        if ((cc = this.m_reg.lockContext(id)) != null) {
            try {
                Vector v = this.m_reg.subscriptions(id, "#");
                int size = v.size();
                for (int i = 0; i < size; ++i) {
                    BrokerSubscription bs = (BrokerSubscription)v.elementAt(i);
                    if (bs.getLabel().getRouteLimit() <= 1) continue;
                    bs.setIBMark(true);
                }
            }
            catch (EInvalidSubjectSyntax e) {
                throw new EAssertFailure(prAccessor.getString("STR044") + n + ": " + e, e);
            }
            catch (EClientNotRegistered e) {
                throw new EAssertFailure(prAccessor.getString("STR045") + n + ": " + e, e);
            }
            catch (EGeneralException e) {
                throw new EAssertFailure(prAccessor.getString("STR047") + n + ": " + e, e);
            }
            finally {
                cc.unlock();
            }
        }
    }

    synchronized void queueEvent(IBEvent event) {
        event.setEnqueueVTime(++this.m_vclock);
        this.m_event_queue.enqueue(event);
        this.notifyAll();
    }

    synchronized long getVTime() {
        return this.m_vclock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopConnects(long clientId) {
        LongHashTable longHashTable = this.m_clientBlacklist;
        synchronized (longHashTable) {
            this.m_clientBlacklist.put(clientId, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allowConnects(long clientId) {
        LongHashTable longHashTable = this.m_clientBlacklist;
        synchronized (longHashTable) {
            this.m_clientBlacklist.remove(clientId);
        }
    }

    void processSubscribe(SubscribeEvent s) {
        long id = s.getId();
        ISubject subject = s.getSubject();
        Label label = s.getLabel();
        int rte = label.getRouteLimit();
        long vtime = s.getEnqueueVTime();
        CollectiveGroup[] groups = this.m_neighbors.getAllGroups();
        CollectiveGroup subGroup = this.m_neighbors.getGroupByID(id);
        for (int i = 0; i < groups.length; ++i) {
            if (vtime > groups[i].getCreationVTime() && Neighbors.okToForward(subGroup, groups[i], rte)) {
                if (InterbrokerConfig.DEBUG) {
                    System.out.println("Forwarding subscription to " + s.getSubject() + " to group " + groups[i]);
                }
                groups[i].addSubscription(subject, label);
                continue;
            }
            if (!InterbrokerConfig.DEBUG) continue;
            System.out.println("*Not* forwarding subscription to " + s.getSubject() + " from group " + subGroup + " to group " + groups[i]);
        }
    }

    void processUnsubscribe(UnsubscribeEvent u) {
        long id = u.getId();
        ISubject subject = u.getSubject();
        Label label = u.getLabel();
        int rte = label.getRouteLimit();
        long vtime = u.getEnqueueVTime();
        CollectiveGroup[] groups = this.m_neighbors.getAllGroups();
        CollectiveGroup subGroup = this.m_neighbors.getGroupByID(id);
        for (int i = 0; i < groups.length; ++i) {
            if (vtime <= groups[i].getCreationVTime() || !Neighbors.okToForward(subGroup, groups[i], rte)) continue;
            groups[i].removeSubscription(subject, label);
        }
    }

    void processLabelUpdate(LabelUpdateEvent lu) {
        long id = lu.getId();
        long vtime = lu.getEnqueueVTime();
        Label fromLabel = lu.getOldLabel();
        Label toLabel = lu.getNewLabel();
        int fromRte = fromLabel.getRouteLimit();
        int toRte = toLabel.getRouteLimit();
        CollectiveGroup[] groups = this.m_neighbors.getAllGroups();
        CollectiveGroup subGroup = this.m_neighbors.getGroupByID(id);
        for (int i = 0; i < groups.length; ++i) {
            if (vtime <= groups[i].getCreationVTime()) continue;
            boolean wasOk = Neighbors.okToForward(subGroup, groups[i], fromRte);
            boolean isOk = Neighbors.okToForward(subGroup, groups[i], toRte);
            if (wasOk) {
                if (isOk) {
                    if (!(lu instanceof SubjectLabelUpdateEvent)) continue;
                    groups[i].updateSubscription(((SubjectLabelUpdateEvent)lu).getSubject(), fromLabel, toLabel);
                    continue;
                }
                if (!(lu instanceof SubjectLabelUpdateEvent)) continue;
                groups[i].removeSubscription(((SubjectLabelUpdateEvent)lu).getSubject(), fromLabel);
                continue;
            }
            if (!isOk || !(lu instanceof SubjectLabelUpdateEvent)) continue;
            groups[i].addSubscription(((SubjectLabelUpdateEvent)lu).getSubject(), toLabel);
        }
    }

    void processCWADSUpdate(CWADSEvent cu) throws EGeneralException {
        CollectiveGroup[] groups = this.m_neighbors.getAllGroups();
        long vtime = cu.getEnqueueVTime();
        for (int i = 0; i < groups.length; ++i) {
            if (vtime <= groups[i].getCreationVTime()) continue;
            groups[i].sendCWADSEvent(cu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processConnect(ConnectEvent c) {
        Message m;
        Neighbor n = c.getNeighbor();
        if (n == null) {
            return;
        }
        long id = n.getID();
        this.m_reg.lockSubscriptionTable();
        try {
            if (!n.isActive()) {
                return;
            }
            m = new Message("$ISYS.IB.subscriptionListXfer");
            m.writeLong(this.m_reg.getId());
            m.writeShort(1);
            CollectiveGroup g = n.getGroup();
            Enumeration enu = n.getGroup().getSubscriptions();
            while (enu.hasMoreElements()) {
                IBSubscription sub = (IBSubscription)enu.nextElement();
                try {
                    if (InterbrokerConfig.DEBUG) {
                        System.out.println("Transferring subscription to " + sub.getSubject());
                    }
                    WrappedDataOutputStream dos = new WrappedDataOutputStream(m);
                    sub.getSubject().writeToStream(dos);
                    sub.getLabel().serialize(m);
                    if (m.getBody().length < 10000) continue;
                    this.m_ibs.publish(id, m, 0, false);
                    m = new Message("$ISYS.IB.subscriptionListXfer");
                    m.writeLong(this.m_reg.getId());
                    m.writeShort(1);
                }
                catch (ENetworkFailure enf) {
                    if (Broker.isInShutdown()) continue;
                    BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR048") + sub.getSubject().getSubjectString() + ": " + enf.getMessage(), (Throwable)enf, 2);
                }
                catch (IOException e) {
                    BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR048") + sub.getSubject().getSubjectString() + ": " + e.getMessage(), (Throwable)e, 2);
                }
            }
        }
        finally {
            this.m_reg.unlockSubscriptionTable();
        }
        try {
            this.m_ibs.publish(id, m, 0, false);
            m = new Message("$ISYS.IB.subscriptionListEnd");
            m.writeLong(this.m_reg.getId());
            m.writeLong(c.getToken());
            this.m_ibs.publish(id, m, 0, false);
        }
        catch (EGeneralException e) {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR051") + id + ": " + e.getMessage(), (Throwable)e, 2);
        }
        try {
            this.m_reg.getCWADSMsgHandler().CWADSNeighborHandshake(n.getClient());
        }
        catch (EGeneralCWADSException e) {
            if (InterbrokerConfig.DEBUG) {
                BrokerComponent.getComponentContext().logMessage("Received EGeneralCWADSException", (Throwable)e, 3);
            }
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage("Error reconciling durable subscription data with neighbor " + n.getClient().getAppid() + "/" + n.getClient().getUid(), (Throwable)e, 2);
        }
    }

    static {
        s_thread = null;
        s_singleton = null;
        s_object = new Object();
    }
}

