/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import java.io.IOException;
import progress.message.broker.AMPScratchPad;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentListener;
import progress.message.broker.LBSTrackingInfo;
import progress.message.client.EIntegrityCompromised;
import progress.message.interbroker.Neighbor;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.util.ArrayUtil;
import progress.message.zclient.EUnexpectedMgram;

final class InterbrokerListener
extends AgentListener {
    private Neighbor m_neighbor;
    private boolean m_needReset = true;

    InterbrokerListener(AgentConnection con, Neighbor n) throws IOException {
        super("InterbrokerListener of", con);
        this.m_neighbor = n;
    }

    @Override
    protected void setClientSessionVer(byte clientSessionVer) {
        super.setClientSessionVer(clientSessionVer);
    }

    @Override
    public void handleNormal(IMgram m) throws InterruptedException, EIntegrityCompromised {
        m.getBrokerHandle().setFromRemoteBroker(true);
        super.handleNormal(m);
    }

    @Override
    protected void handleAck(IMgram m) throws InterruptedException {
        if (!this.m_neighbor.handleAckAck(m) && !this.m_neighbor.handleQAckAck(m)) {
            super.handleAck(m);
        }
    }

    @Override
    protected void handleOperation(IMgram m) throws IOException, EUnexpectedMgram, EIntegrityCompromised {
        IOperationHandle iOpHandle = m.getOperationHandle();
        if (this.DEBUG) {
            this.debug("Received Operation Mgram");
        }
        int op = iOpHandle.getOperationType();
        switch (op) {
            case 13: 
            case 14: {
                this.handleGroupSubscription(op, m);
                break;
            }
            default: {
                try {
                    super.handleOperation(m);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGroupSubscription(int op, IMgram m) throws EUnexpectedMgram, EIntegrityCompromised {
        IMgram msg = null;
        LBSTrackingInfo groups = LBSTrackingInfo.unmarshalLBTargetWrapper(m);
        if (groups.isInTransitHistory(s_reg.getId())) {
            if (this.DEBUG) {
                this.debug("message already been routed to this broker previously");
            }
            return;
        }
        if (this.CALLBACK) {
            this.callback("AgentListener", 100500, new Object[]{this.m_connection, this.m_neighbor, m, new Integer(op), groups.toTransitVector()});
        }
        if (this.DEBUG) {
            this.debug("received an operation mgram for group subscrption(s). total hop count = " + groups.getHopCount() + ", total group count = " + groups.getTargetCount());
        }
        msg = (IMgram)m.getOperationHandle().getMgramList().get(0);
        boolean origmsgguaranteed = msg.isGuarenteed();
        long origmsgid = msg.getGuarenteedTrackingNum();
        if (this.DEBUG) {
            long wrapperMsgId = 0L;
            if (m.isGuarenteed()) {
                wrapperMsgId = m.getGuarenteedTrackingNum();
            }
            this.debug("origmsgid= " + origmsgid + " origguar= " + origmsgguaranteed + " pers= " + msg.isJMSPersistent() + " wrapperMsgId= " + wrapperMsgId + " ***TxnPublish= " + msg.getBrokerHandle().isTransactionalPublish());
        }
        if (m.isGuarenteed()) {
            msg.setGuarenteed(m.getGuarenteedTrackingNum());
        }
        msg.getBrokerHandle().setFromDB(false);
        msg.getBrokerHandle().setSenderID(m.getBrokerHandle().getSenderID());
        msg.getBrokerHandle().setFromRemoteBroker(true);
        msg.getBrokerHandle().clearTransactionPublish();
        AMPScratchPad scratch = this.getScratchPad(m);
        if (scratch == null) {
            return;
        }
        scratch.m_groupSubscriptionOnly = op == 14;
        scratch.m_groupSubscriptionList = groups;
        if (m.isSuccessor()) {
            msg.setSuccessor(true);
        } else {
            scratch.m_gsRedeliveryOk = true;
        }
        if (this.DEBUG) {
            this.debug(scratch.m_groupSubscriptionList.toString());
        }
        try {
            if (msg != null) {
                if (this.CALLBACK) {
                    this.callback("AgentListener", 100501, new Object[]{this, this.m_neighbor, msg, scratch});
                }
                if (msg.getType() == 25) {
                    try {
                        this.handleOperation(msg);
                    }
                    catch (IOException e) {}
                } else {
                    this.handleNormal(msg, scratch);
                    if (this.CALLBACK) {
                        this.callback("AgentListener", 100502, new Object[]{this, this.m_neighbor, msg, scratch});
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (scratch != null) {
                scratch.m_gsRedeliveryOk = false;
            }
        }
    }

    @Override
    protected void handlePing(IMgram m) throws EUnexpectedMgram {
        if (m.isRequest() && m.getBodyLength() > 0) {
            byte[] data = m.getRawBody();
            short version = ArrayUtil.readShort(data, 0);
            boolean reset = false;
            if (this.m_needReset) {
                reset = true;
                this.m_needReset = false;
            }
            switch (version) {
                case 1: {
                    int totalConnectionCount = ArrayUtil.readInt(data, 2);
                    boolean hasNewConnections = ArrayUtil.readShort(data, 6) == 1;
                    this.m_neighbor.updateNeighborConnectionInfo(totalConnectionCount, hasNewConnections, reset);
                    break;
                }
                default: {
                    throw new EUnexpectedMgram(m);
                }
            }
        }
        super.handlePing(m);
    }
}

