/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BaseClientContextWrapper;
import progress.message.broker.DurableManager;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.ETrackingNumNotFound;
import progress.message.broker.IClientContext;
import progress.message.broker.IClientContextWrapper;
import progress.message.broker.IProxyHandle;
import progress.message.broker.IProxyingHandle;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.LBSTrackingInfo;
import progress.message.broker.MsgRestorePos;
import progress.message.broker.MsgSaver;
import progress.message.broker.ProxyDoubtResolvedEvt;
import progress.message.broker.PublishLimiter;
import progress.message.client.ENotConnected;
import progress.message.interbroker.IBFlowControlTracker;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.Neighbor;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.EDuplicateKey;
import progress.message.util.LongHashTable;
import progress.message.zclient.FastVector;
import progress.message.zclient.Label;

public class NeighborClientContext
extends BaseClientContextWrapper
implements IProxyHandle {
    private HashMap m_proxyRecipsTable;
    private DurableManager m_durMan;
    private HashSet m_proxyingClients;
    private HashSet m_inDoubtProxyingClients;
    private final Object m_proxySync = new Object();
    private boolean m_disconnecting = false;
    private boolean m_stallProxyRegistration = false;
    private HashSet m_disconnectListeners;
    private HashSet m_disconnectingClients;
    private LongHashTable m_lbsWrapperTargets;

    public NeighborClientContext(IClientContext delegate, IClientContextWrapper delegator) {
        super(delegate, delegator);
        this.m_proxyRecipsTable = new HashMap();
        this.m_proxyingClients = new HashSet();
        this.m_inDoubtProxyingClients = new HashSet();
        this.m_disconnectListeners = new HashSet();
        this.m_disconnectingClients = new HashSet();
        this.m_durMan = s_reg.getDurableManager();
        this.debugName("NeighborClientContext");
        this.setFlowControlTracker();
    }

    private void setFlowControlTracker() {
        if (this.m_delegator.getCCFlowControlTracker() == null) {
            this.setCCFlowControlTracker(new IBFlowControlTracker(this.m_delegator));
        }
    }

    @Override
    public void acknowledge(long tracking, boolean txnCommit, IMgram ack, IMgram ackedMgram) throws InterruptedException {
        if (ack != null && ack.isGuarenteed() && ack.getAckHandle().getClientID() != -1L && ack.getAckHandle().getClientID() != this.m_delegator.getId()) {
            ack.getBrokerHandle().setRedirectAckTarget(ack.getAckHandle().getClientID());
        }
        this.m_delegate.acknowledge(tracking, txnCommit, ack, ackedMgram);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProxyRecips(long tracking, FastVector recips) {
        HashMap hashMap = this.m_proxyRecipsTable;
        synchronized (hashMap) {
            this.m_proxyRecipsTable.put(new Long(tracking), recips);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FastVector getProxyRecips(long tracking) {
        HashMap hashMap = this.m_proxyRecipsTable;
        synchronized (hashMap) {
            return (FastVector)this.m_proxyRecipsTable.get(new Long(tracking));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proxyDoubtResolved(boolean replicated) {
        Object trackNums;
        if (this.DEBUG) {
            System.out.println(this + ": Proxy Doubt Resolved.");
        }
        boolean needEvent = false;
        ProxyDoubtResolvedEvt evt = new ProxyDoubtResolvedEvt(this.m_delegator.getId());
        ProxyDoubtResolvedEvt replOnlyEvt = new ProxyDoubtResolvedEvt(this.m_delegator.getId());
        HashMap hashMap = this.m_proxyRecipsTable;
        synchronized (hashMap) {
            trackNums = this.m_proxyRecipsTable.keySet().iterator();
            while (trackNums.hasNext()) {
                needEvent = true;
                try {
                    long tracking = (Long)trackNums.next();
                    AgentGuarMsgTracker tracker = AgentGuarMsgTracker.getTracker(tracking);
                    tracker.removeProxyRecips(this.m_delegator);
                    if (tracker.isReplicateOnly()) {
                        replOnlyEvt.addTracking(tracking);
                        continue;
                    }
                    evt.addTracking(tracking);
                }
                catch (ETrackingNumNotFound etnnf) {}
            }
            this.m_proxyRecipsTable.clear();
        }
        block9: while (true) {
            Iterator proxying = null;
            trackNums = this.m_delegator.getSyncObj();
            synchronized (trackNums) {
                if (this.m_inDoubtProxyingClients.isEmpty()) {
                    break;
                }
                needEvent = true;
                proxying = this.m_inDoubtProxyingClients.iterator();
                this.m_inDoubtProxyingClients = new HashSet();
            }
            while (true) {
                if (proxying == null || !proxying.hasNext()) continue block9;
                IClientContext cc = (IClientContext)proxying.next();
                cc.getProxyingHandle().notifyProxyDoubtResolved(this.m_delegator);
            }
            break;
        }
        if (!replicated && needEvent) {
            if (this.DEBUG) {
                System.out.println(this + ": Adding ProxyDoubtResolvedEvt");
            }
            evt.setReplicateOnly(false);
            s_reg.getLogManager().addEvent(evt, false);
            replOnlyEvt.setReplicateOnly(true);
            s_reg.getLogManager().addEvent(replOnlyEvt, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAcknowledgment(long tracking) {
        HashMap hashMap = this.m_proxyRecipsTable;
        synchronized (hashMap) {
            if (this.m_proxyRecipsTable.remove(new Long(tracking)) != null && this.DEBUG) {
                this.debug(this.m_delegator + "Removed proxyRecipsTable entry for GUAR=" + tracking);
            }
        }
        this.m_delegate.addAcknowledgment(tracking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(boolean sync) {
        HashSet curProxyingClients = null;
        this.m_delegator.cancelMsgRestore();
        boolean interrupted = false;
        HashSet hashSet = this.m_disconnectingClients;
        synchronized (hashSet) {
            while (!this.m_disconnectingClients.isEmpty()) {
                try {
                    this.m_disconnectingClients.wait();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        ArrayList<IProxyingHandle> disconnectListenerList = null;
        Object ex = this.m_disconnectListeners;
        synchronized (ex) {
            disconnectListenerList = new ArrayList<IProxyingHandle>(this.m_disconnectListeners.size());
            for (IProxyingHandle proxying : this.m_disconnectListeners) {
                disconnectListenerList.add(proxying);
                if (this.DEBUG) {
                    this.debug("NOTIFYING DISCONNECTING PROXY OF DISCONNECT: " + proxying);
                }
                proxying.addDisconnectingProxy(this.m_delegator);
            }
        }
        try {
            ex = this.m_proxySync;
            synchronized (ex) {
                this.m_disconnecting = true;
            }
            curProxyingClients = this.m_proxyingClients;
            Iterator proxying = curProxyingClients.iterator();
            this.m_proxyingClients = new HashSet();
            while (proxying.hasNext()) {
                IClientContext cc = (IClientContext)proxying.next();
                if (this.DEBUG) {
                    System.out.println("CWADS: Neighbor disconnect, disconnecting proxying cc: " + cc);
                }
                cc.getProxyingHandle().addDisconnectingProxy(this.m_delegator);
                try {
                    s_reg.prepareDisconnect(cc.getId());
                    s_reg.disconnect(cc.getId(), sync, false, null, true);
                }
                catch (EClientNotRegistered ecnr) {
                    // empty catch block
                }
                if (!this.DEBUG) continue;
                System.out.println("CWADS: disconnected proxying cc: " + cc);
            }
            for (IClientContext cc : this.m_durMan.getAllDurableCCs()) {
                IProxyingHandle proxy = cc.getProxyingHandle();
                if (proxy == null) continue;
                proxy.onInboundProxyDisconnect(this.m_delegator);
            }
            this.m_delegate.disconnect(sync);
        }
        finally {
            Iterator iterator;
            if (curProxyingClients != null) {
                iterator = curProxyingClients.iterator();
                while (iterator.hasNext()) {
                    ((IClientContext)iterator.next()).getProxyingHandle().removeDisconnectingProxy(this.m_delegator);
                }
            }
            iterator = this.m_proxySync;
            synchronized (iterator) {
                this.m_disconnecting = false;
                this.m_proxySync.notifyAll();
            }
            if (disconnectListenerList != null) {
                iterator = disconnectListenerList.iterator();
                while (iterator.hasNext()) {
                    ((IProxyingHandle)iterator.next()).removeDisconnectingProxy(this.m_delegator);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreComplete(MsgRestorePos pos) {
        block18: {
            Object object;
            if (this.DEBUG) {
                BrokerComponent.getComponentContext().logMessage(this + ": Restore Complete", 3);
            }
            try {
                object = this.m_proxySync;
                synchronized (object) {
                    this.m_stallProxyRegistration = true;
                }
                if (!this.m_proxyingClients.isEmpty()) {
                    try {
                        s_reg.getMsgProc().lockPubDispatch();
                        this.m_delegator.waitForPubDispatches();
                        this.m_delegate.restoreComplete(pos);
                        Iterator proxying = this.m_proxyingClients.iterator();
                        while (proxying.hasNext()) {
                            ((IClientContext)proxying.next()).getProxyingHandle().notifyProxyRestoreComplete(this.m_delegator);
                        }
                        break block18;
                    }
                    finally {
                        s_reg.getMsgProc().unlockPubDispatch();
                    }
                }
                this.m_delegate.restoreComplete(pos);
            }
            finally {
                object = this.m_proxySync;
                synchronized (object) {
                    this.m_stallProxyRegistration = false;
                    this.m_proxySync.notifyAll();
                }
            }
        }
    }

    @Override
    public boolean isInterbroker() {
        return true;
    }

    @Override
    public void setInterbroker(boolean val) {
    }

    @Override
    public int send(IMgram mg, Label opts, PublishLimiter pubLimiter) {
        if (this.CALLBACK) {
            this.callback("NeighborClientContext", 100300, new Object[]{this.m_delegator.getConnection(), mg});
        }
        return this.m_delegate.send(mg, opts, pubLimiter);
    }

    @Override
    public void sendPriorityPush(IMgram m, int prio, int pushPrio) {
        if (this.CALLBACK) {
            this.callback("NeighborClientContext", 100301, new Object[]{this.m_delegator.getConnection(), m});
        }
        this.m_delegate.sendPriorityPush(m, prio, pushPrio);
    }

    @Override
    public void sendAck(long backTracking, IMgram m, long redirectClient) {
        boolean guar = false;
        long ackTracking = 0L;
        if (m != null && m.isJMSPersistent()) {
            guar = true;
            ackTracking = s_reg.getLogManager().allocSeqNo() & 0xFFFFFFFFFFFFL;
            InterbrokerHook.sendingGuarAck(ackTracking, this.m_delegator.getId(), backTracking);
        }
        this.m_delegator.sendThrough(MgramFactory.getMgramFactory().buildAck(backTracking, redirectClient, (short)0, guar, ackTracking, false, 0, this.m_delegator.getChannel()));
    }

    @Override
    public void sendAckAck(IMgram ack) {
        if (ack != null && ack.isGuarenteed() && !ack.getBrokerHandle().isAckNoReply()) {
            if (this.DEBUG) {
                this.debug("Sending Ack Confirm: ack tracking: " + ack.getGuarenteedTrackingNum());
            }
            this.m_delegator.sendThrough(MgramFactory.getMgramFactory().buildAck(ack.getGuarenteedTrackingNum(), ack.getBrokerHandle().getRedirectAckTarget(), (short)0, false, 0L, false, 0, ack.getChannel()));
        }
    }

    @Override
    public String toString() {
        return "NeighborClientContext wrapper for: " + this.m_delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proxyRegister(IClientContext registrant) throws InterruptedException, ENotConnected {
        Object object = this.m_proxySync;
        synchronized (object) {
            while (true) {
                if (this.m_disconnecting) {
                    throw new ENotConnected();
                }
                if (!this.m_stallProxyRegistration) break;
                this.m_proxySync.wait();
            }
            this.m_proxyingClients.add(registrant);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proxyUnregister(IClientContext registrant) {
        boolean interrupted = false;
        Object object = this.m_proxySync;
        synchronized (object) {
            while (true) {
                if (this.m_disconnecting) {
                    return;
                }
                if (!this.m_stallProxyRegistration) break;
                try {
                    this.m_proxySync.wait();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
            this.m_proxyingClients.remove(registrant);
            return;
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDisconnectNotication(IProxyingHandle proxying) {
        HashSet hashSet = this.m_disconnectListeners;
        synchronized (hashSet) {
            this.m_disconnectListeners.add(proxying);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterDisconnectNotication(IProxyingHandle proxying) {
        HashSet hashSet = this.m_disconnectListeners;
        synchronized (hashSet) {
            this.m_disconnectListeners.remove(proxying);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareProxyingDisconnect(IProxyingHandle proxying) {
        if (this.isDisconnecting()) {
            return false;
        }
        HashSet hashSet = this.m_disconnectingClients;
        synchronized (hashSet) {
            return this.m_disconnectingClients.add(proxying);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proxyingDisconnectComplete(IProxyingHandle proxying) {
        HashSet hashSet = this.m_disconnectingClients;
        synchronized (hashSet) {
            this.m_disconnectingClients.remove(proxying);
            if (this.m_disconnectingClients.isEmpty()) {
                this.m_disconnectingClients.notifyAll();
            }
        }
    }

    @Override
    public IProxyHandle getProxyHandle() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInDoubt(IClientContext proxying) {
        Object object = this.m_delegator.getSyncObj();
        synchronized (object) {
            this.m_inDoubtProxyingClients.add(proxying);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterInDoubt(IClientContext proxying) {
        Object object = this.m_delegator.getSyncObj();
        synchronized (object) {
            this.m_inDoubtProxyingClients.remove(proxying);
        }
    }

    @Override
    public boolean okToUnregister() {
        Neighbor n = Interbroker.getInterbroker().getNeighborByID(this.m_delegator.getId());
        if (n == null || n.isInvalid()) {
            return this.m_delegate.okToUnregister();
        }
        return false;
    }

    @Override
    public void setUnregistered() {
        this.m_delegate.setUnregistered();
        this.m_delegator.getProxyHandle().proxyDoubtResolved(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRestoredMgram(IMgram m, boolean durableSMORestore, boolean fromRemoteBroker) throws EDuplicateKey, InterruptedException {
        FastVector lbsRecips = null;
        NeighborClientContext neighborClientContext = this;
        synchronized (neighborClientContext) {
            if (this.m_lbsWrapperTargets != null) {
                lbsRecips = (FastVector)this.m_lbsWrapperTargets.get(m.getGuarenteedTrackingNum());
            }
        }
        if (lbsRecips != null) {
            m = MsgSaver.removeLBSWrapper(m);
            LBSTrackingInfo info = new LBSTrackingInfo();
            info.addTransitHistory(AgentRegistrar.getAgentRegistrar().getId());
            info.setTargetGroups(lbsRecips);
            m = LBSTrackingInfo.buildLBSTargetWrapper(m, info);
        }
        return this.m_delegate.addRestoredMgram(m, durableSMORestore, fromRemoteBroker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLBSWrapperInfo(long tracking, FastVector groupMemberIds) {
        NeighborClientContext neighborClientContext = this;
        synchronized (neighborClientContext) {
            if (this.m_lbsWrapperTargets == null) {
                this.m_lbsWrapperTargets = new LongHashTable();
            }
            this.m_lbsWrapperTargets.put(tracking, groupMemberIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLBSWrapperInfo(long tracking) {
        AgentGuarMsgTracker tracker = AgentGuarMsgTracker.getTrackerIfExists(tracking);
        if (tracker != null) {
            tracker.removeProxyLBSRecips(this.m_delegate.getId());
        }
        NeighborClientContext neighborClientContext = this;
        synchronized (neighborClientContext) {
            if (this.m_lbsWrapperTargets == null) {
                return;
            }
            this.m_lbsWrapperTargets.remove(tracking);
            if (this.m_lbsWrapperTargets.isEmpty()) {
                this.m_lbsWrapperTargets = null;
            }
        }
    }
}

