/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.MergedBrokerSubscription;
import progress.message.broker.UnsubscribeEvt;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.prAccessor;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

final class SubscriptionListEnd
extends DebugObject
implements IMessageHandler {
    private Interbroker m_ib;

    SubscriptionListEnd(Interbroker ib) {
        super("SubscriptionListEnd ");
        this.m_ib = ib;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        try {
            AgentRegistrar reg = this.m_ib.getAgentRegistrar();
            Message m = env.getMessage();
            long id = m.readLong();
            long token = m.readLong();
            IClientContext cc = reg.lockContext(id);
            if (cc != null) {
                try {
                    if (token != this.m_ib.getNeighborByID(id).getToken()) {
                        return;
                    }
                    Vector v = reg.subscriptions(id, "#");
                    int size = v.size();
                    for (int i = 0; i < size; ++i) {
                        BrokerSubscription bs = (BrokerSubscription)v.elementAt(i);
                        if (!bs.hasIBMark()) continue;
                        reg.unsubscribe(new UnsubscribeEvt(null, id, bs.getSubject()));
                        if (!this.DEBUG) continue;
                        if (bs.getVirtualClock() != null) {
                            this.debug("SubscriptionListEnd.handleMessage(): from neighbor " + cc.getUid() + " unsubscribing remote subscription to  " + bs.getSubject());
                        }
                        if (!(bs instanceof MergedBrokerSubscription)) continue;
                        String appid = null;
                        String uid = null;
                        if (bs.getClient() != null) {
                            appid = bs.getClient().getAppid();
                            uid = bs.getClient().getUid();
                        }
                        this.debug("SubscriptionListEnd.handleMessage(): from neighbor " + cc.getUid() + " unsubscribing Merged subscription to  " + bs.getSubject() + " uid= " + uid + " appid= " + appid);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (EInvalidSubjectSyntax e) {
                    throw new EAssertFailure(prAccessor.getString("STR068") + e, e);
                }
                catch (EClientNotRegistered e) {
                    throw new EAssertFailure(prAccessor.getString("STR069") + e, e);
                }
                finally {
                    cc.unlock();
                }
            }
            reg.getLogManager().beginFlush();
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }
}

