/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.aspi;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.XAConnection;
import progress.message.client.EGeneralException;
import progress.message.jimpl.Connection;
import progress.message.jimpl.DurableSubscriber;
import progress.message.jimpl.IConnectionConsumer;
import progress.message.jimpl.IMessageSelector;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.jimpl.MessageConsumer;
import progress.message.jimpl.QueueReceiver;
import progress.message.jimpl.Session;
import progress.message.jimpl.aspi.prAccessor;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;

final class ConnectionConsumer
implements javax.jms.ConnectionConsumer,
IConnectionConsumer {
    IMessageSelector m_selector = null;
    ServerSessionPool m_sessionPool = null;
    MessageConsumer m_msgConsumer = null;
    Connection m_jconnection = null;
    static final int TOPIC_NONDURABLE = 1;
    static final int TOPIC_DURABLE = 2;
    static final int QUEUE = 3;
    private static final String DEFAULT_JSESSION_NAME = "DefaultSession(CC)";
    int m_type = 0;
    private progress.message.zclient.Session m_ackSession;
    private ServerSession m_serverSession = null;
    private IMessageHandler m_ihdr;
    private javax.jms.Session m_defaultJSession = null;

    ConnectionConsumer(Connection connection, Destination dest, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (maxMessages < 1) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("INVALID_MAXMESSAGES"), null);
        }
        if (sessionPool == null) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("INVALID_SSPOOL"), null);
        }
        this.m_sessionPool = sessionPool;
        this.m_defaultJSession = connection.getDefaultJSession();
        if (this.m_defaultJSession == null) {
            this.m_defaultJSession = connection.createSession(false, 1, DEFAULT_JSESSION_NAME);
            connection.setDefaultJSession(this.m_defaultJSession);
        }
        if (connection instanceof XAConnection) {
            ((Session)this.m_defaultJSession).setFromXASession(true);
        }
        this.m_ihdr = new IHandler();
        this.m_msgConsumer = ((Session)this.m_defaultJSession).createConsumer(dest, messageSelector, this.m_ihdr);
        this.m_jconnection = connection;
        this.m_ackSession = this.m_msgConsumer.getZmessageHandler().getSession();
        this.m_selector = this.m_msgConsumer.getSelector();
        this.m_type = dest instanceof Queue ? 3 : 1;
    }

    ConnectionConsumer(Connection connection, Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (maxMessages < 1) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("INVALID_MAXMESSAGES"), null);
        }
        if (sessionPool == null) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("INVALID_SSPOOL"), null);
        }
        this.m_sessionPool = sessionPool;
        this.m_defaultJSession = connection.getDefaultJSession();
        if (this.m_defaultJSession == null) {
            this.m_defaultJSession = connection.createSession(false, 1, DEFAULT_JSESSION_NAME);
            connection.setDefaultJSession(this.m_defaultJSession);
        }
        if (connection instanceof XAConnection) {
            ((Session)this.m_defaultJSession).setFromXASession(true);
        }
        this.m_ihdr = new IHandler();
        this.m_msgConsumer = new DurableSubscriber(connection, (Session)this.m_defaultJSession, subscriptionName, topic, messageSelector, false, this.m_ihdr);
        this.m_jconnection = connection;
        this.m_ackSession = this.m_msgConsumer.getZmessageHandler().getSession();
        this.m_selector = this.m_msgConsumer.getSelector();
        this.m_type = 2;
    }

    @Override
    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.m_sessionPool;
    }

    @Override
    public void close() throws JMSException {
        this.m_msgConsumer.close();
    }

    private Message extract(Envelope env) throws JMSException {
        Message message = Message.createMessage(env);
        message.setPropertiesReadOnly(true);
        message.setBodyReadOnly(true);
        return message;
    }

    @Override
    public void redeliver(Envelope env) {
        if (!this.m_msgConsumer.isClosing()) {
            this.m_msgConsumer.getZmessageHandler().getMessageQueue().addElement(env, this.m_ihdr);
        }
    }

    @Override
    public boolean isClosing() {
        return this.m_msgConsumer.isClosing();
    }

    @Override
    public MessageConsumer getMessageConsumer() {
        return this.m_msgConsumer;
    }

    private void doGetRequestIfNecessary() throws Exception {
        if (this.m_type == 3) {
            ((QueueReceiver)this.m_msgConsumer).decrementOutstandingRequested();
            int msgQsize = this.m_msgConsumer.getZmessageHandler().getQueueSize();
            ((QueueReceiver)this.m_msgConsumer).makeGetRequest(msgQsize);
        }
    }

    private class IHandler
    implements IMessageHandler {
        private IHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(progress.message.zclient.Session session, Envelope env) {
            boolean needReleaseMsg = false;
            try {
                Message msg = ConnectionConsumer.this.extract(env);
                msg.setConnectionConsumer(ConnectionConsumer.this, (Session)ConnectionConsumer.this.m_defaultJSession, ConnectionConsumer.this.m_msgConsumer);
                msg = ConnectionConsumer.this.m_msgConsumer.checkUndeliverable(msg);
                if (msg == null) {
                    ConnectionConsumer.this.doGetRequestIfNecessary();
                    return;
                }
                if (ConnectionConsumer.this.isClosing() || ConnectionConsumer.this.m_jconnection.isClosing()) {
                    ConnectionConsumer.this.m_msgConsumer.release(env);
                    return;
                }
                if (ConnectionConsumer.this.m_selector != null && !ConnectionConsumer.this.m_selector.match(msg)) {
                    try {
                        ConnectionConsumer.this.m_msgConsumer.acknowledge(env, ConnectionConsumer.this.m_ackSession);
                        ConnectionConsumer.this.m_msgConsumer.release(env);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                ConnectionConsumer.this.m_serverSession = ConnectionConsumer.this.getServerSessionPool().getServerSession();
                Session jsession = null;
                if (ConnectionConsumer.this.m_serverSession != null) {
                    jsession = (Session)ConnectionConsumer.this.m_serverSession.getSession();
                }
                if (jsession == null || ConnectionConsumer.this.m_serverSession == null) {
                    needReleaseMsg = true;
                    throw JMSExceptionUtil.createJMSException(prAccessor.getString("NO_SESSION"), null);
                }
                if (jsession.isClosing()) {
                    needReleaseMsg = true;
                    throw new JMSException(prAccessor.getString("NO_SESSION"));
                }
                if (jsession.getJconnection() != ConnectionConsumer.this.m_jconnection) {
                    needReleaseMsg = true;
                    throw JMSExceptionUtil.createJMSException(prAccessor.getString("NOT_SAME_CONNECTION"), null);
                }
                MessageConsumer sessionMessageConsumer = (MessageConsumer)ConnectionConsumer.this.m_msgConsumer.clone();
                msg.setConnectionConsumer(ConnectionConsumer.this, jsession, sessionMessageConsumer);
                jsession.loadMsgFromCC(msg);
                sessionMessageConsumer.bindSession(jsession);
                jsession.setServerSession(ConnectionConsumer.this.m_serverSession);
                if (jsession.getUseInternalThreadForCCDelivery()) {
                    jsession.startDeliveryThread();
                } else {
                    ConnectionConsumer.this.m_serverSession.start();
                }
                ConnectionConsumer.this.doGetRequestIfNecessary();
            }
            catch (JMSException je) {
                needReleaseMsg = true;
                if (!ConnectionConsumer.this.isClosing()) {
                    je.printStackTrace();
                }
            }
            catch (EGeneralException ee) {
                needReleaseMsg = true;
                if (!ConnectionConsumer.this.isClosing()) {
                    ee.printStackTrace();
                }
            }
            catch (Exception e) {
                needReleaseMsg = true;
                if (!ConnectionConsumer.this.isClosing()) {
                    e.printStackTrace();
                }
            }
            finally {
                if (needReleaseMsg) {
                    ConnectionConsumer.this.m_msgConsumer.release(env);
                }
            }
        }
    }
}

