/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.xa;

import java.util.EventObject;
import javax.jms.JMSException;
import javax.jms.TransactionInProgressException;
import javax.transaction.xa.XAException;
import progress.message.client.EGeneralException;
import progress.message.client.EParameterIsNull;
import progress.message.client.EUnusableConnection;
import progress.message.jimpl.Connection;
import progress.message.jimpl.EventHandler;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Session;
import progress.message.jimpl.SessionCloseEvent;
import progress.message.jimpl.xa.XAResource;

public class XASession
extends Session
implements progress.message.jclient.xa.XASession,
EventHandler {
    public static final String XA_PARENT_SESSION_LABEL = "(XA Session)";
    public static final String XA_CHILD_SESSION_LABEL = "(XA JMS Session)";
    private Connection m_connection = null;
    protected Session m_session = null;
    private boolean m_transacted;
    private int m_acknowledgeMode;
    private XAResource m_xaResource = null;
    private boolean m_setFlowControlDisabled_onXASession = false;
    private String m_name = null;

    XASession(Connection connection, boolean transacted, int acknowledgeMode, String sessionName) throws JMSException {
        super(connection, transacted, acknowledgeMode, true, (sessionName == null ? "" : sessionName) + XA_PARENT_SESSION_LABEL);
        this.debugName("XASession");
        try {
            this.m_xaResource = new XAResource(this);
        }
        catch (XAException e) {
            throw JMSExceptionUtil.createJMSException("Exception when creating XAResource", e);
        }
        this.m_connection = connection;
        this.m_transacted = transacted;
        this.m_acknowledgeMode = acknowledgeMode;
        this.m_name = sessionName != null && sessionName.length() == 0 ? null : sessionName;
    }

    @Override
    public javax.transaction.xa.XAResource getXAResource() {
        if (this.DEBUG) {
            if (this.m_xaResource == null) {
                this.debug("getXAResource() resource is null.");
            } else {
                this.debug("getXAResource() resource=" + this.m_xaResource.getObjectRefString());
            }
        }
        return this.m_xaResource;
    }

    @Override
    public javax.jms.Session getSession() throws JMSException {
        if (this.isClosing()) {
            return this.m_session;
        }
        if (this.m_session == null || this.m_session.isClosing()) {
            String sessname = (this.m_name == null ? "" : this.m_name) + XA_CHILD_SESSION_LABEL;
            this.m_session = new Session(this.m_connection, this.m_transacted, this.m_acknowledgeMode, sessname);
            this.m_session.setFromXASession(true);
            this.m_session.setEnforceLocallyTransactedOnXAEnlistment(this.getEnforceLocallyTransactedOnXAEnlistment());
            this.m_session.setUseInternalThreadForCCDelivery(this.getUseInternalThreadForCCDelivery());
            this.m_session.setAfterDeliveryListener(this.getAfterDeliveryListener());
            this.m_session.setBeforeDeliveryListener(this.getBeforeDeliveryListener());
            this.m_session.setServerSessionReleaseListener(this.getServerSessionReleaseListener());
            this.m_session.addEventHandler(this);
        }
        return this.m_session;
    }

    @Override
    public void close() throws JMSException {
        super.close();
        this.m_xaResource.close();
        this.closeSession();
    }

    @Override
    public boolean getTransacted() throws JMSException {
        return true;
    }

    @Override
    public void commit() throws JMSException {
        throw new TransactionInProgressException("should not be called for an XASession object");
    }

    @Override
    public void rollback() throws JMSException {
        throw new TransactionInProgressException("should not be called for an XASession object");
    }

    @Override
    public void setDeferredAck(boolean value) throws JMSException {
        ((Session)this.getSession()).setDeferredAckInXATxn(value);
    }

    @Override
    public boolean isDeferredAck() throws JMSException {
        return ((Session)this.getSession()).isDeferredAckInXATxn();
    }

    @Override
    public void handleEvent(EventObject evt) {
        if (evt instanceof SessionCloseEvent) {
            this.handleSessionCloseEvent((SessionCloseEvent)evt);
        }
    }

    public void handleSessionCloseEvent(SessionCloseEvent evt) {
    }

    @Override
    public String getSessionName() {
        return this.m_name;
    }

    private synchronized void closeSession() throws JMSException {
        if (this.m_session == null) {
            return;
        }
        this.m_session.removeEventHandler(this);
        this.m_session.closeInternal();
    }

    @Override
    public void setFlowControlDisabled(boolean disabled) {
        super.setFlowControlDisabled(disabled);
        this.m_setFlowControlDisabled_onXASession = true;
    }

    progress.message.zclient.Session createGTzsession() throws JMSException {
        progress.message.zclient.Session zSession;
        try {
            if (this.m_session != null && !this.m_setFlowControlDisabled_onXASession) {
                this.getZconnection().setFlowControlDisabled(this.m_session.isFlowControlDisabled());
            }
            zSession = new progress.message.zclient.Session(this.getZconnection(), true);
        }
        catch (EParameterIsNull e) {
            throw JMSExceptionUtil.createJMSException("XASession create z session", e);
        }
        catch (EUnusableConnection e) {
            throw JMSExceptionUtil.createJMSException("XASession create z session", e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException("XASession create z session", e);
        }
        return zSession;
    }

    progress.message.zclient.Session createGTzsession(int tid) throws JMSException {
        progress.message.zclient.Session zSession;
        try {
            if (this.m_session != null && !this.m_setFlowControlDisabled_onXASession) {
                this.getZconnection().setFlowControlDisabled(this.m_session.isFlowControlDisabled());
            }
            zSession = new progress.message.zclient.Session(this.getZconnection(), tid);
        }
        catch (EParameterIsNull e) {
            throw JMSExceptionUtil.createJMSException("XASession create z session", e);
        }
        catch (EUnusableConnection e) {
            throw JMSExceptionUtil.createJMSException("XASession create z session", e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException("XASession create z session", e);
        }
        return zSession;
    }
}

