/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.xmessage;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import progress.message.client.prAccessor;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.xmessage.Part;

public class Header
implements progress.message.jclient.Header,
Cloneable {
    private String m_contentType;
    private String m_contentId;
    private Hashtable m_fields = new Hashtable();
    private boolean m_readOnly = false;
    private String m_contentXType;
    private Part m_parentPart;

    Header() {
    }

    Header(String contentType) {
        this.m_contentType = contentType;
    }

    Header(String contentType, String contentId, String XType) {
        this.m_contentType = contentType;
        this.m_contentId = contentId;
        this.m_contentXType = XType;
    }

    @Override
    public String getContentId() {
        return this.m_contentId;
    }

    @Override
    public void setContentId(String cid) throws JMSException, MessageNotWriteableException {
        if (this.m_readOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_PROPS_READ_ONLY"));
        }
        if (this.m_contentId == null && cid == null || this.m_contentId != null && this.m_contentId.equals(cid)) {
            return;
        }
        if (cid != null && this.isContentIdAlreadyExist(cid)) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CID_ALREADY_EXISTS"), null);
        }
        this.m_contentId = cid;
        if (this.m_parentPart != null && this.m_parentPart.getParentMM() != null) {
            this.m_parentPart.getParentMM().setDirty(true);
        }
    }

    @Override
    public void setContentType(String type) throws JMSException, MessageNotWriteableException {
        if (this.m_readOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_PROPS_READ_ONLY"));
        }
        this.m_contentType = type;
        if (this.m_parentPart != null && this.m_parentPart.getParentMM() != null) {
            this.m_parentPart.getParentMM().setDirty(true);
        }
    }

    @Override
    public String getContentType() {
        return this.m_contentType;
    }

    @Override
    public Enumeration getHeaderFieldNames() {
        Vector<String> fieldNames = new Vector<String>();
        if (this.m_contentType != null) {
            fieldNames.add("Content-Type");
        }
        if (this.m_contentId != null) {
            fieldNames.add("Content-ID");
        }
        fieldNames.addAll(this.m_fields.keySet());
        return fieldNames.elements();
    }

    @Override
    public String getHeaderField(String name) {
        return this.getHeaderField(name, null);
    }

    @Override
    public String getHeaderField(String name, String value) {
        String fieldValue = null;
        fieldValue = name.equals("Content-Type") ? this.getContentType() : (name.equals("Content-ID") ? this.getContentId() : this.m_fields.get(name));
        if (fieldValue == null) {
            return value;
        }
        if (fieldValue instanceof String) {
            return fieldValue;
        }
        return null;
    }

    @Override
    public void setHeaderField(String name, String value) throws JMSException {
        if (name.equals("Content-Type")) {
            this.setContentType(value);
            return;
        }
        if (name.equals("Content-ID")) {
            this.setContentId(value);
            return;
        }
        if (this.m_readOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_PROPS_READ_ONLY"));
        }
        if (value == null) {
            if (this.m_fields.get(name) != null) {
                this.m_fields.remove(name);
            }
        } else {
            this.m_fields.put(name, value);
        }
        if (this.m_parentPart != null && this.m_parentPart.getParentMM() != null) {
            this.m_parentPart.getParentMM().setDirty(true);
        }
    }

    @Override
    public void removeHeaderField(String name) throws JMSException {
        if (name.equals("Content-Type")) {
            this.setContentType(null);
            return;
        }
        if (name.equals("Content-ID")) {
            this.setContentId(null);
            return;
        }
        if (this.m_readOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_PROPS_READ_ONLY"));
        }
        this.m_fields.remove(name);
        if (this.m_parentPart != null && this.m_parentPart.getParentMM() != null) {
            this.m_parentPart.getParentMM().setDirty(true);
        }
    }

    @Override
    public void removeAllHeaders() throws JMSException {
        if (this.m_readOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_PROPS_READ_ONLY"));
        }
        this.m_fields.clear();
        if (this.m_parentPart != null && this.m_parentPart.getParentMM() != null) {
            this.m_parentPart.getParentMM().setDirty(true);
        }
    }

    void marshal(ObjectOutput out) throws JMSException {
        try {
            if (this.m_contentType != null) {
                this.m_fields.put("CONTENT_TYPE", this.m_contentType);
            }
            if (this.m_contentId != null) {
                this.m_fields.put("CONTENT_ID", this.m_contentId);
            }
            if (this.m_contentXType != null) {
                this.m_fields.put("CONTENT_XTYPE", this.m_contentXType);
            }
            out.writeInt(this.m_fields.size());
            Enumeration keys = this.m_fields.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                out.writeUTF(key);
                out.writeUTF((String)this.m_fields.get(key));
            }
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    void unpack(ObjectInput in) throws JMSException {
        try {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String key = in.readUTF();
                String value = in.readUTF();
                if ("CONTENT_TYPE".equals(key)) {
                    this.m_contentType = value;
                    continue;
                }
                if ("CONTENT_ID".equals(key)) {
                    this.m_contentId = value;
                    continue;
                }
                if ("CONTENT_XTYPE".equals(key)) {
                    this.m_contentXType = value;
                    continue;
                }
                this.m_fields.put(key, value);
            }
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
    }

    boolean isSonicmqMessageType() {
        if (this.m_contentType == null) {
            return false;
        }
        return this.m_contentType.equals("application/x-sonicmq-message") || this.m_contentType.equals("application/x-sonicmq-bytesmessage") || this.m_contentType.equals("application/x-sonicmq-mapmessage") || this.m_contentType.equals("application/x-sonicmq-objectmessage") || this.m_contentType.equals("application/x-sonicmq-streammessage") || this.m_contentType.equals("application/x-sonicmq-textmessage") || this.m_contentType.equals("application/x-sonicmq-xmlmessage") || this.m_contentType.equals("application/x-sonicmq-multipartmessage");
    }

    public Object clone() {
        try {
            Header header = (Header)super.clone();
            header.m_fields = (Hashtable)this.m_fields.clone();
            return header;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    String getXType() {
        return this.m_contentXType;
    }

    void setXType(String xType) {
        this.m_contentXType = xType;
    }

    Part getParentPart() {
        return this.m_parentPart;
    }

    void setParentPart(Part parentPart) {
        this.m_parentPart = parentPart;
    }

    private boolean isContentIdAlreadyExist(String contentId) {
        if (this.m_parentPart == null) {
            return false;
        }
        return this.m_parentPart.isContentIdAlreadyExist(contentId);
    }
}

