/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import progress.message.net.ISocket;
import progress.message.zclient.DebugObject;
import progress.message.zclient.SessionConfig;

public class ProgressInetAddress
extends DebugObject {
    public static final String CANONICAL_IPV6_LOOPBACK = "0:0:0:0:0:0:0:1";
    public static final String LOCALHOST = "localhost";
    public static final String PROPERTYNAME_LOCALHOST = "SonicMQ.net.localhost";
    public static final String PROPERTYNAME_PREFER_IPV4 = "SonicMQ.net.preferIPv4";
    public static final String PROPERTYNAME_PREFER_IPV6 = "SonicMQ.net.preferIPv6";
    public static final String PROPERTYNAME_PREFER_IP_PATTERN = "SonicMQ.net.preferIPPattern";
    public static final String PROPERTYNAME_IP_ADDRESS_DEBUG = "SonicMQ.net.IPAddressDebug";
    private InetAddress m_delegate;
    private static volatile String s_localHostName = null;
    private static final Object LOCALHOST_LOCK_OBJ = new Object();
    private static String s_localhost_name_override = null;
    private static boolean s_ipaddress_debug = false;
    public static final int PREFERENCE_PATTERN_LOOPBACK = 1;
    public static final int PREFERENCE_PATTERN_ANYLOCAL = 2;
    public static final int PREFERENCE_PATTERN_LINKLOCAL = 4;
    public static final int PREFERENCE_PATTERN_SITELOCAL = 8;
    public static final int PREFERENCE_PATTERN_MULTICAST = 16;
    public static final int DEFAULT_PREFERENCE_PATTERN = 23;
    private static boolean s_prefer_IPv4 = false;
    private static boolean s_prefer_IPv6 = false;
    private static int s_preference_pattern = 23;

    public static String getLocalHostNameOverride() {
        return s_localhost_name_override;
    }

    public static boolean debugIPAddress() {
        return s_ipaddress_debug;
    }

    public static void showIPAddressDiagnostic(String message) {
        ProgressInetAddress.showIPAddressDiagnostic(message, null);
    }

    public static void showIPAddressDiagnostic(String message, Throwable e) {
        if (s_ipaddress_debug) {
            SessionConfig.logMessage(message, SessionConfig.WARNING);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public static void showCreatedSocketDiagnostic(String artifactName, ISocket socket) {
        if (s_ipaddress_debug) {
            String message = artifactName + " created ProgressSocket for InetAddress = " + socket.getInetAddress() + ", remote address = " + socket.getRemoteAddress() + ", local address = " + socket.getLocalAddress();
            SessionConfig.logMessage(message, SessionConfig.WARNING);
        }
    }

    public static void showAcceptedSocketDiagnostic(String artifactName, Socket socket) {
        if (s_ipaddress_debug) {
            String message = artifactName + " accepted connection " + socket.toString() + " InetAddress = " + socket.getInetAddress().toString();
            SessionConfig.logMessage(message, SessionConfig.WARNING);
        }
    }

    private static void showIPAddressDetail(String message, InetAddress addr) {
        if (s_ipaddress_debug) {
            SessionConfig.logMessage(message + "\n  type: " + addr.getClass().getName() + "\n  host address: " + addr.getHostAddress() + "\n  host name: " + addr.getHostName() + "\n  canonicalhostname = " + addr.getCanonicalHostName() + "\n    loopback  = " + addr.isLoopbackAddress() + "\n    anylocal  = " + addr.isAnyLocalAddress() + "\n    linklocal = " + addr.isLinkLocalAddress() + "\n    sitelocal = " + addr.isSiteLocalAddress() + "\n    multicast = " + addr.isMulticastAddress(), SessionConfig.WARNING);
        }
    }

    public ProgressInetAddress(InetAddress delegate) {
        super("ProgressInetAddress");
        if (s_ipaddress_debug) {
            ProgressInetAddress.showIPAddressDetail("ProgressInetAddress: Creating ProgressInetAddress for " + delegate.toString(), delegate);
        }
        this.m_delegate = delegate;
    }

    private ProgressInetAddress(InetAddress delegate, boolean enforceIPv4Only) throws IOException {
        super("ProgressInetAddress");
        if (s_ipaddress_debug) {
            ProgressInetAddress.showIPAddressDetail("ProgressInetAddress: Creating ProgressInetAddress for " + delegate.toString(), delegate);
        }
        if (enforceIPv4Only && delegate instanceof Inet6Address) {
            throw new IOException("IPv6 InetAddress usage is not supported for " + delegate.toString());
        }
        this.m_delegate = delegate;
    }

    public InetAddress getDelegateInetAddress() {
        return this.m_delegate;
    }

    public boolean isMulticastAddress() {
        return this.m_delegate.isMulticastAddress();
    }

    public boolean isAnyLocalAddress() {
        return this.m_delegate.isAnyLocalAddress();
    }

    public boolean isLoopbackAddress() {
        return this.m_delegate.isLoopbackAddress();
    }

    public boolean isLinkLocalAddress() {
        return this.m_delegate.isLinkLocalAddress();
    }

    public boolean isSiteLocalAddress() {
        return this.m_delegate.isSiteLocalAddress();
    }

    public boolean isMCGlobal() {
        return this.m_delegate.isMCGlobal();
    }

    public boolean isMCNodeLocal() {
        return this.m_delegate.isMCNodeLocal();
    }

    public boolean isMCLinkLocal() {
        return this.m_delegate.isMCLinkLocal();
    }

    public boolean isMCSiteLocal() {
        return this.m_delegate.isMCSiteLocal();
    }

    public boolean isMCOrgLocal() {
        return this.m_delegate.isMCOrgLocal();
    }

    public String getHostName() {
        String hostname = this.m_delegate.getHostName();
        return hostname;
    }

    public String getCanonicalHostName() {
        return this.m_delegate.getCanonicalHostName();
    }

    public byte[] getAddress() {
        return this.m_delegate.getAddress();
    }

    public String getHostAddress(boolean wrapIPv6) {
        String hostAddr;
        boolean isIPv6 = this.m_delegate instanceof Inet6Address;
        String string = hostAddr = isIPv6 && wrapIPv6 ? "[" + this.m_delegate.getHostAddress() + "]" : this.m_delegate.getHostAddress();
        if (s_ipaddress_debug) {
            ProgressInetAddress.showIPAddressDiagnostic("ProgressInetAddress.getHostAddress for " + this.m_delegate.toString() + "\n  wrapIPv6 = " + wrapIPv6 + "\n  isIPv6 = " + isIPv6 + "\n  host address = " + hostAddr, null);
        }
        return hostAddr;
    }

    public int hashCode() {
        return this.m_delegate.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            return this.m_delegate.equals(((ProgressInetAddress)obj).m_delegate);
        }
        return false;
    }

    @Override
    public String toString() {
        return "ProgressInetAddress[" + this.m_delegate.toString() + "]";
    }

    public static ProgressInetAddress getByName(String host) throws UnknownHostException {
        return ProgressInetAddress.getByName(host, false);
    }

    private static ProgressInetAddress getByName(String host, boolean ipv4Required) throws UnknownHostException {
        ProgressInetAddress ret = null;
        InetAddress inet = InetAddress.getByName(host);
        inet = ipv4Required ? ProgressInetAddress.checkIPPreference(inet, true, false) : ProgressInetAddress.checkIPPreference(inet, s_prefer_IPv4, s_prefer_IPv6);
        if (inet != null) {
            try {
                ret = new ProgressInetAddress(inet, ipv4Required);
            }
            catch (IOException ioe) {
                throw new UnknownHostException("Unable to enforce IPv4 for " + host + " - no matching IPv4 address found");
            }
        }
        if (s_ipaddress_debug) {
            ProgressInetAddress.showIPAddressDiagnostic("ProgressInetAddress.getByName(" + host + ") " + "returning " + ret, null);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProgressInetAddress getLocalHost() throws UnknownHostException {
        ProgressInetAddress ret = null;
        InetAddress inet = null;
        if (s_localHostName != null) {
            try {
                inet = InetAddress.getByName(s_localHostName);
            }
            catch (UnknownHostException e) {
                Object object = LOCALHOST_LOCK_OBJ;
                synchronized (object) {
                    s_localHostName = null;
                }
            }
        }
        if (inet == null) {
            inet = InetAddress.getLocalHost();
        }
        if (inet != null) {
            if (s_localHostName == null) {
                Object object = LOCALHOST_LOCK_OBJ;
                synchronized (object) {
                    if (s_localHostName == null) {
                        s_localHostName = inet.getHostName();
                    }
                }
            }
            ret = new ProgressInetAddress(inet);
        }
        if (s_ipaddress_debug) {
            ProgressInetAddress.showIPAddressDiagnostic("ProgressInetAddress.getLocalHost() returning " + ret, null);
        }
        return ret;
    }

    public static ProgressInetAddress getLocalLoopbackAddress() throws UnknownHostException {
        return ProgressInetAddress.getLocalLoopbackAddress(false);
    }

    private static ProgressInetAddress getLocalLoopbackAddress(boolean ipv4Only) throws UnknownHostException {
        ProgressInetAddress ret = null;
        InetAddress inet = null;
        try {
            if (!ipv4Only) {
                inet = InetAddress.getByName("::1");
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        if (inet == null) {
            inet = InetAddress.getByName("127.0.0.1");
        }
        if (inet != null) {
            ret = new ProgressInetAddress(inet);
        }
        if (ret == null) {
            throw new UnknownHostException("Unable to determine local loopback address for this system.");
        }
        if (s_ipaddress_debug) {
            ProgressInetAddress.showIPAddressDiagnostic("ProgressInetAddress.getLocalLoopbackAddress() returning " + ret, null);
        }
        return ret;
    }

    public static ProgressInetAddress getLocalAnyLocalAddress() throws UnknownHostException {
        return ProgressInetAddress.getLocalAnyLocalAddress(false);
    }

    private static ProgressInetAddress getLocalAnyLocalAddress(boolean enforceIPv4Only) throws UnknownHostException {
        ProgressInetAddress ret = null;
        InetAddress inet = null;
        inet = InetAddress.getByName("0.0.0.0");
        if (inet == null) {
            UnknownHostException uhe = new UnknownHostException("Cannot determine Anylocal Host Address for this system.");
            if (s_ipaddress_debug) {
                ProgressInetAddress.showIPAddressDiagnostic("ProgressInetAddress.getLocalAnyLocalAddress() Cannot determine Anylocal Host Address for this system.", uhe);
            }
            throw uhe;
        }
        try {
            ret = new ProgressInetAddress(inet, enforceIPv4Only);
        }
        catch (IOException ioe) {
            UnknownHostException uhe = new UnknownHostException("Unable to determine local AnyLocal Address");
            uhe.initCause(ioe);
            if (s_ipaddress_debug) {
                ProgressInetAddress.showIPAddressDiagnostic("ProgressInetAddress.getLocalAnyLocalAddress() Cannot determine Anylocal Host Address for this system.", uhe);
            }
            throw uhe;
        }
        if (s_ipaddress_debug) {
            ProgressInetAddress.showIPAddressDiagnostic("ProgressInetAddress.getLocalAnyLocalAddress() returning " + ret, null);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocalHostName() {
        if (s_localHostName == null) {
            Object object = LOCALHOST_LOCK_OBJ;
            synchronized (object) {
                if (s_localHostName == null) {
                    String override = ProgressInetAddress.getLocalHostNameOverride();
                    if (override != null) {
                        s_localHostName = override;
                    }
                    try {
                        ProgressInetAddress local = ProgressInetAddress.getLocalHost();
                        if (local != null) {
                            s_localHostName = local.getHostName();
                        }
                    }
                    catch (UnknownHostException uhe) {
                    }
                    finally {
                        if (s_localHostName == null) {
                            try {
                                s_localHostName = System.getProperty("COMPUTERNAME");
                            }
                            catch (SecurityException se) {
                                SessionConfig.logMessage("Invalid property - permissions denied for: COMPUTERNAME", se, SessionConfig.WARNING);
                            }
                            if (s_localHostName == null) {
                                s_localHostName = LOCALHOST;
                            }
                        }
                    }
                    if (s_ipaddress_debug) {
                        ProgressInetAddress.showIPAddressDiagnostic("ProgressInetAddress.getLocalHostName() returning " + s_localHostName, null);
                    }
                }
            }
        }
        return s_localHostName;
    }

    private static InetAddress checkIPPreference(InetAddress addr, boolean preferIPv4, boolean preferIPv6) {
        if (!preferIPv4 && !preferIPv6) {
            return addr;
        }
        if (preferIPv4 && addr instanceof Inet4Address) {
            return addr;
        }
        if (preferIPv6 && addr instanceof Inet6Address) {
            return addr;
        }
        LinkedHashSet<InetAddress> altAddresses = new LinkedHashSet<InetAddress>();
        try {
            int i;
            InetAddress[] hosts = InetAddress.getAllByName(addr.getCanonicalHostName());
            for (i = 0; hosts != null && i < hosts.length; ++i) {
                altAddresses.add(hosts[i]);
            }
            if (!addr.getHostAddress().equals(addr.getCanonicalHostName())) {
                hosts = InetAddress.getAllByName(addr.getHostAddress());
                for (i = 0; hosts != null && i < hosts.length; ++i) {
                    altAddresses.add(hosts[i]);
                }
            }
        }
        catch (IOException e) {
            SessionConfig.logMessage("Problem attempting to find matching InetAddress of preferred type for " + addr, e, SessionConfig.SEVERE);
        }
        if (s_ipaddress_debug) {
            ProgressInetAddress.showIPAddressDetail("checkIPPreference found " + altAddresses.size() + " possible matches for " + addr.getCanonicalHostName() + "\n  preferIPv4 = " + preferIPv4 + "\n  preferIPv6 = " + preferIPv6 + "\n  preferencePattern = 0" + Integer.toBinaryString(s_preference_pattern) + " (binary)", addr);
        }
        int count = 0;
        Iterator it = altAddresses.iterator();
        while (it.hasNext()) {
            ++count;
            InetAddress altAddr = (InetAddress)it.next();
            if (s_ipaddress_debug) {
                ProgressInetAddress.showIPAddressDetail("checkIPPreference comparing " + addr.getCanonicalHostName() + " to match [" + count + "]: ", altAddr);
            }
            if (!ProgressInetAddress.isPreferredAddress(addr, altAddr, preferIPv4, preferIPv6)) continue;
            if (s_ipaddress_debug) {
                SessionConfig.logMessage("checkIPPreference found preferred match, replacing " + addr + " with " + altAddr, SessionConfig.WARNING);
            }
            return altAddr;
        }
        if (s_ipaddress_debug) {
            SessionConfig.logMessage("checkIPPreference found no suitable alternatives for " + addr, SessionConfig.WARNING);
        }
        return addr;
    }

    private static boolean isPreferredAddress(InetAddress origAddr, InetAddress testAddr, boolean preferIPv4, boolean preferIPv6) {
        if (preferIPv4 && !(testAddr instanceof Inet4Address) || preferIPv6 && !(testAddr instanceof Inet6Address)) {
            return false;
        }
        if ((s_preference_pattern & 2) > 0 && origAddr.isAnyLocalAddress() != testAddr.isAnyLocalAddress()) {
            return false;
        }
        if ((s_preference_pattern & 4) > 0 && origAddr.isLinkLocalAddress() != testAddr.isLinkLocalAddress()) {
            return false;
        }
        if ((s_preference_pattern & 8) > 0 && origAddr.isSiteLocalAddress() != testAddr.isSiteLocalAddress()) {
            return false;
        }
        if ((s_preference_pattern & 1) > 0 && origAddr.isLoopbackAddress() != testAddr.isLoopbackAddress()) {
            return false;
        }
        return (s_preference_pattern & 0x10) <= 0 || origAddr.isMulticastAddress() == testAddr.isMulticastAddress();
    }

    public static Set<String> getAllHostnamesAndIps(boolean includeLoopback) {
        TreeSet<String> result = new TreeSet<String>();
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            ProgressInetAddress.addAddressDetails(localHost, includeLoopback, result);
            ProgressInetAddress.showIPAddressDetail("localhost static:", localHost);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (includeLoopback) {
            try {
                InetAddress[] loopbacks;
                for (InetAddress loopback : loopbacks = InetAddress.getAllByName(LOCALHOST)) {
                    ProgressInetAddress.addAddressDetails(loopback, includeLoopback, result);
                    ProgressInetAddress.showIPAddressDetail("localhost by name:", loopback);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface interf = interfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = interf.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress address = inetAddresses.nextElement();
                    ProgressInetAddress.addAddressDetails(address, includeLoopback, result);
                    ProgressInetAddress.showIPAddressDetail("network interface: " + interf.getDisplayName(), address);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static void addAddressDetails(InetAddress address, boolean includeLoopback, Set<String> result) {
        if (ProgressInetAddress.includeAddress(address, includeLoopback)) {
            result.add(address.getHostName().toLowerCase());
            result.add(address.getCanonicalHostName().toLowerCase());
            result.add(ProgressInetAddress.hostAddress(address));
        }
    }

    private static String hostAddress(InetAddress address) {
        if (address instanceof Inet6Address && address.isLoopbackAddress()) {
            return CANONICAL_IPV6_LOOPBACK;
        }
        return address.getHostAddress().toLowerCase();
    }

    private static boolean includeAddress(InetAddress address, boolean includeLoopback) {
        return address.isLoopbackAddress() && includeLoopback || !address.isLoopbackAddress();
    }

    public static void main(String[] args) {
        Set<String> allHostnamesAndIps = ProgressInetAddress.getAllHostnamesAndIps(false);
        System.out.println(allHostnamesAndIps);
    }

    static {
        String propertyName = null;
        try {
            propertyName = PROPERTYNAME_LOCALHOST;
            s_localhost_name_override = System.getProperty(propertyName, null);
            propertyName = PROPERTYNAME_PREFER_IPV4;
            String propertyValue = System.getProperty(propertyName, Boolean.toString(s_prefer_IPv4));
            if (propertyValue != null) {
                s_prefer_IPv4 = Boolean.valueOf(propertyValue);
            }
            if ((propertyValue = System.getProperty(propertyName = PROPERTYNAME_PREFER_IPV6, Boolean.toString(s_prefer_IPv6))) != null) {
                s_prefer_IPv6 = Boolean.valueOf(propertyValue);
            }
            if (s_prefer_IPv4 && s_prefer_IPv6) {
                s_prefer_IPv4 = false;
            }
            if ((propertyValue = System.getProperty(propertyName = PROPERTYNAME_PREFER_IP_PATTERN, Integer.toString(s_preference_pattern))) != null) {
                s_preference_pattern = Integer.valueOf(propertyValue);
            }
            if ((propertyValue = System.getProperty(propertyName = PROPERTYNAME_IP_ADDRESS_DEBUG, Boolean.toString(s_ipaddress_debug))) != null) {
                s_ipaddress_debug = Boolean.valueOf(propertyValue);
            }
        }
        catch (SecurityException e) {
            SessionConfig.logMessage("Invalid optional property; " + propertyName + " permission denied", e, SessionConfig.SEVERE);
        }
        catch (Exception e) {
            SessionConfig.logMessage("Invalid optional property; " + propertyName, e, SessionConfig.SEVERE);
        }
    }
}

