/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net;

import java.io.IOException;
import java.security.Principal;
import progress.message.client.EInterrupted;
import progress.message.net.ESocketConnectTimeout;
import progress.message.net.ProgressSocket;
import progress.message.net.ProgressSocketFactory;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.net.prAccessor;
import progress.message.resources.prMessageFormat;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugThread;

class SocketConnectHelper
extends DebugThread {
    private boolean m_cancelled;
    private IOException m_ex;
    private ProgressSocket m_socket;
    private Object m_resultSync = new Object();
    private ProgressSocketFactory m_sf;
    private String m_host;
    private int m_port;
    private Principal m_principal;
    private Object m_props;
    private IHttpProxyConfig m_httpProxyConfig;
    private long m_timeout;

    public SocketConnectHelper(ProgressSocketFactory sf, Principal principal, String host, int port, Object props, IHttpProxyConfig httpProxyConfig, long timeout) {
        super("SocketConnectHelper Thread: host=" + host + "; port=" + port);
        this.m_sf = sf;
        this.m_principal = principal;
        this.m_host = host;
        this.m_port = port;
        this.m_props = props;
        this.m_httpProxyConfig = httpProxyConfig;
        this.m_timeout = timeout;
    }

    public ProgressSocket openSocket() throws IOException, ESocketConnectTimeout {
        this.start();
        long waitTime = this.m_timeout;
        long startTime = System.currentTimeMillis();
        long endTime = startTime + this.m_timeout;
        if (this.DEBUG) {
            this.debug("openSocket; starting - timeout: " + this.m_timeout + "ms");
        }
        Object object = this.m_resultSync;
        synchronized (object) {
            try {
                while (this.m_ex == null && this.m_socket == null && startTime < endTime) {
                    this.m_resultSync.wait(endTime - startTime);
                    startTime = System.currentTimeMillis();
                }
                if (this.m_socket != null) {
                    return this.m_socket;
                }
                if (this.m_ex != null) {
                    throw this.m_ex;
                }
                this.m_cancelled = true;
                this.interrupt();
                String msgf = prAccessor.getString("SocketConnectTimeout");
                Object[] obj = new Object[]{this.m_host, Long.toString(this.m_timeout)};
                String result = prMessageFormat.format(msgf, obj);
                throw new ESocketConnectTimeout(result);
            }
            catch (InterruptedException ex) {
                if (this.m_socket == null && this.m_ex == null) {
                    this.m_cancelled = true;
                    this.interrupt();
                } else if (this.m_socket != null) {
                    try {
                        this.m_socket.close();
                        this.m_socket = null;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                throw new EInterrupted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadMain() throws Exception {
        String name = this.getName();
        ProgressSocket s = null;
        IOException ex = null;
        long start = System.currentTimeMillis();
        long time = 0L;
        try {
            if (this.CALLBACK) {
                if (this.DEBUG) {
                    this.debug("DEBUG: IN SocketConnectHelper threadMain - ERR_SOCKET_CONNECT_TIMEOUT CALLBACK for HOST=" + this.m_host + " PORT=" + this.m_port);
                }
                Object obj = new Object[]{this.m_host, Integer.toString(this.m_port)};
                this.callback("SocketConnectHelper", 0, obj);
            }
            s = this.m_sf.createProgressSocket(this.m_principal, this.m_host, this.m_port, this.m_props, this.m_httpProxyConfig);
        }
        catch (IOException ioe) {
            ex = ioe;
        }
        catch (Throwable te) {
            ex = new IOException("Unexpected exception while creating socket", te);
        }
        finally {
            time = System.currentTimeMillis() - start;
            Object ioe = this.m_resultSync;
            synchronized (ioe) {
                if (this.m_cancelled) {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable e) {}
                    }
                } else {
                    if (s != null) {
                        this.m_socket = s;
                    } else if (ex != null) {
                        this.m_ex = ex;
                    } else {
                        new EAssertFailure(name + " exiting; no exception; socket not created").printStackTrace();
                    }
                    this.m_resultSync.notifyAll();
                }
            }
        }
    }
}

