/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.StringTokenizer;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import sun.misc.BASE64Encoder;

public class TCPProxy {
    private TCPProxy() {
    }

    public static Socket connectProxy(String host, int port) throws IOException {
        try {
            String TCPProxyHost = System.getProperty("TUNNELING_PROXY_HOST");
            int TCPProxyPort = Integer.getInteger("TUNNELING_PROXY_PORT", -1);
            return TCPProxy.connectProxy(host, port, TCPProxyHost, TCPProxyPort, null);
        }
        catch (SecurityException se) {
            return null;
        }
    }

    public static Socket connectProxy(String host, int port, String proxyHost, int proxyPort, IHttpProxyConfig pConfig) throws IOException {
        Socket tcpSocket = null;
        if (pConfig != null && pConfig.getHost() != null && pConfig.getHost().trim().length() > 0 && pConfig.getPort() != -1) {
            tcpSocket = new Socket(pConfig.getHost(), pConfig.getPort());
            DataOutputStream dao = new DataOutputStream(tcpSocket.getOutputStream());
            String httpCommand_1_0 = "CONNECT " + host + ":" + port + " HTTP/1.0";
            dao.writeBytes(httpCommand_1_0);
            dao.writeBytes("\n");
            if (pConfig.getUserName() != null && pConfig.getUserName().trim().length() > 0) {
                String password = pConfig.getUserName() + ":" + pConfig.getUserPassword();
                BASE64Encoder base64Encoder = new BASE64Encoder();
                String encodedPassword = base64Encoder.encode(password.getBytes());
                String httpAuthCommand = "Proxy-Authorization: Basic " + encodedPassword;
                dao.writeBytes(httpAuthCommand);
                dao.writeBytes("\n");
            }
            dao.writeBytes("\n");
            String error = null;
            error = TCPProxy.getHTTPResponseErrorCode(tcpSocket);
            if (!"200".equals(error)) {
                IOException e = new IOException("Proxy server HTTP error: " + error);
                throw e;
            }
            return tcpSocket;
        }
        if (proxyHost != null && proxyPort != -1) {
            tcpSocket = new Socket(proxyHost, proxyPort);
            String error = null;
            new DataOutputStream(tcpSocket.getOutputStream()).writeBytes("CONNECT " + host + ":" + port + " HTTP/1.0\n\n");
            error = TCPProxy.getHTTPResponseErrorCode(tcpSocket);
            if (!"200".equals(error)) {
                throw new IOException("Proxy server HTTP error: " + error);
            }
        }
        return tcpSocket;
    }

    public static String getHTTPResponseErrorCode(Socket socket) throws IOException {
        String error = "HTTP response syntax error";
        BufferedReader is = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        String line = is.readLine();
        StringTokenizer st = new StringTokenizer("");
        if (line != null) {
            st = new StringTokenizer(line);
        }
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            error = st.nextToken();
        }
        boolean count = false;
        while ((line = is.readLine()) != null && !"".equals(line)) {
        }
        return error;
    }
}

